/**
 * 互联服务注册主页面
 * 
 * @class QueryForm
 * @extends Ext.ux.Form
 */
var areaUrl = "register/servAffordManRegAction_queryAllServInfo.action";
// var servUrl = "servAffordManRegAction_queryAllServInfo.action";
var servUrl = "msgInnerChosenAction_getServCode.action";
var connServ;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var ConnServRegObj = {
	connServId : '',
	connServCode : '',
	connServName : '',
	connServType : '',
	areaCode : '',
	connRoutePlatCode : '',
	provideCode : '',
	connServInvokeMode : '',
	connServStatus : '',
	connServProcStatus : '',
	wsdlId : '',
	protocolId : '',
	delFlag : '',
	description : '',
	servDefineId : ''
};
var url_Invoke_Mode = "servAffordManRegAction_queryInvokeMode.action";
var providerUrl = "connLimitScAction_queryConnMan.action";
var SERVTYPE_STORE_URL = 'register/servDefineAction_queryServType.action';
var SERVMANURL = 'register/getAllServMan_queryAllServMan.action';

Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}

	// 格式化时间
	Date.prototype.format = function(format) {
		var o = {
			"M+" : this.getMonth() + 1, // month<
			"d+" : this.getDate(),// day
			"h+" : this.getHours(), // hour
			"m+" : this.getMinutes(), // minute
			"s+" : this.getSeconds(), // second
			"q+" : Math.floor((this.getMonth() + 3) / 3),// quarter
			"S" : this.getMilliseconds()
			// millisecond
		}
		if (/(y+)/.test(format))
			format = format.replace(RegExp.$1, (this.getFullYear() + "")
							.substr(4 - RegExp.$1.length));
		for (var k in o) {
			if (new RegExp("(" + k + ")").test(format))
				format = format.replace(RegExp.$1, RegExp.$1.length == 1
								? o[k]
								: ("00" + o[k]).substr(("" + o[k]).length));
		}
		return format;
	}

	var beginTimeFieldValue;
	var endTimeFieldValue;
	function check() {
		var msgText = '时间为必选项，格式应为：yyyy-mm-dd hh:mm:ss！';
		if (!Ext.getCmp('beginTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
						Ext.getCmp('beginTime').focus();
					});
			return false;
		}
		if (!Ext.getCmp('endTime').isValid()) {
			Ext.MessageBox.alert("信息提示", msgText, function(btn) {
						Ext.getCmp('endTime').focus();
					});
			return false;
		}
		beginTimeFieldValue = Ext.get("beginTime").getValue();
		endTimeFieldValue = Ext.get("endTime").getValue();
		beginTimeValueTemp = new Date(Date.parse(beginTimeFieldValue.replace(
				/-/g, "/")));
		endTimeValueTemp = new Date(Date.parse(endTimeFieldValue.replace(/-/g,
				"/")));

		var daydiff = (endTimeValueTemp.getTime() - beginTimeValueTemp
				.getTime())
				/ (1000 * 60 * 60 * 24);
		if (daydiff < 0) {
			Ext.Msg.alert("信息提示", "结束时间不能小于开始时间！");
			return false;;
		}
		return true;
	}
	QueryForm = Ext.extend(Ext.ux.Form, {
				servCombo : null,
				beginTime : null,
				endTime : null,
				constructor : function() {
					// this.servCombo =
					// this.createCombo2("服务名称","","servCode","servName","90%",servUrl,"servDtoList","",false);
					// this.servCombo.initComponent =
					// this.addBlankSelectForCombox(this.servCombo);
					// this.servCombo.store.load();
					this.servCombo = this.createCombo2("服务名称", "servSet",
							"servCode", "servName", "90%", servUrl, "areaList",
							"areaCount", true);
					this.servCombo.initComponent = this
							.addBlankSelectForCombox(this.servCombo);
					this.servCombo.store.load();
					// 接口类型

					var nowDate = new Date();
					var startDate = new Date(nowDate.getTime() - 24 * 60 * 60
							* 1000);
					nowDate = nowDate.format("yyyy-MM-dd hh:mm:ss");
					startDate = startDate.format("yyyy-MM-dd hh:mm:ss");
					// 开始时间
					this.beginTime = new Ext.form.DateField({
						fieldLabel : '开始时间',
						xtype : 'xdatetime',
						name : 'beginTime',
						id : 'beginTime',
						width : 200,
						anchor: '99%',
						allowBlank : false,
						altFormats : 'Y-m-d H:i:s',
						format : 'Y-m-d H:i:s', 
						value : startDate,
						emptyText : '请选择一个日期'
							// readOnly : true
						});

					// 结束时间
					this.endTime = new Ext.form.DateField({
						fieldLabel : '结束时间',
						xtype : 'xdatetime',
						name : 'endTime',
						id : 'endTime',
						width : 200,
						anchor: '99%',
						allowBlank : false,
						altFormats : 'Y-m-d H:i:s',
						format : 'Y-m-d H:i:s',
						value : nowDate,
						emptyText : '请选择一个日期'
							// readOnly : true
						});
					QueryForm.superclass.constructor.call(this, {
								title : "服务实例查询",
								width : Ext.getBody().getViewSize().width - 5,
								height : Ext.getBody().getViewSize().height
										* 0.25,
								region : "center",
								labelWidth : 80,
								labelAlign : "right",
								applyTo : "queryform",
								frame : true,
								items : [{
											layout : "column",
											items : [{
														layout : "form",
														items : this.servCombo,
														columnWidth : .3333
													}, {
														layout : "form",
														items : this.beginTime,
														columnWidth : .3333
													}, {
														layout : "form",
														items : this.endTime,
														columnWidth : .3333
													}]
										}],
								buttons : [{
											text : '查询',
											id : 'query_connserv_btn',
											iconCls : 'find',
											width : 20,
											hidden : false,
											handler : this.queryFormClick,
											scope : this
										}, {
											text : '重置',
											id : 'resume_connserv_btn',
											width : 20,
											iconCls : 'resume',
											hidden : false,
											handler : this.onResumeClick,
											scope : this
										}]

							})
				},
				queryFormClick : function() {
					if (check()) {
						var beginValue = beginTimeFieldValue;
						var endValue = endTimeFieldValue;
						var servCode = this.servCombo.getValue();
						connServ.store.baseParams = {
							'innerServInstanceDto.servCode' : servCode,
							'beginTime' : Ext.get("beginTime").getValue(),
							'endTime' : Ext.get("endTime").getValue()
						};
						connServ.store.load({
									params : {
										'pageInner.start' : 0,
										'pageInner.pageSize' : 10
									}
								});
					}
				},
				onResumeClick : function() {
					this.getForm().reset();
				},
				addBlankSelectForCombox : function(combo) {
					combo.on("select", function() {
								if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
									combo.setValue("");
								}
							});
					combo.store.on("datachanged", function(a) {
								var r = new Ext.data.Record({});
								r.set(combo.valueField, ''); // 添加一格值为-1的选项
								r.set(combo.displayField, combo.emptyText);
								a.insert(0, r);
							});
				}
			});
	var queryForm = new QueryForm();

	ConnServGrid = Ext.extend(UxGrid, {
		store : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
					url : "innerServInstanceAction_queryInnerServInstance.action",
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'pageInner.totalCount',
							root : 'pageInner.result'
						}, [{
									name : 'servCode'
								}, {
									name : 'servName'
								}, {
									name : 'sendSystem'
								}, {
									name : 'receiveSystem'
								}, {
									name : 'consumerRequestTimes'
								}, {
									name : 'consumerResponseTimes'
								}, {
									name : 'receiveTimes'
								}, {
									name : 'requestTimes'
								}, {
									name : 'responseTimes'
								}, {
									name : 'sendTimes'
								}, {
									name : 'aimReceiveTimes'
								}, {
									name : 'aimSendTimes'
								}])
			}),

			ConnServGrid.superclass.constructor.call(this, {
						title : '服务信息列表',
						frame : true,
						width : Ext.getBody().getViewSize().width - 5,
						renderTo : "grid-div",
						region : "center",
						height : Ext.getBody().getViewSize().height * 0.73,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : new Ext.grid.RowSelectionModel({
									singleSelect : true
								}),
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(), {
									header : '服务名',
									dataIndex : 'servName',
									hidden : false
								}, {
									header : '服务编码',
									dataIndex : 'servCode',
									hidden : true
								}, {
									header : '源系统',
									dataIndex : 'sendSystem',
									sortable : true,
									width : 80
								}, {
									header : '目标系统',
									dataIndex : 'receiveSystem',
									sortable : true,
									width : 100
								}, {
									header : '源系统发送',
									dataIndex : 'consumerRequestTimes',
									sortable : true,
									hidden : false,
									width : 100
								}, {
									header : '源系统收到响应',
									dataIndex : 'consumerResponseTimes',
									sortable : true,
									hidden : false
								}, {
									header : 'oip接收次数',
									dataIndex : 'receiveTimes',
									sortable : true,
									width : 100
								}, {
									header : 'oip发送次数',
									dataIndex : 'requestTimes',
									sortable : true,
									width : 100
								}, {
									header : 'oip接收响应次数',
									dataIndex : 'responseTimes',
									sortable : true,
									width : 100
								}, {
									header : 'oip返回次数',
									dataIndex : 'sendTimes',
									hidden : false,
									sortable : true,
									width : 100
								}, {
									header : '目标系统接受',
									dataIndex : 'aimReceiveTimes',
									sortable : true,
									width : 100
								}, {
									header : '目标系统发送响应',
									dataIndex : 'aimSendTimes',
									hidden : false,
									sortable : true,
									width : 130
								}, {
									header : '详情查询',
									dataIndex : 'servCode',
									sortable : true,
									width : 100,
									renderer : this.getDetail
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 10,
									paramNames : {
										start : 'pageInner.start',
										limit : 'pageInner.pageSize'
									},
									store : this.store,
									displayInfo : true,
									displayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录"
								}),
						ds : this.store
					})
		},
		getDetail : function(val, params, record) {
			var servCode = record.get("servCode");
			var sendSystem = record.get("sendSystem");
			var beginTime = null, endTime = null;
			if (Ext.get("beginTime") != null) {
				beginTime = Ext.get("beginTime").getValue();
				beginTime = beginTime.replace(/ /g, "@");
			}
			if (Ext.get("endTime") != null) {
				endTime = Ext.get("endTime").getValue();
				endTime = endTime.replace(/ /g, "@");
			}
			return '<a href=javascript:detDetailPro("' + servCode + '","'
					+ sendSystem + '","' + beginTime + '","' + endTime + '")>'
					+ '<center>查看</center>' + '</a>';

		}
	});
	connServ = new ConnServGrid();
	connServ.store.load({
				params : {
					'pageInner.start' : 0,
					'pageInner.pageSize' : 10
				}
			});

});

function detDetailPro(servCode, sendSystem, beginTime, endTime) {
	var servCodeValue = servCode;
	var sendSystemValue = sendSystem;
	var beginTimeValue = beginTime.replace(/@/g, " ");
	var endTimeValue = endTime.replace(/@/g, " ");
	var hp = new Ext.data.HttpProxy({
				url : 'innerServInstanceAction_queryInnerServInstanceDetail.action'
			});
	var storePro = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		reader : new Ext.data.JsonReader({
					totalProperty : "pageInner1.totalCount",
					root : 'pageInner1.result',
					idProperty : "servInstanceScId",
					fields : ['msgId', 'servName', 'sendSystem',
							'receiveSystem', 'consumerRequestStatus',
							'consumerResponseStatus', 'receiveStatus',
							'requestStatus', 'responseStatus', 'sendStatus',
							'aimReceiveStatus', 'aimSendStatus', 'servCode']
				})
	});
	var gridWidth = Ext.getBody().getViewSize().width - 200;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}
	var gridHeight = Ext.getBody().getViewSize().height * 0.55;
	var columnWidth = gridWidth - 8;
	var bbar1 = new Ext.PagingToolbar({
				store : storePro,
				firstText : '第一页',
				nextText : '下一页',
				prevText : '上一页',
				refreshText : '刷新',
				lastText : '最后一页',
				beforePageText : '当前',
				afterPageText : '页/共{0}页',
				paramNames : {
					start : 'pageInner1.start',
					limit : 'pageInner1.pageSize'
				},
				pageSize : 10,
				displayInfo : true,
				displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
				emptyMsg : "没有记录"
			});
	var gridPro = new Ext.grid.GridPanel({
				title : '服务实例展现列表',
				width : gridWidth,// Ext.getBody().getViewSize().width
				height : gridHeight,// Ext.getBody().getViewSize().height
				frame : true,
				stripeRows : true,
				bbar : bbar1,
				// sm : sm1,// 设置复选框选择模式
				store : storePro,
				loadMask : true,
				viewConfig : {
					forceFit : true
				},
				columns : [// 配置表格列
						// sm1, // 复选框选择模式中的checkbox组件将会显示在该列
						new Ext.grid.RowNumberer(), {
							header : '消息id',
							dataIndex : 'msgId',
							sortable : true,
							width : 100
						}, {
							header : '服务名',
							dataIndex : 'servName',
							sortable : true,
							width : 100
						}, {
							header : '源系统',
							dataIndex : 'sendSystem',
							sortable : true,
							hidden : false,
							width : 140
						}, {
							header : '目标系统',
							dataIndex : 'receiveSystem',
							sortable : true,
							hidden : false
						}, {
							header : '源系统发送',
							dataIndex : 'consumerRequestStatus',
							sortable : true,
							width : 130,
							renderer : this.dealIdToName
						}, {
							header : '源系统收到响应',
							dataIndex : 'consumerResponseStatus',
							sortable : true,
							width : 100,
							renderer : this.dealIdToName
						}, {
							header : 'oip接受请求',
							dataIndex : 'receiveStatus',
							sortable : true,
							width : 100,
							renderer : this.dealIdToName
						}, {
							header : 'oip发送请求',
							dataIndex : 'requestStatus',
							hidden : false,
							sortable : true,
							width : 100,
							renderer : this.dealIdToName
						}, {
							header : 'oip接受响应',
							dataIndex : 'responseStatus',
							sortable : true,
							width : 100,
							renderer : this.dealIdToName
						}, {
							header : 'oip发送响应',
							dataIndex : 'sendStatus',
							hidden : false,
							renderer : this.dealIdToName
						}, {
							header : '目标系统接受',
							dataIndex : 'aimReceiveStatus',
							hidden : false,
							renderer : this.dealIdToName
						}, {
							header : '目标系统发送',
							dataIndex : 'aimSendStatus',
							hidden : false,
							renderer : this.dealIdToName
						}, {
							header : '服务编码',
							dataIndex : 'servCode',
							hidden : true
						}]
			});
	storePro.baseParams = {
		'innerServInstanceDto1.servCode' : servCodeValue,
		'innerServInstanceDto1.sendSystem' : sendSystemValue,
		'beginTime' : beginTimeValue,
		'endTime' : endTimeValue
	};
	storePro.load({
				params : {
					'pageInner1.start' : 0,
					'pageInner1.pageSize' : 10
				}
			});
	var width = Ext.getBody().getViewSize().width - 190;
	var height = Ext.getBody().getViewSize().height * 0.60;
	if (screen.width == 1024 && screen.height == 768) {
		width = Ext.getBody().getViewSize().width - 100;
	}
	var dslMapWin = new Ext.Window({ // 新建一个窗口
		title : "服务实例展现查看",
		modal : true, // 模式窗口
		width : width,
		height : height,
		resizable : false,
		plain : true,
		listeners : {
			"minimize" : function() {
				this.hide();
			},
			"close" : function() {
				this.close();
			}
		},
		items : [gridPro]
	});
	dslMapWin.show();
};
function dealIdToName(value) {
	if (value == '1')
		return '<font color=blue>' + '成功' + '</font>';
	else
		return '<font color=red>' + '失败' + '</font>';
};