/**
 * 流量监控模块JS
 * 
 * @author ZhangJian
 */
Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';
var pageSize = 10;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}
	// 公用 代码区
	// combox自动加上"请选择"
	var addBlankSelectForCombox = function(combo) { // 自动添加一个空选择项
		combo.on("select", function() {
					if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
						combo.setValue("");
					}
				});
		combo.store.on("datachanged", function(a) {
					var r = new Ext.data.Record({});
					r.set(combo.valueField, ''); // 添加一格值为-1的选项
					r.set(combo.displayField, combo.emptyText);
					a.insert(0, r);
				});
	}

	// 先建注册服务商下拉列表
	var servManStore = new Ext.data.JsonStore({
		url : 'register/servAffordManRegAction_queryAllRegiteredServMans.action',
		root : 'servManList',
		fields : ['servManId', 'servManName'],
		autoLoad : true
	})
	// 服务提供方下拉列表
	var servAffordManCombox = new Ext.form.ComboBox({
				fieldLabel : "服务提供方",
				emptyText : "请选择…",
				store : servManStore,
				editable : false,
				// value:'',
				hiddenName : 'servManId',
				valueField : 'servManId',
				displayField : 'servManName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				forceSelection : true,
				width : 150,
//				initComponent : function() {
//					addBlankSelectForCombox(this);
//				},
				mode : 'local'
			});
		var servConsumeManCombox = new Ext.form.ComboBox({
				fieldLabel : "服务消费方",
				emptyText : "请选择…",
				store : servManStore,
				editable : false,
				// value:'',
				hiddenName : 'servManId',
				valueField : 'servManId',
				displayField : 'servManName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				forceSelection : true,
				width : 150,
				initComponent : function() {
					addBlankSelectForCombox(this);
				},
				mode : 'local'
			});

	var servStore = new Ext.data.JsonStore({
				url : 'register/servAffordManRegAction_queryServByServMan.action',
				root : 'servDtoList',
				fields : ['servId', 'servName']
			})
	// 服务名称下拉列表
	var servCombox = new Ext.form.ComboBox({
				fieldLabel : "服务名称",
				emptyText : "请选择…",
				store : servStore,
				editable : false,
				value : '',
				hiddenName : 'servId',
				valueField : 'servId',
				displayField : 'servName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				disabled : true,
				width : 150,
				mode : 'local',
				initComponent : function() {
					addBlankSelectForCombox(this);
				}
			});
			/*
			 * 起始更新时间和截止更新时间
			 * 
			 * */
    	var beginTimeField = new Ext.form.DateField({
						fieldLabel : '开始时间',
						name : 'updateTimeBegin',
						id   :'updateTimeBegin',
						width : 150,
						allowBlank : false,
						altFormats : 'Y-m-d H:i:s',
						format : 'Y-m-d H:i:s',
						emptyText : '选择一个日期'
					});
	   var endTimeField = new Ext.form.DateField({
						fieldLabel : '结束时间',
						name : 'updateTimeEnd',
						id   :'updateTimeEnd',
						width : 150,
						allowBlank : false,
						altFormats : 'Y-m-d H:i:s',
						format : 'Y-m-d H:i:s',
						emptyText : '选择一个日期'
					});
	/*
	 * 展现方式选择
	 * 
	 */
	  var modeByTime = new Ext.form.Radio({
	       id :"modeSelect",
	       inputValue:1,
	       boxLabel:"按周期展现",
	       checked:true,
	       name :'modeSelect'
	  });
	  var modeUnion = new Ext.form.Radio({
	       inputValue:2,
	       boxLabel:"合并展现",
	       checked:false,
	       name :'modeSelect'
	  });
	  var pageSizeField = new Ext.form.TextField({
				fieldLabel : "每页显示行数",
				name : "pageSize",
				id : "pageSize",
				blankText : '请填写每页显示的行数！',
				msgTarget : 'qtip',
				emptyText : 10 ,
				maxLength : 32,
				width : 150

			})		
	// 二级联动,联动后，原先数据需要清除
	servAffordManCombox.on("select", function(comb) {
				servStore.load({
							params : {
								servAffordManId : comb.value
							}
						});
				servCombox.setValue('');
				// 当服务框未选择时，二级框置不可用
				if (servAffordManCombox.getValue() == '') {
					servCombox.setDisabled(true)
				} else {
					servCombox.setDisabled(false);
				}
			});
	// 计算form 宽度
	var gridWidth = Ext.getBody().getViewSize().width - 5;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 4;
	}
	// 将上面的查询选项放进form 面板 中
	var queryform = new Ext.FormPanel({
				title : "查询条件",
				width : gridWidth,// Ext.getBody().getViewSize().width - 5,
				height: Ext.getBody().getViewSize().height *0.29,//150,
				buttonAlign : 'center',
				applyTo : 'queryform',
				labelWidth : 80,
				labelAlign : "right",
				frame : true,
				items : [{
							layout : "column",
							items : [ {
										columnWidth : 0.3333,
										layout : "form",
										items : servConsumeManCombox
									},{
										columnWidth : 0.3333,
										layout : "form",
										items : servAffordManCombox
									}, {
										columnWidth : 0.3333,
										layout : "form",
										items : servCombox
									},{
										columnWidth : 0.3333,
										layout : "form",
										items : beginTimeField
									},{
										columnWidth : 0.3333,
										layout : "form",
										items : endTimeField

									},{
										columnWidth : 0.3333,
										layout : "form",
										items : pageSizeField

									},{
										columnWidth : 0.1333,
										layout : "fit",
										items : modeByTime
									},{
										columnWidth : 0.1333,
										layout : "fit",
										items : modeUnion
									}]
						}],
				buttons : [{
							text : "查询",
							iconCls : 'find',
						    width : 20,
						    hidden : false,
							handler : queryCheck
						}, {
							text : "重置",
							iconCls : 'resume',
						    width : 20,
						    hidden : false,
							handler : resetQuery
						}]
			});

	/** ********************************************结果列表区*********************************** */
	var hp = new Ext.data.HttpProxy({
				url : 'monitor/servMonAction_findServFluxInfo.action'
			});
	var store = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		// servCtrlId = 1 servId = 0 servName = null
		// ctrlAnalyseTime = 10 countUp = 100 oneBusiBagUp = 0 busiRateUp = 0
		// ctrlType = 1 )
		reader : new Ext.data.JsonReader({
					totalProperty : "page.totalCount",
					root : 'page.result',
					// idProperty : 'servCtrlId',// default id
					fields : ['servMonitorId', 'servId', 'servName',
							 'busiMoSum', 'busiMoAvg','servManReceiveName',
							'requestTimes', 'responseTimes', 'updateTime',
							'ctrlAnalyseTime','servManSendName']
				})
	});
	/**
	 * radio触发check事件
	 */
/*	 modeByTime.on('check',function(modeByTime,isChecked){
	  if(isChecked){
	  	var updateBegin = Ext.get('updateTimeBegin').getValue();
	  	var updateEnd = Ext.get('updateTimeEnd').getValue();
	  	var msgText = '时间格式应为：yyyy-mm-dd hh:mm:ss！';
	  	var servId = servCombox.getValue();
	  	var servManReceiveId  = servAffordManCombox.getValue();
	  	if (servId == ''){
	  	 servId = 0;
	  	   } 
	  	if(servManReceiveId == ''){
	  	   servManReceiveId = 0;
	  	   }
	  	   
		if (!Ext.getCmp('updateTimeBegin').isValid()) {
			Ext.MessageBox.alert("系统提示", msgText, function(btn) {
						Ext.getCmp('updateTimeBegin').focus();
					});
			return;
		}
		if (!Ext.getCmp('updateTimeEnd').isValid()) {
			Ext.MessageBox.alert("系统提示", msgText, function(btn) {
						Ext.getCmp('updateTimeEnd').focus();
					});
			return;
		}
	  		store.baseParams = {
		                'servMonDto.servId' : parseInt(servId),
		                'servMonDto.servManSendCode': servConsumeManCombox.getValue(),
		                'servMonDto.servManReceiveId':parseInt(servManReceiveId),
						'servMonDto.updateTimeBegin' : updateBegin,
						'servMonDto.updateTimeEnd' : updateEnd,
						'servMonDto.showMode' :Ext.getCmp("modeSelect").getGroupValue()
			
		}
	  	store.reload({params:{'page.start':0,'page.pageSize':pageSize}});
	  }
	  else{
	  
	  }
	  	
	  })
	 modeUnion.on('check',function(modeUnion,isChecked){
	  if(isChecked){
	  	var updateBegin = Ext.get('updateTimeBegin').getValue();
	  	var updateEnd = Ext.get('updateTimeEnd').getValue();
	  	var servId = servCombox.getValue();
	  	var servManReceiveId  = servAffordManCombox.getValue();
	  	if (servId == ''){
	  	 servId = 0;
	  	     } 
	  	if(servManReceiveId == ''){
	  	   servManReceiveId = 0;
	  	     }
	 	var msgText = '时间格式应为：yyyy-mm-dd hh:mm:ss！';
		if (!Ext.getCmp('updateTimeBegin').isValid()) {
			Ext.MessageBox.alert("系统提示", msgText, function(btn) {
						Ext.getCmp('updateTimeBegin').focus();
					});
			return;
		}
		if (!Ext.getCmp('updateTimeEnd').isValid()) {
			Ext.MessageBox.alert("系统提示", msgText, function(btn) {
						Ext.getCmp('updateTimeEnd').focus();
					});
			return;
		}
	  		store.baseParams = {
		                'servMonDto.servId' : parseInt(servId) ,
		                'servMonDto.servManSendCode': servConsumeManCombox.getValue(),
		                'servMonDto.servManReceiveId':parseInt(servManReceiveId),
						'servMonDto.updateTimeBegin' : updateBegin,
						'servMonDto.updateTimeEnd' : updateEnd,
						'servMonDto.showMode' :Ext.getCmp("modeSelect").getGroupValue()
			
		}
	  	store.reload({params:{'page.start':0,'page.pageSize':pageSize}});
	  }
	  })*/
	var bbar = new Ext.PagingToolbar({// 分页工具栏
					store : store,
					// 改变传给服务端的分页参数名。extjs3.1推荐是在Store 里面定义这个参数，可是我试验却失败了。
					// 在这里却可以成功，不知道是不是extjs 版本问题
					paramNames : {
						start : 'page.start',
						limit : 'page.pageSize'
					},
					pageSize : pageSize,
					displayInfo : true,
					displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
					emptyMsg : "没有记录"
				});
	function queryCheck() {
		var msgText = '时间格式应为：yyyy-mm-dd hh:mm:ss！';
		var msgTextStart = blankStr+"请选择开始时间!"+blankStr;
		var msgTextEnd = blankStr+"请选择结束时间!"+blankStr;
		if (!Ext.getCmp('updateTimeBegin').isValid()) {
			if(Ext.getCmp("updateTimeBegin").getRawValue() == null ||Ext.getCmp("updateTimeBegin").getRawValue() == ""){
			   Ext.MessageBox.alert("系统提示",msgTextStart,function(){ 
			   	Ext.getCmp("updateTimeBegin").focus();
			   });
			}else{
			Ext.MessageBox.alert("系统提示", msgText, function(btn) {
				        Ext.getCmp("updateTimeBegin").setValue(); 
						Ext.getCmp('updateTimeBegin').focus();
					});
			}
			return;
		}
		if (!Ext.getCmp('updateTimeEnd').isValid()) {
			if(Ext.getCmp("updateTimeEnd").getRawValue() == null|| Ext.getCmp("updateTimeEnd").getRawValue() == ""){
			  Ext.MessageBox.alert("系统提示",msgTextEnd,function(btn){
			   Ext.getCmp("updateTimeEnd").focus();
			  })
			}else{
			Ext.MessageBox.alert("系统提示", msgText, function(btn) {
						Ext.getCmp("updateTimeEnd").setRawValue("");
						Ext.getCmp('updateTimeEnd').focus();
					});
			}
			return;
		}
		updateBegin = Ext.get("updateTimeBegin").getValue();
        updateEnd  = Ext.get("updateTimeEnd").getValue();
        updateBeginTemp = new Date(Date.parse(updateBegin.replace(/-/g,"/")));
        updateEndTemp = new Date(Date.parse(updateEnd.replace(/-/g,"/")));
        
        daydiff = (updateEndTemp.getTime() - updateBeginTemp.getTime())/(1000*60*60*24); 
        if(daydiff < 0){
          Ext.Msg.alert("信息提示","结束时间不能小于开始时间！");
          return ;
         }
		//处理服务id为空时由string类型转long型控制台报错的问题
		var servComboxValue = servCombox.getValue();
		var servConsumeManComboxValue = servConsumeManCombox.getValue();
		var servAffordManComboxValue = servAffordManCombox.getValue();
		var radioValue = Ext.getCmp("modeSelect").getGroupValue();
//		if(radioValue == null ) radioValue = 1;
//		if (servAffordManComboxValue !="" && servCombox.getValue() ==""){
//		Ext.Msg.alert("信息提示!","请选择服务商提供的服务!")
//		return ;
//		}
		pageTotal = parseInt(Ext.getCmp("pageSize").getValue());
        bbar.pageSize = pageTotal;
		if(servComboxValue == ''){
		servComboxValue = 0 ;
		}
		if(servAffordManComboxValue == ''){
		   servAffordManComboxValue = 0;
		 }
		store.baseParams = {
		                'servMonDto.servId' : parseInt(servComboxValue),
		                'servMonDto.servManReceiveId':parseInt(servAffordManComboxValue),
		                'servMonDto.servManSendCode': servConsumeManComboxValue,
						'servMonDto.updateTimeBegin' : Ext.get("updateTimeBegin").getValue(),
						'servMonDto.updateTimeEnd' : Ext.get("updateTimeEnd").getValue(),
						'servMonDto.showMode' :radioValue
			
		}
		store.load({
					params : {
						'page.start' : 0,
						'page.pageSize' : pageTotal						
					}
				}); // 传参供查询调用
	}

	function resetQuery() {
		Ext.getCmp("modeSelect").suspendEvents();
		queryform.getForm().reset();
		Ext.getDom("updateTimeBegin").value = '';
		Ext.getDom("updateTimeEnd").value = '';
		servCombox.setDisabled(true);
	}

	// store.load({params:{start:0, limit:pageSize}});
	// 创建表格数据

	// 定义复选框选择模式变量：加上选择列
	var sm = new Ext.grid.CheckboxSelectionModel();
	// 创建Grid表格组件
	var gridHeight = 360;
	/*if (Ext.getBody().getViewSize().height - 360 > gridHeight) {
		gridHeight = Ext.getBody().getViewSize().height - 360;
	}*/

	var columnWidth = gridWidth - 8;
	var grid = new Ext.grid.GridPanel({
				title : '服务流量监控列表',
				applyTo : 'grid-div',
				width : gridWidth,// Ext.getBody().getViewSize().width - 5,
				// height : 300,
				height :  Ext.getBody().getViewSize().height *0.69,//gridHeight,//
				frame : true,
				stripeRows : true,
				bbar : bbar,
				sm : sm,// 设置复选框选择模式
				store : store,
				loadMask : true,
				viewConfig : {forceFit:true},
				columns : [// 配置表格列
						sm,// 复选框选择模式中的checkbox组件将会显示在该列
						new Ext.grid.RowNumberer(), 
//							{
//							header : "ID",
//							// width : 100,
//							width : columnWidth / 11,// Ext.getBody().getViewSize().width
//							// / 11.5,
//							sortable : true,// yhzhang 2009/10/27
//							dataIndex : 'servMonitorId'
//						}, 
							{
							header : "服务ID",
							// width : 120,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 11,
							sortable : true,
							dataIndex : 'servId',
							name : 'servId',
							hidden : true

						}, {
							header : "服务名称",
							// width : 120,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 11,
							sortable : true,
							dataIndex : 'servName',
							name : 'servName'
						},{
							header : "服务提供方",
							// width : 120,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 11,
							sortable : true,
							hidden : true,
							dataIndex : 'servManReceiveName',
							name : 'servManReceiveName'
						}, {
							header : "服务消费方",
							// width : 120,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 11,
							sortable : true,
							dataIndex : 'servManSendName',
							name : 'servManSendName'
						},  {
							header : "服务调用次数",
							// width : 120,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 11,
							sortable : true,
							dataIndex : 'requestTimes',
							name : 'requestTimes',
							hidden : true

						}, {
							header : "总业务流量(KB)",
							// width : 120,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 11,
							sortable : true,
							dataIndex : 'busiMoSum',
							name : 'busiMoSum'
						}, {
							header : "平均业务流量(KB)",
							// width : 100,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 11.5,
							sortable : true,
							dataIndex : 'busiMoAvg',
							name : 'busiMoAvg'
						}, {
							header : "服务请求次数",
							// width : 80,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 12,
							sortable : true,
							dataIndex : 'requestTimes',
							name : 'requestTimes'
						}, {
							header : "服务响应次数",
							// width : 80,
							width : columnWidth / 12,// Ext.getBody().getViewSize().width
							// / 12,
							sortable : true,
							dataIndex : 'responseTimes',
							name : 'responseTimes'
						}, {
							header : "更新时间",
							// width : 80,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 12,
							sortable : true,
							dataIndex : 'updateTime',
							hidden:true,
							name : 'updateTime'
						}, {
							header : "分析时长",
							// width : 48,
							width : columnWidth / 8,// Ext.getBody().getViewSize().width
							// / 12,
							sortable : true,
							dataIndex : 'ctrlAnalyseTime',
							hidden:true,
							name : 'ctrlAnalyseTime'
						}]
			})
	store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : pageSize
				}
			});
});
