/**
 * 公告内容
 * 
 * @author cjpan
 * @created 2009年3月17日
 */

Ext.BLANK_IMAGE_URL = '../../resources/images/default/s.gif';  //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格


DetailForm = Ext.extend(Ext.form.FormPanel,{
	
	titleTf: null,					//"公告标题"文本框
	authorTf: null,					//"公告作者"文本框
	issueTimeTf: null,      		//"公告日期"文本框
	contentHtmlEditor: null,		//"公告内容"编辑框
	
    constructor: function() {
    
    	this.titleTf = this.createTextField('95.8%','<font size=2>标题</font>','.x-form-text{background:#dfe8f6;border:0;size:3;}');
    	this.authorTf = this.createTextField('95.8%','<font size=2>作者</font>','.x-form-text{background:#dfe8f6;border:0;size:3;}');
    	this.issueTimeTf = this.createTextField('95.8%','<font size=2>日期</font>','.x-form-text{background:#dfe8f6;border:0;size:3;}');
    	this.contentHtmlEditor = this.createHtmlEditor('htmlEditor', '<font size=2>内容</font>', '95.5%', 570, 240);
        
        DetailForm.superclass.constructor.call(this, {
        	renderTo: 'detailForm',
        	title: '公告内容',
            width: Ext.getBody().getViewSize().width - 10,//988,
			height : Ext.getBody().getViewSize().height - 10 ,
            labelWidth: 45,
            frame: true,
            buttonAlign:'right',
            items : [this.titleTf,this.authorTf,this.issueTimeTf,this.contentHtmlEditor],
			buttons:[
			{text: '返回浏览', id: 'add_user_btn', iconCls: 'back',width: 20, hidden: false, handler: this.backClick, scope: this}
			]
        });
    },
    createTextField: function(anchor, fieldLabel, style) {
        var tf = new Ext.form.TextField({
        	anchor: anchor,
            fieldLabel: fieldLabel,
            value: '',
            labelSeparator: ':',
            frame: false,
            readOnly: true,
            border: false,
            style: style
        });
        return tf;
    },
    createHtmlEditor: function(id, fieldLabel, anchor, width, height) {      //生成一个通用的HtmlEditor
        var he = new Ext.form.HtmlEditor({
        	id: id,
            fieldLabel: fieldLabel,
            labelStyle:'',
            anchor: anchor,
            width: width,
            height: height,
            enableAlignments : false,
            enableColors: false,
            enableFont: false,
            enableFontSize: false,
            enableFormat: false,
            enableLinks: false,
            enableLists: false,
            enableSourceEdit: false
        });
        return he;
    },
    backClick: function(){
    	history.back();
    }
});

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + style + ".css");
}


/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();								//开启快速提示功能
    Ext.form.Field.prototype.msgTarget = 'side';		//提示方式为'side'
    
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + window.parent.styleCssValue);
    
    /*********************HtmlEditor添加setReadOnly方法*********************************************/      
    Ext.override(Ext.form.HtmlEditor, {
	/**
	 * Set a readonly mask over the editor
	 * @param {Boolean} readOnly - True to set the read only property, False to switch to the editor
	 */
	setReadOnly: function(readOnly){
		if(readOnly){
			this.syncValue();
			var roMask = this.wrap.mask();
			roMask.dom.style.filter = "alpha(opacity=100);"; //IE
			roMask.dom.style.opacity = "1"; //Mozilla
			roMask.dom.style.background = "#eeeeee";
			roMask.dom.style.overflow = "auto";
			roMask.dom.style.zIndex = 10; 
			roMask.dom.innerHTML = this.getValue();
			this.el.dom.readOnly = true;
		} else {
			if(this.rendered){
				this.wrap.unmask();
			}
			this.el.dom.readOnly = false;
		}
	},
    onRender : function(ct, position){
        Ext.form.HtmlEditor.superclass.onRender.call(this, ct, position);
        this.el.dom.style.border = '';
        this.el.dom.setAttribute('tabIndex', -1);
        this.el.addClass('x-hidden');
        if(Ext.isIE){ // fix IE 1px bogus margin
            this.el.applyStyles('margin-top:-1px;margin-bottom:-1px;');
        }
        this.wrap = this.el.wrap({
            cls:'x-html-editor-wrap', cn:{cls:'x-html-editor-tb'}
        });

        this.createToolbar(this);

        this.tb.items.each(function(item){
           if(item.itemId != 'sourceedit'){
                item.disable();
            }
        });

        var iframe = document.createElement('iframe');
        iframe.name = Ext.id();
        iframe.frameBorder = 'no';

        iframe.src=(Ext.SSL_SECURE_URL || "javascript:false");

        this.wrap.dom.appendChild(iframe);

        this.iframe = iframe;

        if(Ext.isIE){
            iframe.contentWindow.document.designMode = 'on';
            this.doc = iframe.contentWindow.document;
            this.win = iframe.contentWindow;
        } else {
            this.doc = (iframe.contentDocument || window.frames[iframe.name].document);
            this.win = window.frames[iframe.name];
            this.doc.designMode = 'on';
        }
        this.doc.open();
        this.doc.write(this.getDocMarkup());
        this.doc.close();

        var task = { // must defer to wait for browser to be ready
            run : function(){
                if(this.doc.body || this.doc.readyState == 'complete'){
                    Ext.TaskMgr.stop(task);
                    this.doc.designMode="on";
                    this.initEditor.defer(10, this);
                }
            },
            interval : 10,
            duration:10000,
            scope: this
        };
        Ext.TaskMgr.start(task);

        if(!this.width){
            this.setSize(this.el.getSize());
        }

		this.setReadOnly(this.readOnly);
    	}
	});

 
  	var detailForm = new DetailForm();
  	var id = Ext.get("noticeId").dom.value;
  	
  	NoticeInfoManager.findNoticeInfo(id, function(data){
  		var detailStr = Ext.util.JSON.decode(data);
  		detailForm.titleTf.setValue(detailStr.title);
  		detailForm.authorTf.setValue(detailStr.author);
  		detailForm.issueTimeTf.setValue(formatDate(new Date((detailStr.issueTime)["time"]),"y-M-d HH:mm:ss"));
  		detailForm.contentHtmlEditor.setValue(detailStr.content);
  		detailForm.contentHtmlEditor.setReadOnly(true);
  	});
  	
});