/**
 * 发布公告
 * 
 * @author Qinaldo,cjpan
 * @created 2009年2月26日15:45:42
 */

Ext.BLANK_IMAGE_URL = '../../resources/images/default/s.gif';  //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp';     //需要补充的空格

var NOTICETYPE_STORE_URL = 'getAllNoticeType.action';

var noticeTypeStore = new Ext.data.Store({		//"公告类别"store
		proxy: new Ext.data.HttpProxy({url:'getAllNoticeType.action', method:'POST'}),
		reader: new Ext.data.JsonReader({},[{name:'typeId'},{name:'name'}])	
});

var noticeForm;

/***************************公告发布form组件***********************************************/
NoticeForm = Ext.extend(Ext.ux.Form,{
	
	typeCombo: null,			//"公告类别"下拉框
	titleTf: null,				//"公告标题"文本框
	contentHtmlEditor: null,	//"公告内容"编辑框
	addBtn: null,				//"添加公告类别"按钮
	removeBtn: null,			//"删除公告类别"按钮
	updateBtn: null,			//"修改公告类别"按钮
	typeWnd: null,				//"公告类别"窗口
	
    constructor: function() {
    	
    	this.typeCombo = this.createCombo('公告类别','typeId','name','类别不能为空','90%',NOTICETYPE_STORE_URL);
    	this.typeCombo.store.load();
    	this.titleTf = this.createTextFiled("公告标题", "96.6%", "标题不能为空","",50,"标题最大长度是50");
    	this.contentHtmlEditor = this.createHtmlEditor("公告内容","96%", 570, 270,["Arial", "Courier New", "Tahoma", "Times New Roman", "Verdana", "宋体", "隶书", "黑体"]);
    	this.addBtn = this.createButton('添加',"new", this.addTypeClick,this);
    	this.deleteBtn = this.createButton('删除',"delete", this.deleteTypeClick,this);
    	this.updateBtn = this.createButton('修改',"update", this.updateTypeClick,this);
    	this.typeWnd = new TypeWnd();
    	
        NoticeForm.superclass.constructor.call(this, {
        	renderTo: 'NoticeForm',
        	title: '公告发布',
            width: Ext.getBody().getViewSize().width - 10, //800,
			height : Ext.getBody().getViewSize().height - 10 ,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            items: [{
                xtype:"panel",    
                layout:"column",
                items:[{
                    columnWidth:.4,    
                    layout:"form",
                    items: this.typeCombo
                },{
                    columnWidth:.12,    
                    layout:"form",
                    items:this.addBtn,
                    handler: this.addTypeClick,
                    scope: this
                },{
                    columnWidth:.12,    
                    layout:"form",
                    items:this.deleteBtn,
                    handler: this.deleteTypeClick,
                    scope: this
                },{
                    columnWidth:.12,    
                    layout:"form",
                    items:this.updateBtn,
                    handler: this.updateTypeClick,
                    scope: this
                }]},this.titleTf,this.contentHtmlEditor],
            buttons: [
               {text: '发布', id: 'add_user_btn', iconCls: 'new',width: 20, hidden: false, handler: this.addFormClick, scope: this},
               {text: '清空', iconCls: 'refresh', width: 20, handler: this.resetFormClick, scope: this}
            ]
        });
    },
    createTextFiled: function(fieldLabel, anchor, blankText, vtype, maxLength, maxLengthText) {
        var tf = new Ext.form.TextField({
            fieldLabel: fieldLabel,
            allowBlank: false,
            anchor: anchor,
            blankText: blankText,
            vtype: vtype,
            maxLength: maxLength,
            maxLengthText: maxLengthText
        });
        return tf;
    },
    createCombo: function(fieldLabel,id,name,blankText,anchor,url) {    //生成一个通用的ComboBox
        var combo = new Ext.form.ComboBox({
        	autoLoad: true,
            fieldLabel: fieldLabel,
            emptyText: '请选择...',
            isFormField: true,
            anchor: anchor,
            mode: 'local',
            hiddenName: name,
            allowBlank: false,
            blankText: blankText,
            forceSelection: true,
            triggerAction: 'all',
            displayField:name,
            valueField:id,
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name}]))
            }),
            readOnly: true,
            initCancleText:function(o){                 //自动添加一个空选择项
		        o.on("select",function(){
			        if(o.getValue()==-1){ //当选择-1时，把值设置为空
			            o.setValue("");
			        }
		       });
		       this.store.on("datachanged",function(a){
		           var r = new Ext.data.Record({});
		           r.set(o.valueField,-1); //添加一格值为-1的选项
		           r.set(o.displayField,o.emptyText);
		           a.insert(0,r);
		        });
	    	},
		    initComponent:function(){
		        this.initCancleText(this)
		    }
        });
        return combo;
    },
    createHtmlEditor: function(fieldLabel, anchor, width, height, fontFamilies) {      //生成一个通用的HtmlEditor
        var he = new Ext.form.HtmlEditor({
            fieldLabel: fieldLabel,
            anchor: anchor,
            enableLists: false,
            enableLinks: false,    
            enableSourceEdit: false,
            width: width,
            height: height,
            fontFamilies: fontFamilies,
            buttonTips: {
            	bold: {title: 'Bold', text: '粗体'},
            	italic: {title: 'Italic', text: '斜体'},
            	underline: {title: 'Underline', text: '下划线'},
            	increasefontsize: {title: 'Grow Text', text: '增大字体'},
            	decreasefontsize: {title: 'Shrink Text', text: '缩小字体'},
            	forecolor: {title: 'Font Color', text: '字体颜色'},
            	backcolor: {title: 'Text Highlight Color', text: '突出显示'},
            	justifyleft: {title: 'Align Text Left', text: '左对齐'},
            	justifyleft: {title: 'Align Text Left', text: '左对齐'},
            	justifycenter: {title: 'Center Text', text: '居中对齐'},
            	justifyright: {title: 'Align Text Right', text: '右对齐'},
            	insertunorderedlist: {title: 'Bullet List', text: '项目符号'},
            	insertorderedlist: {title: 'Numbered List', text: '数字符号'}
            }
        });
        return he;
    },
    createButton: function(text,iconCls,fn,scope) {
    	var btn = new Ext.Button({
    		align: 'left',
    		text: text,
    		iconCls: iconCls,
    		handler: fn,
    		scope: scope
    	});
    	return btn;
    },
    addTypeClick: function() {
//    	this.typeWnd.show();
//    	Ext.getCmp('add_type_btn').show();
//    	Ext.getCmp('update_type_btn').hide();
//   	this.typeWnd.typeForm.getForm().reset();
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	noticeForm.typeWnd.show();
			    	Ext.getCmp('add_type_btn').show();
			    	Ext.getCmp('update_type_btn').hide();
			    	noticeForm.typeWnd.typeForm.getForm().reset();
			}
    	});
    },
    deleteTypeClick: function() {
    	TimeOutDwr.isTimeOut(function(data){
	    if(data) {
	       Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
	       if (btn == 'ok'){   
	           var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
	           window.location = redirect;   
	       }   
	       });   
	    } 
	    else {
		    	var val = noticeForm.typeCombo.getValue();
		    	if(val) {
		    		Ext.Msg.confirm('系统提示:', blankStr + '是否删除？' + blankStr, function(btn){
		    			if(btn == 'yes'){
		    				NoticeTypeManager.deleteNoticeType(val, function(data){
				    			if(data){
				    				Ext.Msg.alert('系统提示:', blankStr + '删除成功！' + blankStr);
				    				noticeForm.typeCombo.clearValue();
				    				noticeForm.typeCombo.store.load();
				    			}else{
				    				Ext.Msg.alert('系统提示:', blankStr + '删除失败，请选择类别！' + blankStr);
				    			}
		    				});
		    			}
		    		});
		    	} else {
		    		Ext.Msg.alert('系统提示:', blankStr + '删除失败，请选择类别！' + blankStr);
		    	}
	    }
    	});
    },
    updateTypeClick: function(){		//修改类别
//    	var val = this.typeCombo.getValue();
//    	var rawVal = this.typeCombo.getRawValue();
//    	if(val){
//    		this.typeWnd.show();
//    		Ext.getCmp('add_type_btn').hide();
//    		Ext.getCmp('update_type_btn').show();
//    		this.typeWnd.typeForm.typeTf.setValue(rawVal);
//    	}else{
//    		Ext.Msg.alert('系统提示:', blankStr + '修改失败，请选择类别！' + blankStr);
//    	}
    	TimeOutDwr.isTimeOut(function(data){
	    if(data) {
	       Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
	       if (btn == 'ok'){   
	           var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
	           window.location = redirect;   
	       }   
	       });   
	    } 
	    else {
	    	var val = noticeForm.typeCombo.getValue();
	    	var rawVal = noticeForm.typeCombo.getRawValue();
	    	if(val){
	    		noticeForm.typeWnd.show();
	    		Ext.getCmp('add_type_btn').hide();
	    		Ext.getCmp('update_type_btn').show();
	    		noticeForm.typeWnd.typeForm.typeTf.setValue(rawVal);
	    	}else{
	    		Ext.Msg.alert('系统提示:', blankStr + '修改失败，请选择类别！' + blankStr);
	    	}
	    }
	    });   	
    },
    DelHtml: function(Word){		//去除html代码
		a = Word.indexOf("<");
		b = Word.indexOf(">");
		len = Word.length;
		c = Word.substring(0, a);
		if(b == -1)
		b = a;
		d = Word.substring((b + 1), len);
		Word = c + d;
		tagCheck = Word.indexOf("<");
		if(tagCheck != -1)
		Word = this.DelHtml(Word);
		return Word;
	},
    addFormClick: function(){
    	TimeOutDwr.isTimeOut(function(data){
	    if(data) {
	       Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
	       if (btn == 'ok'){   
	           var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
	           window.location = redirect;   
	       }   
	       });   
	    } 
	    else {
		    	var typeId = noticeForm.typeCombo.getValue();
		    	var title = noticeForm.titleTf.getValue();
		    	var content = noticeForm.contentHtmlEditor.getValue();
		    	var length = content.length;
		    	var cont = noticeForm.DelHtml(content);
		    	var subLenth = cont.length;
		    	if(noticeForm.getForm().isValid()) {
		    		/*if(length > 1024){
						Ext.Msg.alert('系统提示:', blankStr + '发布失败，公告内容超过最大长度！' + blankStr);
						return;
			    	}*/
			    	NoticeInfoManager.saveNoticeInfo(typeId, title, content, function(data){
			    		if(data){
							Ext.Msg.alert('系统提示:', blankStr + '发布成功！' + blankStr);
							//noticeForm.getForm().reset();
						}else{
							Ext.Msg.alert('系统提示:', blankStr + '发布失败，请重试！' + blankStr);
							//noticeForm.getForm().reset();
						}
			    	});
			    }
	    }
    	});
    },
    resetFormClick: function(){
    	this.getForm().reset();
    },
    toDisplayNotice: function(){
    	TimeOutDwr.isTimeOut(function(data){
	    if(data) {
	       Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
	       if (btn == 'ok'){   
	           var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
	           window.location = redirect;   
	       }   
	       });   
	    } 
	    else {
		    	if(parent.parent == parent) {
		    		parent.mainPanel.loadMenuByMenuId(2011);				//2011  是浏览公告的MENU_ID
		    	} else {
		    		parent.parent.mainPanel.loadMenuByMenuId(2011);
		//	    	alert(document.protocol);
		//	    	alert(document.location.host);
		//	    	alert(document.location.pathname);
			    	//document.location=  'http://' + document.location.host + '/INAS4/maintenance/notice/displayNotice.jsp';  // tomcat 服务器
			    	//document.location=  'http://' + document.location.host + '/maintenance/notice/displayNotice.jsp';  // weblogic 服务器
			    	
		    	}
	    }
    	});
    }
});

/*************************公告类别form组件*************************************************/
TypeForm = Ext.extend(Ext.form.FormPanel,{

	typeLabel: null,	
	typeTf: null,
	
    constructor: function() {
    
    	this.typeLabel = this.createLabel("88%", "", "");
    	this.typeTf = this.createTextField("88%", "类别名称", 20, "类别名称最大长度是50", "类别名称不能为空", "");
        
        TypeForm.superclass.constructor.call(this, {
            width: 280,
            height: 110,
            labelWidth: 63,
            labelAlign: "left",
            frame: true,
            bodyStyle: "padding: 5px 5px 0",
            items : [this.typeLabel, this.typeTf],
            buttons: [
               {text: '添加', id: 'add_type_btn', iconCls: 'new',width: 20, hidden: false, handler: this.addTypeSubmit, scope: this},
               {text: '修改', id: 'update_type_btn', iconCls: 'refresh',width: 20, hidden: false, handler: this.updateTypeSubmit, scope: this},
               {text: '重置', iconCls: 'refresh', width: 20, handler: this.resetTypeForm, scope: this}
            ]
        });
    },
    createLabel: function(anchor, fieldLabel, text) {
        var label = new Ext.form.Label({
        	anchor: anchor,
        	height: 15,
            fieldLabel: fieldLabel,
            labelSeparator: '',
            text: text
        });
        return label;
    },
    createTextField: function(anchor, fieldLabel, maxLength, maxLengthText, blankText, emptyText) {
        var tf = new Ext.form.TextField({
        	anchor: anchor,
            fieldLabel: fieldLabel,
            labelSeparator: ':',
            maxLength: maxLength,
            maxLengthText: maxLengthText,
            allowBlank: false,
            blankText: blankText,
            emptyText: emptyText,
            selectOnFocus: true
        });
        return tf;
    },
    createButton: function(text,iconCls,fn,scope) {
    	var btn = new Ext.Button({
    		align: 'left',
    		text: text,
    		iconCls: iconCls,
    		handler: fn,
    		scope: scope
    	});
    	return btn;
    },
 	addTypeSubmit: function(){
 		TimeOutDwr.isTimeOut(function(data){
	    if(data) {
	       Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
	       if (btn == 'ok'){   
	           var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
	           window.location = redirect;   
	       }   
	       });   
	    } 
	    else {
		 		//if(noticeForm.getForm().isValid()) {
		 			var name = noticeForm.typeWnd.typeForm.typeTf.getValue();
			 		if(name){
			 			NoticeTypeManager.findNoticeType(name, function(data){
				    		if(data){
				    			Ext.Msg.alert('系统提示:', blankStr + '添加失败，该类别已经存在！' + blankStr);
				    		}else{
				    			NoticeTypeManager.saveNoticeType(name, function(data1){
				    				if(data1){
				    					Ext.Msg.alert('系统提示:', blankStr + '添加成功！' + blankStr);
				    					noticeForm.typeCombo.store.load();
										noticeForm.typeWnd.hide();	    					
				    				}else{
				    					Ext.Msg.alert('系统提示:', blankStr + '添加失败，请重试！' + blankStr);
				    				}
				    			});
				    		}
				    	});
			 		}else{
			 			Ext.Msg.alert('系统提示:', blankStr + '添加失败，类别名称不能为空！' + blankStr);
			 		}
		 	//}
	    }
 		});
 	},
 	updateTypeSubmit: function(){
 		TimeOutDwr.isTimeOut(function(data){
	    if(data) {
	       Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
	       if (btn == 'ok'){   
	           var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
	           window.location = redirect;   
	       }   
	       });   
	    } 
	    else {
		 		if(noticeForm.typeCombo.getValue()!=null && noticeForm.typeWnd.typeForm.typeTf.getValue()!=null) {
		 			var id = noticeForm.typeCombo.getValue();
			 		var name = noticeForm.typeWnd.typeForm.typeTf.getValue();
			 		if(name){
			 			NoticeTypeManager.findNoticeType(name, function(data){
				    		if(data){
				    			Ext.Msg.alert('系统提示:', blankStr + '修改失败，该类别已经存在！' + blankStr);
				    		}else{
				    			NoticeTypeManager.updateNoticeType(id, name, function(data1){
					  				if(data1){
					  					Ext.Msg.alert('系统提示:', blankStr + '修改成功！' + blankStr);
					  					noticeForm.typeCombo.clearValue();
					  					noticeForm.typeCombo.store.load();
					  					noticeForm.typeWnd.hide();
					  				}else{
					  					Ext.Msg.alert('系统提示:', blankStr + '修改失败，请重试！' + blankStr);
					  				}
					  			});
				    		}	
				 		});	
			 		}else{
			 			Ext.Msg.alert('系统提示:', blankStr + '修改失败，类别名称不能为空！' + blankStr);
			 		}
		 		}
	    }
 		});
 	},
 	resetTypeForm: function(){
 		this.getForm().reset();
 	}
});

/*************************公告类别window组件*************************************************/
TypeWnd = Ext.extend(Ext.Window,{

	typeForm: null,
	
 	constructor: function() { 
   		this.typeForm = new TypeForm(); 
   		TypeWnd.superclass.constructor.call(this, {
	       	title: "公告类别",
	       	width: 280,
	       	height: 140,
	       	resizable : false,
	       	plain: true,
	       	modal: true,
	       	autoScroll: false,
	        closeAction: 'hide',
	       	items: [this.typeForm]
   		});
 	}
});

function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();							//开启快速提示功能
    Ext.form.Field.prototype.msgTarget = 'side';	//提示方式为'side'
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + window.parent.parent.parent.styleCssValue);
    Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	 
	function checkUserSessionStatus(conn,response,options) {     
        var sessionStatus = response.getResponseHeader["sessionstatus"]; 
        
        if(typeof(sessionStatus) != "undefined"){   
            Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
            });   
         }     
    }   
    noticeForm = new NoticeForm();
    
});
