/**
 * 公告显示
 * 
 * @author cjpan
 * @created 2009年3月16日
 */
 
Ext.BLANK_IMAGE_URL = '../../resources/images/default/s.gif';  //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
var PAGESIZE = 10;
var TYPE_STORE_URL = 'getAllNoticeType.action';        //公告类别请求的action
var NOTICEINFO_STORE_URL = "getNoticeInfoByTypeId.action";		//公告信息请求的action
var grid = null;

/***************************************公告浏览grid组件***************************************************/
DisplayGrid = Ext.extend(Ext.grid.GridPanel, {
    
    noticeInfoStore : new Ext.data.Store({		//公告信息store
        proxy: new Ext.data.HttpProxy({url:NOTICEINFO_STORE_URL, method:'POST'}),
        reader: new Ext.data.JsonReader({totalProperty: 'totalProperty', root:'root'},[{name: 'id'},{name: 'name'},{name: 'title'},{name: 'content'},{name: 'userName'},{name: 'author'},{name: 'issueTime'}])
    }),
    
    constructor: function() {
    	
        DisplayGrid.superclass.constructor.call(this, {
            renderTo: 'displayGrid',
            title: "公告浏览",
            frame: true,
        	enableHdMenu:false, 
			enableColumnHide:false, 
			draggable:false,
			enableColumnMove:false,
            width: Ext.getBody().getViewSize().width,
            height: Ext.getBody().getViewSize().height,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header: "标题", width: Ext.getBody().getViewSize().width / 4, sortable: false, dataIndex: 'title',renderer:this.getTitle},               
                {header: "作者", width: Ext.getBody().getViewSize().width / 4, sortable: false, dataIndex: 'userName',renderer:this.getUserName},
                {header: "时间", width: Ext.getBody().getViewSize().width / 4, sortable: false, dataIndex: 'issueTime',renderer: this.changeTime, scope: this}
            ]),
            ds: this.noticeInfoStore,
            tools:[{id:'refresh',qtip:'刷新',handler:this.refreshClick}],
            bbar:['->',{text:'查看更多',handler:this.toDetail}]/*,
            listeners: {
                //'rowdblclick': { fn: this.gridDblClick, scope: this}
            }*/
        });
    },
   /* createCombo: function(fieldLabel,url) {    //生成一个通用的ComboBox
        var combo = new Ext.form.ComboBox({
            fieldLabel: fieldLabel,
            emptyText: '所有',
            isFormField: true,
            //anchor: anchor,
            value: '所有',
            width: 100,
            mode: 'local',
            forceSelection: true,
            triggerAction: 'all',
            displayField:'name',
            valueField:'typeId',
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:'typeId'},{name:'name'}]))
            }),
            readOnly: true,
            initCancleText:function(o){                 //自动添加一个空选择项
		        o.on("select",function(){
			        if(o.getValue()==-1){ //当选择-1时，把值设置为空
			            o.setValue("");
			        }
		       });
		       this.store.on("datachanged",function(a){
		           var r = new Ext.data.Record({});
		           r.set(o.valueField,-1); //添加一格值为-1的选项
		           r.set(o.displayField,o.emptyText);
		           a.insert(0,r);
		        });
	    	},
		    initComponent:function(){
		        this.initCancleText(this)
		    }
        });
        return combo;
    },*/
    refreshClick: function(e,tool,grid) {
    	//this.TypeCombo.clearValue();
        //this.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, typeId: null}});
    	grid.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, typeId: null}});
    },/*
    TypeFilter: function(combo) {
    	var typeId = combo.getValue();
    	this.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, typeId: typeId}});
    },*/
    changeTime: function(val) {
    	//return formatDate(new Date(val["time"]),"y-M-d HH:mm:ss");
    	var dateTime = formatDate(new Date(val["time"]),"yyyy-MM-dd HH:mm:ss");
    	return '<span ext:qtip="' + dateTime + '">' + dateTime + '</span>';
    },
    changeType: function(val) {
    	//return '【' + val + '】';
    	var noticeType = '【' + val + '】'; 
    	return '<span ext:qtip="' + noticeType + '">' + noticeType + '</span>';
    },
    gridDblClick:function(grid, rowIndex, e) {
    	parent.parent.parent.mainPanel.loadMenuByMenuId(2011);
    },
    toDetail:function() {
    	parent.parent.parent.mainPanel.loadMenuByMenuId(2011);
    },
    getTitle:function(val) {
    	return '<span ext:qtip="' + val + '">' + val + '</span>';
    },
    getUserName:function(val) {
    	return '<span ext:qtip="' + val + '">' + val + '</span>';
    }
});

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();								//开启快速提示功能
    Ext.form.Field.prototype.msgTarget = 'side';		//提示方式为'side'
    
  //  Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + window.parent.parent.parent.styleCssValue);
 
    grid = new DisplayGrid();
    grid.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, typeId: null}});
/*    grid.store.on('beforeload', function() {
    	var typeId = grid.TypeCombo.getValue();
    	if(typeId == '所有')
    		typeId = null;
        Ext.apply(this,{baseParams:{recordCount: -1, typeId: null}});
    });*/
});

