/**
 * 重新编辑公告
 */

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp';     //需要补充的空格

var noticeForm;

/***************************编辑公告form组件***********************************************/
NoticeForm = Ext.extend(Ext.ux.Form,{
	
	titleTf: null,				//"公告标题"文本框
	contentHtmlEditor: null,	//"公告内容"编辑框	
    constructor: function() {
    	
    	this.titleTf = this.createTextFiled("公告标题", "96.6%", "标题不能为空","",50,"标题最大长度是50");
    	this.contentHtmlEditor = this.createHtmlEditor("公告内容","96%", 570, 270,["Arial", "Courier New", "Tahoma", "Times New Roman", "Verdana", "宋体", "隶书", "黑体"]);
    	
        NoticeForm.superclass.constructor.call(this, {
        	renderTo: 'EditNoticeForm',
        	title: '公告编辑',
            width: Ext.getBody().getViewSize().width - 10,//800,
			height : Ext.getBody().getViewSize().height - 10 ,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            items: [this.titleTf,this.contentHtmlEditor],
            buttons: [
               {text: '保存修改', id: ' save_user_btn',iconCls: 'save',width: 20, hidden: false, handler: this.saveFormClick, scope: this},
               {text: '返回浏览', id: 'add_user_btn', iconCls: 'back',width: 20, hidden: false, handler: this.backClick, scope: this}
            ]
        });
    },
    createTextFiled: function(fieldLabel, anchor, blankText, vtype, maxLength, maxLengthText) {
        var tf = new Ext.form.TextField({
            fieldLabel: fieldLabel,
            allowBlank: false,
            anchor: anchor,
            blankText: blankText,
            vtype: vtype,
            maxLength: maxLength,
            maxLengthText: maxLengthText
        });
        return tf;
    },
    createHtmlEditor: function(fieldLabel, anchor, width, height, fontFamilies) {      //生成一个通用的HtmlEditor
        var he = new Ext.form.HtmlEditor({
            fieldLabel: fieldLabel,
            anchor: anchor,
            enableLists: false,
            enableLinks: false,    
            enableSourceEdit: false,
            width: width,
            height: height,
            fontFamilies: fontFamilies,
            buttonTips: {
            	bold: {title: 'Bold', text: '粗体'},
            	italic: {title: 'Italic', text: '斜体'},
            	underline: {title: 'Underline', text: '下划线'},
            	increasefontsize: {title: 'Grow Text', text: '增大字体'},
            	decreasefontsize: {title: 'Shrink Text', text: '缩小字体'},
            	forecolor: {title: 'Font Color', text: '字体颜色'},
            	backcolor: {title: 'Text Highlight Color', text: '突出显示'},
            	justifyleft: {title: 'Align Text Left', text: '左对齐'},
            	//justifyleft: {title: 'Align Text Left', text: '左对齐'},
            	justifycenter: {title: 'Center Text', text: '居中对齐'},
            	justifyright: {title: 'Align Text Right', text: '右对齐'},
            	insertunorderedlist: {title: 'Bullet List', text: '项目符号'},
            	insertorderedlist: {title: 'Numbered List', text: '数字符号'}
            }
        });
        return he;
    },
    DelHtml: function(Word){		//去除html代码
		a = Word.indexOf("<");
		b = Word.indexOf(">");
		len = Word.length;
		c = Word.substring(0, a);
		if(b == -1)
		b = a;
		d = Word.substring((b + 1), len);
		Word = c + d;
		tagCheck = Word.indexOf("<");
		if(tagCheck != -1)
		Word = this.DelHtml(Word);
		return Word;
	},
    saveFormClick: function(){
    	TimeOutDwr.isTimeOut(function(data){
	    if(data) {
	       Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
	       if (btn == 'ok'){   
	           var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
	           window.location = redirect;   
	       }   
	       });   
	    } 
	    else {
	    	    var id = Ext.get("noticeId").dom.value; 
		    	var title = noticeForm.titleTf.getValue();
		    	var content = noticeForm.contentHtmlEditor.getValue();
		    	var length = content.length;
		    	var cont = noticeForm.DelHtml(content);
		    	var subLenth = cont.length;
		    	if(noticeForm.getForm().isValid()) {
			    	NoticeInfoManager.updateNoticeInfo(id, title, content, function(data){
			    		if(data){
							Ext.Msg.alert('系统提示:', blankStr + '保存成功！' + blankStr);
						}else{
							Ext.Msg.alert('系统提示:', blankStr + '保存失败，请重试！' + blankStr);
						}
			    	});
			    }
	    }
    	});
    },
    backClick: function(){
    	history.back();
    }
});
/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();							//开启快速提示功能
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + window.parent.parent.parent.styleCssValue);
    Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	 
	function checkUserSessionStatus(conn,response,options) {     
        var sessionStatus = response.getResponseHeader["sessionstatus"]; 
        
        if(typeof(sessionStatus) != "undefined"){   
            Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
            });   
         }     
    }   
    
    noticeForm = new NoticeForm();
    var id = Ext.get("noticeId").dom.value;  	
  	NoticeInfoManager.findNoticeInfo(id, function(data){
  		var detailStr = Ext.util.JSON.decode(data);
  		noticeForm.titleTf.setValue(detailStr.title);
  		noticeForm.contentHtmlEditor.setValue(detailStr.content);
  	});
    
});
