/**
 * 公告显示
 * 
 * @author cjpan
 * @created 2009年3月16日
 */
 
Ext.BLANK_IMAGE_URL = '../../resources/images/default/s.gif';  //本地图形化

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
var PAGESIZE = 20;
var TYPE_STORE_URL = 'getAllNoticeType.action';        //公告类别请求的action
var NOTICEINFO_STORE_URL = "getNoticeInfoByTypeId.action";		//公告信息请求的action
var grid = null;

/***************************************公告浏览grid组件***************************************************/
DisplayGrid = Ext.extend(Ext.grid.GridPanel, {
    
	TypeCombo : null,		//公告类别下拉框
    noticeInfoStore : new Ext.data.Store({		//公告信息store
        proxy: new Ext.data.HttpProxy({url:NOTICEINFO_STORE_URL, method:'POST'}),
        reader: new Ext.data.JsonReader({totalProperty: 'totalProperty', root:'root'},[{name: 'id'},{name: 'name'},{name: 'title'},{name: 'content'},{name: 'userName'},{name: 'author'},{name: 'issueTime'}])
    }),
    
    constructor: function() {
    	
    	this.TypeCombo = this.createCombo('公告类别',TYPE_STORE_URL);
    	this.TypeCombo.store.load();
    	this.TypeCombo.on('select', this.TypeFilter, this);
    	
        DisplayGrid.superclass.constructor.call(this, {
            renderTo: 'displayGrid',
            title: "公告浏览",
            frame: true,
            width: Ext.getBody().getViewSize().width,
            height: Ext.getBody().getViewSize().height,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
//                {header: "id", width: 0, sortable: false, dataIndex: 'id',hidden:true},
                {header: "类别", width: 50, sortable: true, dataIndex: 'name',renderer: this.changeType, scope: this},
                {header: "标题", width: 250, sortable: true, dataIndex: 'title'},//yhzhang 
                {header: "作者", width: 60, sortable: true, dataIndex: 'userName'},
                {header: "时间", width: 80, sortable: true, dataIndex: 'issueTime',renderer: this.changeTime, scope: this}
            ]),
            ds: this.noticeInfoStore,
            tbar: ['-','公告类别:',this.TypeCombo,blankStr,'-',
                {text: '刷新', handler: this.refreshClick, iconCls:'refreshxp', scope: this},'-',
                {text: '查看', handler: this.displayDetail, iconCls:'find', scope: this},'-',
                {text: '编辑', id: 'editBtn',handler: this.editClick, iconCls:'update',scope: this},'-',
                {text: '删除', id: 'deleteBtn',handler: this.deleteClick, iconCls:'delete', scope: this},'-',
                {text: '发布公告', handler: this.toIssueNotice, iconCls:'submit', scope: this},'->','提示：只能删除、编辑本人发布的公告'
            ],
            bbar: new Ext.PagingToolbar({
            	firstText:'第一页',
            	nextText:'下一页',
            	prevText:'上一页',
            	refreshText:'刷新',
            	lastText:'最后一页',
            	beforePageText: '当前',
            	afterPageText:'页/共{0}页',
                pageSize : PAGESIZE,
                store: this.noticeInfoStore,
                displayInfo : true,
                displayMsg : '本页显示 {0} - {1},&nbsp;&nbsp;共&nbsp;&nbsp;{2}&nbsp;&nbsp;条记录',
                emptyMsg : "没有可显示的记录"
            }),
            listeners: {
                'dblclick': { fn: this.gridDblClick, scope: this},
                'rowclick': {fn: this.onRowClick, scope: this}
            }
        });
    },
    createCombo: function(fieldLabel,url) {    //生成一个通用的ComboBox
        var combo = new Ext.form.ComboBox({
            fieldLabel: fieldLabel,
            emptyText: '所有',
            isFormField: true,
            //anchor: anchor,
            value: '所有',
            width: 100,
            mode: 'local',
            forceSelection: true,
            triggerAction: 'all',
            displayField:'name',
            valueField:'typeId',
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:'typeId'},{name:'name'}]))
            }),
            readOnly: true,
            initCancleText:function(o){                 //自动添加一个空选择项
		        o.on("select",function(){
			        if(o.getValue()==-1){ //当选择-1时，把值设置为空
			            o.setValue("");
			        }
		       });
		       this.store.on("datachanged",function(a){
		           var r = new Ext.data.Record({});
		           r.set(o.valueField,-1); //添加一格值为-1的选项
		           r.set(o.displayField,o.emptyText);
		           a.insert(0,r);
		        });
	    	},
		    initComponent:function(){
		        this.initCancleText(this)
		    }
        });
        return combo;
    },
    onRowClick: function(grid, rowIndex, e) {
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var record = grid.store.getAt(rowIndex), userId;
			    	if(record)
			    		userId = record.data.author;
			    	LogInManager.getLogInUserId(function(data){
			    		if(data) {
			    			if(data === userId) {
			    				Ext.getCmp('deleteBtn').enable();
			    				Ext.getCmp('editBtn').enable();
			    			} else {
			    				Ext.getCmp('deleteBtn').disable();
			    				Ext.getCmp('editBtn').disable();
			    			}
			    		} else {
			    			Ext.MessageBox.alert("系统提示：", "操作可能出现了某些错误,请重试！");
			    		}
			    	});
			}
    	});
    
    },
 /*   getLogInUserId: function() {
    	var userId;
    	
    	return userId;
    },*/
    gridDblClick: function() {
    	this.displayDetail();
    },
    refreshClick: function() {
    	this.TypeCombo.clearValue();
        this.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, typeId: null}});
    },
    TypeFilter: function(combo) {
    	var typeId = combo.getValue();
    	this.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, typeId: typeId}});
    },
    displayDetail: function() {
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			        var record = grid.getSelectionModel().getSelected();
					if (!record) {
						Ext.Msg.alert('系统提示', blankStr + '请选择一条记录' + blankStr);
						return;
					}
					var id = record.data.id;
			        window.location ="getNoticeInfoById.action?id="+id;
			}
    	});
    },
    editClick:function(){
        TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			        var record = grid.getSelectionModel().getSelected();
					if (!record) {
						Ext.Msg.alert('系统提示', blankStr + '请选择一条记录' + blankStr);
						return;
					}
					var id = record.data.id;
			        window.location ="editNoticeInfoById.action?id="+id;
			}
    	});
    },
    deleteClick:function(){
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	var record = grid.getSelectionModel().getSelected();
			    	
			    	if(record) {
			    	    var id = record.data.id;
			    		Ext.MessageBox.confirm('系统提示:','是否删除所选记录？',function(btn){
			                if(btn == 'yes') {
			                    NoticeInfoManager.deleteNoticeInfoById(id, function(data){
			                       if(data) {
			                           Ext.MessageBox.alert("系统提示:", blankStr + "删除成功！" + blankStr);
			                           grid.store.reload();
			                       }
			                    });
			                }
			            });
			    	} else {
			    		 Ext.Msg.alert('系统提示', blankStr + '请选择一条记录！' + blankStr);
			    	}
			}
    	});
    },
    changeTime: function(val) {
    	return formatDate(new Date(val["time"]),"y-M-d HH:mm:ss");
    },
    changeType: function(val) {
    	return '【' + val + '】';
    },
    toIssueNotice: function(){
    	TimeOutDwr.isTimeOut(function(data){
			if(data) {
				  Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
				    if (btn == 'ok'){   
				        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
				        window.location = redirect;   
				    }   
            	});   
			} else {
			    	if(parent.parent == parent) {
			    		parent.mainPanel.loadMenuByMenuId(2012); 	//2012  是发布公告的MENU_ID//TODO
			    	} else {
			    		parent.parent.mainPanel.loadMenuByMenuId(2012);
			    		//document.location=  'http://' + document.location.host + '/INAS4/maintenance/notice/issueNotice.jsp'; // 服务器是tomcat
			    		//document.location=  'http://' + document.location.host + '/maintenance/notice/issueNotice.jsp';  // 发布时需注意
			    	}
			}
    	});
    }
});

function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + style + ".css");
}

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();								//开启快速提示功能
    Ext.form.Field.prototype.msgTarget = 'side';		//提示方式为'side'
    
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + window.parent.parent.parent.styleCssValue);
    Ext.Ajax.on('requestcomplete',checkUserSessionStatus, this); 
	 
	function checkUserSessionStatus(conn,response,options) {     
        var sessionStatus = response.getResponseHeader["sessionstatus"]; 
        
        if(typeof(sessionStatus) != "undefined"){   
            Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text){   
			    if (btn == 'ok'){   
			        var redirect = URL_START + document.location.host + LOG_IN_URL+'?flag=true';   
			        window.location = redirect;   
			    }   
            });   
         }     
    }   
 
    grid = new DisplayGrid();
    grid.store.load({params: {start: 0, limit: PAGESIZE, recordCount: -1, typeId: null}});
    grid.store.on('beforeload', function() {
    	var typeId = grid.TypeCombo.getValue();
    	if(typeId == '所有')
    		typeId = null;
        Ext.apply(this,{baseParams:{recordCount: -1, typeId: typeId}});
    });
});

