/**
 * @author:shtang
 * @time:2009-4-22
 * @function:日志页面
 */
 var userGrid;
 var conditionForm;
 var resultGrid;
 var USERINFO_STORE_URL='getLogUserInfo.action';
 var LOGINFO_STORE_URL='getLogInfo.action';
 var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';//需要补充的空格
 var PAGESIZE=20;
 
 var userId;		//用户标识
 var operateType;	//操作类型
 var queryTable;	//1表示当前表,0表示历史表
 var beginTime;		//开始时间
 var endTime;		//结束时间
/***************************************UserGrid组件***************************************************/
UserGrid = Ext.extend(Ext.grid.GridPanel, {
	userStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: USERINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({},[{name:'userID'},{name:'userName'},{name:'sex'},{name:'phone'},{name:'mobile'},{name:'organID'},{name:'email'},{name:'organName'},{name:'limitTimeType'},{name:'limitTime'}])
    }),
    userRoleSm: new Ext.grid.CheckboxSelectionModel({handleMouseDown:Ext.emptyFn}),
    constructor: function(){
    UserGrid.superclass.constructor.call(this, {
        	title: '用户信息',
            renderTo: 'userInfoGrid',
            frame: true,
            width: 250,
            height: Ext.getBody().getViewSize().height - 10,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: this.userRoleSm,
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                 this.userRoleSm,
                {header:'机构ID',dataIndex:'organID',width:50,hidden:true},
                {header:'机构名称',dataIndex:'organName',sortable:true,width:120},
                {header:'用户标识',dataIndex:'userID',width:120,hidden:true},
                {header:'用户名称',dataIndex:'userName',sortable:true,width:120},
                {header:'性别',dataIndex:'sex',width:50,hidden:true,renderer:this.sexChange,scope:this},
                {header:'电话',dataIndex:'phone',width:120,hidden:true},
                {header:'手机号码',dataIndex:'mobile',width:120,hidden:true},
                {header:'邮箱',dataIndex:'email',width:120,hidden:true}
                
            ]),
            tbar: new Ext.Toolbar({
            	items:[{
            		id: 'tips',
            		xtype: 'label',
            		text: '系统提示:请选择用户',
            		style: 'color: blue;'
            	}]
            }),
            ds: this.userStore,
            bbar: new Ext.Toolbar({
            	items:['-',
            		{text:'全选',iconCls: 'new', handler:this.onSelectAll,scope:this},'-',
            		{text:'反选',iconCls: 'update',handler:this.onReverse,scope:this},'-',
            		{text:'清除',iconCls: 'delete',handler:this.onClear,scope:this}, '-'
            	]
            })
        });
    },
	
	onSelectAll:function()
	{
		//this.getSelectionModel().selectAll();
		var hd_checker = this.getEl().select('div.x-grid3-hd-checker');
		var hd = hd_checker.first();
//		if(!hd.hasClass('x-grid3-hd-checker-on')) {
//			hd.addClass('x-grid3-hd-checker-on');
//			this.getSelectionModel().selectAll();
//		}
		var select = [];
		for(var i =0,j= 0;i<this.store.getCount();i++){
			if(this.getSelectionModel().isSelected(i)){
				this.getSelectionModel().deselectRow(i);
				select[j]=i;
				j++;
			}else{
				select[j]=i;
				j++;
			}	
		}
		this.getSelectionModel().selectRows(select);
	},
	onClear:function()
	{
		var hd_checker = this.getEl().select('div.x-grid3-hd-checker');
		var hd = hd_checker.first();
		
//		if(hd.hasClass('x-grid3-hd-checker-on')) {
//			hd.removeClass('x-grid3-hd-checker-on');
			this.getSelectionModel().clearSelections();
//		}
	},
	onReverse:function()
	{
		var hd_checker = this.getEl().select('div.x-grid3-hd-checker');
		var hd = hd_checker.first();
		
//		if(hd.hasClass('x-grid3-hd-checker-on')) {
//			hd.removeClass('x-grid3-hd-checker-on');
			
			var select=[];
			for(var i=0,j=0;i<this.store.getCount();i++)
			{
				
				if(this.getSelectionModel().isSelected(i))
				{
					this.getSelectionModel().deselectRow(i);
				}
				else
				{
					select[j]=i;
					j++;
				}
			}
			this.getSelectionModel().selectRows(select);
//		} else {
//			hd.addClass('x-grid3-hd-checker-on');
//			this.getSelectionModel().selectAll();
//		}
	}


});

/***************************************ConditionForm组件***************************************************/
ConditionForm = Ext.extend(Ext.ux.Form,{
	logTypeCombo:null,
	currnetLogRadio:null,
	historyLogRadio:null,
	beginDateField:null,
	beginTimeField:null,
	queryButtonX:null,
	resetButton:null,

	constructor: function(){
		var jsonData = [{'logTypeId':-1, 'logTypeName':'全部'},{'logTypeId':0, 'logTypeName':'新增'},{'logTypeId':2, 'logTypeName':'修改'},{'logTypeId':1, 'logTypeName':'删除'},{'logTypeId':3, 'logTypeName':'查询'},{'logTypeId':4, 'logTypeName':'其它'}];
		this.logTypeCombo=this.createMemoryCombo('操作类型','logTypeId','logTypeName','28%',jsonData);
		this.logTypeCombo.store.load();
		this.currnetLogRadio=this.createRadio("&nbsp;&nbsp;当前(30天之内)",'table',true,0);
		this.historyLogRadio=this.createRadio("&nbsp;&nbsp;历史",'table',false,1);
		this.beginDateField = this.createDateFieldX("起始日期", 'beginDate','Y-m-d H:i','80%','',new Date((new Date()).getTime() - 30*24*3600*1000));
		this.endDateField = this.createDateFieldX("结束日期", 'endDate','Y-m-d H:i','80%','',new Date());
		this.queryButtonX=this.createButton('查询',"find", this.onQuery,this);
		this.resetButton=this.createButton('重置',"resume", this.reset,this);
		this.logTypeCombo.setValue(-1);
		
		this.currnetLogRadio.on('check', function(radio, checked) {
        	if(checked)
        	{
        		this.beginDateField.setValue(new Date((new Date()).getTime() - 30*24*3600*1000));
        		this.endDateField.setValue(new Date());
        	}
        }, this);
        this.historyLogRadio.on('check', function(radio, checked) {
        	if(checked)
        	{
        		this.beginDateField.setValue(new Date((new Date()).getTime() - 60*24*3600*1000));
        		this.endDateField.setValue(new Date((new Date()).getTime() - 30*24*3600*1000));
        	}
        }, this);
	
		ConditionForm.superclass.constructor.call(this,{
		 renderTo: 'queryCondition',
        	title: '日志查询条件',
            width: Ext.getBody().getViewSize().width-260,
            height: Ext.getBody().getViewSize().height*0.3,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            items:[this.logTypeCombo,
            {
                fieldLabel:"日志查询",
                xtype:"panel",
                labelWidth: 1,
                layout:"column",
                isFormField:true,
                labelAlign:"left",
                items: [{
                    columnWidth:.3,
                    layout:"form",
                    labelAlign:"right",
                    items:this.currnetLogRadio
                },{
                    columnWidth:.3,
                    layout:"form",
                    labelAlign:"right",
                    items:this.historyLogRadio
                }]
            },{
                xtype:"panel",    
                layout:"column",
                items:[{
                    columnWidth:.35,    
                    layout:"form",
                    items: this.beginDateField
                },{
                    columnWidth:.35,    
                    layout:"form",
                    items: this.endDateField
                }
                ]
            },{

                xtype:"panel",
                labelWidth: 1,
                layout:"column",
                isFormField:false,
                labelAlign:"center",
                items: [{
                    columnWidth:.18
                },{
                    columnWidth:.33,    
                    layout:"form",
                    items: this.queryButtonX
                },{
                    columnWidth:.33,    
                    layout:"form",
                    items: this.resetButton
                }]
            }
            ]
           
		
		})
	},
	 reset:function(){
	 	this.beginDateField.setValue(new Date((new Date()).getTime() - 30*24*3600*1000));
	 	this.endDateField.setValue(new Date());
	 	this.currnetLogRadio.reset();
	 	this.historyLogRadio.reset();
        this.logTypeCombo.setValue(-1);
	},	
	onQuery:function()
	{
		if(!this.getForm().isValid())
		{
			return;
		}

    	var beginDate=new Date(this.beginDateField.getValue());
    	var endDate=new Date(this.endDateField.getValue());
    	if(beginDate.getTime()>endDate.getTime())
    	{
    		Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"开始时间不能大于结束时间！"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
    		return;
    	}
    	if(this.currnetLogRadio.checked&&beginDate.getTime()<((new Date()).getTime() - 31*24*3600*1000))
    	{
    		Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"只能查询一个月之内的日志!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
    		return;
    	}
    	if(userGrid.getSelectionModel().getCount()<=0)
    	{
    		Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"请选择查询日志用户!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
    		return;
    	}
		var records=[];
		userId=new Array();
		records=userGrid.getSelectionModel().getSelections();
		for(var i=0;i<userGrid.getSelectionModel().getCount();i++)
		{
			userId[i]=records[i].data.userID;
		}
		operateType=this.logTypeCombo.getValue();
		
		if(this.currnetLogRadio.getValue())
		{
			queryTable=1;
		}
		else{
			queryTable=0;
		}
		 beginTime=this.beginDateField.getRawValue();
		 endTime=this.endDateField.getRawValue();
		resultGrid.store.load({params:{start: 0, limit: PAGESIZE, recordCount: -1,userId:userId,operationType:operateType,queryTable:queryTable,beginTime:beginTime,endTime:endTime}});
		
	},
	createTimeField:function(name,fieldLabel,value)
	{
		var tf=new Ext.form.TimeField({
					name: name,
					fieldLabel: fieldLabel,
					allowBlank: false,
					blankText: '请选择开始时间',
					format: 'H:i',
					value: value
		});
		return tf;
	},
	createButton: function(text,iconCls,fn,scope) {
    	var btn = new Ext.Button({
    		align: 'left',
    		text: text,
    		iconCls: iconCls,
    		handler: fn,
    		scope: scope
    	});
    	return btn;
    },
	createDateFieldX: function(fieldLabel, name, format, anchor, minText, value) {
    	var df =  new Ext.form.DateField({
			fieldLabel: fieldLabel,
			name: name,
			value : value,
			anchor: anchor,
			minText: minText,
			format: format,
			allowBlank: false,
			blankText: '请选择时间'
		});
		return df;
    }


});


/***************************************ResultGrid组件***************************************************/
ResultGrid=Ext.extend(Ext.grid.GridPanel, {
		completeLogWnd: null,
	    userStore: new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: LOGINFO_STORE_URL, method: 'POST'}),
        reader: new Ext.data.JsonReader({totalProperty: 'totalProperty', root:'root'},[{name: 'logId'},{name: 'userCode'},{name: 'opeationStatus'},{name: 'logContent'},{name: 'logDate'},{name: 'operationType'},{name: 'userName'}])
    }),
    constructor: function(){
    	this.completeLogWnd=new CompleteLogWnd();
    UserGrid.superclass.constructor.call(this, {
        	title: '查询结果',
            renderTo: 'queryResult',
            frame: true,
            width: Ext.getBody().getViewSize().width-260,
            //height: Ext.getBody().getViewSize().height-150,
            height: Ext.getBody().getViewSize().height*0.68,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect:false}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'日志ID',dataIndex:'logId',width:50},
                {header:'用户标识',dataIndex:'userCode',width:120,hidden:true},
                {header:'用户名称',dataIndex:'userName',width:60},
                {header:'操作内容',dataIndex:'logContent',sortable:true,width:250},
                {header:'操作日志时间',dataIndex:'logDate',sortable:true,width:80,scope:this},
                {header:'操作类型',dataIndex:'operationType',sortable:true,width:80,renderer:this.operationType,scope:this},
                {header:'操作状态',dataIndex:'opeationStatus',sortable:true,width:50,renderer:this.operationState,scope:this}
            ]),
            bbar: new Ext.PagingToolbar({
            	firstText:'第一页',
            	nextText:'下一页',
            	prevText:'上一页',
            	refreshText:'刷新',
            	lastText:'最后一页',
            	beforePageText: '当前',
            	afterPageText:'页/共{0}页',
                pageSize : PAGESIZE,
                store: this.userStore,
                displayInfo : true,
                displayMsg : '本页显示 {0} - {1},&nbsp;&nbsp;共&nbsp;&nbsp;{2}&nbsp;&nbsp;条记录',
                emptyMsg : "没有可显示的记录"
            }),
            
            ds: this.userStore,
            listeners: {
                "dblclick": { fn: this.CompleteInfo, scope: this}
            }
        });
    },
    CompleteInfo:function()
    {
    	var r = this.getSelectionModel().getSelected();
    	if(r) {
    		this.completeLogWnd.show();
    		this.completeLogWnd.completeLogForm.getForm().loadRecord(r);
    		this.completeLogWnd.completeLogForm.operationTypeField.setValue(this.operationType(r.data.operationType));
    		this.completeLogWnd.completeLogForm.logDateField.setValue(r.data.logDate);
 			this.completeLogWnd.completeLogForm.operationStateField.setValue(this.operationState(r.data.opeationStatus));
    	}
    	else{
    		Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"请选择一条记录!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
    	    return;
    	    
    	} 
    },
     formatTime : function(val) {
    		//var valStr = val.constructor == Date ? Ext.util.Format.date(val, 'Y-m-d H:i') : formatDate(new Date(val["time"]),"yyyy-MM-dd HH:MM");   modify jzwu
//     		var valStr = val.constructor == Date ? Ext.util.Format.date(val, 'Y-m-d H:i') : formatDate(new Date(val["time"]),"yyyy-MM-dd HH:mm");    		
//    		var valArr = valStr.split('-');
//    		var valDate = new Date(valArr[0], valArr[1] - 1, valArr[2]);
     	if(val == null){
     		return "";
     	}else{
    		return new Date(val['time']).format("Y-m-d H:i:s");
    		}
    	},
    operationState:function(val)
    {
    	if(val==1)
    	{
    		return "成功";
    	}
    	else
    	{
    		return "失败";
    	}
    },
    operationType:function(val){
    	var value;
    		switch(val)
    		{
    			case 0:value='新增';break;
    			case 1:value='删除';break;
    			case 2:value='更新';break;
    			case 3:value='查询';break;
    			case 4:value='其它';break;
    			default:value='其它';break;
    		}
    		return value;
    	}

});

/****************************CompleteLogForm组件*******************************************/
CompleteLogForm=Ext.extend(Ext.form.FormPanel,{
	userNameField:null,
	operationTypeField:null,
	logDateField:null,
	operationStateField:null,
	logContentArea:null,
	constructor: function(){
	 this.userNameField=this.createTextFiled('用户名称','userName');
	 this.operationTypeField=this.createTextFiled('操作类型','operationType');
	 this.logDateField=this.createTextFiled('操作时间','logDate');
	 this.operationStateField=this.createTextFiled('操作状态','opeationStatus');
	 this.logContentArea=this.createTextArea('操作内容','logContent');
	 
	 CompleteLogForm.superclass.constructor.call(this,{
	  		width: 600,
            height: 210,
            labelWidth : 80,
            frame: true,
            bodyStyle:"padding: 3px 3px 0",
	 		items:[{
	 			layout : "column",
				items : [{
					layout : "form",
					columnWidth : 0.51,
					items : this.userNameField
				},{
					layout : "form",
					columnWidth : 0.45,
					items : this.operationTypeField
				},{
					layout : "form",
					columnWidth : 0.51,
					items : this.logDateField
				},{
					layout : "form",
					columnWidth : 0.45,
					items : this.operationStateField
				},{
					layout : "form",
					columnWidth :  1.0,
					items : this.logContentArea
				}]	
	 		}]
	 })
	},
	createTextFiled: function(fieldLabel, name) 
     {    //生成一个通用的TextField
        var tf = new Ext.form.TextField({
            fieldLabel: fieldLabel,
            xtype: 'textfield',
            readOnly: true,
            anchor:"90%",
            name: name,
            allowBlank:true
        });
        return tf;
    },
    //生成一个通用的TextArea
	createTextArea: function(fieldLabel, name) 
     	{   
        	var ta = new Ext.form.TextArea({
            fieldLabel: fieldLabel,
            xtype: 'textarea',
            readOnly: true,
            anchor:"90%",
            height : 100,
            labelAlign:'center',
            name: name,
            allowBlank:false
        	});
        	return ta;
    }
	
});
/****************************CompleteLogWnd组件**********************************************/
CompleteLogWnd=Ext.extend(Ext.Window,{
	completeLogForm : null,
	 constructor: function() {
	 	this.completeLogForm=new CompleteLogForm();
	 	CompleteLogWnd.superclass.constructor.call(this, {
	 	 	title: "日志详细信息",
            width: 620,
            height: 250,
            resizable : false,
            plain: true,
            modal: true,
            buttonAlign : 'center',
            autoScroll: false,
            closeAction: 'hide',//如果没有这个参数，窗口只显示一次
            items: [
            	this.completeLogForm           
            ],
	 		buttons:[
            	{text:'关闭',width:45,handler:this.winClose, scope: this}
            ]
	 	})	 	
	 },
	 winClose: function() {
    	this.completeLogForm.getForm().reset();
    	this.hide();
    }
});

function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + style + ".css");
}
/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
	Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../../resources/css/" + window.parent.styleCssValue);
    userGrid = new UserGrid();
    userGrid.store.load();
    conditionForm=new ConditionForm();
    
   resultGrid=new ResultGrid();
   resultGrid.store.on('beforeload', function() {
        Ext.apply(this,{baseParams:{recordCount: -1,userId:userId,operationType:operateType,queryTable:queryTable,beginTime:beginTime,endTime:endTime}});
    });
});