Ext.onReady(function(){
	Ext.QuickTips.init();
	Ext.form.Field.prototype.msgTarget = 'side';
	var loginForm = new Ext.form.FormPanel({
		frame : true,
		monitorValid : true,// 把有formBind:true的按钮和验证绑定
		applyTo : "loginForm",
		labelWidth : 50,
		height : 120,
		width : 230,
		submit : function(){
			this.getEl().dom.action = 'login.action',
			this.getEl().dom.method='POST',
			this.getEl().dom.submit();
		},
		items : [
			new Ext.form.TextField({
				fieldLabel : "用户名",
				id : "userCode",
				selectOnFocus : true,
				allowBlank : false,
				blankText : "用户名不能为空，请填写",
				listeners : { // 回车提交
					specialkey : function(field, e) {
						if (e.getKey() == Ext.EventObject.ENTER) {
							login();
						}
					}
				}
			}),
			new Ext.form.TextField({
				fieldLabel : "密码",
				id : "password",
				inputType : 'password',
				allowBlank : false,
				blankText : "密码不能为空，请填写",
				listeners : { // 回车提交
					specialkey : function(field, e) {
						if (e.getKey() == Ext.EventObject.ENTER) {
							login();
						}
					}
				}
			})
		],
		buttons : [
			{
				text : "登陆",
				handler : login,
				formBind : true
			},
			{
				text : "重置",
				handler : function(){
					loginForm.form.reset();
				}
			}
		]
	})
	
	//Ext.get('userCode').focus();
	//loginForm.form.findField("userCode").focus(true);
	document.getElementById('userCode').focus();
	
	// 登陆
	function login(){
		if(document.getElementById('userCode').value != '' && document.getElementById('password').value != '' ){
			loginForm.form.submit();
		}
	}

});



