var g_perfList = null;
var g_perfType = null;
var g_pagingToolbar = null;
var g_lastPerfTypeId = null;
var g_chainSelect = false;
var isFirstLoad = true;
var g_perfItemPerPage = 15;

var g_perfTypeIdBeforeLoad = null;
var g_bInitialized = false;


var g_selectedNodeId = null;

//定义一个DateField
function createDateField(fieldLabel,format,name,width,onChangeHandler){
	var dateField = new Ext.form.DateField({
		fieldLabel:fieldLabel,
		format:format,
		name:name,
		width:width
	});
	if(onChangeHandler){
		dateField.on('change',onChangeHandler);
	}
	return dateField;
}
//定义一个Radio
function createRadio(boxLabel,checked,name){
	var dateField = new Ext.form.Radio({
		boxLabel:boxLabel,
		checked:checked,
		name:name
	});
	return dateField;
}
//定义一个ComboBox
function createCombox(store,emptyText,width,onSelectHandler)
{
	var combo = new Ext.form.ComboBox({
				store:store,
				readOnly:true,
				displayField:'label',
				valueField:'value',
				typeAhead: true,
				mode: 'local',
				triggerAction: 'all',
				emptyText:emptyText,
        		selectOnFocus:true,
				width:width
			});
	combo.on('select',onSelectHandler);	
	return combo;
}


function createComboDataStore( dataSourceUrl ,onLoadHandler)
{
	var ds = new Ext.data.Store({
		// load using HTTP
		proxy: new Ext.data.HttpProxy({url: dataSourceUrl }),
		// the return will be XML, so lets set up a reader
		reader: new Ext.data.XmlReader(
			{
				record:'LabelValues',
				id: 'value'
			},
			[
				{name:'value'},
				{name:'label'}
			])
		});
	ds.on('load',onLoadHandler);
	return ds; 
}



function addPagingToolbarButton(pageToolbar, icon, text, handler)
{
	pageToolbar.add('-',{
		pressed: false,
		enableToggle:false,
		icon: icon,	
		text: text,
		cls: 'x-btn-text-icon details',
		handler: handler
	});
}


function createPerfBoardFooter(grid)
{
	var gridFoot = grid.getView().getFooterPanel(true);
	var paging = new Ext.PagingToolbar(
	    gridFoot, 
	    grid.dataSource, 
	    {
    		pageSize: g_perfItemPerPage,
	    	displayInfo: true,
		    displayMsg: '共{2}条纪录   本页显示 {0} - {1}',
    		emptyMsg: "无纪录"
	    }
	    );
	return paging;
}
function createGridCm(col){
	var cols = new Array(col.length );
	for(var i = 0; i<col.length;i++)
	{
		cols[i] = {
					header: col[i].header,
					dataIndex: col[i].field,
					width: col[i].width,
					hidden: col[i].hidden,
					sortable:!col[i].sortunable
					};
	}
	var cm = new Ext.grid.ColumnModel(cols);
	//cm.defaultSortable = true;
	return cm;
}
function createGridDs(col,url,recordName,totalRecords,recordItemId){
	var plants = new Array(col.length);
	for(var i = 0; i<col.length;i++)
	{
		plants[i] = {name:col[i].field};
	}
	var Plant = Ext.data.Record.create(plants);
	var ds = new Ext.data.Store({
			// load using HTTP
			proxy: new Ext.data.HttpProxy({url: url,method:'POST'}),
			remoteSort:true,
			// the return will be XML, so lets set up a reader
			reader: new Ext.data.XmlReader({
				   // records will have a "plant" tag
				   record: recordName,
				   totalRecords: totalRecords,
				   fields:[
				   	{name:'dbId'},
				   	{name:'dbName'}
				   	]
			})
	});
	return ds;
}

function createPerfBoard( initParam )
{
//	var cols = new Array(initParam.col.length );
//	var plants = new Array(initParam.col.length);
//	for(var i = 0; i<initParam.col.length;i++)
//	{
//		cols[i] = {
//					 header: initParam.col[i].header,
//					 dataIndex: initParam.col[i].field,
//					 id: initParam.col[i].field,
//					 width: initParam.col[i].width,
//					 hidden: initParam.col[i].hidden
//				};
//		plants[i] = {name:initParam.col[i].field};
//	}
//	var cm = new Ext.grid.ColumnModel(cols);
//	//var cm = createGridCm(initParam.col);
//	// by default columns are sortable
//	cm.defaultSortable = true;
//	var Plant = Ext.data.Record.create(plants);
//	// create the Data Store
//	//var ds = createGridDs(initParam.col,initParam.url,initParam.recordName,initParam.totalRecords,initParam.recordItemId)
//	var ds = new Ext.data.Store({
//			// load using HTTP
//			proxy: new Ext.data.HttpProxy({url: initParam.url}),
//			remoteSort:true,
//			// the return will be XML, so lets set up a reader
//			reader: new Ext.data.XmlReader({
//				   // records will have a "plant" tag
//				   record: initParam.recordName,
//				   totalRecords: initParam.totalRecords,
//				   id: initParam.recordItemId
//			   }, Plant)
//		});
	//var cm = createGridCm(initParam.col);
	//var ds = createGridDs(initParam.col,initParam.url,initParam.recordName,initParam.totalRecords,initParam.recordItemId);
	//alert( initParam.containerId);
	var cm = new Ext.grid.ColumnModel([
		{header:'数据库名',dataIndex:'dbName'},
		{header:'id',dataIndex:'dbId',hidden:true,width:100}
	]);
	var rd = new Ext.data.JsonReader({
		root:'list',
		fields:[
			{name:'dbId'},
			{name:'dbName'}
		]
	});
	
	var ds = new Ext.data.Store({
		proxy: new Ext.data.HttpProxy({
			url:'getSybaseDbNames.action',
			method:'POST'
		}),
		reader:rd
	});
//	var perfBoard = new Ext.grid.Grid( initParam.containerId, {
//       	ds: ds,
//        cm: cm,
//        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
//        enableColLock:false,
//        loadMask: true,
//        waitMsg:'数据读取中...'
//    });
	var perfBoard = new Ext.grid.GridPanel({
		ds:ds,
		cm:cm,
		height:200,
		width:125,
        loadMask: true,
		waitMsg:'数据读取中'
	});
	// render it
	perfBoard.store.load();
	perfBoard.render("perfSyDbNameGrid");
   	return perfBoard;
}
