/**
 * File monitor.js
 * @author jluo
 * @version 1.0
 */

var ARCSIZE = 0.15;//弧度

/**
 * 图形点击事件
 */
function OnClickEvent(){
	var URL = "perf.html";
	var urlto = URL+"?";
	if(this.clazz.perfType){
		urlto += "perfType="+this.clazz.perfType;
		if(nodeId != null)urlto += "&node="+nodeId;
		window.location.href = urlto;
	}
}

function addEvent( obj, type, fn ) {  
    if (obj.addEventListener)  
        obj.addEventListener( type, fn, false );  
    else if (obj.attachEvent) {  
        obj["e"+type+fn] = fn;  
        obj.attachEvent( "on"+type, function() { obj["e"+type+fn](); } );  
    }  
}  
function removeEvent( obj, type, fn ) {  
    if (obj.removeEventListener)  
        obj.removeEventListener( type, fn, false );  
    else if (obj.detachEvent) {  
        obj.detachEvent( "on"+type, obj["e"+type+fn] );  
        obj["e"+type+fn] = null;  
    }  
}  

/**
 * 间隔符
 * @param params{left: ,top: ,width: ,height: ,color:} 参数
 */
function SpaceMark(params){
	var FRONTCOLOR = params.color||"green";//默认的前景色
	var line = document.createElement('v:line');
	line.style.left = params.left;
	line.style.top = params.top + params.height/2;
	line.style.zIndex = 1000;
	line.from = '0,0';
	line.to = params.width + ",0" ;
	line.strokecolor = FRONTCOLOR;
	line.strokeweight = params.height + 'px';

	this.line = line;
}


/**
 * 可定位文本区类
 * @param params{text:{alignment: ,className: ,color: ,text:},left: ,top: ,width: ,height: ,zIndex: ,cursor: ,coordsize:} 参数
 */
function TextAera(params){
	this.textDiv;
	this.shape;
	this.showTitle = params.showTitleOnMouseOn||false;
	
	//文本div
	var newText = document.createElement("DIV");
	var text = params.text;
	newText.style.textAlign = text.alignment||'center';
	newText.style.cursor = params.cursor;
	if(text.className)newText.className = text.className;
	if(text.color)newText.style.color = text.color;
	newText.innerHTML = text.text.text||text.text;
	if(this.showTitle)
		newText.title = text.text.title||text.text.text||text.text;
	this.textDiv = newText;

	//定位框
	var newShape= document.createElement("v:shape");
	newShape.style.position = 'absolute';
	newShape.style.left = params.left||0;
	newShape.style.top = params.top||0;
	newShape.style.width = params.width||10;
	newShape.style.height = params.height||10;
	newShape.style.zIndex = params.zIndex||0;
	newShape.coordsize = params.coordsize||'21600,21600';
	newShape.appendChild(newText);

	this.shape = newShape;
	
	//类成员方法
	this.setText = function(text){
		if(text != null){
			this.textDiv.innerHTML = text.text||text;
			if(this.showTitle)this.textDiv.title = text.title||text.text||text;
		}
	}
	this.setColor = function(color){this.textDiv.style.color = color;}
	this.setAlign = function(align){this.textDiv.style.textAlign = align;}
	this.setClass = function(className){this.textDiv.className = className;}
}

/**
 * 图表框架类
 * @param params{width:,height:,title:} 图表参数
 * @param container 父节点
 */
function chart(params,container){
	this.arcsize = params.arcsize||ARCSIZE;
	var BACKCOLOR = "gray";//默认的背景色
	var FRONTCOLOR = "white";//默认的前景色
	var r = Math.min(params.width, params.height)*this.arcsize*10;
	
	//成员变量
	this.vmlGroup;
	this.title = new TextAera({text:{alignment:'center',color:'#f0fff0',className:'charttitle',text:params.title||'TITLE'},left:r,top:20,width:(params.width*10-2*r),height:(r-40),zIndex:10});
	
	//组
	var group = document.createElement("v:group");
	group.style.width = params.width+"px";
	group.style.height = params.height+"px";
	group.coordsize = params.width*10 +"," + params.height*10;
	//背景
	var roundrect = document.createElement("v:roundrect");
	roundrect.style.zIndex = 7;
	roundrect.style.left = 0;
	roundrect.style.top = 0;
	roundrect.style.width = params.width*10+"px";
	roundrect.style.height = params.height*10+"px";
	roundrect.arcsize = this.arcsize;
	roundrect.fillcolor = BACKCOLOR;
	roundrect.strokecolor = "black";
	roundrect.strokeweight = "1px";

	//前景
	var rect = document.createElement("v:rect");
	rect.style.zIndex = 8;
	rect.style.left = 0;
	rect.style.top = r+"px";
	rect.style.width = params.width*10+"px";
	rect.style.height = (params.height*10-r*2)+"px";
	rect.fillcolor = FRONTCOLOR;
	rect.strokecolor = "black";
	rect.strokeweight = "1px";

	group.appendChild(roundrect);
	group.appendChild(rect);
	group.appendChild(this.title.shape);
	container.appendChild(group);

	this.vmlGroup = group;
}

/**
 * Vml按钮类
 * @param params{left:,top:,width:,height:,title:,text:,perfType:} 参数
 */
function VmlButton(params){
	var FRONTCOLOR = "gray";

	this.perfType = params.perfType;
	this.buttonDiv;
	this.btnOval;
	this.title = new TextAera({text:{alignment:'center',color:'red',className:'btntitle',text:params.title||'title'},left:params.left,top:params.top-160,width:params.width,height:150,zIndex:10});
	this.text = new TextAera({text:{alignment:'center',color:'white',className:'btnlabel',text:params.text},left:params.left+50,top:params.top+10,width:params.width-100,height:params.height-20,cursor:'hand',zIndex:10});
	
	//前景
	var oval = document.createElement("v:oval");
	oval.style.zIndex = 9;
	oval.style.left = params.left;
	oval.style.top = params.top;
	oval.style.width = params.width+"px";
	oval.style.height = params.height+"px";
	oval.style.cursor = 'hand';
	oval.filled = "t";
	oval.fillcolor = FRONTCOLOR;
	oval.strokecolor = FRONTCOLOR;
	oval.strokeweight = "1px";
	var fill = document.createElement("<v:fill type='frame' opacity='1'/>");
	oval.appendChild(fill);
	this.btnOval = oval;

	var ovalcover = document.createElement("v:oval");
	ovalcover.style.zIndex = 100;
	ovalcover.style.left = params.left;
	ovalcover.style.top = params.top;
	ovalcover.style.width = params.width+"px";
	ovalcover.style.height = params.height+"px";
	ovalcover.style.cursor = 'hand';
	ovalcover.style.filter = 'alpha(opacity=0,style=0)';
	ovalcover.filled = "t";
	ovalcover.strokeweight = "1px";
	ovalcover.clazz = this;
	this.ovalcover = ovalcover;

	var btnDiv = document.createElement("DIV");
	btnDiv.appendChild(oval);
	btnDiv.appendChild(this.title.shape);
	btnDiv.appendChild(this.text.shape);
	btnDiv.appendChild(ovalcover);
	this.buttonDiv = btnDiv;

	//类成员方法
	this.setTitle = function(text){this.title.setText(text);}
	this.setText = function(text){
		this.text.setText(text);
		this.setColor('green');
	}
	this.setColor = function(color){
		this.btnOval.fillcolor = color;
		this.btnOval.strokecolor = color;
	}
	this.addEvent = function(eventName,fn){
		addEvent(this.ovalcover, eventName, fn);
	}
	//this.addEvent("dblclick",OnClickEvent)
}

/**
 * Bar类
 * @param params{left: ,top: ,width: ,height: ,title: ,text: ,min: ,max: ,perfType:} 参数
 */
function VmlBar(params){
	var BACKCOLOR = "gray";
	var FRONTCOLOR = "green";

	this.perfType = params.perfType;
	this.barDiv; 
	this.frontBar;
	this.backBar;
	this.min = params.min||0;
	this.max = params.max||60;
	this.width = params.width;
	this.limitType = '2';
	this.valves = [0.5,0.6,0.9];
	this.colors = ['green','yellow','blue','red'];
	//标题、标签
	tmpwidth = params.width/2;
	var barHeight = params.height - 450;
	this.title = new TextAera({text:{alignment:'center',className:'bartitle',text:params.title||'title'},left:params.left,top:params.top,width:params.width,height:150,zIndex:10});
	this.minLabel = new TextAera({text:{alignment:'left',color:'black',className:'barlabel',text:this.min},left:params.left,top:params.top+300+barHeight,width:tmpwidth-4,height:150,cursor:'hand',zIndex:10});
	this.maxLabel = new TextAera({text:{alignment:'right',color:'black',className:'barlabel',text:this.max},left:params.left+tmpwidth+4,top:params.top+300+barHeight,width:tmpwidth-4,height:150,cursor:'hand',zIndex:10});
	this.curLabel = new TextAera({text:{alignment:'center',color:'green',className:'barlabel',text:params.text},left:params.left+tmpwidth/2+2,top:params.top+150,width:tmpwidth-4,height:150,cursor:'hand',zIndex:10,showTitleOnMouseOn:true});
//	this.curLabel = new TextAera({text:{alignment:'center',color:'green',className:'barlabel',text:params.text},left:params.left+tmpwidth+2,top:params.top+params.height,width:tmpwidth-4,height:150,cursor:'hand',zIndex:10});

	//背景条
	var rectBack = document.createElement("v:rect");
	rectBack.style.zIndex = 11;
	rectBack.style.left = params.left;
	rectBack.style.top = params.top+300;
	rectBack.style.width = params.width+"px";
	rectBack.style.height = barHeight+"px";
	rectBack.style.cursor = 'hand';
	rectBack.filled = "t";
	rectBack.fillcolor = BACKCOLOR;
	rectBack.strokecolor = "black";
	rectBack.strokeweight = "1px";
	var fillBack = document.createElement("<v:fill type='frame' opacity='39321F'/>");
	rectBack.appendChild(fillBack);
	this.backBar = rectBack;
	//前景条
	var rectFront = document.createElement("v:rect");
	rectFront.style.zIndex = 11;
	rectFront.style.left = params.left;
	rectFront.style.top = params.top+300;
	rectFront.style.width = 0;
	rectFront.style.height = barHeight+"px";
	rectFront.style.cursor = 'hand';
	rectFront.filled = "t";
	rectFront.fillcolor = FRONTCOLOR;
	rectFront.strokecolor = "black";
	rectFront.strokeweight = "1px";
	var fillFront = document.createElement("<v:fill type='frame' opacity='1'/>");
	rectFront.appendChild(fillFront);
	this.frontBar = rectFront;
	//蒙板
	var rectcover = document.createElement("v:rect");
	rectcover.style.zIndex = 100;
	rectcover.style.left = params.left;
	rectcover.style.top = params.top+300;
	rectcover.style.width = params.width+"px";
	rectcover.style.height = barHeight+"px";
	rectcover.style.cursor = 'hand';
	rectcover.style.filter = 'alpha(opacity=0,style=0)';
	rectcover.strokecolor = "black";
	rectcover.strokeweight = "1px";
	rectcover.clazz =this;
	this.rectcover = rectcover;

	var bar = document.createElement("DIV");
	bar.appendChild(rectBack);
	bar.appendChild(rectFront);
	bar.appendChild(rectcover);
	bar.appendChild(this.title.shape);
	bar.appendChild(this.minLabel.shape);
	bar.appendChild(this.maxLabel.shape);
	bar.appendChild(this.curLabel.shape);

	this.barDiv = bar;
	this.clearBar = function(){
		this.maxLabel.setText(' ');
		this.curLabel.setText(' ');
		this.frontBar.style.width = '0px';
	}
	//类成员方法
	this.setBar = function(value){
		if(value.max){
			this.max = value.max.match(/^\d+\.?\d*/);
			this.maxLabel.setText(value.max);
		}
		if(value.limitType){
			this.limitType = value.limitType;
		}
		if(value.colorRuler){
			this.setColorRuler(value.colorRuler);
		}
		if(value.curlabel){
			this.curLabel.setText(value.curlabel);
		}
		if(value.cur){
//			var	percent = value.cur.match(/^\d+\.?\d*/)/(this.max-this.min);
			var	percent = value.cur.match(/^\d+\.?\d*/)/100;
			this.frontBar.style.width = percent*this.width+'px';
			this.setColor(this.colors[level(percent,this.valves,this.limitType)]||FRONTCOLOR);
			this.rectcover.title = value.cur;
		}
	}
	this.setColorRuler = function(colorRuler){
		if(colorRuler.valves)this.valves  = colorRuler.valves ;
		if(colorRuler.colors)this.colors  = colorRuler.colors ;
	}
	this.setColor = function(color){
		this.frontBar.fillcolor = color;
		this.curLabel.setColor(color);
	}
	this.addEvent = function(eventName,fn){
		addEvent(this.rectcover, eventName, fn);
	}
	//this.addEvent("click",OnClickEvent);
}

/**
 * 柱状图类
 * @param params{left: ,top: ,width: ,height: ,colscale:, title: ,text: ,min: ,max: ,labels:{cols: ,rows: ,colscale: ,rowscale:},perfType:} 参数
 */
function VmlCol(params){
	var BACKCOLOR = "gray";
	var FRONTCOLOR = "green";
	var colscale = params.colscale||3;
	var tmpwidth = params.width/colscale;
	var top = params.top + 150 - tmpwidth/colscale/6;
	
	this.perfType = params.perfType;
	this.colDiv; 
	this.frontCol;
	this.ovalcover;
	this.min = params.min||0;
	this.max = params.max||60;
	this.colheight = params.height - 150 + tmpwidth/colscale/6;
	this.limitType = '2';
	this.valves = [0.5,0.6,0.9];
	this.colors = ['green','yellow','blue','red'];
	//标题、标签
	this.title = new TextAera({text:{alignment:'left',className:'coltitle',text:params.title||'title'},left:params.left,top:params.top,width:params.width,height:150,zIndex:10});
	this.labels = new VmlLabels({left:params.left+tmpwidth+5, top:top+tmpwidth/6 ,width:tmpwidth*(colscale-1)-10 ,height:this.colheight ,cols:params.labels.cols ,rows:params.labels.rows ,colscale:params.labels.colscale ,rowscale:params.labels.rowscale });
	this.label1 = new TextAera({text:{alignment:'left',color:'black',className:'collabel',text:this.max},left:params.left+tmpwidth+5,top:top + tmpwidth/6,width:tmpwidth*2-10,height:this.colheight/2,cursor:'hand',zIndex:10});
	this.label2 = new TextAera({text:{alignment:'left',color:'green',className:'collabel',text:this.min},left:params.left+tmpwidth+5,top:top + tmpwidth/6 + this.colheight/2,width:tmpwidth*2-10,height:this.colheight/2,cursor:'hand',zIndex:10});

	//背景
	var ovalBack1 = document.createElement("v:oval");
	ovalBack1.style.zIndex = 11;
	ovalBack1.style.left = params.left;
	ovalBack1.style.top = top + this.colheight;
	ovalBack1.style.width = tmpwidth+"px";
	ovalBack1.style.height = tmpwidth/3+"px";
	ovalBack1.style.cursor = 'hand';
	ovalBack1.filled = "f";
	ovalBack1.stroked= "t";
	ovalBack1.fillcolor = "white";
	ovalBack1.strokecolor = BACKCOLOR;
	ovalBack1.strokeweight = "1px";
	var fillBack1 = document.createElement("<v:extrusion on='t' foredepth='0' backdepth='1px' diffusity='2' rotationangle='90,0'/>");
	fillBack1.color = BACKCOLOR;
	ovalBack1.appendChild(fillBack1);

	var ovalBack2 = document.createElement("v:oval");
	ovalBack2.style.zIndex = 11;
	ovalBack2.style.left = params.left;
	ovalBack2.style.top = top;
	ovalBack2.style.width = tmpwidth+"px";
	ovalBack2.style.height = tmpwidth/3+"px";
	ovalBack2.style.cursor = 'hand';
	ovalBack2.filled = "f";
	ovalBack1.stroked= "t";
	ovalBack2.fillcolor = BACKCOLOR;
	ovalBack2.strokecolor = BACKCOLOR;
	ovalBack2.strokeweight = "1px";
	var fillBack2 = document.createElement("<v:extrusion on='t' foredepth='1px' backdepth='0' diffusity='2' rotationangle='90,0'/>");
	fillBack2.color = BACKCOLOR;
	ovalBack2.appendChild(fillBack2);

	var lineBack1 = document.createElement("v:line");
	lineBack1.style.zIndex = 11;
	lineBack1.style.left = params.left;
	lineBack1.style.top = top;
	lineBack1.stroked = "t";
	lineBack1.strokecolor = BACKCOLOR;
	lineBack1.from="0," + tmpwidth/6;
	lineBack1.to="0," + (this.colheight+tmpwidth/6);
	lineBack1.strokeweight = "1px";

	var lineBack2 = document.createElement("v:line");
	lineBack2.style.zIndex = 11;
	lineBack2.style.left = params.left + tmpwidth;
	lineBack2.style.top = top;
	lineBack2.stroked = "t";
	lineBack2.strokecolor = BACKCOLOR;
	lineBack2.from="0," + tmpwidth/6;
	lineBack2.to="0," + (this.colheight+tmpwidth/6);
	lineBack2.strokeweight = "1px";

	//前景条
	var ovalFront = document.createElement("v:oval");
	ovalFront.style.zIndex = 11;
	ovalFront.style.left = params.left;
	ovalFront.style.top = top + this.colheight;
	ovalFront.style.width = tmpwidth+"px";
	ovalFront.style.height = tmpwidth/3+"px";
	ovalFront.style.cursor = 'hand';
	ovalFront.fillcolor = FRONTCOLOR;
	ovalFront.strokecolor = "white";
	ovalFront.strokeweight = "1px";
	var fillFront = document.createElement("<v:extrusion on='t' backdepth='0' diffusity='2' rotationangle='90,0'/>");
	fillFront.color = FRONTCOLOR;
	fillFront.foredepth = 0;
	ovalFront.appendChild(fillFront);
	this.frontCol = fillFront;

	//蒙板
	var ovalcover = document.createElement("v:oval");
	ovalcover.style.zIndex = 100;
	ovalcover.style.left = params.left;
	ovalcover.style.top = top + this.colheight;
	ovalcover.style.width = tmpwidth+"px";
	ovalcover.style.height = tmpwidth/3+"px";
	ovalcover.style.cursor = 'hand';
	ovalcover.strokecolor = "white";
	ovalcover.strokeweight = "1px";
	ovalcover.style.filter = 'alpha(opacity=0,style=0)';
	var fillcover = document.createElement("<v:extrusion on='t' backdepth='0' diffusity='2' rotationangle='90,0'/>");
	fillcover.foredepth = this.colheight/10 +'px';
	ovalcover.appendChild(fillcover);
	ovalcover.clazz = this;
	this.ovalcover = ovalcover;

	var col = document.createElement("DIV");
	col.appendChild(ovalBack1);
	col.appendChild(ovalFront);
	col.appendChild(lineBack1);
	col.appendChild(lineBack2);
	col.appendChild(ovalBack2);
	col.appendChild(this.title.shape);
	col.appendChild(this.labels.labelsDiv);
	col.appendChild(ovalcover);
	//col.appendChild(this.label1.shape);
	//col.appendChild(this.label2.shape);

	this.colDiv = col;

	//类成员方法
	this.setTitle = function(title){this.title.setText(title)}
	this.setLabels = function(labels){this.labels.setLabels(labels)}
	this.setColors = function(colors){this.labels.setColors(colors)}
	this.setCol = function(values){
		this.setColorRuler(values.colorRuler);
		if(values.limitType){
			this.limitType = values.limitType;
		}
		if(values.cur){
//			var	percent = values.cur.match(/^\d+\.?\d*/)/(values.max.match(/^\d+\.?\d*/)||this.max-this.min);
			var	percent = values.cur.match(/^\d+\.?\d*/)/100;
			this.frontCol.foredepth = percent*this.colheight/10 +'px';
		//	this.label2.setText(value);			
			this.setColor(this.colors[level(percent,this.valves,this.limitType)]||FRONTCOLOR);
		}
	}
	this.clearCol = function(){
		this.frontCol.foredepth = '0px';
		this.setColor(this.colors[0]);
	}
	this.setColorRuler = function(colorRuler){
		if(colorRuler.valves)this.valves  = colorRuler.valves ;
		if(colorRuler.colors)this.colors  = colorRuler.colors ;
	}
	this.setColor = function(color){
		this.frontCol.color = color;
		this.frontCol.parentNode.fillcolor = color;
	//	this.label2.setColor(color);
	}
	this.addEvent = function(eventName,fn){
		addEvent(this.ovalcover, eventName, fn);
	}
	//this.addEvent("click",OnClickEvent);
}

/**
 * 根据值和阀值数组得到级别
 * @param value 值
 * @param array 阀值数组
 * @return 等级索引
 */
function level(value,array,limitType){
	if(array instanceof Array){
		if(limitType == '1'){
			try{
				if(value > array[0])return 0;
				for(i=0;i<array.length-1;i++)
					if(value <= array[i] && value > array[i+1])return i+1;
				if(value <= array[array.length-1])return array.length;
			}
			catch (e){
				alert('error');
			}
		}
		else if(limitType == '2'){
			try{
				if(value < array[0])return 0;
				for(i=0;i<array.length-1;i++)
					if(value >= array[i] && value < array[i+1])return i+1;
				if(value >= array[array.length-1])return array.length;
			}
			catch (e){
				alert('error');
			}
		}
	}
}

/**
 * 获取路径
 */
function getpath(r1,r2,rnd){
	var r3=(r1+r2)/2;
	var pm = 'm'+Math.floor(r2*Math.cos(rnd))+','+Math.floor(-r2*Math.sin(rnd));
	var pl1 = ' l'+Math.floor(r3*Math.cos(rnd-Math.PI*1/18))+','+Math.floor(-r3*Math.sin(rnd-Math.PI*1/18))+','+Math.floor(r1*Math.cos(rnd))+','+Math.floor(-r1*Math.sin(rnd));
	var pat = ' at'+(-r1)+','+(-r1)+','+r1+','+r1+','+Math.floor(r1*Math.cos(rnd))+','+Math.floor(-r1*Math.sin(rnd))+','+Math.floor(r1*Math.cos(rnd+Math.PI*4/9))+','+Math.floor(-r1*Math.sin(rnd+Math.PI*4/9));
	var pl2 = ' l'+Math.floor(r3*Math.cos(rnd+Math.PI*7/18))+','+Math.floor(-r3*Math.sin(rnd+Math.PI*7/18))+','+Math.floor(r2*Math.cos(rnd+Math.PI*4/9))+','+Math.floor(-r2*Math.sin(rnd+Math.PI*4/9));
	var pwa = ' wa'+(-r2)+','+(-r2)+','+r2+','+r2+','+Math.floor(r2*Math.cos(rnd+Math.PI*4/9))+','+Math.floor(-r2*Math.sin(rnd+Math.PI*4/9))+','+Math.floor(r2*Math.cos(rnd))+','+Math.floor(-r2*Math.sin(rnd));
	var path = pm+pl1+pat+pl2+pwa+' e';
	return path;
}
/**
 * 转盘类
 * @param params{left: ,top: ,width: ,stitle: ,dtitle: ,text: ,min: ,max: ,perfType:} 参数
 */
function VmlRound(params){
	var FRONTCOLOR = 'green';
	var x = params.left + params.width/2;
	var y = params.top + params.width/2 + 180;
	var r1 = params.width/2;
	var r2 = params.width/4;
	
	this.perfType = params.perfType;
	this.runValue =  0;
	this.roundDiv;
	this.interval;
	this.min = params.min||0;
	this.max = params.max||60;
	this.valves = [0.5,0.6,0.9];
	this.colors = ['green','yellow','blue','red'];
	this.limitType = '2';
	this.stitle = new TextAera({text:{alignment:'right',className:'roundtitle',text:params.stitle||'stitle'},left:params.left,top:params.top,width:params.width*2/3-10,height:150,zIndex:10});
	this.dtitle = new TextAera({text:{alignment:'left',className:'roundtitle',text:params.dtitle||'dtitle'},left:params.left+params.width*2/3,top:params.top,width:params.width/3,height:150,zIndex:10});
	this.label = new TextAera({text:{alignment:'center',className:'roundlabel',text:params.text||'0'},left:(x-0.8*r2),top:(y-0.4*r2),width:1.6*r2,height:0.8*r2,zIndex:11});
	
	this.roundsharp1 = new RoundSharp({cirX:x,cirY:y,r1:r1,r2:r2,rnd:0});
	this.roundsharp2 = new RoundSharp({cirX:x,cirY:y,r1:r1,r2:r2,rnd:Math.PI/2});
	this.roundsharp3 = new RoundSharp({cirX:x,cirY:y,r1:r1,r2:r2,rnd:Math.PI});
	this.roundsharp4 = new RoundSharp({cirX:x,cirY:y,r1:r1,r2:r2,rnd:Math.PI*3/2});

	var ovalcover = document.createElement("v:oval");
	ovalcover.style.zIndex = 100;
	ovalcover.style.left = params.left;
	ovalcover.style.top = params.top + 150;
	ovalcover.style.width = params.width+"px";
	ovalcover.style.height = params.width+"px";
	ovalcover.style.cursor = 'hand';
	ovalcover.style.filter = 'alpha(opacity=0,style=0)';
	ovalcover.filled = "t";
	ovalcover.strokeweight = "1px";
	ovalcover.clazz = this;
	this.ovalcover = ovalcover;

	var round = document.createElement("DIV");
	round.appendChild(this.stitle.shape);
	round.appendChild(this.dtitle.shape);
	round.appendChild(this.roundsharp1.sharp);
	round.appendChild(this.roundsharp4.sharp);
	round.appendChild(this.roundsharp3.sharp);
	round.appendChild(this.roundsharp2.sharp);
	round.appendChild(this.label.shape);
	round.appendChild(ovalcover);
	this.roundDiv = round;

	/*
	 * 设置标题
	 * @param title {stitle: , dtitle:}
	 */
	this.setTitle = function(title){
		if(title.stitle)this.stitle.setText(title.stitle);
		if(title.dtitle)this.dtitle.setText(title.dtitle);
	//	if(!title.stitle&&!title.dtitle)
	}
	
	this.setValue = function(value){
		this.label.setText(value);
	}
	this.setColorRuler = function(colorRuler){
		if(colorRuler.valves)this.valves  = colorRuler.valves ;
		if(colorRuler.colors)this.colors  = colorRuler.colors ;
	}
	this.setColor = function(color){
		this.roundsharp1.setColor(color);
		this.roundsharp2.setColor(color);
		this.roundsharp3.setColor(color);
		this.roundsharp4.setColor(color);
	}

	this.run = function(){
		var value = this.runValue;
		var	percent = value/(this.max-this.min);
		this.setColor(this.colors[level(percent,this.valves,this.limitType)]||FRONTCOLOR);
		this.roundsharp1.run(percent);
		this.roundsharp2.run(percent);
		this.roundsharp3.run(percent);
		this.roundsharp4.run(percent);
	}
	this.setRound = function(values){
		if(values.title)this.setTitle(values.title);
		if(values.colorRuler)this.setColorRuler(values.colorRuler);
		if(values.limitType){
			this.limitType = values.limitType;
		}
		if(values.value){
			this.runValue = values.value.match(/^\d+\.?\d*/);	
			this.setValue(values.value);	
		}
	}
	this.addEvent = function(eventName,fn){
		addEvent(this.ovalcover, eventName, fn);
	}
	//this.addEvent("click",OnClickEvent);
}

/**
 * 转盘图形
 * @param params{cirX: ,cirY: ,r1: ,r2: ,rnd: ,color:} 按钮参数
 */
function RoundSharp(params){
	var FRONTCOLOR = params.color||'green';

	this.sharp;
	this.arc = params.rnd;

	var sharp = document.createElement('v:shape');
	sharp.style.zIndex = 10;
	sharp.style.left = params.cirX;
	sharp.style.top = params.cirY;
	sharp.style.width = params.r1;
	sharp.style.height = params.r1;
	sharp.style.cursor = 'hand';
	sharp.fillcolor = FRONTCOLOR;
	sharp.strokecolor = FRONTCOLOR;
	sharp.strokeweight = "1px";
	sharp.coordsize = params.r1+','+params.r1;
	sharp.path = getpath(params.r1,params.r2,this.arc);
	var fill = document.createElement("<v:fill type='gradientRadial' opacity='.5' color2='black' angle='90'/>");
	sharp.appendChild(fill);
	this.sharp=sharp;

	this.setPath = function(path){this.sharp.path = path;}
	this.setColor = function(color){
		this.sharp.fillcolor = color;
		this.sharp.strokecolor = color;
	}
	this.run = function(value){
		var src = value||0;
		this.arc -= Math.PI*src/4;
		this.setPath(getpath(params.r1,params.r2,this.arc));
	}
} 

/**
 * 标签集合
 * @param params{left: ,top: ,width: ,height: ,cols: ,rows: ,colscale: ,rowscale: ,perfType:} 按钮参数
 */
function VmlLabels(params){
	this.labelsDiv = document.createElement("DIV");
	this.labels = [];
	this.cols = params.cols||1;
	this.rows = params.rows||1;
	this.perfType = params.perfType;
	
	var a_colscale = [];
	a_colscale[0]=0;
	var a_rowscale = [];
	a_rowscale[0]=0;
	for(var i=0; i<this.rows; i++){
		this.labels[i] = [];
	}
	if(params.colscale){
		var tmparray = params.colscale.split(':');
		var tmpsum =0;
		var tmpscale =0;
		for(var i=0; i<tmparray.length; i++){
			tmpsum+=parseFloat(tmparray[i]);
		}
		for(var i=0; i<tmparray.length; i++){
			tmpscale+=parseFloat(tmparray[i]);
			a_colscale[i+1] = tmpscale/tmpsum;
		}
	}else
		for(var i=0; i<this.cols; i++){
			a_colscale[i+1] = (i+1)/this.cols;
		}
	if(params.rowscale){
		var tmparray = params.rowscale.split(':');
		var tmpsum =0;
		var tmpscale =0;
		for(var i=0; i<tmparray.length; i++){
			tmpsum+=parseFloat(tmparray[i])
		}
		for(var i=0; i<tmparray.length; i++){
			tmpscale+=parseFloat(tmparray[i]);
			a_rowscale[i+1] = tmpscale/tmpsum;
		}
	}else
		for(var i=0; i<this.rows; i++){
			a_rowscale[i+1] = (i+1)/this.rows;
		}
	
	for(var i=0; i<this.rows; i++){
		var top = params.top+params.height*a_rowscale[i];
		var _height = params.height*a_rowscale[i+1] - params.height*a_rowscale[i];//alert('_height='+_height)
		for(var j=0; j<this.cols; j++){//alert("i="+i+'|j='+j+'|a_colscale['+i+']='+a_colscale[i])
			var left = params.left+params.width*a_colscale[j];
			var _width = params.width*a_colscale[j+1] - params.width*a_colscale[j];
			var newText =  new TextAera({text:{className:'labels',text:params.title||i+'-'+j},left:left,top:top,width:_width,height:_height,zIndex:10,showTitleOnMouseOn:true});
			this.labelsDiv.appendChild(newText.shape);
			this.labels[i][j] = newText;
		}
	}

	//labels [[],[],[]]
	this.setLabels = function(labels){
		for(var i=0;i<labels.length;i++){
			for(var j=0;j<labels[i].length;j++){
				if(labels[i][j] != null)this.labels[i][j].setText(labels[i][j]);
			}
		}
	}

	this.setLabel = function(text,rownum,colnum){
		if((0<=colnum && colnum<this.cols)){
				if(0<=rownum && rownum<this.rows)
					this.labels[rownum][colnum].setText(text);
				else for(var i=0; i<this.rows; i++){
					this.labels[i][colnum].setText(text);
				}
			}
		else{
			for(var j=0; j<this.cols; j++){
				if(0<=rownum && rownum<this.rows)
					this.labels[rownum][j].setText(text);
				else for(var i=0; i<this.rows; i++){
					this.labels[i][j].setText(text);
				}
			}
		}
	}

	//labels [[],[],[]]
	this.setColors = function(colors){
		for(var i=0;i<labels.length;i++){
			for(var j=0;j<labels[i].length;j++){
				if(labels[i][j] != null)this.labels[i][j].setColor(colors[i][j]);
			}
		}
	}

	this.setColor = function(color,rownum,colnum){
		if((0<=colnum && colnum<this.cols)){
				if(0<=rownum && rownum<this.rows)
					this.labels[rownum][colnum].setColor(color);
				else for(var i=0; i<this.rows; i++){
					this.labels[i][colnum].setColor(color);
				}
			}
		else{
			for(var j=0; j<this.cols; j++){
				if(0<=rownum && rownum<this.rows)
					this.labels[rownum][j].setColor(color);
				else for(var i=0; i<this.rows; i++){
					this.labels[i][j].setColor(color);
				}
			}
		}
	}

	//params {align: ,type: ,num: }
	this.setAlign = function(params){
			if(params.type == 'col' || params.type == 'cols')
				if(params.num>=0 && params.num<this.cols){
				for(var i=0;i<this.rows;i++)
					this.labels[i][params.num].setAlign(params.align);
				return;
			}
			if(params.type == 'row' || params.type == 'rows')
				if(params.num>=0 && params.num<this.rows){
				for(var i=0;i<this.cols;i++)
					this.labels[params.num][i].setAlign(params.align);
				return;
			}
		
		for(var i=0;i<this.rows;i++)
			for(var j=0;j<this.cols;j++)
				this.labels[i][j].setAlign(params.align);
	}

	//params {className: ,type: ,num: }
	this.setClass = function(params){
			if(params.type == 'col' || params.type == 'cols')
				if(params.num>=0 && params.num<this.cols){
				for(var i=0;i<this.rows;i++)
					this.labels[i][params.num].setClass(params.className);
				return;
			}
			if(params.type == 'row' || params.type == 'rows')
				if(params.num>=0 && params.num<this.rows){
				for(var i=0;i<this.cols;i++)
					this.labels[params.num][i].setClass(params.className);
				return;
			}
		
		for(var i=0;i<this.rows;i++)
			for(var j=0;j<this.cols;j++)
				this.labels[i][j].setClass(params.className);
	}
}

/**
 * Net类
 * @param params{left: ,top: ,width: ,height: ,hostName: ,ip: ,perfType:} 参数
 */
function VmlNet(params){
	var BACKCOLOR = "#999900";
	var FRONTCOLOR = "green";
	
	this.boundId = null;
	this.perfType = params.perfType;
	this.netDiv; 
	this.frontBar;
	this.backBar;
	this.min = params.min||0;
	this.max = params.max||60;
	this.width = params.width;
	this.limitType = '2';
	this.valves = [0.5,0.6,0.9];
	this.colors = ['green','yellow','blue','red'];
	//标题、标签
	tmpwidth = params.width/2;
	var netHeight = params.height;
	var netLeft = params.left + params.width/3;
	var netWidth = params.width/3;
	this.hostName = new TextAera({text:{alignment:'center',className:'bartitle',text:params.hostName||'hostName'},showTitleOnMouseOn:true,left:netLeft,top:params.top,width:netWidth,height:150,zIndex:20});
	//this.ip = new TextAera({text:{alignment:'center',className:'netip',text:params.ip||'ip'},showTitleOnMouseOn:true,left:netLeft,top:params.top+netHeight/2,width:netWidth,height:150,zIndex:120});
	this.ip = new TextAera({text:{alignment:'center',className:'barlabel2',color:'#0506ff',text:params.ip||'ip'},showTitleOnMouseOn:true,left:netLeft,top:params.top+netHeight*2/5,width:netWidth,height:150,zIndex:120});
	this.inpackets = new TextAera({text:{alignment:'right',color:'#0506ff',className:'barlabel',text:{text:'0',title:'收到数据包'}},showTitleOnMouseOn:true,left:params.left,top:params.top+netHeight*2/5,width:netWidth,height:150,cursor:'hand',zIndex:20});
	this.outpackets = new TextAera({text:{alignment:'left',color:'#0506ff',className:'barlabel',text:{text:'0',title:'发送数据包'}},showTitleOnMouseOn:true,left:params.left+params.width*4/6,top:params.top+netHeight*2/5,width:netWidth,height:150,cursor:'hand',zIndex:20});
	this.inerrors = new TextAera({text:{alignment:'center',color:'red',className:'barlabel',text:{text:'0',title:'收到错误包数'}},showTitleOnMouseOn:true,left:params.left+params.width/6,top:params.top+netHeight*2/3,width:netWidth/2,height:150,cursor:'hand',zIndex:20});
	this.outerror = new TextAera({text:{alignment:'center',color:'red',className:'barlabel',text:{text:'0',title:'发送错误包数'}},showTitleOnMouseOn:true,left:params.left+params.width*2/3,top:params.top+netHeight*2/3,width:netWidth/2,height:150,cursor:'hand',zIndex:20});

	//背景条
	var rectBack = document.createElement("v:roundrect");
	rectBack.style.zIndex = 11;
	rectBack.style.left = netLeft;
	rectBack.style.top = params.top;
	rectBack.style.width = netWidth+"px";
	rectBack.style.height = netHeight+"px";
	rectBack.style.cursor = 'hand';
	rectBack.filled = "t";
	rectBack.arcsize = 0.15;
	rectBack.fillcolor = BACKCOLOR;
	rectBack.strokecolor = "black";
	rectBack.strokeweight = "1px";
	var fillBack = document.createElement("<v:fill type='frame' opacity='39321F'/>");
	rectBack.appendChild(fillBack);
	this.backBar = rectBack;

	//蒙板
	var rectcover = document.createElement("v:roundrect");
	rectcover.style.zIndex = 100;
	rectcover.style.left = netLeft;
	rectcover.style.top = params.top;
	rectcover.style.width = params.width/3+"px";
	rectcover.style.height = netHeight+"px";
	rectBack.arcsize = 0.15;
	rectcover.style.cursor = 'hand';
	rectcover.style.filter = 'alpha(opacity=0,style=0)';
	rectcover.strokecolor = "black";
	rectcover.strokeweight = "1px";
	rectcover.clazz =this;
	this.rectcover = rectcover;

	//剑标
	var rectLeft = document.createElement("v:rect");
	rectLeft.style.zIndex = 100;
	rectLeft.style.left = netLeft + netWidth;
	rectLeft.style.top = params.top + netHeight*2/5;
	rectLeft.style.width = params.width/6+"px";
	rectLeft.style.height = netHeight/5+"px";
	rectLeft.style.cursor = 'hand';
	rectLeft.filled = "t";
	rectLeft.fillcolor = BACKCOLOR;
	rectLeft.strokecolor = "black";
	rectLeft.strokeweight = "1px";
	var fillLeft = document.createElement("<v:fill type='frame' opacity='39321F'/>");
	rectLeft.appendChild(fillLeft);

	var rectRight = document.createElement("v:rect");
	rectRight.style.zIndex = 100;
	rectRight.style.left = netLeft - params.width/6;
	rectRight.style.top = params.top + netHeight*2/5;
	rectRight.style.width = params.width/6+"px";
	rectRight.style.height = netHeight/5+"px";
	rectRight.style.cursor = 'hand';
	rectRight.filled = "t";
	rectRight.fillcolor = BACKCOLOR;
	rectRight.strokecolor = "black";
	rectRight.strokeweight = "1px";
	var fillRight = document.createElement("<v:fill type='frame' opacity='39321F'/>");
	rectRight.appendChild(fillRight);

	var net = document.createElement("DIV");
	net.appendChild(rectBack);
	net.appendChild(rectLeft);
	net.appendChild(rectRight);
//	net.appendChild(rectcover);
//	net.appendChild(this.hostName.shape);
	net.appendChild(this.ip.shape);
	net.appendChild(this.inpackets.shape);
	net.appendChild(this.outpackets.shape);
	net.appendChild(this.inerrors.shape);
	net.appendChild(this.outerror.shape);

	this.netDiv = net;
	this.clearNet = function(){
		this.hostName.setText(' ');
		this.ip.setText(' ');
		this.inpackets.setText(' ');
		this.outpackets.setText(' ');
		this.inerrors.setText(' ');
		this.outerror.setText(' ');
	}
	//类成员方法
	this.setNetValue = function(value){
		if(value.hostName){
			this.hostName.setText(value.hostName);
		}
		if(value.ip){
			this.ip.setText(value.ip);
		}
		if(value.inpackets){
			this.inpackets.setText({text:value.inpackets,title:'收到数据包'});
		}
		if(value.outpackets){
			this.outpackets.setText({text:value.outpackets,title:'发送数据包'});
		}
		if(value.inerrors){
			this.inerrors.setText({text:value.inerrors,title:'收到错误包数'});
		}
		if(value.outerror){
			this.outerror.setText({text:value.outerror,title:'发送错误包数'});
		}
		if(value.limitType){
			this.limitType = value.limitType;
		}
		if(value.colorRuler){
			this.setColorRuler(value.colorRuler);
		}
	}

	this.bind = function(boundId){
		this.boundId = boundId;
	}
	this.isBound = function(){
		return (this.boundId != null);
	}
	this.setColorRuler = function(colorRuler){
		if(colorRuler.valves)this.valves  = colorRuler.valves ;
		if(colorRuler.colors)this.colors  = colorRuler.colors ;
	}
	this.setColor = function(color){
		this.frontBar.fillcolor = color;
		this.curLabel.setColor(color);
	}
}

function TableText(params,shape){
	this.tableDiv;
	var table = document.createElement("DIV");
	var paramNumber = params.length;
	var valueLableArray = new Array();
	for(i=0;i<paramNumber ;i++){		
		var lable1 = new TextAera ({text:{alignment:'right',color:'black',className:'barlabel',text:params[i].name},left:0.125*shape.width,top:(shape.top+i*200),width:0.5*shape.width,height:200,cursor:'hand',zIndex:10});		
		var lable2 = new TextAera ({text:{alignment:'left',color:'green',className:'barlabel',text:params[i].value},left:0.625*shape.width,top:(shape.top+i*200),width:0.5*shape.width,height:200,cursor:'hand',zIndex:10});	
		valueLableArray.push(lable2);	
		table.appendChild(lable1.shape);
		table.appendChild(lable2.shape);
	}
	this.tableDiv  = table ; 
	this.setTableValues = function(values){
		for(i=0;i<valueLableArray.length;i=i+1){
			valueLableArray[i].setText (values[i]);
		}
	}
}

function CpuChart(shape){	
	
	var params = {width:shape.width,height:shape.height,title:'CPU'} ;
	var cpuChart = new chart(params,cpudiv);	
	roundCpuUsed = new VmlRound ({width:params.width*6,left:params.width*2,top:0.8*(params.height),stitle:'CPU个数:',dtitle:' ',text:' ',max:100,perfType:'CpuTotal'});
	cpuChart.vmlGroup.appendChild(roundCpuUsed.roundDiv); 
	this.interval=setInterval("roundCpuUsed.run()",100);//控制转速
	cpuUsed = new VmlBar({width:params.width*0.8*10,height:0.08*(params.width*0.8*10)+450,left:params.width,top:0.4*(params.height)*10-300,text:'0',max:100,title:'CPU总利用率'});	
	cpuChart.vmlGroup.appendChild(cpuUsed.barDiv);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*4.8,color:'block'});
	cpuChart.vmlGroup.appendChild(spaceMark.line);
	var lbProcess = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"进程信息"},left:params.width,top:5*(params.height),width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	cpuChart.vmlGroup.appendChild(lbProcess.shape);
	totalProcess = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:0.62*(params.height)*10,text:'0',title:'总进程数',perfType:'ProcessInfo',perfType:'ProcessInfo'});
	cpuChart.vmlGroup.appendChild(totalProcess.buttonDiv); 
	zProcess = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:0.73*(params.height)*10,text:'0',title:'僵尸进程数',perfType:'ProcessInfo',perfType:'ProcessInfo'});
	cpuChart.vmlGroup.appendChild(zProcess.buttonDiv);
	sProcess = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:0.84*(params.height)*10,text:'0',title:'休眠进程数',perfType:'ProcessInfo',perfType:'ProcessInfo'});
	cpuChart.vmlGroup.appendChild(sProcess.buttonDiv);
	
	this.setCpuChart= function(values)
	{	
		if(values && values.cpuUsed){
			//roundCpuUsed.setRound({title:{dtitle:values.cpuTotal},colorRuler:{valves:values.alarmLimit,colors:values.alarmColors},value:values.cpuUsed,limitType:values.cpuUsed.limitType});
			roundCpuUsed.setRound({title:null,colorRuler:null,value:values.cpuUsed,limitType:null});
			try {
				clearInterval(this.interval);
			} catch (e) {}
			finally {
				this.interval = setInterval("roundCpuUsed.run()",100);
			}	
			cpuUsed.setBar({cur:values.cpuUsed,curlabel:values.cpuUsed,max:'100%',colorRuler:{valves:values.alarmLimit,colors:values.alarmColors}});
			if(values.cpuNumbers)roundCpuUsed.setTitle({dtitle:values.cpuNumbers});
			//alert(values.totalProcess+"---"+values.zProcess+"---"+values.sleepProcess);
			totalProcess.setText(values.totalProcess);
			zProcess.setText(values.zombiesProcess);
			sProcess.setText(values.sleepProcess); 	
		}
		
	}
	this.clearCpuChart = function(){
		this.setCpuChart({cpuTotal:' ',alarmLimit:[],alarmColors:[],cpuUsed:'0',totalProcess:0,zombiesProcess:0,sleepProcess:0});
	}
}


	
function MemChart(shape){
	var params = {width:shape.width,height:shape.height,title:'Memory'} ;
	var memChart = new chart(params,memdiv);
	//物理内存信息
	var lbPhysicalTitle = new TextAera({text:{alignment:'center',color:'black',className:'texttitle',text:'物理内存'},left:params.width,top:(10/9)*(params.height),width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	memChart.vmlGroup.appendChild(lbPhysicalTitle.shape);
	phyMemTable = new TableText([{name:'总大小:',value:' '},{name:'剩余大小:',value:''},{name:'使用率:',value:''}],{width:params.width*0.8*10,top:(16/9)*(params.height)});
	memChart.vmlGroup.appendChild(phyMemTable.tableDiv);
	barPhyMemUsed = new VmlBar({width:params.width*0.8*10,height:0.08*(params.width*0.8*10)+450,left:params.width,top:(10/3)*(params.height)-300,text:'0',max:100,title:' ',perfType:'MemTotal'});
	memChart.vmlGroup.appendChild(barPhyMemUsed.barDiv);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*4.5,color:'block'});
	memChart.vmlGroup.appendChild(spaceMark.line);
	//总内存信息
	var lbTotalTitle = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"总内存"},left:params.width,top:(44/9)*(params.height),width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	memChart.vmlGroup.appendChild(lbTotalTitle.shape);
	var totalMemTable = new TableText([{name:'总大小:',value:' '},{name:'剩余大小:',value:''},{name:'使用率:',value:''}],{top:(50/9)*(params.height),width:params.width*0.8*10});
	memChart.vmlGroup.appendChild(totalMemTable.tableDiv);
	var barTotalMemUsed = new VmlBar({width:params.width*0.8*10,height:0.08*(params.width*0.8*10)+450,left:params.width,top:7.1*(params.height)-300,text:'0',max:100,title:' '});
	memChart.vmlGroup.appendChild(barTotalMemUsed.barDiv);
	
	this.setMemChart = function(values){
		if(values.phyMemTable){
			phyMemTable.setTableValues([values.phyMemTable.total,values.phyMemTable.free,values.phyMemTable.quo]); 				
			barPhyMemUsed.setBar({cur:values.phyMemTable.quo,curlabel:values.phyMemTable.used,max:values.phyMemTable.total,colorRuler:{valves:values.phyMemTable.alarmLimit,colors:values.phyMemTable.alarmColors},limitType:values.phyMemTable.limitType});
		}
		if(values.totalMemTable){
			totalMemTable.setTableValues([values.totalMemTable.total,values.totalMemTable.free,values.totalMemTable.quo]);
			barTotalMemUsed.setBar({cur:values.totalMemTable.quo,curlabel:values.totalMemTable.used,max:values.totalMemTable.total,colorRuler:{valves:values.totalMemTable.alarmLimit,colors:values.totalMemTable.alarmColors},limitType:values.totalMemTable.limitType});
		}
	}
   this.clearMemChart = function(){
   		//this.setMemChart({phyMemTable:{total:' ',free:' ',quo:' ',used:'0'},totalMemTable:{total:' ',free:' ',quo:' ',used:'0'}});
   		phyMemTable.setTableValues([' ',' ',' ']);
   		barPhyMemUsed.clearBar();
   		totalMemTable.setTableValues([' ',' ',' ']);
   		barTotalMemUsed.clearBar();
   }
}

function SwapChart(shape){
	var params = {width:shape.width,height:shape.height,title:'Swap File'} ;
	var swapChart = new chart(params,swapdiv);
	colSwap  = new VmlCol({title:'虚拟内存',width:params.width*9,height:params.height*5,left:params.width,top:params.height*2,colscale:4,labels:{cols:2 ,rows:3,colscale:'1:1' },perfType:'SwapTotal'});
	colSwap.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSwap.labels.setAlign({align:'left' ,type:'cols' ,num:1});
	colSwap.labels.setColor('green',-1,1);
	colSwap.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	swapChart.vmlGroup.appendChild(colSwap.colDiv);
	this.setSwapChart = function(values){
		if(values){
			colSwap.setCol({cur:values.quo,curlabel:values.used,max:values.total,colorRuler:{valves:values.alarmLimit,colors:values.alarmColors},limitType:values.limitType});
			colSwap.setLabels([[,values.total],[,values.free],[,values.quo]]);
		}
	}
	this.clearSwapChart = function(){
		colSwap.clearCol();
		colSwap.setLabels([[,' '],[,' '],[,' ']])
	}
}

function DiskChart(shape){
	var params = {width:shape.width,height:shape.height,title:'Disk'} ;
	var diskChart = new chart(params,diskdiv);
	colDiskTotal = new VmlCol({title:'磁盘总空间',width:params.width*9,height:params.height*3,left:params.width,top:params.height*1,colscale:4,labels:{cols:2 ,rows:3,colscale:'1:1' },perfType:'DiskTotal'}); 
	colDiskTotal.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colDiskTotal.labels.setAlign({align:'left' ,type:'cols' ,num:1});
	colDiskTotal.labels.setColor('green',-1,1);
	colDiskTotal.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	diskChart.vmlGroup.appendChild(colDiskTotal.colDiv);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*4.8,color:'block'});
	diskChart.vmlGroup.appendChild(spaceMark.line);
	var lbDiskMostUsedTitle = new TextAera ({text:{alignment:'center',color:'black',text:"使用率最高空间"},left:params.width,top:params.height*5,width:params.width*0.8*10,height:200, cursor:'hand',zIndex:10});
	diskChart.vmlGroup.appendChild(lbDiskMostUsedTitle.shape);
	colDiskMostUsed = new VmlCol({title:' ',width:params.width*9,height:params.height*3,left:params.width,top:params.height*5.5,colscale:4,labels:{cols:2 ,rows:3,colscale:'1:1' },perfType:'DiskInfo'});
	colDiskMostUsed.title.showTitle = true;
	colDiskMostUsed.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colDiskMostUsed.labels.setAlign({align:'left' ,type:'cols' ,num:1});
	colDiskMostUsed.labels.setColor('green',-1,1);
	colDiskMostUsed.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	diskChart.vmlGroup.appendChild(colDiskMostUsed.colDiv);
	this.setDiskChart = function(values){
		if(values.diskTotal){
			colDiskTotal.setCol({cur:values.diskTotal.quo,max:values.diskTotal.total,colorRuler:{valves:values.diskTotal.alarmLimit,colors:values.diskTotal.alarmColors},limitType:values.diskTotal.limitType,perfType:'DiskTotal'});
			colDiskTotal.setLabels([[,values.diskTotal.total],[,values.diskTotal.free],[,values.diskTotal.quo]]);
		}
		if(values.diskMostUsed){
			colDiskMostUsed.setTitle(values.diskMostUsed.title);
			colDiskMostUsed.setCol({cur:values.diskMostUsed.quo,max:values.diskMostUsed.total,colorRuler:{valves:values.diskMostUsed.alarmLimit,colors:values.diskMostUsed.alarmColors},limitType:values.diskMostUsed.limitType,perfType:'DiskInfo'});
			colDiskMostUsed.setLabels([[,values.diskMostUsed.total],[,values.diskMostUsed.free],[,values.diskMostUsed.quo]]);
		}
	}
	this.clearDiskChart = function(){
		colDiskTotal.clearCol();
		colDiskTotal.setLabels([[,' '],[,' '],[,' ']]);
		colDiskMostUsed.setTitle(' ');
		colDiskMostUsed.clearCol();
		colDiskMostUsed.setLabels([[,' '],[,' '],[,' ']]);
	}
}

function NetworkChart(shape){
	var params = {width:shape.width,height:shape.height,title:'Network'};
	var diskChart = new chart(params,networkdiv);
	totalInErr = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*2,text:'0',title:'总接收错误次数'});
	diskChart.vmlGroup.appendChild(totalInErr.buttonDiv); 
	totalOutErr = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*5,text:'0',title:'总发送错误次数'});
	diskChart.vmlGroup.appendChild(totalOutErr.buttonDiv);
	this.setNetworkChart = function(values){
		totalInErr.setText(values.inErr);
		totalOutErr.setText(values.outErr);
	}
}

function OraInfoChart(shape){
	var params = {width:shape.width,height:shape.height,title:'Oracle Info'} ;
	infoChart = new chart(params,oraInfoDiv);
	var lbSession = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"Session"},left:params.width,top:0.5*(params.height),width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	infoChart.vmlGroup.appendChild(lbSession.shape);
	//Session
	totalSession = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*1.5,text:'0',title:'Session总数',perfType:'OrServiceInfo'});
	infoChart.vmlGroup.appendChild(totalSession.buttonDiv); 
	activeSession = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*2.5,text:'0',title:'活动Session',perfType:'OrServiceInfo'});
	infoChart.vmlGroup.appendChild(activeSession.buttonDiv);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*3.3,color:'block'});
	infoChart.vmlGroup.appendChild(spaceMark.line);
	//游标
	var lbCursor = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"游标"},left:params.width,top:3.5*(params.height),width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	infoChart.vmlGroup.appendChild(lbCursor.shape);
	totalCursor = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*4.5,text:'0',title:'游标总数',perfType:'OrPerformance'});
	infoChart.vmlGroup.appendChild(totalCursor.buttonDiv); 
	userCursor = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*5.5,text:'0',title:'用户游标数',perfType:'OrPerformance'});
	infoChart.vmlGroup.appendChild(userCursor.buttonDiv); 
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*6.3,color:'block'});
	infoChart.vmlGroup.appendChild(spaceMark.line);
	//锁
	var lbLock = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"锁"},left:params.width,top:6.5*(params.height),width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	infoChart.vmlGroup.appendChild(lbLock.shape);
	totalLock = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*7.5,text:'0',title:'锁个数',perfType:'OrPerformance'});
	infoChart.vmlGroup.appendChild(totalLock.buttonDiv); 
	deadLock = new VmlButton({width:params.width*0.8*10,height:0.2*(params.width*0.8*10),left:params.width,top:params.height*8.5,text:'0',title:'死锁个数',perfType:'OrPerformance'});
	infoChart.vmlGroup.appendChild(deadLock.buttonDiv);	
	//成员方法
	this.setOraInfoChart = function(values){
		if(values){
			totalSession.setText(values.totalSession);
			activeSession.setText(values.activeSession);
			totalCursor.setText(values.totalCursor);
			userCursor.setText(values.userCursor);
			totalLock.setText(values.totalLock);
			deadLock.setText(values.deadLock);
		}
	}
	this.clearOraInfoChart = function(){
		totalSession.setText(0);
		activeSession.setText(0);
		totalCursor.setText(0);
		userCursor.setText(0);
		totalLock.setText(0);
		deadLock.setText(0);
	}
}

function OraSgaChart(shape){
	var params = {width:shape.width,height:shape.height,title:'SGA'} ;
	var sgaChart = new chart(params,oraSgaDiv);
	var lbSgaSize = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"大小"},left:params.width,top:params.height,width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	sgaChart.vmlGroup.appendChild(lbSgaSize.shape);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*1.5,color:'block'});
	sgaChart.vmlGroup.appendChild(spaceMark.line);
	
	sgaTable =  new TableText([{name:'共享池大小:',value:''},{name:'共享池剩余大小:',value:''},{name:'高速缓存大小:',value:''},{name:'大型池大小:',value:''},{name:'Java池大小:',value:''}],{width:params.width*10,top:params.height*1.6});
	sgaChart.vmlGroup.appendChild(sgaTable.tableDiv);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*3.8,color:'block'});
	sgaChart.vmlGroup.appendChild(spaceMark.line);
	
	var lbSgaHit = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"命中率"},left:params.width,top:4.3*(params.height),width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	sgaChart.vmlGroup.appendChild(lbSgaHit.shape);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*5,color:'block'});
	sgaChart.vmlGroup.appendChild(spaceMark.line);
	barCachePoolTarget = new VmlBar({width:params.width*0.8*10,height:0.08*(params.width*0.8*10)+450,left:params.width,top:6*(params.height)-300,text:'0',max:100,title:'缓存池命中率',perfType:'OrPerformance'});
	sgaChart.vmlGroup.appendChild(barCachePoolTarget.barDiv);
	barLibCacheTarget = new VmlBar({width:params.width*0.8*10,height:0.08*(params.width*0.8*10)+450,left:params.width,top:7.3*(params.height)-300,text:'0',max:100,title:'库缓存命中率',perfType:'OrPerformance'});
	sgaChart.vmlGroup.appendChild(barLibCacheTarget.barDiv); 
	barCacheTarget = new VmlBar({width:params.width*0.8*10,height:0.08*(params.width*0.8*10)+450,left:params.width,top:8.6*(params.height)-300,text:'0',max:100,title:'高速缓存命中率',perfType:'OrPerformance'});
	sgaChart.vmlGroup.appendChild(barCacheTarget.barDiv);
	//成员方法
	this.setOraSgaChart= function(values){
		if(values){
			sgaTable.setTableValues([values.sharePoolSize,values.inSharePoolSize,values.cacheSize,values.bigPoolSize,values.javaPoolSize]);
			barCachePoolTarget.setBar({cur:values.cachePoolTarget,curlabel:values.cachePoolTarget,max:'100%',colorRuler:{valves:values.cachePoolTargetAlarmLimit,colors:values.alarmColors},limitType:values.cachePoolTargetAlarmLimitType});
			barLibCacheTarget.setBar({cur:values.libCacheTarget,curlabel:values.libCacheTarget,max:'100%',colorRuler:{valves:values.libCacheTargetAlarmLimit,colors:values.alarmColors},limitType:values.libCacheTargetAlarmLimitType});
			barCacheTarget.setBar({cur:values.cacheTarget,curlabel:values.cacheTarget,max:'100%',colorRuler:{valves:values.cacheTargetAlarmLimit,colors:values.alarmColors},limitType:values.cacheTargetAlarmLimitType});
		}
	}
	this.clearOraSgaChart= function(){
		sgaTable.setTableValues([' ',' ',' ',' ',' ']);
		barCachePoolTarget.clearBar();
		barLibCacheTarget.clearBar();
		barCacheTarget.clearBar();
	}
}

function OraSpaceChart(shape){
	var params = {width:shape.width,height:shape.height,title:'Space'} ;
	var spaceChart = new chart(params,oraSpaceDiv);
	var lbTotalSpace = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"总的表空间"},left:params.width,top:params.height*0.6,width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	spaceChart.vmlGroup.appendChild(lbTotalSpace.shape);
	colSpaceTotal = new VmlCol({title:' ',width:params.width*9,height:params.height*1.5,left:params.width,top:params.height*1,colscale:4,labels:{cols:2 ,rows:3,colscale:'3:2' },perfType:'OrServiceInfo'}); 
	colSpaceTotal.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSpaceTotal.labels.setColor('green',-1,1);
	colSpaceTotal.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	spaceChart.vmlGroup.appendChild(colSpaceTotal.colDiv);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:params.height*2.8,color:'block'});
	spaceChart.vmlGroup.appendChild(spaceMark.line);
	var lbMostUsedSpace = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"使用率最高表空间"},left:params.width,top:params.height*3,width:params.width*0.8*10,height:500,cursor:'hand',zIndex:10});
	spaceChart.vmlGroup.appendChild(lbMostUsedSpace.shape);
	
	colSpaceFirst = new VmlCol({title:'1 ',width:params.width*9,height:params.height*1.5,left:params.width,top:params.height*4,colscale:4,labels:{cols:2 ,rows:3,colscale:'3:2' },perfType:'OrTablespace'}); 
	colSpaceFirst.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSpaceFirst.labels.setColor('green',-1,1);
	colSpaceFirst.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	spaceChart.vmlGroup.appendChild(colSpaceFirst.colDiv);
	
	colSpaceSecond = new VmlCol({title:'2 ',width:params.width*9,height:params.height*1.5,left:params.width,top:params.height*5.8,colscale:4,labels:{cols:2 ,rows:3,colscale:'3:2' },perfType:'OrTablespace'}); 
	colSpaceSecond.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSpaceSecond.labels.setColor('green',-1,1);
	colSpaceSecond.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	spaceChart.vmlGroup.appendChild(colSpaceSecond.colDiv);
	
	colSpaceThird = new VmlCol({title:'3 ',width:params.width*9,height:params.height*1.5,left:params.width,top:params.height*7.6,colscale:4,labels:{cols:2 ,rows:3,colscale:'3:2' },perfType:'OrTablespace'}); 
	colSpaceThird.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSpaceThird.labels.setColor('green',-1,1);
	colSpaceThird.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	spaceChart.vmlGroup.appendChild(colSpaceThird.colDiv);
	//成员方法
	this.setOraSpaceChart = function(values){
		if(values.colSpaceTotal){
			colSpaceTotal.setCol({cur:values.colSpaceTotal.quo,curlabel:values.colSpaceTotal.used,max:values.colSpaceTotal.total,colorRuler:{valves:values.colSpaceTotal.alarmLimit,colors:values.colSpaceTotal.alarmColors},limitType:values.colSpaceTotal.limitType});
			colSpaceTotal.setLabels([[,values.colSpaceTotal.total],[,values.colSpaceTotal.free],[,values.colSpaceTotal.quo]]);
		}
		
		if(values.colSpaceFirst){
			colSpaceFirst.setTitle(values.colSpaceFirst.title);
			colSpaceFirst.setCol({cur:values.colSpaceFirst.quo,curlabel:values.colSpaceFirst.used,max:values.colSpaceFirst.total,colorRuler:{valves:values.colSpaceFirst.alarmLimit,colors:values.colSpaceFirst.alarmColors},limitType:values.colSpaceFirst.limitType});
			colSpaceFirst.setLabels([[,values.colSpaceFirst.total],[,values.colSpaceFirst.free],[,values.colSpaceFirst.quo]]);
		}
		if(values.colSpaceSecond){
			colSpaceSecond.setTitle(values.colSpaceSecond.title);
			colSpaceSecond.setCol({cur:values.colSpaceSecond.quo,curlabel:values.colSpaceSecond.used,max:values.colSpaceSecond.total,colorRuler:{valves:values.colSpaceSecond.alarmLimit,colors:values.colSpaceSecond.alarmColors},limitType:values.colSpaceSecond.limitType});
			colSpaceSecond.setLabels([[,values.colSpaceSecond.total],[,values.colSpaceSecond.free],[,values.colSpaceSecond.quo]]);
		}
		
		if(values.colSpaceThird){
			colSpaceThird.setTitle(values.colSpaceThird.title);
			colSpaceThird.setCol({cur:values.colSpaceThird.quo,curlabel:values.colSpaceThird.used,max:values.colSpaceThird.total,colorRuler:{valves:values.colSpaceThird.alarmLimit,colors:values.colSpaceThird.alarmColors},limitType:values.colSpaceThird.limitType});
			colSpaceThird.setLabels([[,values.colSpaceThird.total],[,values.colSpaceThird.free],[,values.colSpaceThird.quo]]);
		}
	}
	this.clearOraSpaceChart = function(){
		colSpaceTotal.clearCol();
		colSpaceTotal.setLabels([[,' '],[,' '],[,' ']]);
		
		colSpaceFirst.setTitle(' ');
		colSpaceFirst.clearCol();
		colSpaceFirst.setLabels([[,' '],[,' '],[,' ']]);
		
		colSpaceSecond.setTitle(' ');
		colSpaceSecond.clearCol();
		colSpaceSecond.setLabels([[,' '],[,' '],[,' ']]);
		
		colSpaceThird.setTitle(' ');
		colSpaceThird.clearCol();
		colSpaceThird.setLabels([[,' '],[,' '],[,' ']]);
	}

}

function SyServiceChart(params){
	infoChart = new chart({width:params.width,height:params.height,title:'Sybase服务',arcsize:0.075},params.container);
	var topY = Math.min(params.width, params.height)*infoChart.arcsize*10 + 10;
	var topY1 = topY;
	var leftX = params.width;
	cpuUsed = new VmlRound ({width:params.width*3,left:params.width,top:topY,stitle:'CPU利用率',dtitle:' ',text:' ',max:100,perfType:'CpuTotal'});
	this.interval=setInterval("cpuUsed.run()",100);//控制转速
	infoChart.vmlGroup.appendChild(cpuUsed.roundDiv);
	topY +=(params.width*3 + 180 + 150);
	var spaceMark  = new SpaceMark ({left:0.5*params.width,width:9*params.width,height:2,top:topY,color:'block'});
	infoChart.vmlGroup.appendChild(spaceMark.line);
	topY +=(150);
	//memery
	this.dbMembar = new VmlBar({left:params.width*5 ,top:topY1 ,width:params.width*0.8*5 ,height:100+450 ,title:"内存利用率" ,text:0 ,min:0 ,max:100 ,perfType:""});
	infoChart.vmlGroup.appendChild(this.dbMembar.barDiv);
	topY1 +=(550+20);
	this.dbProcess = new VmlBar({left:params.width*5 ,top:topY1 ,width:params.width*0.8*5 ,height:100+450 ,title:"连接数" ,text:0 ,min:0 ,max:100 ,perfType:""});
	infoChart.vmlGroup.appendChild(this.dbProcess.barDiv);
	topY1 +=(550+20); 
	//游标
	this.perfTable = new VmlLabels({left:params.width/2 ,top:topY ,width:params.width*5 ,height:params.height*5 ,cols:2 ,rows:9 ,colscale:'5:1'});
	this.perfTable.setLabels([["IO操作上所花费的时间/分","0"],
							["服务器空闲时间/分","0"],
							["读取磁盘次数/分","0"],
							["写入磁盘次数/分","0"],
							["读写磁盘的遇到的错误数/分","0"],
							["接收网络包的个数/分","0"],
							["发送网络包的个数/分","0"],
							["读写数据包遇到的错误数/分","0"],
							["登录或尝试登录的次数/分","0"]]);
	this.perfTable.setAlign({align:"right" ,type:"col" ,num:0 });
	infoChart.vmlGroup.appendChild(this.perfTable.labelsDiv);
	//成员方法
	this.setCpuUsed = function(value){
		cpuUsed.setRound(value)
		try {
				clearInterval(this.interval);
			} catch (e) {}
			finally {
				this.interval = setInterval("cpuUsed.run()",100);
		}
	}
	this.setDbMembar = function(value){
		this.dbMembar.setBar(value)
	}
	this.setDbProcess = function(value){
		this.dbProcess.setBar(value)
	}
	this.setPerfTable = function(values){
		for(var i=0;i<values.length;i++){
			this.perfTable.setLabel(values[i],i,1);
		}
	}
	//value {cpuUsed: ,dbMembar: ,dbProcess: ,perfTable:[] }
	this.setValue = function(value){
		if(value){
			if(value.cpuUsed)this.setCpuUsed(value.cpuUsed);
			if(value.dbMembar)this.setDbMembar(value.dbMembar);
			if(value.dbProcess)this.setDbProcess(value.dbProcess);
			if(value.perfTable instanceof Array)this.setPerfTable(value.perfTable);
		}
	}
	this.clearData = function(){
		this.setCpuUsed(0);
		this.dbMembar.clearBar();
		this.dbProcess.clearBar();
		for(var i=0;i<9;i++){
			this.perfTable.setLabel(" ",i,1);
		}
	}
}

function SyDbChart(shape){
	var params = {width:shape.width,height:shape.height,title:'DbSpaceInfo'} ;
	var dbSpaceInfoChart = new chart(params,sybaseDb);
	var lbDbSpace = new TextAera ({text:{alignment:'center',color:'black',className:'texttitle',text:"数据库空间"},left:params.width,top:params.height*0.6,width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	dbSpaceInfoChart.vmlGroup.appendChild(lbDbSpace.shape);
	lbDbName = new TextAera ({text:{alignment:'center',color:'red',className:'texttitle',text:" "},left:params.width,top:params.height*1.0,width:params.width*0.8*10,height:200,cursor:'hand',zIndex:10});
	dbSpaceInfoChart.vmlGroup.appendChild(lbDbName.shape);
	colSpaceData = new VmlCol({title:'数据空间',width:params.width*9,height:params.height*1.5,left:params.width,top:params.height*1.5,colscale:4,labels:{cols:2 ,rows:3,colscale:'3:2' },perfType:'SyTablespace'}); 
	colSpaceData.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSpaceData.labels.setColor('green',-1,1);
	colSpaceData.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	dbSpaceInfoChart.vmlGroup.appendChild(colSpaceData.colDiv);
	
	colSpaceLog = new VmlCol({title:'日志空间',width:params.width*9,height:params.height*1.5,left:params.width,top:params.height*3.5,colscale:4,labels:{cols:2 ,rows:3,colscale:'3:2' },perfType:'SyTablespace'}); 
	colSpaceLog.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSpaceLog.labels.setColor('green',-1,1);
	colSpaceLog.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	dbSpaceInfoChart.vmlGroup.appendChild(colSpaceLog.colDiv);
	
	colSpaceShare = new VmlCol({title:'公用空间',width:params.width*9,height:params.height*1.5,left:params.width,top:params.height*5.5,colscale:4,labels:{cols:2 ,rows:3,colscale:'3:2' },perfType:'SyTablespace'}); 
	colSpaceShare.labels.setAlign({align:'right' ,type:'cols' ,num:0});
	colSpaceShare.labels.setColor('green',-1,1);
	colSpaceShare.setLabels([['总大小:',' '],['剩余大小:',' '],['使用率:',' ']]);
	dbSpaceInfoChart.vmlGroup.appendChild(colSpaceShare.colDiv);
	
	this.setSyDbChart = function(values){
		if(values.colSpaceData){
			colSpaceData.setCol({cur:values.colSpaceData.quo,curlabel:values.colSpaceData.used,max:values.colSpaceData.total,colorRuler:{valves:values.colSpaceData.alarmLimit,colors:values.colSpaceData.alarmColors},limitType:values.colSpaceData.limitType});
			colSpaceData.setLabels([[,values.colSpaceData.total],[,values.colSpaceData.free],[,values.colSpaceData.quo]]);
		}
		if(values.colSpaceLog){
			colSpaceLog.setCol({cur:values.colSpaceLog.quo,curlabel:values.colSpaceLog.used,max:values.colSpaceLog.total,colorRuler:{valves:values.colSpaceLog.alarmLimit,colors:values.colSpaceLog.alarmColors},limitType:values.colSpaceLog.limitType});
			colSpaceLog.setLabels([[,values.colSpaceLog.total],[,values.colSpaceLog.free],[,values.colSpaceLog.quo]]);
		}
		
		if(values.colSpaceShare){
			colSpaceShare.setCol({cur:values.colSpaceShare.quo,curlabel:values.colSpaceShare.used,max:values.colSpaceShare.total,colorRuler:{valves:values.colSpaceShare.alarmLimit,colors:values.colSpaceShare.alarmColors},limitType:values.colSpaceShare.limitType});
			colSpaceShare.setLabels([[,values.colSpaceShare.total],[,values.colSpaceShare.free],[,values.colSpaceShare.quo]]);
		}
	}
	this.setSyDbName = function(text){
		lbDbName.setText(text);
	}
	this.clearSyDbChart = function(){
		colSpaceData.clearCol();
		colSpaceData.setLabels([[,' '],[,' '],[,' ']]);
		
		colSpaceLog.clearCol();
		colSpaceLog.setLabels([[,' '],[,' '],[,' ']]);
		
		colSpaceShare.clearCol();
		colSpaceShare.setLabels([[,' '],[,' '],[,' ']]);
	}
}
/*
function EwsChart(params){
	infoChart = new chart({width:params.width,height:params.height,title:'电子工单'},params.container);
	var topY = Math.min(params.width, params.height)*infoChart.arcsize*10 + 50;
	//游标
	this.perfTable = new VmlLabels({left:params.width ,top:topY ,width:params.width*8 ,height:params.height*8 ,cols:2 ,rows:7 ,colscale:'3:2'});
	this.perfTable.setLabels([["成功工单数","0"],
							["人工成功工单数","0"],
							["失败工单数","0"],
							["错误工单数","0"],
							["正在调用工单数","0"],
							["正在运行工单数","0"],
							["成功率","0"]]);
	this.perfTable.setAlign({align:"right" ,type:"col" ,num:0 });
	infoChart.vmlGroup.appendChild(this.perfTable.labelsDiv);
	//成员方法
	this.setPerfTable = function(value){
		if(value.succSheetCount)this.perfTable.setLabel(value.succSheetCount,0,1);
		if(value.humanSheetCount)this.perfTable.setLabel(value.humanSheetCount,1,1);
		if(value.failSheetCount)this.perfTable.setLabel(value.failSheetCount,2,1);
		if(value.errorSheetCount)this.perfTable.setLabel(value.errorSheetCount,3,1);
		if(value.invokingSheetCount)this.perfTable.setLabel(value.invokingSheetCount,4,1);
		if(value.runningSheetCount)this.perfTable.setLabel(value.runningSheetCount,5,1);
		if(value.succRate)this.perfTable.setLabel(value.succRate,6,1);
	}
	this.setValue = function(value){
		if(value)this.setPerfTable(value);
	}
	this.clearData = function(){
		for(var i=0;i<7;i++){
			this.perfTable.setLabel(" ",i,1);
		}
	}
}
*/
function EwsChart(params){
	var FRONTCOLOR = "white";//默认的前景色
	this.vmlGroup;
	//组
	var group = document.createElement("v:group");
	group.style.width = params.width+"px";
	group.style.height = params.height+"px";
	group.coordsize = params.width*10 +"," + params.height*10;
	
	var rect = document.createElement("v:rect");
	rect.style.zIndex = 8;
	rect.style.left = 0;
	rect.style.top = 0+"px";
	rect.style.width = params.width*10+"px";
	rect.style.height = (params.height*10)+"px";
	rect.fillcolor = FRONTCOLOR;
	rect.strokecolor = "black";
	rect.strokeweight = "1px";
	
	group.appendChild(rect);
	this.vmlGroup = group;
	params.container.appendChild(group);
	
	this.collectTime = new TextAera({text:{alignment: 'center',className: 'labels',text:'time'},left:params.width*3 ,top: 80,width:params.width*4 ,height: 200,zIndex: 10});
	this.vmlGroup.appendChild(this.collectTime.shape);
	
	var topY = 250;
	
	this.perfTable = new VmlLabels({left:params.width ,top:topY+300 ,width:params.width*3 ,height:550*7 ,cols:1 ,rows:7});
	this.perfTable.setLabels([["成功工单数"],
							["人工成功工单数"],
							["失败工单数"],
							["错误工单数"],
							["正在调用工单数"],
							["正在运行工单数"],
							["成功率"]]);
	this.perfTable.setAlign({align:"right" ,type:"col" ,num:0 });
	this.vmlGroup.appendChild(this.perfTable.labelsDiv);
	
	this.succSheet = new VmlBar({left:params.width*5 ,top:topY ,width:params.width*4 ,height:100+450 ,title:" " ,text:0 ,min:0 ,max:100 ,perfType:""});
	this.humanSheet = new VmlBar({left:params.width*5 ,top:topY+550 ,width:params.width*4 ,height:100+450 ,title:" " ,text:0 ,min:0 ,max:100 ,perfType:""});
	this.failSheet = new VmlBar({left:params.width*5 ,top:topY+550*2 ,width:params.width*4 ,height:100+450 ,title:" " ,text:0 ,min:0 ,max:100 ,perfType:""});
	this.errorSheet = new VmlBar({left:params.width*5 ,top:topY+550*3 ,width:params.width*4 ,height:100+450 ,title:" " ,text:0 ,min:0 ,max:100 ,perfType:""});
	this.invokingSheet = new VmlBar({left:params.width*5 ,top:topY+550*4 ,width:params.width*4 ,height:100+450 ,title:" " ,text:0 ,min:0 ,max:100 ,perfType:""});
	this.runningSheet = new VmlBar({left:params.width*5 ,top:topY+550*5 ,width:params.width*4 ,height:100+450 ,title:" " ,text:0 ,min:0 ,max:100 ,perfType:""});
	this.succRate = new VmlBar({left:params.width*5 ,top:topY+550*6 ,width:params.width*4 ,height:100+450 ,title:" " ,text:0 ,min:0 ,max:100 ,perfType:""});
	this.vmlGroup.appendChild(this.succSheet.barDiv);
	this.vmlGroup.appendChild(this.humanSheet.barDiv);
	this.vmlGroup.appendChild(this.failSheet.barDiv);
	this.vmlGroup.appendChild(this.errorSheet.barDiv);
	this.vmlGroup.appendChild(this.invokingSheet.barDiv);
	this.vmlGroup.appendChild(this.runningSheet.barDiv);
	this.vmlGroup.appendChild(this.succRate.barDiv);
	
		//成员方法
	this.setPerfTable = function(value){
		if(value.collectTime)this.collectTime.setText(value.collectTime);
		if(value.succSheetCount)this.succSheet.setBar(value.succSheetCount);
		if(value.humanSheetCount)this.humanSheet.setBar(value.humanSheetCount);
		if(value.failSheetCount)this.failSheet.setBar(value.failSheetCount);
		if(value.errorSheetCount)this.errorSheet.setBar(value.errorSheetCount);
		if(value.invokingSheetCount)this.invokingSheet.setBar(value.invokingSheetCount);
		if(value.runningSheetCount)this.runningSheet.setBar(value.runningSheetCount);
		if(value.succRate)this.succRate.setBar(value.succRate);
	}
	this.setValue = function(value){
		if(value)this.setPerfTable(value);
	}
	this.clearData = function(){
		this.succSheet.clearBar();
		this.humanSheet.clearBar();
		this.failSheet.clearBar();
		this.errorSheet.clearBar();
		this.invokingSheet.clearBar();
		this.runningSheet.clearBar();
		this.succRate.clearBar();
	}
}

function NetChart(params){
	var FRONTCOLOR = "white";//默认的前景色
	this.vmlGroup;
	this.netNum = 0;
	//组
/*	var group = document.createElement("v:group");
	group.style.width = params.width+"px";
	group.style.height = params.height+"px";
	group.coordsize = params.width*10 +"," + params.height*10;
	
	
	var rect = document.createElement("v:rect");
	rect.style.zIndex = 8;
	rect.style.left = 0;
	rect.style.top = 0+"px";
	rect.style.width = params.width*10+"px";
	rect.style.height = (params.height*10)+"px";
	rect.fillcolor = FRONTCOLOR;
	rect.strokecolor = "black";
	rect.strokeweight = "1px";
	
	group.appendChild(rect);*/
	var netGroup = new chart(params,params.container);
	this.vmlGroup = netGroup;
//	params.container.appendChild(group);
	
	this.netArray = new Array();

	this.addNet = function(boundId){
		var _top = this.netNum*850 + 400;
		this.netArray[this.netNum] = new VmlNet({left:-300 ,top:_top ,width:(params.width+60)*10 ,height:750 ,perfType:'aaa'});
		this.netArray[this.netNum].bind(boundId);
		this.vmlGroup.vmlGroup.appendChild(this.netArray[this.netNum].netDiv);
		this.netNum = this.netNum + 1;
	}
	this.setNetPerf = function(data){
		var blag = false;
		for(var i=0;i<data.length;i++){
			blag = false;
			for(var j=0;j<this.netArray.length;j++){
				if(data[i].boundId == this.netArray[j].boundId){
					this.netArray[j].setNetValue(data[i]);
					blag = true;
					break;
				}
			}
			if(!blag){
				this.addNet(data[i].boundId);
				this.netArray[this.netNum - 1].setNetValue(data[i]);
			}
		}
	}
}