/**
 * File graphic.js
 * @author jluo
 * @version 1.0
 */
var ALERT_MESSAGE1 = "error";
var ALERT_MESSAGE2 = "最大值和最小值不能为空";
var DATE_FORMAT1 = "yyyy年MM月dd日hh:mm:ss.S";
var DATE_FORMAT2 = "yyyy年MM月dd日hh:mm:ss";
var DATE_FORMAT3 = "hh:mm";

var bstSingle  = 0; //Chart边框为单线
var bstDouble  = 1; //Chart边框为双线
var fstSolid  = 0; //Chart背景实心填充
var fstTexture  = 1; //Chart背景材质填充
var fstRegular  = "regular"  //字体：正常
var fstItalic  = "italic"; //字体：斜体
var fstBold   = "bold"; //字体：粗体
var atLeft   = "left"; //Chart标题左对齐
var atCenter  = "center"; //Chart标题居中
var atRight   = "right"; //Chart标题右对齐

/**
 * 图形基类
 * @class: Graph
 */
function Graph(){
    this.Text   = new Text();
    this.Border = new Border();
    this.Width  = 500;
    this.Height = 300;
    this.Fill   = new Fill();
    this.Legend = new Legend();
    this.SeriesCollection   = [];
    this.Container  = null;
    this.Shadow     = true;
    this.VMLObject  = null;
    this.valueInterval = 10;
    this.YAxisFromZero = false;
    this.minValue = 0;
    this.valueDecimalPlace = 0;
    this.horizontalGrid = false;
    this.drawVertical = false;
    this.verticalLines = [];
    this.legendStyle = "Box";
};

//获取Graph类的一个引用
var _p = Graph.prototype;
/**
 * 设置Graph类属性
 */
_p.setParameters = function(params){
    this.Width  = params.Width||this.Width;
    this.Height = params.Height||this.Height;
    this.Container  = params.container||this.Container;
};
/**
 * 通过基类初始化生成Chart底图
 */
_p.draw = function(){
    if(this.Container == null) return;
    var o;

    //画外框
    var group = document.createElement("v:group");
    group.style.width = this.Width+"pt";
    group.style.height = this.Height+"pt";
    group.coordsize  = this.Width*10 +"," + this.Height*10;
    group.id   = "group1";

    //添加一个背景层
    var vRect = document.createElement("v:rect");
    vRect.style.width = (this.Width*10) +"px";
    vRect.style.height = this.Height*10+ "px";
    vRect.coordsize  = "21600,21600";

    group.appendChild(vRect);

    o = vRect;
    //设置边框大小
    vRect.strokeweight = this.Border.Width;
    //设置边框颜色
    vRect.strokecolor = this.Border.Color;

    //设置背景
    if(this.Fill.Style == fstSolid){
        vRect.fillcolor = this.Fill.Color;
    } else {
        if(this.Fill.background != null)
            vRect.style.backgroundImage = this.Fill.background;
        else
            vRect.fillcolor = this.Fill.Color;
    }

//    //边框是否为双线
//    if (this.Border.Style == bstDouble){
//        var tmp = document.createElement("v:rect");
//        tmp.style.width  = (this.Width*10-300) +"px";
//        tmp.style.height = (this.Height*10-200)+ "px";
//        tmp.style.top  = "100px";
//        tmp.style.left  = "100px";
//        tmp.strokecolor  = this.Border.Color;
//
//        if(this.Fill.Style == fstSolid){
//            tmp.fillcolor = this.Fill.Color;
//        } else {
//            if(this.Fill.background != null)
//                tmp.style.backgroundImage = this.Fill.background;
//            else
//                tmp.fillcolor = this.Fill.Color;
//        }
//
//        var filltmp = document.createElement("v:fill");
//        filltmp.type = "Frame";
//        tmp.appendChild(filltmp);
//        group.appendChild(tmp);
//        o = tmp;
//    }

/*    //画标题
    var vCaption = document.createElement("v:textbox");
    vCaption.style.fontSize  = this.Text.Font.Size +"px";
    vCaption.style.color  = this.Text.Font.Color;
    vCaption.style.height  = this.Text.Height +"px";
    vCaption.style.fontWeight = this.Text.Font.Style;
    vCaption.innerHTML   = this.Text.Text;
    vCaption.style.textAlign = this.Text.Alignment;
    o.appendChild(vCaption);
*/
    //画阴影
    if(this.Shadow){
        var vShadow = document.createElement("v:shadow");
        vShadow.on  = "t";
        vShadow.type = "single";
        vShadow.color = "silver";
        vShadow.offset = "4px,3px";
        vRect.appendChild(vShadow);
    }

    this.VMLObject = group;
    this.Container.appendChild(group);
};

//定义 VML Chart 边框类
function Border(){
    this.Color = "Black";
//    this.Style = bstSingle;
    this.Width = 1;
};

//定义 VML Chart 背景类
function Fill(){
    this.Color  = "White";
    this.background = null;
    this.Style  = fstSolid;
};

/**
 * 定义 VML Chart 标题类
 * className:css样式，写在CSS文件中
 */
function Text(){
    this.Alignment = atCenter;
    this.Height  = 24;
    this.Font  = new Font();
    this.Text  = "";
    this.className;
};

//定义 VML Chart 字体类
function Font(){
    this.fontStyle = "";
    this.fontVariant = "";
    this.fontWeight = ""
    this.fontSize = "";
    this.fontHeight = "";
    this.fontFamily = "";
};
/**
 * 定义 VML Chart 文字区域类
 */
function TextAera(params){
	var newText = document.createElement("DIV");
	var text = params.Text;
	newText.style.textAlign = text.Alignment;
	if(text.className)
	newText.className = text.className;
//	else{
//		if(text.Font.fontStyle)newText.style.fontStyle = text.Font.fontStyle;
//		if(text.Font.fontVariant)newText.style.fontVariant = text.Font.fontVariant;
//		if(text.Font.fontWeight)newText.style.fontWeight = text.Font.fontWeight;
//		if(text.Font.fontSize)newText.style.fontSize = text.Font.fontSize;
//		if(text.Font.fontHeight)newText.style.fontHeight = text.Font.fontHeight;
//		if(text.Font.fontFamily)newText.style.fontFamily = text.Font.fontFamily;
//	}
	newText.style.color = text.Color;
	newText.innerHTML = text.Text;
	var newShape= document.createElement("v:shape");
	newShape.style.position = 'absolute';
	newShape.style.left = params.left||0;
	newShape.style.top = params.top||0;
	newShape.style.width = params.width||10;
	newShape.style.height = params.height||10;
 	newShape.style.zIndex = params.zIndex||0;
 	newShape.coordsize = params.coordsize||'21600,21600';
 	newShape.fillcolor = params.fillcolor||'white';
  newShape.appendChild(newText);
	return newShape;
}
//定义 VML Chart 图例类
function Legend(){
    this.Font = new Font();
};

//定义 VML Chart 序列类
function Series(){
    this.Color = Series.getColor();
    this.Title  = null;
    this.all = [];
    this.lineStyle = "Solid";
};

//随机获取一种颜色
Series.getColor = function(){
    return "rgb("+Math.round(Math.random()*255)+","+Math.round(Math.random()*255)+","+Math.round(Math.random()*255)+")";
};
//定义 VML Chart 坐标轴类
function Axis(showPoint,titleText,minLabel,maxLabel){
    this.Color = "Black";
    this.Ln  = 0;
    this.NumberFormat = 0;
    this.Prefix = null;
    this.suffix = null;
    this.Spacing= 30;
    this.Precision = 5;  //精度
    this.Width = 0;
    this.showPoint = showPoint||10;
    this.title = titleText||"";
    this.TitleDiv;
    this.LabelDiv;
    this.minLabel = minLabel||0;
    this.maxLabel = maxLabel||0;
};
/**
 * Class: VerticalChart
 * Subclasses: Graph
 */
function VerticalChart(){
	Graph.call(this);
	this.Margin  = {left:200,right:200,top:300,bottom:200};
	this.axispoint = new Array();
	this.AxisStyle = "rect";
	this.AxisX;
	this.AxisY;
	this.Title = new Text();
};

var _p = VerticalChart.prototype = new Graph;

//画VerticalLineChart
_p.draw = function() {
	Graph.prototype.draw.call(this);
    var oContainer = this.VMLObject;
    this.drawCoord(oContainer);
    this.drawLineX(oContainer);
   	this.drawLineY(oContainer);
};

_p.setParameters = function(params){
	Graph.prototype.setParameters.call(this,params);
	this.AxisX  = new Axis(params.XshowPoint, params.AxisXTitleText, params.AxisXmin, params.AxisXmax);
	this.AxisY  = new Axis(params.YshowPoint, params.AxisYTitleText, params.AxisYmin, params.AxisYmax);
	this.Title.Text  = params.headTitle||"标题";
}

//画坐标系
_p.drawCoord = function(oContainer){
	this.axispoint[0] = this.Margin.left;
	this.axispoint[1] = this.Height*10 - this.Margin.bottom;
	this.axispoint[2] = this.Width*10 - this.Margin.right;
	this.axispoint[3] = this.Margin.top;
		
    this.AxisY.Ln = eval(this.Height*10 - this.Margin.bottom - this.Margin.top);
   	this.AxisY.Spacing = this.AxisY.Ln/(this.AxisY.showPoint*this.AxisY.Precision);
    var vLine = document.createElement("v:line");
    vLine.id = "idCoordY";
    vLine.from = this.axispoint[0] +","+ this.axispoint[1];
    vLine.to = this.axispoint[0] +","+ this.axispoint[3];
    vLine.style.zIndex = 8;
    vLine.style.position = "absolute";
    vLine.strokecolor = this.AxisY.Color;
    vLine.strokeweight = 1;

    var vStroke = document.createElement("v:stroke");
    vLine.appendChild(vStroke);
    oContainer.appendChild(vLine);

	//画Y轴单位
    var newText = document.createElement("<div style=\"Text-align:center;font-size:10pt\"></div>");
    var newShape= document.createElement("<v:shape style='position:absolute;left:"+ eval(this.axispoint[0] -180) +";top:"+ eval(this.axispoint[3] - 180) +";WIDTH:500px;HEIGHT:120px;z-index:8' coordsize='21600,21600' fillcolor='white'></v:shape>");
    newShape.appendChild(newText);
    this.AxisY.TitleDiv = newText;
	oContainer.appendChild(newShape);

    this.AxisX.Ln = eval(this.Width*10 - this.Margin.left - this.Margin.right);
    this.AxisX.Spacing = this.AxisX.Ln/(this.AxisX.showPoint*this.AxisX.Precision);
    var vLine = document.createElement("v:line");
    vLine.id = "idCoordX";
    vLine.to = this.axispoint[2] +","+ this.axispoint[1];
    vLine.from = this.axispoint[0] +","+ this.axispoint[1];
    vLine.style.zIndex = 8;
    vLine.style.position = "absolute";
    vLine.strokecolor = this.AxisX.Color;
    vLine.strokeweight = 1;

    var vStroke = document.createElement("v:stroke");
    vLine.appendChild(vStroke);
    oContainer.appendChild(vLine);
    
	//画X轴单位
    var newText = document.createElement("<div style=\"Text-align:center;font-size:10pt\"></div>");
    var newShape= document.createElement("<v:shape style='position:absolute;left:"+ eval(this.axispoint[2] - 250) +";top:"+ eval(this.axispoint[1] + 95) +";WIDTH:400px;HEIGHT:100px;z-index:8' coordsize='21600,21600' fillcolor='white'></v:shape>");
    newShape.appendChild(newText);
    this.AxisX.TitleDiv = newText;
	oContainer.appendChild(newShape);
	
	//画图表上标题
	var textArea = new TextAera({Text:this.Title,left:600,top:20,width:eval(this.Width*10-1200),height:eval(this.Margin.top-40),zIndex:8})
	oContainer.appendChild(textArea);
	
	//是否采用方框形坐标空间
    if(this.AxisStyle == "rect"){
	    var vLine = document.createElement("v:line");
	    vLine.id = "idCoordX2";
	    vLine.from = this.axispoint[0] +","+ this.axispoint[3];
	    vLine.to = this.axispoint[2] +","+ this.axispoint[3];
	    vLine.style.zIndex = 8;
	    vLine.style.position = "absolute";
	    vLine.strokecolor = this.AxisX.Color;
	    vLine.strokeweight = 1;
	
	    var vStroke = document.createElement("v:stroke");
	    vLine.appendChild(vStroke);
	    oContainer.appendChild(vLine);
	    
	    var vLine = document.createElement("v:line");
	    vLine.id = "idCoordY2";
	    vLine.to = this.axispoint[2] +","+ this.axispoint[1];
	    vLine.from = this.axispoint[2] +","+ this.axispoint[3];
	    vLine.style.zIndex = 8;
	    vLine.style.position = "absolute";
	    vLine.strokecolor = this.AxisY.Color;
	    vLine.strokeweight = 1;
	
	    var vStroke = document.createElement("v:stroke");
	    vLine.appendChild(vStroke);
	    oContainer.appendChild(vLine);
    }
};

//画X轴刻度
_p.drawLineX = function(oContainer){
	var LabelDivX = document.createElement("DIV");
    for(var i=0; i<=this.AxisX.showPoint*this.AxisX.Precision; i++){
    var px = this.axispoint[0] + this.AxisX.Spacing*i;
    newLine   = document.createElement("v:line");
    newLine.from = px +","+ this.axispoint[1];
    newLine.to  = px +","+ this.axispoint[3];
    newLine.style.zIndex = 7;
    newLine.style.position = "absolute";
	    oContainer.appendChild(newLine);
		if(i%this.AxisX.Precision!=0){
		    var newStroke = document.createElement("<v:stroke dashstyle='Dot' color='black'/>");
		    newLine.insertBefore(newStroke);
		}
		else{
		    var newStroke = document.createElement("<v:stroke color='#babbae' />");
		    newLine.insertBefore(newStroke);
		    //画刻度
		    newText = document.createElement("<div style=\"Text-align:center;font-size:7pt\"></div>");
	        newShape= document.createElement("<v:shape style='position:absolute;left:"+ eval(px -120) +";top:"+ eval(this.axispoint[1] + 10) +";WIDTH:240px;HEIGHT:80px;z-index:8' coordsize='21600,21600' fillcolor='white'></v:shape>");
	        newShape.appendChild(newText);
	        LabelDivX.appendChild(newShape);
		}
	 }
	this.AxisX.LabelDiv = LabelDivX;
	oContainer.appendChild(LabelDivX);
	this.setXLabel(this.AxisX);
}
//画Y轴刻度
_p.drawLineY = function(oContainer){
	var LabelDivY = document.createElement("DIV");
    for(var i=0; i<=this.AxisY.showPoint*this.AxisY.Precision; i++){
	    var py = this.axispoint[1] - this.AxisY.Spacing*i;
	    newLine   = document.createElement("v:line");
	    newLine.from = this.axispoint[0] +","+ py;
	    newLine.to  = this.axispoint[2] +","+ py;
	    newLine.style.zIndex = 7;
	    newLine.style.position = "absolute";
		oContainer.appendChild(newLine);
		if(i%this.AxisX.Precision!=0){
		    var newStroke = document.createElement("<v:stroke dashstyle='Dot' color='black'/>");
		    newLine.insertBefore(newStroke);
		}
		else{
		    var newStroke = document.createElement("<v:stroke color='#babbae' />");
		    newLine.insertBefore(newStroke);
		    newText = document.createElement("<div id=\"y2\" style=\"Text-align:center;font-size:10pt\"></div>");
	        newShape= document.createElement("<v:shape style='position:absolute;left:"+ eval(this.axispoint[0]-200) +";top:"+ eval(py-50) +";WIDTH:200px;HEIGHT:100px;z-index:8' coordsize='21600,21600' fillcolor='white'></v:shape>");
	        newShape.appendChild(newText);
	        LabelDivY.appendChild(newShape);
		}
	 }
	this.AxisY.LabelDiv = LabelDivY;
	oContainer.appendChild(LabelDivY);
	this.setYLabel(this.AxisY);
}

_p.setXLabel = function(label){
	var someNodeList = this.AxisX.LabelDiv.getElementsByTagName('DIV');
	var node=$A(someNodeList);
	var len = node.length;
	
	if(label instanceof Array){
		try{
			this.AxisX.TitleDiv.innerHTML = label[0];
			for(i=0;i<len;i++){
				node[i].innerHTML = label[i+1].text;
				node[i].title = label[i+1].title;
			}
		}catch(e){alert(ALERT_MESSAGE1)}
		return;
	}else{
		try{
			this.AxisX.minLabel = label.minLabel;
			this.AxisX.maxLabel = label.maxLabel;
			if(label.title != null)this.AxisX.TitleDiv.innerHTML = label.title;
		}catch(e){alert(ALERT_MESSAGE2)}
		var Spacing = (this.AxisX.maxLabel - this.AxisX.minLabel)/(len-1);
		for(i=0;i<len;i++){
			node[i].innerHTML = new Date(eval(this.AxisX.maxLabel - Spacing*(len-i-1))).format(DATE_FORMAT3);
			node[i].title = new Date(eval(this.AxisX.maxLabel - Spacing*(len-i-1))).format(DATE_FORMAT2);
		}
	}
}

_p.setYLabel = function(label){
	var someNodeList = this.AxisY.LabelDiv.getElementsByTagName('DIV');
	var node=$A(someNodeList);
	var len = node.length;
	
	if(label instanceof Array){
		try{
			this.AxisY.TitleDiv.innerHTML = label[0];
			for(i=0;i<len;i++){
				node[i].innerHTML = label[i+1];
				node[i].title = label[i+1];
			}
		}catch(e){alert(ALERT_MESSAGE1);}
		return;
	}else{
		try{
			this.AxisY.minLabel = label.minLabel;
			this.AxisY.maxLabel = label.maxLabel;
			if(label.title != null)this.AxisY.TitleDiv.innerHTML = label.title;
		}catch(e){alert(ALERT_MESSAGE2);}
		var Spacing = (this.AxisY.maxLabel - this.AxisY.minLabel)/(len-1);
		for(i=0;i<len;i++){
			node[i].innerHTML = this.AxisY.minLabel + Spacing*i;
			node[i].title = this.AxisY.minLabel + Spacing*i;
		}
	}
}
/*
_p.setXLabel = function(minValue,maxValue,title){
	if(minValue == null || maxValue == null){
		alert(ALERT_MESSAGE);
		return;
	}
	this.AxisX.minLabel = minValue;
	this.AxisX.maxLabel = maxValue;
	if(title != null)this.AxisX.TitleDiv.innerHTML = title;
	var someNodeList = this.AxisX.LabelDiv.getElementsByTagName('DIV');
	var node=$A(someNodeList);
	var len = node.length;
	var Spacing = (maxValue - minValue)/(len-1);
	for(i=0;i<len;i++){
		node[i].innerHTML = new Date(eval(maxValue - Spacing*(len-i-1))).format(DATE_FORMAT3);
		node[i].title = new Date(eval(maxValue - Spacing*(len-i-1))).format(DATE_FORMAT2);
	}
}
_p.setYLabel = function(minValue,maxValue,title){
	if(minValue == null || maxValue == null){
		alert(ALERT_MESSAGE);
		return;
	}
	this.AxisY.minLabel = minValue;
	this.AxisY.maxLabel = maxValue;
	if(title != null)this.AxisY.TitleDiv.innerHTML = title;
	var someNodeList = this.AxisY.LabelDiv.getElementsByTagName('DIV');
	var node=$A(someNodeList);
	var len = node.length;
	var Spacing = (maxValue - minValue)/(len-1);
	for(i=0;i<len;i++){
		node[i].innerHTML = minValue + Spacing*i;
		node[i].title = minValue + Spacing*i;
	}
}*/
//------------------------------------------------------------------------------
/**
 * 线型图类
 * @class StaticLineChart
 * @param 属性参数
 */
function StaticLineChart(params){
	VerticalChart.call(this);
	this.setParameters(params);
	this.lines = {};
	this.curLine;
	this.lineDiv;
}

var _p = StaticLineChart.prototype = new VerticalChart;

//画StaticLineChart
_p.draw = function() {
	VerticalChart.prototype.draw.call(this);
	var _lineDiv = document.createElement('DIV');
	this.VMLObject.appendChild(_lineDiv);
	this.lineDiv = _lineDiv;
};

_p.drawLine = function(_line_) {
	var lineStr="<v:PolyLine id='old' filled='f'"+"title='"+_line_.hashKey+"' Points='"+_line_.path+"' strokecolor="+_line_.color+" strokeweight=1pt style='z-index:9' ></v:PolyLine>";
	var line=document.createElement(lineStr);
	this.lineDiv.appendChild(line);
}

//------------------------------------------------------------------------------
/**
 * 线型图类
 * @class DynamicLineChart
 * @param 属性参数
 */
function DynamicLineChart(params){
	VerticalChart.call(this);
	this.setParameters(params);
	this.colors = ['#008000','#FFFF00','#FF00FF','#00FF00','#00FFFF','#008080','#800000','#009900','#0000FF','#FF0000'];
	this.lines = {};
	this.curLine;
	this.lineDiv;
}

var _p = DynamicLineChart.prototype = new VerticalChart;

//画VerticalLineChart
_p.draw = function() {
	VerticalChart.prototype.draw.call(this);
	var _lineDiv = document.createElement('DIV');
	this.VMLObject.appendChild(_lineDiv);
	this.lineDiv = _lineDiv;
};


var lines = new Array();	//所有连线对象

/**
 * 坐标对象包含x,y位置
 */
function Point(time, value){
	this.time = time;
	this.value = value;
	this.x = 0;
	this.xtext = new Date(time).format(DATE_FORMAT1);
	this.y = 0;
	this.ytext = value;
}
/**
 * @class 线类
 * @param chart:线所在图表
 * @param UnitTitle:Y轴单位
 */
function Line(chart,title) {
	this.points = new Array();	// 连线中的转折点对象
	this.showStaIndex = 0;
	// 连线图形对象
	this.Chart = chart;			// 显示该线条的父容器节点
	this.leftEdge = chart.axispoint[0];
	this.rightEdge = chart.axispoint[2];
	this.changeY = chart.axispoint[1];
	this.lineColor = "red";
	this.lineImg = document.createElement("DIV");
	this.lineImg.style.display = "none";
	this.lineImg.line = this;
	this.linePath = null;
	this.Chart.lineDiv.appendChild(this.lineImg);
	this.title = title||"线";
	
	this.IsDynamic = false;
	this.AxisXmax = chart.AxisX.maxLabel;
	this.AxisXmin = chart.AxisX.minLabel;
	this.AxisYmin = chart.AxisY.minLabel;
	this.AxisYmax = chart.AxisY.maxLabel;
}

var _p = Line.prototype;
	/**
	 * 将点的时间和值转化为坐标系下的点坐标
	 * @method
	 * @param {Point,Array} point Point对象或数组
	 */
	_p.transitionXY = function(point){
		if(point instanceof Point){
			var chart = this.Chart;
			var a = (chart.axispoint[2] - chart.axispoint[0])/(this.AxisXmax - this.AxisXmin);
			var b = chart.axispoint[0] - a*this.AxisXmin;
			point.x = a*point.time - (0-b);
			var c = (chart.axispoint[3] - chart.axispoint[1])/(this.AxisYmax - this.AxisYmin);
			var d = chart.axispoint[1] - c*this.AxisYmin;
			point.y = c*point.value + d;
		}else if(point instanceof Array){
			for(var i=0;i<point.length;i++)
				this.transitionXY(point[i]);
		}
	}
	
	_p.refreshLinePath = function(){
		this.linePath = "";
		while(this.points.length>0&&this.points[this.showStaIndex].x<this.leftEdge){
			this.showStaIndex += 1;
		}
		var staIndex = this.showStaIndex;
		if(staIndex>0&&this.points[staIndex].x>this.leftEdge){
			var dydx = (this.points[staIndex].y - this.points[staIndex-1].y)/(this.points[staIndex].x - this.points[staIndex-1].x);
			var staY = this.points[staIndex].y - dydx*(this.points[staIndex].x - this.leftEdge);
			this.linePath = this.leftEdge+","+staY;
		}
		for (var i=staIndex;i<this.points.length;i++) {
			this.linePath += " "+this.points[i].x+","+ this.points[i].y;
		}
	}
	
	_p.draw = function() {
		if(this.points.length>0){
			this.refreshLinePath();
			this.drawLine(this.linePath);
			this.drawPoint(this.points.slice(this.showStaIndex));
		}this.show();
	}
	
	
	_p.addPoint = function(newPoints){
		var redraw = false;
		var _linePath = "";
		var index = 0;		//新加入点的开始位置
		if(this.points.length>0){
			index = this.points.length;
			_linePath += this.points[this.points.length-1].x+","+this.points[this.points.length-1].y;
		}
		for(i=0;i<newPoints.length;i++){
			newPoint = newPoints[i];
			if(i>0)_linePath +=" ";
			if(newPoint.value > this.AxisYmax){
				this.AxisYmax = newPoint.value*1.2;
				this.transitionXY(this.points);
				redraw = true;
			}
			this.transitionXY(newPoint);
			this.points.push(newPoint);
			_linePath += " "+newPoint.x+","+ newPoint.y;
		}
		if(this.points[this.points.length-1].x > this.rightEdge){
			var a = this.points[this.points.length-1].x - this.rightEdge;
			var b = (this.rightEdge - this.leftEdge)/2;
			var gap = Math.floor(a/b);
			this.moveleft(gap+1);
			redraw = true;
		}
		if(redraw){
			this.reDraw();
		} else {
			this.drawPoint(this.points.slice(index));
			this.drawLine(_linePath);
		}
	}
	
	_p.moveleft = function(len){
		var b = (this.rightEdge - this.leftEdge)/2;
		var xlab = (this.AxisXmax - this.AxisXmin)/2;
		this.AxisXmin += len*xlab;
		this.AxisXmax += len*xlab;
		for(var i=0;i<this.points.length;i++)
			this.points[i].x -= len*b;
	}
	
	_p.show = function() {
		this.lineImg.style.display = "block";
	}
	
	_p.hidden_line = function() {
		this.lineImg.style.display = "none";
	}

	//画线
	_p.drawLine = function(p_linePath) {
		var lineStr="<v:PolyLine id='old' filled='f'"+"title='"+this.title+"' Points='"+p_linePath+"' strokecolor="+this.lineColor+" strokeweight=1pt style='z-index:9' ></v:PolyLine>";
		var line=document.createElement(lineStr);
		this.lineImg.appendChild(line);
	} 

	//删除线
	_p.removeLine = function(obj) {
		obj.line = null;
		obj.ondblclick = null;
		obj.oncontextmenu = null;
		obj.onclick = null;
		this.Chart.lineDiv.removeChild(obj);
	}

	//重绘线条
	_p.reDraw = function() {
		this.removeLine(this.lineImg);
		this.lineImg = document.createElement("DIV");
		this.lineImg.style.display = "none";
		this.lineImg.line = this;
		this.Chart.lineDiv.appendChild(this.lineImg);
		this.draw();
		this.show();
		this.Chart.setXLabel({minLabel:this.AxisXmin,maxLabel:this.AxisXmax});
		this.Chart.setYLabel({minLabel:this.AxisYmin,maxLabel:this.AxisYmax});
//		this.Chart.setYLabel(this.AxisYmin,this.AxisYmax);
//		this.Chart.setXLabel(this.AxisXmin,this.AxisXmax);
		
	}

	//画点
	_p.drawPoint = function(point) {
		if(point instanceof Point){
			var pleft = point.x - 10;
			var ptop = point.y - 10;//坐标变换
			var pointStr="<v:oval style='position:relative;left:"+pleft+";top:"+ptop+";width:20;height:20;z-index:10' StrokeColor="+this.lineColor+"  fillcolor="+this.lineColor+" />";
			var pointNode=document.createElement(pointStr);
			pointNode.title="时间:"+point.xtext + "\n数值:" + point.ytext;
			this.lineImg.appendChild(pointNode);
		}
		else if(point instanceof Array)
			for(var i=0;i<point.length;i++)
				this.drawPoint(point[i]);
	}


//按给定的格式输出日期
Date.prototype.format = function(format)
{
  var o = {
    "M+" : this.getMonth()+1, //month
    "d+" : this.getDate(),    //day
    "h+" : this.getHours(),   //hour
    "m+" : this.getMinutes(), //minute
    "s+" : this.getSeconds(), //second
    "q+" : Math.floor((this.getMonth()+3)/3),  //quarter
    "S+" : this.getUTCMilliseconds() //millisecond
  }
  if(/(y+)/.test(format))
  	format=format.replace(RegExp.$1,(this.getFullYear()+"").substr(4 - RegExp.$1.length));
  for(var k in o)
  if(new RegExp("("+ k +")").test(format))
    format = format.replace(RegExp.$1, RegExp.$1.length==1 ? o[k] : ("00"+ o[k]).substr((""+ o[k]).length));
  return format;
}

var $A = Array.from = function(iterable) {
  if (!iterable) return [];
  if (iterable.toArray) {
    return iterable.toArray();
  } else {
    var results = [];
    for (var i = 0, length = iterable.length; i < length; i++)
      results.push(iterable[i]);
    return results;
  }
}