
function createTextField(fieldLabel,name,width,allowBlank,vtype, inputType, maxLength,readOnly )
{
	var textField =  new Ext.form.TextField({
        fieldLabel: fieldLabel,
        name: name,
        width:width,
		allowBlank:allowBlank,
		vtype:vtype,
		inputType: inputType,
		maxLength: maxLength,
		readOnly: readOnly
    });
    return textField;
}
function createTextArea(fieldLabel,name,allowBlank,width,growMin,readOnly)
{
	var	textArea = new Ext.form.TextArea({
        fieldLabel:fieldLabel,
        name: name,
        grow: true,
        preventScrollbars:true,
        allowBlank:allowBlank,
        width:width,
        growMin: growMin,
        readOnly: readOnly
    });
    return textArea;
}
function createStore( url, record, id, name )
{
	var store = new Ext.data.Store({
		proxy:new Ext.data.HttpProxy({
			url:url
		}),
		remoteSort:true,
		reader:new Ext.data.XmlReader({
			record:record,
			id:id
		},[
			{name:id},
			{name:name}
		  ])
	});
	return store;
}
function createComboBox(store,fieldLabel,hiddenName,displayField,valueField,emptyText,allowBlank,width )
{
	var combo = new Ext.form.ComboBox({
		store:store,
		fieldLabel:fieldLabel,
		hiddenName:hiddenName,
		displayField:displayField,
		valueField:valueField,
		typeAhead: true,
		mode: 'local',
		readOnly:true,
		triggerAction: 'all',
		emptyText:emptyText,
        selectOnFocus:true,
        allowBlank:allowBlank,
		width:width
	});
	return combo;
}
function createRadio(fieldLabel,boxLabel,checked,name,group,inputValue)
{
	var radio = new Ext.form.Radio({
    	 fieldLabel: fieldLabel,
    	 boxLabel: boxLabel,
    	 checked:checked,
    	 name: name,
    	 group: group,
         inputValue: inputValue
    });
    return radio;
}
function createDateField(fieldLabel,format,name,width,onChangeHandler){
	var dateField = new Ext.form.DateField({
		fieldLabel:fieldLabel,
		format:format,
		name:name,
		width:width
	});
	if(onChangeHandler){
		dateField.on('change',onChangeHandler);
	}
	return dateField;
}
