/**
 * 全网服务域管理主页面
 * @class EditForm
 * @extends Ext.ux.Form
 */
var  hostNetMonResultDto;
var  hostNetMonResult;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
var HostNetMonResultDto = {areaCode:"",connServManCode:"",hostAddress:"",hostDesc:"",testStartTime:null,testEndTime:null};
var queryDicUrl = "getDicAction_queryDictionary.action";

//格式化时间
	Date.prototype.format = function(format)
	{
		var o ={ "M+" : this.getMonth()+1, //month<
		"d+" : this.getDate(),//day
		"h+" : this.getHours(), //hour
		"m+" : this.getMinutes(), //minute
		"s+" : this.getSeconds(), //second
		"q+" : Math.floor((this.getMonth()+3)/3),//quarter
		"S" : this.getMilliseconds() //millisecond
	    }
		if(/(y+)/.test(format)) format=format.replace(RegExp.$1,(this.getFullYear()+"").substr(4 - RegExp.$1.length));
		for(var k in o) {
			if(new RegExp("("+ k +")").test(format))
				format = format.replace(RegExp.$1,RegExp.$1.length==1 ? o[k] :("00"+ o[k]).substr((""+ o[k]).length));
		}
		return format;
	}

Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}
	// 计算form 宽度
	var gridWidth = Ext.getBody().getViewSize().width - 5;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 5;
	}
	
	// 接口类型
    var nowDate = new Date();
    var startDate = new Date(nowDate.getTime() - 7 * 24 * 60 * 60 * 1000);
    nowDate = nowDate.format("yyyy-MM-dd hh:mm:ss") ;
    startDate = startDate.format("yyyy-MM-dd hh:mm:ss") ;
	// 开始时间
	var beginTimeField = new Ext.form.DateField({
				fieldLabel : '开始时间',
				xtype :'xdatetime',
				name : 'testStartTime',
				id : 'testStartTime',
				width : 290,
				allowBlank : true,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				value : startDate,
				emptyText : '选择一个日期'
			});

	// 结束时间
	var endTimeField = new Ext.form.DateField({
				fieldLabel : '结束时间',
				xtype :'xdatetime',
				name : 'testEndTime',
				id : 'testEndTime',
				width:290,
				allowBlank : true,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				value : nowDate,
				emptyText : '选择一个日期'
			});
	
	QueryForm = Ext.extend(Ext.ux.Form,{
		 areaCombo:null,
		 servmanCombo:null,
		 hostDesc:null,
		 hostAddress:null,
		 testStartTime:null,
		 testEndTime:null,
    constructor:function(){
	 	this.areaCombo = this.createCombo2("区域名称","areaCode","businid","businname","96%",queryDicUrl+"?busintypeid=AREA_CODE&"+new Date(),"dicList","dicCount");
        this.servmanCombo = this.createCombo2(show_name+"名称","connServManCode","businid","businname","96%",queryDicUrl+"?busintypeid=CONN_SERV_MAN_CODE&"+new Date(),"dicList","dicCount");
        this.hostDesc = this.createTextField("主机描述","hostDesc","96%","text",100,true,"","超出最大长度100");
        this.hostAddress = this.createTextField("主机IP地址","hostAddress","96%","text",100,true,"","超出最大长度100");
        var that = this ;
        this.areaCombo.store.load({callback:function(){
        	 that.servmanCombo.store.load();
        }});
	 	QueryForm.superclass.constructor.call(this,{
	 	title:"主机网络监测查询",
	 	width:gridWidth,
	 	height:Ext.getBody().getViewSize().height * 0.33,
	 	region:"center",
	 	applyTo:"queryform",
	 	labelAlign: "right",
	 	bodyStyle : "padding: 5px 5px 0",
		items : [{layout:"column",items:[{layout:"form",items:this.areaCombo,columnWidth:.3333},
			{layout:"form",columnWidth:.3333,items:this.servmanCombo},
			{layout:"form",items:this.hostDesc,columnWidth:.3333},
			{layout:"form",items:this.hostAddress,columnWidth:.3333},
			{layout:"form",columnWidth:.3333,items:beginTimeField},
			{layout:"form",items:endTimeField,columnWidth:.3333}]}],
	 	buttons : [{text : '查询',id : 'search_btn',iconCls : 'find',width : 20,hidden : false,handler :this.searchFormClick,scope : this},
				   {text : '重置',id : 'resume_search_btn',width : 20,iconCls : 'resume',hidden : false,handler : this.onResumeSearchClick,scope : this}
				   ]
	 	})
 },
searchFormClick:function(){
  check() ;
  var beginTimeValueTemp,endTimeValueTemp ;
  var beginTimeFieldValue = Ext.get("testStartTime").getValue();
  var endTimeFieldValue  = Ext.get("testEndTime").getValue();
  if(Ext.getCmp('testStartTime').isValid() && Ext.getCmp('testStartTime').isValid()){
    	if(Ext.getCmp("testStartTime").getValue() == "选择一个日期"||Ext.getCmp("testStartTime").getValue() ==""){
          beginTimeFieldValue = "";	
          beginTimeValueTemp = "";
    	}else{
          beginTimeValueTemp = new Date(Date.parse(beginTimeFieldValue.replace(/-/g,"/")));
    	}
    	if(Ext.getCmp("testEndTime").getValue() == "请选择一个日期" || Ext.getCmp("testEndTime").getValue() == ""){
    		endTimeFieldValue = "";
    		endTimeValueTemp = "";
    	}else{
            endTimeValueTemp = new Date(Date.parse(endTimeFieldValue.replace(/-/g,"/")));
    	}
        if(beginTimeValueTemp != null && beginTimeValueTemp != ""&&endTimeValueTemp != null &&endTimeValueTemp != ""){
	        daydiff = (endTimeValueTemp.getTime() - beginTimeValueTemp.getTime())/(1000*60*60*24); 
	        if(daydiff < 0){
	          Ext.Msg.alert("信息提示","结束时间不能小于开始时间！");
	          return ;
	         }
        }
    }
    hostNetmonResult.store.baseParams = {
    'hostNetMonResultDto.areaCode':this.areaCombo.getValue(),    'hostNetMonResultDto.hostAddress':this.hostAddress.getValue(),
    'hostNetMonResultDto.hostDesc':this.hostDesc.getValue(),    'hostNetMonResultDto.connServManCode':this.servmanCombo.getValue(),    
    'testStartTime':Ext.get("testStartTime").getValue(), 'testEndTime':Ext.get("testEndTime").getValue()} ;
    hostNetmonResult.store.removeAll() ;
    hostNetmonResult.store.load({params:{'page.start':0,'page.pageSize':12,'page.totalCount':0}});
},
onResumeSearchClick:function(){
	queryForm.getForm().reset();
	hostNetmonResult.store.baseParams = {} ;
},
createTextField: function(fieldLabel, name, anchor,inputType,maxLength, allowBlank, vtype, maxLengthText) {    //生成一个通用的TextField
        var tf = new Ext.form.TextField({
            fieldLabel: fieldLabel,
            name: name,
            xtype: 'textfield',
            readOnly: false,
            allowBlank: allowBlank,
            anchor: anchor,
            blankText: '该选项为必填项,请输入内容...',
            vtype: vtype,
            inputType:inputType,
            maxLength: maxLength,
            maxLengthText: maxLengthText
        });
        return tf;
    }
});
queryForm = new QueryForm();

HostNetmonResultGrid =  Ext.extend(UxGrid, {
	constructor : function() {
		this.servDefineStore = new Ext.data.Store({ // Grid Store
			proxy : new Ext.data.HttpProxy({
						url : "hostNetmonResultAction_findNetMonResult.action",
						method : 'POST'
					}),
			reader : new Ext.data.JsonReader({
						totalProperty : 'page.totalCount',
						root : 'page.result'
					}, [{name:'areaCodeName'},{name:'connServManCodeName'},{name:'hostAddress'},{name:'hostDesc'},{name:'ttl'},{name:'testEndTime'}
						,{name:'packetTotal'},{name:'packetLoss'},{name:'packetLossRate'},{name:'avgRtt'},{name:'maxRtt'},{name:'minRtt'}])
		}),
		HostNetmonResultGrid.superclass.constructor.call(this, {
			title:'主机列表',
			frame : true,
			width : gridWidth,
			renderTo:"grid-div",
			region:"center",
			height : Ext.getBody().getViewSize().height * 0.65,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			cm : new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
					{header : '区域编码',dataIndex : 'areaCodeName',sortable : true,width : 100}, 
					{header : show_name,dataIndex : 'connServManCodeName',sortable : true,width : 100}, 
					{header : '主机地址',dataIndex : 'hostAddress',sortable : true,width : 130}, 
					{header : '主机描述',dataIndex : 'hostDesc',sortable : true,width : 130}, 
					{header : '测试时间',dataIndex : 'testEndTime',sortable : true,width : 100},
					{header : '网络连接跳转次数',dataIndex : 'ttl',sortable : true,width : 100},
					{header : '网络连接总包数',dataIndex : 'packetTotal',sortable : true,width : 100},
					{header : '网络连接丢包数',dataIndex : 'packetLoss',sortable : true,width : 100},
					{header : '网络连接丢包率',dataIndex : 'packetLossRate',sortable : true,width : 100},
					{header : '平均延迟（ms）',dataIndex : 'avgRtt',sortable : true,width : 100},
					{header : '最大延迟（ms）',dataIndex : 'maxRtt',sortable : true,width : 100},
					{header : '最小延迟（ms）',dataIndex : 'minRtt',sortable : true,width : 100}
			]),
			bbar : new Ext.PagingToolbar({
						firstText : '第一页',
						nextText : '下一页',
						prevText : '上一页',
						refreshText : '刷新',
						lastText : '最后一页',
						beforePageText : '当前',
						afterPageText : '页/共{0}页',
						pageSize : 12,
						paramNames:{
						   start:'page.start',
						   limit:'page.pageSize'
						},
						store : this.servDefineStore,
						displayInfo : false,
						dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
						emptyMsg : "没有可显示的记录",
						items : ['-', {
										text : '导出',
										id : 'add_win_btn',
										iconCls : 'excel',
										handler : onExportClick,
										scope : this
									}
							]
					}),
			ds : this.servDefineStore
		});
	}
});

hostNetmonResult = new HostNetmonResultGrid();
hostNetmonResult.store.baseParams = {'hostNetMonResultDto.areaCode':null} ;
hostNetmonResult.store.load({params:{'page.start':0,'page.pageSize':12}});

});

function onExportClick(){
   check() ;
   var beginTimeValueTemp,endTimeValueTemp ;
   var beginTimeFieldValue = Ext.get("testStartTime").getValue();
   var endTimeFieldValue  = Ext.get("testEndTime").getValue();
   if(Ext.getCmp('testStartTime').isValid() && Ext.getCmp('testStartTime').isValid()){
    	if(Ext.getCmp("testStartTime").getValue() == "选择一个日期"||Ext.getCmp("testStartTime").getValue() ==""){
          beginTimeFieldValue = "";	
          beginTimeValueTemp = "";
    	}else{
          beginTimeValueTemp = new Date(Date.parse(beginTimeFieldValue.replace(/-/g,"/")));
    	}
    	if(Ext.getCmp("testEndTime").getValue() == "请选择一个日期" || Ext.getCmp("testEndTime").getValue() == ""){
    		endTimeFieldValue = "";
    		endTimeValueTemp = "";
    	}else{
            endTimeValueTemp = new Date(Date.parse(endTimeFieldValue.replace(/-/g,"/")));
    	}
        if(beginTimeValueTemp != null && beginTimeValueTemp != ""&&endTimeValueTemp != null &&endTimeValueTemp != ""){
	        daydiff = (endTimeValueTemp.getTime() - beginTimeValueTemp.getTime())/(1000*60*60*24); 
	        if(daydiff < 0){
	          Ext.Msg.alert("信息提示","结束时间不能小于开始时间！");
	          return ;
	         }
        }
    }
    window.location.href = "export_exportSearchResult.action?hostNetMonResultDto.areaCode="+queryForm.areaCombo.getValue() +
    		"&hostNetMonResultDto.hostAddress="+queryForm.hostAddress.getValue()+
    		"&hostNetMonResultDto.hostDesc="+queryForm.hostDesc.getValue()+
    		"&hostNetMonResultDto.connServManCode="+queryForm.servmanCombo.getValue()+  
    		"&testStartTime="+beginTimeValueTemp.format("yyyy-MM-dd hh:mm:ss")+
    		"&testEndTime="+endTimeValueTemp.format("yyyy-MM-dd hh:mm:ss") ;
}


function check(){
	if (!Ext.getCmp('testStartTime').isValid()) {
		Ext.MessageBox.alert("信息提示", msgText, function(btn) {
					Ext.getCmp('testStartTime').focus();
				});
		return;
	}
	if(Ext.getCmp('testStartTime').getValue() == "选择一个日期"|| Ext.getCmp('testStartTime').getValue() == ""){
		Ext.MessageBox.alert("信息提示",blankStr+"请选择开始时间"+blankStr);
		return;
	}
  if (!Ext.getCmp('testEndTime').isValid()) {
		Ext.MessageBox.alert("信息提示", msgText, function(btn) {
					Ext.getCmp('testEndTime').focus();
				});
		return;
	}
  if(Ext.getCmp('testEndTime').getValue() == "选择一个日期"|| Ext.getCmp('testEndTime').getValue() == ""){
		Ext.MessageBox.alert("信息提示",blankStr+"请选择结束时间"+blankStr);
		return;
	}
}