/**
 * 互联服务注册主页面
 * 
 * @class QueryForm
 * @extends Ext.ux.Form
 */
var areaUrl = "connSrpRegAction_queryArea.action";
var dicUrl = "connSrpIntefacesAction_queryConnInterType.action";
var connServ;
var pageSize=16 ;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var ConnSrpIntefacesOjb = {
	connSrpInterId : '',
	connRoutePlatCode : '',
	connInterAddr : '',
	connInterType : '',
	delFlag : ''
};
Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}

	QueryForm = Ext.extend(Ext.ux.Form, {
				areaCombo : null,
				constructor : function() {
					this.areaCombo = this.createCombo2("区域名称",
							"connRoutePlatArea", "businid", "businname", "90%",
							areaUrl, "areaList", "areaCount", false);
					this.areaCombo.store.load();
					QueryForm.superclass.constructor.call(this, {
								title : "服务域平台接口查询",
								width : Ext.getBody().getViewSize().width
										* 0.996,
								height : Ext.getBody().getViewSize().height
										* 0.2,
								region : "center",
								applyTo : "queryform",
								labelAlign: "right",
								bodyStyle : "padding: 5px 5px 0",
								items : [{
											layout : "column",
											items : [{
														layout : "form",
														items : this.areaCombo,
														columnWidth : .3333
													}]
										}],
								buttons : [{
											text : '查询',
											id : 'query_connserv_btn',
											iconCls : 'new',
											width : 20,
											hidden : false,
											handler : this.queryFormClick,
											scope : this
										}, {
											text : '重置',
											id : 'resume_connserv_btn',
											width : 20,
											iconCls : 'resume',
											hidden : false,
											handler : this.onResumeClick,
											scope : this
										}]

							})
				},
				queryFormClick : function() {
					areaCode = this.areaCombo.getValue();
					if (areaCode != null && areaCode != "") {
						areaCode = parseInt(areaCode);
					}
					connServ.store.baseParams = {
						'areaCode' : areaCode
					};
					connServ.store.load({
								params : {
									'page.start' : 0,
									'page.pageSize' : pageSize
								}
							});
				},
				onResumeClick : function() {
					this.areaCombo.reset();
				}
			});
	var queryForm = new QueryForm();

	/** ****************************互联服务添加窗口****************************************** */
	InsertDefineWindow = Ext.extend(Ext.Window, {
				connServForm : null,
				constructor : function() {
					this.connServForm = new ConnServForm();
					//if(this.connServForm.connInterType.getValue()==3)
					//this.connServForm.connInterAddr.value =="不需要输入wsdl";
					InsertDefineWindow.superclass.constructor.call(this, {
								title : "服务域平台接口添加",
								width : 350,
								height : 320,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connServForm]
							});
				}
			});

	/** ********************************互联服务修改form表单************************************************* */
	ConnServForm = Ext.extend(Ext.ux.Form, {
		connSrpInterId : null,
		connRoutePlatCode : null,
		connInterAddr : null,
		connInterType : null,
		delFlag : null,

		constructor : function() {
			this.connRoutePlatCode = this.createTextField("互联平台编码",
					"connRoutePlatCode", "90%", "text", 100, false, "",
					"超出最大长度100");
			this.connInterAddr = this
					.createTextField("平台接口地址", "connInterAddr", "90%", "text",
							100, false, "", "超出最大长度100");
			this.connInterType = this.createCombo2("接口类型", "connInterType",
					"businid", "businname", "90%", dicUrl, "infoList", "count",
					false);
			this.connInterType.store.load();
			this.connSrpInterId = this.createHidden("互联服务Id", "connSrpInterId");
			this.delFlag = this.createHidden("删除", "delFlag");
			ConnServForm.superclass.constructor.call(this, {
						width : 330,
						height : 280,
						region : "center",
						labelWidth : 80,
						bodyStyle : "padding: 5px 5px 0",
						items : [this.connRoutePlatCode, this.connInterAddr,
								this.connInterType, this.connSrpInterId,
								this.delFlag],
						buttons : [{
									text : '保存',
									id : 'modify_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : false,
									handler : this.onModifyClick,
									scope : this
								}, {
									text : '重置',
									id : 'resume_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : false,
									handler : this.onResumeClick,
									scope : this
								}]

					})
		},
		onModifyClick : function() {
			if (!this.getForm().isValid()) {
				Ext.MessageBox.alert("系统提示", blankStr + "请填写必填信息" + blankStr);
				return;
			} else {
				ConnSrpIntefacesOjb.connSrpInterId = this.connSrpInterId
						.getValue();
				ConnSrpIntefacesOjb.connRoutePlatCode = this.connRoutePlatCode
						.getValue();
				ConnSrpIntefacesOjb.connInterAddr = this.connInterAddr
						.getValue();
				ConnSrpIntefacesOjb.connInterType = this.connInterType
						.getValue();
				ConnSrpIntefacesOjb.delFlag = this.delFlag.getValue();
				if(ConnSrpIntefacesOjb.connInterType==3&&ConnSrpIntefacesOjb.connInterAddr.indexOf('?wsdl')!=-1){
				Ext.MessageBox.alert("系统提示", blankStr + "平台接口地址不需要加wsdl后缀！" + blankStr);
				return;
				}
				if(ConnSrpIntefacesOjb.connInterType!=3&&ConnSrpIntefacesOjb.connInterAddr.indexOf('?wsdl')==-1){
				Ext.MessageBox.alert("系统提示", blankStr + "" +"平台接口地址需要加wsdl后缀！" + blankStr);
				return;
				}
				if (this.connSrpInterId.getValue() == null
						|| this.connSrpInterId.getValue() == ''
						|| this.connSrpInterId.getValue() == 0) {
					ConnSrpIntefacesDwr.save(ConnSrpIntefacesOjb,
							function(data) {
								if (data) {
									Ext.MessageBox.alert("系统提示", blankStr
													+ "信息保存成功!" + blankStr);
									connServ.insertWindow.hide();
									connServ.store.load({
												params : {
													'page.start' : 0,
													'page.pageSize' : pageSize
												}
											});
								} else {
									Ext.MessageBox.alert("系统提示", blankStr
													+ "信息保存失败!" + blankStr);
								}
							});
				} else {
					ConnSrpIntefacesDwr.update(ConnSrpIntefacesOjb, function(
									data) {
								if (data) {
									Ext.MessageBox.alert("系统提示", blankStr
													+ "信息修改成功!" + blankStr);
									connServ.updateWindow.hide();
									connServ.store.load({
												params : {
													'page.start' : 0,
													'page.pageSize' : pageSize
												}
											});
								} else {
									Ext.MessageBox.alert("系统提示", blankStr
													+ "信息修改失败!" + blankStr);
								}
							});
				}
			}
		},
		onResumeClick : function() {
			record = connServ.getSelectionModel().getSelected();
			if (record == null) {
				this.getForm().reset();
			} else {
				this.getForm().loadRecord(record);
			}
		},
		createTextField : function(fieldLabel, name, anchor, inputType,
				maxLength, allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
			var tf = new Ext.form.TextField({
						fieldLabel : fieldLabel,
						name : name,
						xtype : 'textfield',
						readOnly : false,
						allowBlank : allowBlank,
						anchor : anchor,
						blankText : '该选项为必填项,请输入内容...',
						vtype : vtype,
						inputType : inputType,
						maxLength : maxLength,
						maxLengthText : maxLengthText
					});
			return tf;
		}
	});
	/** *****************************互联服务修改窗口**************************************** */
	UpdateConnServWindow = Ext.extend(Ext.Window, {
				connServForm : null,
				constructor : function() {
					this.connServForm = new ConnServForm();
					UpdateConnServWindow.superclass.constructor.call(this, {
								title : "服务域平台接口修改",
								width : 350,
								height : 320,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connServForm]
							});
				}
			});

	ConnServGrid = Ext.extend(UxGrid, {
		insertWindow : null,
		updateWindow : null,
		store : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
					url : "Scp/connSrpIntefacesAction_queryConnSrpIntfaces.action",
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							root : 'page.result'
						}, [{
									name : 'connSrpInterId'
								}, {
									name : 'connRoutePlatCode'
								}, {
									name : 'connInterAddr'
								}, {
									name : 'connInterType'
								}, {
									name : 'connInterTypeName'
								}, {
									name : 'delFlag'
								}])
			}), this.insertWindow = new InsertDefineWindow();
			this.updateWindow = new UpdateConnServWindow();
			ConnServGrid.superclass.constructor.call(this, {
						title : '服务域平台接口',
						frame : true,
						width : Ext.getBody().getViewSize().width * 0.996,
						renderTo : "grid-div",
						region : "center",
						height : Ext.getBody().getViewSize().height * 0.77,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : new Ext.grid.RowSelectionModel({
									singleSelect : true
								}),

						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(), {
									header : '接口id',
									dataIndex : 'connSrpInterId',
									hidden : true
								}, {
									header : '服务域平台编码',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									width : 100
								}, {
									header : '平台接口地址',
									dataIndex : 'connInterAddr',
									sortable : true,
									width : 100
								}, {
									header : '接口类型',
									dataIndex : 'connInterType',
									sortable : true,
									hidden : true
								}, {
									header : '接口类型',
									dataIndex : 'connInterTypeName',
									sortable : true,
									width : 130
								}, {
									header : '删除标志',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									hidden : true,
									renderer : this.format,
									width : 100
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : pageSize,
									paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
									},
									store : this.store,
									displayInfo : true,
									dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录",
									items : ['-', {
												text : '添加',
												id : 'bbar_newServDefine',
												iconCls : 'new',
												handler : this.onAddClick,
												scope : this
											}, '-', {
												text : '修改',
												id : 'bbar_updateServDefine',
												iconCls : 'update',
												handler : this.onModifyClick,
												scope : this
											}, '-', {
												text : '删除',
												id : 'bbar_deleteServDefine',
												iconCls : 'delete',
												handler : this.onDeleteClick,
												scope : this
											}]
								}),
						ds : this.store,
						listeners : {
							"dblclick" : {
								fn : this.onModifyClick,
								scope : this
							}
						}
					});
		},
		onAddClick : function() {
			this.insertWindow.connServForm.getForm().reset();
			this.insertWindow.show();
		},
		onModifyClick : function() {
			record = connServ.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!" + blankStr);
				return;
			}
			this.updateWindow.show();
			this.updateWindow.connServForm.getForm().loadRecord(record);
		},
		onDeleteClick : function() {
			record = this.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!" + blankStr);
				return;
			}
			Ext.MessageBox.confirm("系统提示", blankStr + "确定要删除该记录吗?" + blankStr,
					function(btn) {
						if (btn == "yes") {
							ConnSrpIntefacesDwr.deleteConnSrpInterfaceSc(record
											.get('connSrpInterId'), function(
											data) {
										if (data) {
											Ext.MessageBox.alert("系统提示",
													blankStr + "删除成功"
															+ blankStr);
											connServ.store.load({
														params : {
															'page.start' : 0,
															'page.pageSize' : pageSize
														}
													});
										} else {
											Ext.MessageBox.alert("系统提示",
													blankStr + "删除失败"
															+ blankStr);
										}
									});
						}
					});
		},
		format : function(val) {
			value = ""
			if (val == 1) {
				value = "已删除";
			} else {
				value = "正常";
			}
			return value;
		}
	});
	connServ = new ConnServGrid();
	connServ.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : pageSize
				}
			});
});