/**
 * 互联服务注册主页面
 * 
 * @class QueryForm
 * @extends Ext.ux.Form
 */
var PAGESIZE = 10;
var ConnServRegSCTree_URL = "connServRegTreeAction_queryConnServSCTree.action";
var areaUrl = "connSrpRegAction_queryArea.action";
var connServ;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var ConnServRegSCObj = {
	connServId : '',
	connServCode : '',
	connServName : '',
	connServType : '',
	areaCode : '', 
	connRoutePlatCode : '',
	provideCode : '',
	connServInvokeMode : '',
	connServStatus : '',
	connServProcStatus : '',
	wsdlId : '',
	protocolId : '',
	delFlag : '',
	description : '', 
	servDefineId : '',
	firstUploadTime : '',
	lastUploadTime : '',
	downloadTime : '',
	firstDownloadTime :'',
	updateServTime :''
};
var url_Invoke_Mode = "servAffordManRegAction_queryConnInvokeMode.action";
var ConnVisitLimitScObj = {
	connServLimitId : '',
	connServCode : '',
	connServManCode : '',
	delFlag : ''
};
var connServCode;
var servUrl = "servAffordManRegAction_queryAllServInfo.action";
var SERVTYPE_STORE_URL = 'register/servDefineAction_queryServType.action';
var providerUrl = "connLimitScAction_queryConnMan.action";
var SERVTYPE_STORE_URL = 'register/servDefineAction_queryServType.action';
var SERVMANURL = 'register/getAllServMan_queryAllServMan.action';
Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';
	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}
	
	var loader = new Ext.tree.MyTreeLoader({
		dataUrl : ConnServRegSCTree_URL 
	});
	loader.processResponse = function(response, node, callback){
		var json = response.responseText;
		try {
            var json = eval("("+json+")");
            node.beginUpdate();
            var o = json["key"];
            for(var i = 0, len = o.length; i < len; i++){
                var n = this.createNode(o[i]);
                if(n){
                    node.appendChild(n);
                }
            }
            node.endUpdate();
            if(typeof callback == "function"){
                callback(this, node);
            }
        }catch(e){
            this.handleFailure(response);
        }
	};
	// 树
	ConnServTree = Ext.extend(TreePanelFil, {
			constructor : function () {
				ConnServTree.superclass.constructor.call(this, {
					renderTo : 'connserv_tree',
					title : '互联服务',
					autoScroll : true,
					enableDD : false, // 是否支持拖拽效果
					containerScroll : true, // 是否支持滚动条
					width : 240,
					height : Ext.getBody().getViewSize().height - 5,					
					frame : false,
					rootVisible : true, // 是否显示根节点
					baseCls : 'x-panel',
					margins : '0 0 0 0',
					loader : loader,
					root : new Ext.tree.AsyncTreeNode({
						// id : '1',
						text : '互联服务域',
						iconCls : 'fwroot',
						leaf : false,
						draggable : false
					})
				});
			}
	});
	var connServTree = new ConnServTree();
	connServTree.getRootNode().expand();
	
	connServTree.on('click', function(node, e) {
    	// if(node == connServTree.getRootNode());
    // else{
    		var nodeId = node.id;
    		var store = connServ.getStore();
    		store.proxy = new Ext.data.HttpProxy({url:"Scp/connServRegSCAction_findConnServRegSC.action"});
    		store.baseParams = {'connServSCDto.connRoutePlatCode' : nodeId};
    		store.load({
    			params: {
    				'page.start' : 0,
    				'page.pageSize' : PAGESIZE
    			}
    		});
    		connServ.render();
    	// }
	});
	
	ServForm = Ext.extend(Ext.ux.Form, {
				areaCombo : null,
				servManCombo : null,
				servCombo : null,
				servTypeCombo : null,
				servType : null,
				constructor : function() {
					this.areaCombo = this.createCombo2("服务名称", "servName",
							"servId", "servName", "90%", servUrl,
							"servDtoList", "recordCount", true);
					this.areaCombo.initComponent = this
							.addBlankSelectForCombox(this.areaCombo);
					this.areaCombo.store.load();
					this.servType = this.createCombo2("服务类型", 'servType',
							'businid', 'businname', '90%', SERVTYPE_STORE_URL,
							'items_SERVTYPE', 'results_SERVTYPE', true);
					this.servType.initComponent = this
							.addBlankSelectForCombox(this.servType);
					this.servType.store.load();
					this.servManCombo = this.createCombo2(show_name,
							"servManName", "servManId", "servManName", "90%",
							SERVMANURL, "servManDtoList", "recordCount", true);
					this.servManCombo.initComponent = this
							.addBlankSelectForCombox(this.servManCombo);
					this.servManCombo.store.load();
					ServForm.superclass.constructor.call(this, {
								title : "服务查询SC",
								width : 700,
								height : 99,
								labelWidth : 80,
								region : "center",
								bodyStyle : "padding: 5px 5px 0",
								items : [{
											layout : "column",
											items : [{
														layout : "form",
														items : this.servManCombo,
														columnWidth : .3333
													}, {
														layout : "form",
														items : this.areaCombo,
														columnWidth : .3333
													}, {
														layout : "form",
														items : this.servType,
														columnWidth : .3333
													}]
										}],
								buttons : [{
											text : '查询',
											id : 'query_connserv_btn',
											iconCls : 'find',
											width : 20,
											hidden : false,
											handler : this.queryFormClick,
											scope : this
										}, {
											text : '重置',
											id : 'resume_connserv_btn',
											width : 20,
											iconCls : 'resume',
											hidden : false,
											handler : this.onResumeClick,
											scope : this
										}]

							});
				},
				queryFormClick : function() {
					servId = this.areaCombo.getValue();
					servType = this.servType.getValue();
					servManId = this.servManCombo.getValue();
					if (servId != null && servId != "") {
						servId = parseInt(servId);
					}
					if (servType != null && servType != "") {
						servType = parseInt(servType);
					}
					if (servManId != null && servManId != "") {
						servManId = parseInt(servManId);
					}
					connServ.insertWindow.servGrid.store.baseParams = {
						'servId' : servId,
						'servType' : servType,
						'servManId' : servManId
					};
					connServ.insertWindow.servGrid.store.load({
								params : {
									'start' : 0,
									'limit' : 10
								}
							});
				},
				onResumeClick : function() {
					connServ.insertWindow.servForm.getForm().reset();
				},
				addBlankSelectForCombox : function(combo) {
					combo.on("select", function() {
								if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
									combo.setValue("");
								}
							});
					combo.store.on("datachanged", function(a) {
								var r = new Ext.data.Record({});
								r.set(combo.valueField, ''); // 添加一格值为-1的选项
								r.set(combo.displayField, combo.emptyText);
								a.insert(0, r);
							});
				}
			});
	
	/** *************************互联服务权限配置列表********************************* */
	var connLimitGrid_AreaCodeStore = new Ext.data.Store({
        proxy: new Ext.data.HttpProxy({url: areaUrl, method: 'POST'}),
        reader: new Ext.data.JsonReader({totalProperty:"areaCount",root:"areaList"},new Ext.data.Record.create([{name:"businid"},{name:"businname"}]))
    }) ;
    connLimitGrid_AreaCodeStore.load() ;
	
	ConnLimitGrid = Ext.extend(UxGrid, {
		store : null,
		sm : null,
		constructor : function() {
			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
							url : "Scp/connLimitScAction_queryAreaConnMan.action",
							method : 'POST'
						}),
				reader : new Ext.data.JsonReader({
							totalProperty : '1',
							id : "businid",
							root : 'conManList'
						}, [{
									name : 'connServLimitId'
								}, {
									name : 'connServCode'
								}, {
									name : 'businid'
								}, {
									name : 'delFlag'
								}, {
									name : 'businname'
								}, {
									name : 'connServName'
								}, {
									name : 'areaCode'
								}])
			}), this.sm = new Ext.grid.CheckboxSelectionModel({
						singleSelect : false,
						handleMouseDown : Ext.emptyFn
					});
			this.areaLabel = new Ext.form.Label({
				text : '区域名称：'
			}), this.areaCombo = this
					.createCombo2("区域名称", "connRoutePlatArea", "businid",
							"businname", "90%", areaUrl, "areaList",
							"areaCount", true);
			this.areaCombo.initComponent = this
			.addBlankSelectForCombox(this.areaCombo);
	        this.areaCombo.store.load();
			ConnLimitGrid.superclass.constructor.call(this, {
						frame : false,
						width : 650,
						region : "center",
						height : 325,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(), this.sm, {
									header : '服务权限id',
									dataIndex : 'connServLimitId',
									hidden : true
								}, {
									header : '互联服务名称',
									dataIndex : 'connServName',
									sortable : true,
									width : 100,
									hidden : true
								}, {
									header : '互联服务编码',
									dataIndex : 'connServCode',
									sortable : true,
									hidden : true,
									width : 100
								}, {
									header : show_name + '编码',
									dataIndex : 'businid',
									sortable : true,
									hidden : false
								}, {
									header : '区域编码',
									dataIndex : 'areaCode',
									sortable : true,
									hidden : true,
									width : 130
								}, {
									header : show_name + '名称',
									dataIndex : 'businname',
									sortable : true,
									width : 130
								}]),
								tbar : new Ext.Toolbar({
									items : [ this.areaLabel, this.areaCombo,
											 '-', {
												text : '查询',
												iconCls : 'find',
												handler : this.query,
												scope : this
											}, '-', {
												text : '重置',
												iconCls : 'resume',
												handler : this.resume,
												scope : this
											} ]
								}),
						ds : this.store,
						listeners : {
							"cellclick" : {
								fn : this.onCellClick,
								scope : this
							}
						}
					});
		},
		query : function() {
			var areaCode = this.areaCombo.getValue();
			connServ.connLimitWindow.servLimitGrid.store.load({
 				params　:　{
 					areaCode:areaCode
 				},
 			callback : function() {
 				dwr.engine.setAsync(false);
 				ConnServLimitDwr.findLimitSc('', connServCode, function(data) {
 							var store = connServ.connLimitWindow.servLimitGrid.getStore();
 							connServ.connLimitWindow.servLimitGrid.getSelectionModel().clearSelections();
 							for (i = 0; i < data.length; i++) {
 								index = store.indexOfId(data[i].connServManCode);
 								if (index != -1) {
 									record = store.getAt(index);
 									record.set('connServLimitId',
 											data[i].connServLimitId);
 									record.set('businid', data[i].connServManCode);
 									record
 											.set('connServCode',
 													data[i].connServCode);
 								}
 								connServ.connLimitWindow.servLimitGrid
 										.getSelectionModel().selectRow(index, true);
 							}
 						});
 				dwr.engine.setAsync(true);
 				// connServ.connLimitWindow.servLimitGrid.sm.addListener('rowselect',this.onCellClick,this)
 			}
 		});
		},
		resume : function() {
			this.areaCombo.setValue("");
		},
		addBlankSelectForCombox : function(combo) {
			combo.on("select", function() {
				if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
					combo.setValue("");
				}
			});
			combo.store.on("datachanged", function(a) {
				var r = new Ext.data.Record({});
				r.set(combo.valueField, ''); // 添加一格值为-1的选项
				r.set(combo.displayField, combo.emptyText);
				a.insert(0, r);
			});
		},
		onCellClick : function(grid, rowIndex, colIndex, e) {
			var areaCombo = this.areaCombo;
			record = grid.getStore().getAt(rowIndex);
			ConnVisitLimitScObj.connServCode = connServCode;
			ConnVisitLimitScObj.connServLimitId = record.get('connServLimitId');
			ConnVisitLimitScObj.connServManCode = record.get('businid');
			ConnVisitLimitScObj.delFlag = '0';
			dataLimit = null;
			dwr.engine.setAsync(false);
			ConnServLimitDwr.findLimitSc(ConnVisitLimitScObj.connServManCode,
					ConnVisitLimitScObj.connServCode, function(data1) {
						if (data1.length != 0) {
							// Ext.MessageBox.alert("系统提示",blankStr+"该权限已经配置过!"+blankStr);
							// connServ.connLimitWindow.servLimitGrid.getSelectionModel().deselectRow(rowIndex);
							// return;
							dataLimit = data1;
						}
					});
			dwr.engine.setAsync(true);
			if (colIndex == 1) {
				record1 = grid.getSelectionModel().getSelected(rowIndex);
				status = grid.getSelectionModel().isSelected(record);
				// item = grid.getSelectionModel().selections.items[rowIndex];
				// if(status){
				Ext.MessageBox.confirm("系统提示", "确定要变更该服务访问权限吗?" + blankStr,
						function(btn) {
							if (btn == "yes") {
								if (dataLimit == null) {
									ConnServLimitDwr.save(ConnVisitLimitScObj,
											function(data) {
												if (data.optFlag) {
													Ext.MessageBox.alert(
															data.title,
															blankStr + data.msg
																	+ blankStr);
													var areaCode = areaCombo.getValue();										 				
													connServ.connLimitWindow.servLimitGrid.store
															.load({
																params:{
												 					areaCode:areaCode
												 				},
																callback : function() {
																	// dwr.engine.setAsync(false);
																	ConnServLimitDwr
																			.findLimitSc(
																					'',
																					connServCode,
																					function(
																							data) {
																						var store = connServ.connLimitWindow.servLimitGrid
																								.getStore();
																						connServ.connLimitWindow.servLimitGrid
																								.getSelectionModel()
																								.clearSelections();
																						for (i = 0; i < data.length; i++) {
																							index = store
																									.indexOfId(data[i].connServManCode);
																							if (index != -1) {
																								record = store
																										.getAt(index);
																								record
																										.set(
																												'connServLimitId',
																												data[i].connServLimitId);
																								record
																										.set(
																												'businid',
																												data[i].connServManCode);
																								record
																										.set(
																												'connServCode',
																												data[i].connServCode);
																								record
																										.set(
																												'delFlag',
																												0);
																							}
																							connServ.connLimitWindow.servLimitGrid
																									.getSelectionModel()
																									.selectRow(
																											index,
																											true);
																						}
																					});
																	// dwr.engine.setAsync(true);
																}
															});
												} else {
													Ext.MessageBox.alert(
															data.title,
															blankStr + data.msg
																	+ blankStr);
												}
											});
								} else {
									ConnServLimitDwr.remove(
											ConnVisitLimitScObj,
											function(data) {
												if (data.optFlag) {
													Ext.MessageBox.alert(
															data.title,
															blankStr + data.msg
																	+ blankStr);
													var areaCode = areaCombo.getValue();	
													connServ.connLimitWindow.servLimitGrid.store
															.load({
																params:{
												 					areaCode:areaCode
												 				},
																callback : function() {
																	dwr.engine
																			.setAsync(false);
																	ConnServLimitDwr
																			.findLimitSc(
																					'',
																					connServCode,
																					function(
																							data) {
																						var store = connServ.connLimitWindow.servLimitGrid
																								.getStore();
																						connServ.connLimitWindow.servLimitGrid
																								.getSelectionModel()
																								.clearSelections();
																						for (i = 0; i < data.length; i++) {
																							index = store
																									.indexOfId(data[i].connServManCode);
																							if (index != -1) {
																								record = store
																										.getAt(index);
																								record
																										.set(
																												'connServLimitId',
																												data[i].connServLimitId);
																								record
																										.set(
																												'businid',
																												data[i].connServManCode);
																								record
																										.set(
																												'connServCode',
																												data[i].connServCode);
																							}
																							connServ.connLimitWindow.servLimitGrid
																									.getSelectionModel()
																									.selectRow(
																											index,
																											true);
																						}
																					});
																	dwr.engine
																			.setAsync(true);
																}
															});
												} else {
													Ext.MessageBox.alert(
															data.title,
															blankStr + data.msg
																	+ blankStr);
												}
											});
								}
							} else {

								if (dataLimit == null) {
									connServ.connLimitWindow.servLimitGrid
											.getSelectionModel()
											.deselectRow(rowIndex);
								} else {
									connServ.connLimitWindow.servLimitGrid
											.getSelectionModel().selectRow(
													rowIndex, true);
								}
							}
						});
				// }
			}
		},
		ondeselect : function(grid, rowIndex) {
			var areaCombo = this.areaCombo;
			record = connServ.connLimitWindow.servLimitGrid.getStore()
					.getAt(rowIndex);
			ConnVisitLimitScObj.connServCode = connServCode;
			ConnVisitLimitScObj.connServLimitId = record.get('connServLimitId');
			ConnVisitLimitScObj.connServManCode = record.get('businid');
			ConnVisitLimitScObj.delFlag = '0';
			Ext.MessageBox.alert('系统提示',
					blankStr + "确定要变更系统的访问权限吗?" + blankStr, function(btn) {
						if (btn = 'yes') {
							ConnServLimitDwr.remove(ConnVisitLimitScObj,
									function(data) {
										if (data.optFlag) {
											Ext.MessageBox.alert(data.title,
													blankStr + data.msg
															+ blankStr);
											var areaCode = areaCombo.getValue();	
											connServ.connLimitWindow.servLimitGrid.store
													.load({params:{
									 					areaCode:areaCode
									 				},
														callback : function() {
															dwr.engine
																	.setAsync(false);
															ConnServLimitDwr
																	.findLimitSc(
																			'',
																			connServCode,
																			function(
																					data) {
																				var store = connServ.connLimitWindow.servLimitGrid
																						.getStore();
																				connServ.connLimitWindow.servLimitGrid
																						.getSelectionModel()
																						.clearSelections();
																				for (i = 0; i < data.length; i++) {
																					index = store
																							.indexOfId(data[i].connServManCode);
																					if (index != -1) {
																						record = store
																								.getAt(index);
																						record
																								.set(
																										'connServLimitId',
																										data[i].connServLimitId);
																						record
																								.set(
																										'businid',
																										data[i].connServManCode);
																						record
																								.set(
																										'connServCode',
																										data[i].connServCode);
																					}
																					connServ.connLimitWindow.servLimitGrid
																							.getSelectionModel()
																							.selectRow(
																									index,
																									true);
																				}
																			});
															dwr.engine
																	.setAsync(true);
														}
													});
										} else {
											Ext.MessageBox.alert(data.title,
													blankStr + data.msg
															+ blankStr);
										}
									});
						} else {
							connServ.connLimitWindow.servLimitGrid
									.getSelectionModel().selectRow(rowIndex,
											false);
						}
					});
		}
	});
	/** *************************************互联服务展示窗口********************************************************** */

	ConnLimitWindow = Ext.extend(Ext.Window, {

				servLimitGrid : null,
				constructor : function() {

					this.servLimitGrid = new ConnLimitGrid();
					ConnLimitWindow.superclass.constructor.call(this, {
								title : "互联权限配置窗口SC",
								width : 670,
								height : 360,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								frame : true,
								closeAction : 'hide',
								items : [this.servLimitGrid]
							});
				}
			});
	/** ********************************域内服务列表***************************************************** */
	ServGrid = Ext.extend(Ext.grid.EditorGridPanel, {
		servSm : null,
		servField : null,
		servDefineStore : new Ext.data.Store({
			proxy : new Ext.data.HttpProxy({
						url : "register/servDefineAction_queryServDefineSc.action",
						method : 'POST'
					}),
			reader : new Ext.data.JsonReader({
						totalProperty : 'totalProperty',
						root : 'servDefineDtoList'
					}, [{
								name : 'servId'
							}, {
								name : 'servName'
							}, {
								name : 'servDefineId'
							}, {
								name : 'servType'
							}, {
								name : 'servTypeName'
							}, {
								name : 'servDesc'
							}, {
								name : 'servInvokeMode'
							}, {
								name : 'servManId'
							}, {
								name : 'versionNo'
							}, {
								name : 'versionState'
							}, {
								name : 'verStateName'
							}, {
								name : 'protocolName'
							}, {
								name : 'protocolId'
							}, {
								name : 'servCode'
							}, {
								name : 'servManCode'
							}, {
								name : 'wsdlId'
							}])
		}),
		constructor : function() {
			this.servField = new Ext.form.TextField({
						name : 'servCode',
						allowBlank : false
					});
			this.servSm = new Ext.grid.CheckboxSelectionModel({
						singleSelect : false,
						header : '',
						handleMouseDown : Ext.emptyFn
					});
			this.servSm.on('rowselect', this.rowSelect, this);
			this.servSm.on('rowdeselect', this.rowDeselect, this);
			ServGrid.superclass.constructor.call(this, {
				frame : false,
				width : 700,
				height : 295,
				title : '域内服务列表',
				clicksToEdit : 1,
				viewConfig : {
					forceFit : true
				},
				loadMask : {
					msg : '正在载入数据,请稍候...'
				},
				sm : this.servSm,
				cm : new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
						this.servSm, {
							header : '服务id',
							dataIndex : 'servId',
							hidden : true
						}, {
							header : '服务名称',
							dataIndex : 'servName',
							sortable : true,
							width : 50
						}, {
							header : '服务编码',
							dataIndex : 'servCode',
							sortable : true,
							width : 100,
							editor : new Ext.grid.GridEditor(this.servField)
						}, {
							header : '服务版本',
							dataIndex : 'versionNo',
							sortable : true,
							width : 40
						}, {
							header : '服务类型',
							dataIndex : 'servTypeName',
							sortable : true,
							width : 50
						}, {
							header : '服务状态',
							dataIndex : 'verStateName',
							sortable : true,
							hidden : false,
							width : 40
						}
				// {header : '服务描述',dataIndex : 'servDesc',sortable :
				// true,hidden : false,width : 100}
				]),
				bbar : new Ext.PagingToolbar({
							firstText : '第一页',
							nextText : '下一页',
							prevText : '上一页',
							refreshText : '刷新',
							lastText : '最后一页',
							beforePageText : '当前',
							afterPageText : '页/共{0}页',
							pageSize : 10,
							store : this.servDefineStore,
							displayInfo : true,
							displayMsg : '本页显示 {0} - {1},共{2}条记录',
							emptyMsg : "没有可显示的记录"
						}),
				ds : this.servDefineStore
					// listeners:{"cellclick":{fn:this.cellClick,scope:this}}
				});
		},
		rowSelect : function(grid, rowIndex, columnIndex, e) {
			// if(columnIndex == 1){
			var record = connServ.insertWindow.servGrid.getStore()
					.getAt(rowIndex);
			// status = grid.getSelectionModel().isSelected(record);
			// if(status){
			ConnServRegSCObj.connServId = '';
			ConnServRegSCObj.servDefineId = record.get('servDefineId');
			ConnServRegSCObj.areaCode = '';
			ConnServRegSCObj.connRoutePlatCode = '';
			ConnServRegSCObj.connServCode = '';
			servCode = record.get('servCode');
			/**
			 * 互联服务编码进行处理
			 */
			if (servCode == null || servCode == '') {
				Ext.MessageBox.alert("系统提示", "互联服务编码不可为空");
				return;
			}
			end = servCode.lastIndexOf('.');
			start = servCode.indexOf('.');
			if (start == -1) {

			} else if (start == end) {
				// servCode = servCode.substring(0,start);
			} else {
				servCode = servCode.substring(start + 1);
			}
			ConnServRegSCObj.connServInvokeMode = record.get('servInvokeMode');
			ConnServRegSCObj.connServName = record.get('servName');
			ConnServRegSCObj.connServProcStatus = 1;
			ConnServRegSCObj.connServStatus = record.get('versionState');
			ConnServRegSCObj.connServType = record.get('servType');
			ConnServRegSCObj.delFlag = 0;
			ConnServRegSCObj.description = record.get('servDesc');
			ConnServRegSCObj.protocolId = record.get('protocolId');
			ConnServRegSCObj.provideCode = '';
			ConnServRegSCObj.wsdlId = record.get('wsdlId');
			servManCode = record.get('servManCode');
			/**
			 * 区域编码从库中读取
			 */
			areaCode = "";
			connRoutePlatCode = "";
			// 互联服务商编码从库中读取
			connServManCode = "";
			Ext.MessageBox.confirm("系统提示", "确认要添加该服务为互联服务吗?", function(btn) {
				if (btn == "yes") {
					ConnServRegDwr.queryLocalAreaCode(function(data) {
						connRoutePlatCode = data;
						if (connRoutePlatCode != "") {
							index = connRoutePlatCode.lastIndexOf('.');
							areaCode = connRoutePlatCode.substring(0, index);
						}
						ConnServRegDwr.queryConnServManCode(servManCode,
								function(data1) {
									connServManCode = data1;
									ConnServRegSCObj.areaCode = areaCode;
									ConnServRegSCObj.connRoutePlatCode = connRoutePlatCode;
									/**
									 * 互联服务商转换信息如果不存在，则保留原服务商编码信息，不做转换处理
									 */
									if (connServManCode == "") {
										ConnServRegSCObj.connServCode = areaCode
												+ '.' + record.get("servCode");
									} else {
										ConnServRegSCObj.connServCode = areaCode
												+ '.'
												+ connServManCode
												+ '.'
												+ servCode;
									}
									if (connServManCode == "") {
										ConnServRegSCObj.provideCode = servManCode;
									} else {
										ConnServRegSCObj.provideCode = connServManCode;
									}
									ConnServRegSCDwr.save(ConnServRegSCObj,
											function(data2) {
												if (data2 != null) {
													Ext.MessageBox
															.alert(
																	"系统提示",
																	blankStr
																			+ "互联服务信息保存成功!"
																			+ blankStr);
													connServ.insertWindow
															.hide();
													connServ.insertWindow.servGrid.store
															.load({
																params : {
																	'start' : 0,
																	'limit' : 10
																}
															});
													connServ.store.load({
														params : {
															'page.start' : 0,
															'page.pageSize' : 10
														}
													});
												} else {
													Ext.MessageBox
															.alert(
																	"系统提示",
																	blankStr
																			+ "互联服务信息保存失败!"
																			+ blankStr);
												}
											});
								});
					});
				} else {

					connServ.insertWindow.servGrid.getSelectionModel()
							.deselectRow(rowIndex);
				}
			});
			// }
			// }
		}
	});
	/** ****************************互联服务添加窗口****************************************** */
	InsertDefineWindow = Ext.extend(Ext.Window, {

				servGrid : null,
				servForm : null,
				constructor : function() {

					this.servGrid = new ServGrid();
					this.servForm = new ServForm();
					InsertDefineWindow.superclass.constructor.call(this, {
								title : "互联服务添加窗口SC",
								width : 720,
								height : 430,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.servForm, this.servGrid]
							});
				}
			});

	/** ********************************互联服务修改form表单************************************************* */
	ConnServForm = Ext.extend(Ext.ux.Form, {
				provideCode : null,
				srpCode : null,
				servCode : null,
				servName : null,
				areaCode : null,
				servId : null,
				servStatus : null,
				servInvokeMode : null,
				connServType : null,
				connServProcStatus : null,
				wsdlId : null,
				protocolId : null,
				delFlag : null,
				description : null,
				servDefineId : null,
				constructor : function() {
					this.provideCode = this.createTextField("系统编码",
							"provideCode", "90%", "text", 100, false, "",
							"超出最大长度100");
					this.provideCode.disabled = true;
					this.srpCode = this.createTextField("服务平台编码",
							"connRoutePlatCode", "90%", "text", 100, false, "",
							"超出最大长度100");
					this.servCode = this.createTextField("服务编码",
							"connServCode", "90%", "text", 100, false, "",
							"超出最大长度100");
					this.servCode.disabled = true;
					this.servName = this.createTextField("服务名称",
							"connServName", "90%", "text", 100, false, "",
							"超出最大长度100");
					this.areaCode = this.createTextField("区域编码", "areaCode",
							"90%", "text", 100, false, "", "超出最大长度100");
					this.servId = this.createHidden("互联服务Id", "connServId");
					that = this;
					josnData = [{
								connServStatus : 1,
								servStatName : '已注册'
							}, {
								connServStatus : 2,
								servStatName : '已发布'
							}, {
								connServStatus : 3,
								servStatName : '已注销'
							}];
					this.servStatus = this.createMemoryCombo("服务状态",
							'connServStatus', 'servStatName', '90%', josnData);
					this.servStatus.store.load();
					// this.servStatus =
					// this.createCombo2("服务状态","srpStaticStatus","businid","businname","90%","servStatusUrl","srpStaticStatus","srpStaticCount",true);
					this.servInvokeMode = this.createCombo2("调用模式",
							"connServInvokeMode", "businid", "businname",
							"90%", url_Invoke_Mode, "invokeMode2",
							"InvokeModeCount2", true);;
					this.servInvokeMode.store.load();
					this.servInvokeMode.disabled = true;
					this.connServType = this.createHidden("服务类型",
							"connServType");
					this.connServProcStatus = this.createHidden("服务运行状态",
							"connServProcStatus");
					this.wsdlId = this.createHidden("wsdlId", "wsdlId");
					this.protocolId = this.createHidden("protocolId",
							"protocolId");
					this.delFlag = this.createHidden("delFlag", "delFlag");
					this.description = this.createTextField("服务描述",
							"description", "90%", "text", 100, true, "",
							"超出最大长度100");
					this.servDefineId = this.createHidden("servDefineId",
							"servDefineId");
					ConnServForm.superclass.constructor.call(this, {
								// title:"互联服务域编辑",
								width : 330,
								height : 280,
								region : "center",
								labelWidth : 80,
								// applyTo:"queryform",
								bodyStyle : "padding: 5px 5px 0",
								items : [this.provideCode, this.srpCode,
										this.servCode, this.servName,
										this.areaCode, this.servId,
										this.description, this.servStatus,
										this.servInvokeMode, this.connServType,
										this.connServProcStatus, this.wsdlId,
										this.protocolId, this.delFlag,
										this.servDefineId],
								buttons : [{
											text : '修改',
											id : 'modify_srp_btn',
											width : 20,
											iconCls : 'update',
											hidden : false,
											handler : this.onModifyClick,
											scope : this
										}, {
											text : '重置',
											id : 'resume_srp_btn',
											width : 20,
											iconCls : 'resume',
											hidden : false,
											handler : this.onResumeClick,
											scope : this
										}]

							})
				},
				onModifyClick : function() {
					if (!this.getForm().isValid()) {
						Ext.MessageBox.alert("系统提示", blankStr + "请填写必填信息"
										+ blankStr);
						return;
					} else {
						ConnServRegSCObj.areaCode = this.areaCode.getValue();
						ConnServRegSCObj.connRoutePlatCode = this.srpCode
								.getValue();
						ConnServRegSCObj.connServCode = this.servCode
								.getValue();
						ConnServRegSCObj.connServId = this.servId.getValue();
						ConnServRegSCObj.connServInvokeMode = this.servInvokeMode
								.getValue();
						ConnServRegSCObj.connServName = this.servName
								.getValue();
						ConnServRegSCObj.connServProcStatus = 1;// this.connServProcStatus.getValue();
						ConnServRegSCObj.connServStatus = this.servStatus
								.getValue();
						ConnServRegSCObj.connServType = this.connServType
								.getValue();
						ConnServRegSCObj.delFlag = this.delFlag.getValue();
						ConnServRegSCObj.description = this.description
								.getValue();
						ConnServRegSCObj.protocolId = this.protocolId
								.getValue();
						ConnServRegSCObj.provideCode = this.provideCode
								.getValue();
						ConnServRegSCObj.servDefineId = this.servDefineId
								.getValue();
						ConnServRegSCObj.wsdlId = this.wsdlId.getValue();
						ConnServRegSCDwr.update(ConnServRegSCObj,
								function(data) {
									if (data) {
										Ext.MessageBox.alert("系统提示", blankStr
														+ "信息修改成功!" + blankStr);
										connServ.updateWindow.hide();
										connServ.store.load({
													params : {
														'page.start' : 0,
														'page.pageSize' : 10
													}
												});
									} else {
										Ext.MessageBox.alert("系统提示", blankStr
														+ "信息修改失败!" + blankStr);
									}
								});
					}
				},
				onResumeClick : function() {
					record = connServ.getSelectionModel().getSelected();
					if (record == null) {
						this.getForm().reset();
					} else {
						this.getForm().loadRecord(record);
					}
				},
				createTextField : function(fieldLabel, name, anchor, inputType,
						maxLength, allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
					var tf = new Ext.form.TextField({
								fieldLabel : fieldLabel,
								name : name,
								xtype : 'textfield',
								readOnly : false,
								allowBlank : allowBlank,
								anchor : anchor,
								blankText : '该选项为必填项,请输入内容...',
								vtype : vtype,
								inputType : inputType,
								maxLength : maxLength,
								maxLengthText : maxLengthText
							});
					return tf;
				}
			});
	/** *****************************互联服务修改窗口**************************************** */
	UpdateConnServWindow = Ext.extend(Ext.Window, {
				connServForm : null,
				constructor : function() {

					this.connServForm = new ConnServForm();
					UpdateConnServWindow.superclass.constructor.call(this, {
								title : "互联服务修改窗口SC",
								width : 350,
								height : 320,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connServForm]
							});
				}
			});
	/**
	 * 互联服务下发情况列表信息
	 */
	ConnSendInfoGrid = Ext.extend(UxGrid, {
		store : null,
		sm : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
							url : "Scp/connSendInfoAction_QuerySendInfo.action",
							method : 'POST'
						}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							id : "connSendId",
							root : 'page.result'
						}, [{
									name : 'connSendId'
								}, {
									name : 'connCode'
								}, {
									name : 'connRoutePlatCode'
								}, {
									name : 'connStateFlag'
								}, {
									name : 'delFlag'
								}, {
									name : 'connRoutePlatName'
								}, {
									name : 'connInterAddr'
								}, {
									name : 'connFlag'
								}])
			}), this.sm = new Ext.grid.RowSelectionModel({
						singleSelect : true
					});
			ConnSendInfoGrid.superclass.constructor.call(this, {
						// title:'互联服务权限列表',
						frame : false,
						width : 660,
						region : "center",
						height : 390,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : this.sm,
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(),
								// this.sm,
								{
									header : '互联服务下发id',
									dataIndex : 'connServLimitId',
									hidden : true
								},
								// {header : '互联服务名称',dataIndex :
								// 'connServName',sortable : true,width :
								// 100,hidden:true},
								{
									header : '互联服务编码',
									dataIndex : 'connCode',
									sortable : true,
									hidden : false,
									width : 100
								}, {
									header : '互联平台编码',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									hidden : false
								}, {
									header : '互联平台名称',
									dataIndex : 'connRoutePlatName',
									sortable : true,
									hidden : false
								}, {
									header : '接口地址',
									dataIndex : 'connInterAddr',
									sortable : true,
									hidden : false
								}, {
									header : '下发情况',
									dataIndex : 'connStateFlag',
									sortable : true,
									hidden : false,
									renderer : this.format
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 10,
									paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
									},
									store : this.store,
									displayInfo : true,
									displayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录",
									items : ['-', {
												text : '下发',
												id : 'bbar_deleteServDefine',
												iconCls : 'submit',
												handler : this.onDownLoadClick,
												scope : this
											}, '-'

									]
								}),
						ds : this.store,
						listeners : {}
					});
		},
		format : function(val) {
			if (val == 1) {
				return '成功';
			} else {
				return '失败';
			}
		},
		onDownLoadClick : function() {
			record = connServ.connServDownLoadWindow.connSendInfoGrid
					.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert('系统提示', '请选择一条记录下发!');
				return;
			}
			connStateFlag = record.get('connStateFlag');
			if (connStateFlag == 1) {
				Ext.MessageBox
						.alert('系统提示', blankStr + '该互联服务已经下发!' + blankStr);
				return;
			}
			connRouteCode = record.get('connRoutePlatCode');
			connServCode = record.get('connCode');
			connRoutePlatAddr = record.get('connInterAddr');
			connServId = connServ.getSelectionModel().getSelected()
					.get('connServId');
			ConnServRegSCDwr.downLoadSingleRoute(connServId, connRoutePlatAddr,
					connRouteCode, function(data) {
						if (data.optFlag) {
							Ext.MessageBox.alert('系统提示', blankStr + '互联服务下发成功!'
											+ blankStr);
							connServ.connServDownLoadWindow.connSendInfoGrid.store
									.load({
										params : {
											'page.start' : 0,
											'page.PageSize' : 10,
											'connSendInfoDto.connFlag' : 2,
											'connSendInfoDto.connCode' : connServCode
										}
									});
						} else {
							Ext.MessageBox.alert('系统提示', blankStr + '互联服务下发失败!'
											+ blankStr);
						}
					});
		}
	});

	// 互联接口列表

	ConnSrpIntefacesGrid = Ext.extend(UxGrid, {
		store : null,
		sm : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
					// url :
					// "Scp/connSrpIntefacesAction_findConnServIntfaces.action",
					url : "Scp/connSrpIntefacesAction_queryConnServIntfaceSc.action",
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'pageConn.totalCount',
							root : 'pageConn.result'
						}, [{
									name : 'connSrpInterId'
								}, {
									name : 'connRoutePlatCode'
								}, {
									name : 'connRoutePlatName'
								}, {
									name : 'connInterAddr'
								}, {
									name : 'connInterType'
								}, {
									name : 'connInterTypeName'
								}, {
									name : 'delFlag'
								}])
			}), this.sm = new Ext.grid.CheckboxSelectionModel({
				// header : ''
					// singleSelect : false
				}), this.sm.on("rowselect", this.rowSelect1, this);
			ConnSrpIntefacesGrid.superclass.constructor.call(this, {
						frame : false,
						width : 660,
						region : "center",
						height : 390,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : this.sm,
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(),this.sm, {
									header : '接口id',
									dataIndex : 'connSrpInterId',
									hidden : true
								}, {
									header : '服务域平台编码',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									width : 100
								},{
									header : '服务域平台名称',
									dataIndex : 'connRoutePlatName',
									sortable : true,
									width : 100
								},  {
									header : '平台接口地址',
									dataIndex : 'connInterAddr',
									sortable : true,
									width : 100
								}, {
									header : '接口类型',
									dataIndex : 'connInterTypeName',
									sortable : true,
									width : 130
								}, {
									header : '删除标志',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									hidden : true,
									renderer : this.format,
									width : 100
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 10,
									paramNames : {
										start : 'pageConn.start',
										limit : 'pageConn.pageSize'
									},
									store : this.store,
									displayInfo : true,
									dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录",
									items : ['-', {
												text : '下发',
												id : 'bbar_deleteServDefine',
												iconCls : 'submit',
												handler : this.onDownLoad,
												scope : this
											}, '-'

									]
								}),
						ds : this.store,
						listeners : {}
					});
		},
		format : function(val) {
			if (val == 1) {
				return '成功';
			} else {
				return '失败';
			}
		},
		rowSelect1:function(){
		record = this.getSelectionModel().getSelected();
	},
		onDownLoadClick : function() {
			record = connServ.connServDownLoadWindow.connSendInfoGrid
					.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert('系统提示', '请选择一条记录下发!');
				return;
			}
			connStateFlag = record.get('connStateFlag');
			if (connStateFlag == 1) {
				Ext.MessageBox
						.alert('系统提示', blankStr + '该互联服务已经下发!' + blankStr);
				return;
			}
			connRouteCode = record.get('connRoutePlatCode');
			connServCode = record.get('connCode');
			connRoutePlatAddr = record.get('connInterAddr');
			connServId = connServ.getSelectionModel().getSelected()
					.get('connServId');
			ConnServRegSCDwr.downLoadSingleRoute(connServId, connRoutePlatAddr,
					connRouteCode, function(data) {
						if (data.optFlag) {
							Ext.MessageBox.alert('系统提示', blankStr + '互联服务下发成功!'
											+ blankStr);
							connServ.connServDownLoadWindow.connSendInfoGrid.store
									.load({
										params : {
											'page.start' : 0,
											'page.PageSize' : 10,
											'connSendInfoDto.connFlag' : 2,
											'connSendInfoDto.connCode' : connServCode
										}
									});
						} else {
							Ext.MessageBox.alert('系统提示', blankStr + '互联服务下发失败!'
											+ blankStr);
						}
					});
		},
		onDownLoad : function() {
			var servCtrlIdStr = '';
				var servCtrlNameStr = '';
				var count = 0;
			record = connServ.connDownLoadWindow.connSrpIntefacesGrid
					.getSelectionModel().getSelected();
			record1 = connServ.getSelectionModel().getSelected();
			if (record1 == null||record == null) {
				Ext.MessageBox.alert('系统提示', '请选择一条记录下发!');
				return;
			}
		
				/*
				 * var cell = record.each(function(rec) { if
				 * (rec.get('connSrpInterId') > 0) { servCtrlIdStr +=
				 * rec.get('connSrpInterId') + ','; //servCtrlNameStr +=
				 * rec.get('connRoutePlatCode') + ','; count++; }
				 */
			var cell = connServ.connDownLoadWindow.connSrpIntefacesGrid.getSelectionModel().each(function(rec) {
							if (rec.get('connSrpInterId') > 0) {
								servCtrlIdStr += rec.get('connSrpInterId') + ',';
								// servCtrlNameStr += rec.get('servManName') +
								// ',';
								count++;
							}
						});
			connRouteAddress="";
			connServId = record1.get('connServId');
			connSrpInterId = record.get('connSrpInterId');
			ConnServRegSCDwr.newDownLoad(connServId, servCtrlIdStr,connRouteAddress, function(
							data) {
						if (data.optFlag) {
							connServ.connDownLoadWindow.hide();
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
							connServ.store.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : 10
										}
									});
						} else {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
						}
					});
		}
	});

	/**
	 * 互联服务下发情况查看窗口
	 */
	ConnServDownLoadWindow = Ext.extend(Ext.Window, {
				connSendInfoGrid : null,
				constructor : function() {

					this.connSendInfoGrid = new ConnSendInfoGrid();
					ConnServDownLoadWindow.superclass.constructor.call(this, {
								title : "互联服务下发信息窗口SC",
								width : 680,
								height : 430,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connSendInfoGrid]
							});
				}
			});
	// 互联下发打开窗口
	ConnDownLoadWindow = Ext.extend(Ext.Window, {
				connSrpIntefacesGrid : null,
				constructor : function() {

					this.connSrpIntefacesGrid = new ConnSrpIntefacesGrid();
					ConnDownLoadWindow.superclass.constructor.call(this, {
								title : "互联服务下发信息窗口SC",
								width : 680,
								height : 430,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connSrpIntefacesGrid]
							});
				}
			});

	ConnServGrid = Ext.extend(UxGrid, {
		insertWindow : null,
		updateWindow : null,
		connLimitWindow : null,
		connServDownLoadWindow : null,
		connDownLoadWindow : null,
		store : null,
		constructor : function() {
			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
// url : "Scp/connServRegSCAction_findConnServRegSC.action",
							method : 'POST'
						}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							root : 'page.result'
						}, [{
									name : 'connServId'
								}, {
									name : 'connServCode'
								}, {
									name : 'connServName'
								}, {
									name : 'connServType'
								}, {
									name : 'areaCode'
								}, {
									name : 'areaName'
								},  {
									name : 'connRoutePlatCode'
								},{
									name : 'provideCode'
								}, {
									name : 'connServInvokeMode'
								}, {
									name : 'connServStatus'
								}, {
									name : 'connServProcStatus'
								}, {
									name : 'wsdlId'
								}, {
									name : 'protocolId'
								}, {
									name : 'delFlag'
								}, {
									name : 'description'
								}, {
									name : 'servDefineId'
								}, {
									name : 'firstUploadTime'
								}, {
									name : 'lastUploadTime'
								}, {
									name : 'downloadTime'
								},{
									name : 'firstDownloadTime'
								},{
									name : 'updateServTime'
								}])
			}), this.insertWindow = new InsertDefineWindow();
			this.updateWindow = new UpdateConnServWindow();
			this.connLimitWindow = new ConnLimitWindow();
			this.connServDownLoadWindow = new ConnServDownLoadWindow();
			this.connDownLoadWindow = new ConnDownLoadWindow();
			ConnServGrid.superclass.constructor.call(this, {
						title : '互联服务列表SC',
						frame : true,
						width : Ext.getBody().getViewSize().width - 245,
						renderTo : "grid-div",
						region : "center",
						height : Ext.getBody().getViewSize().height - 10,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : new Ext.grid.RowSelectionModel({
									singleSelect : true
								}),
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(), {
									header : '服务id',
									dataIndex : 'connServId',
									hidden : true
								}, {
									header : '互联服务名称',
									dataIndex : 'connServName',
									sortable : true,
									width : 80
								}, {
									header : '互联服务编码',
									dataIndex : 'connServCode',
									sortable : true,
									hidden : false,
									width : 140
								}, {
									header : show_name + '编码',
									dataIndex : 'provideCode',
									sortable : true,
									hidden : true
								}, {
									header : '区域名称',
									dataIndex : 'areaName',
									sortable : true,
									width : 100
								}, {
									header : '所属服务平台编码',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									hidden :true
								}, {
									header : '互联服务描述',
									dataIndex : 'description',
									hidden : true,
									sortable : true
								}, {
									header : '互联服务状态',
									dataIndex : 'connServStatus',
									hidden : false,
									renderer : this.format,
									sortable : true,
									width : 100
								}, {
									header : '互联流程状态',
									dataIndex : 'connServProcStatus',
									hidden : false,
									renderer : this.format1,
									sortable : true,
									width : 100
								}, {
									header : '首次上报时间',
									dataIndex : 'firstUploadTime',
									hidden : true,
									sortable : true,
									width : 100
								}, {
									header : '最后一次上报时间',
									dataIndex : 'lastUploadTime',
									hidden : true,
									sortable : true,
									width : 120
								}, {
									header : '首次下发时间',
									dataIndex : 'firstDownloadTime',
									hidden : true,
									sortable : true,
									width : 100
								}, {
									header : '下发时间',
									dataIndex : 'downloadTime',
									hidden : true,
									sortable : true,
									width : 100
								},{
									header : '修改时间',
									dataIndex : 'updateServTime',
									hidden : true,
									sortable : true,
									width : 100
								}, {
									header : '互联权限配置',
									dataIndex : 'connServCode',
									hidden : false,
									renderer : this.onConnLimit,
									sortable : true,
									width : 100
								}, {
									header : '下发情况',
									dataIndex : 'connServCode',
									hidden : false,
									renderer : this.downLoad,
									sortable : true,
									width : 100
								}]),
						tbar :['服务名称或编码:', {
									xtype : 'textfield',
									width : 300,
									id : 'byNameORNTf'
								}, '-', {
									text : '查询',
									iconCls : 'find',
									handler : this.filterByName,
									scope : this
								},
								'-',
								{
									text : '重置',
									iconCls : 'resume',
									handler : this.resumeClick,
									scope : this
								} ],
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 10,
									paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
									},
									store : this.store,
									displayInfo : true,
									displayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录",
									items : [ '-', {
												text : '修改',
												id : 'bbar_updateServDefine',
												iconCls : 'update',
												handler : this.onModifyClick,
												scope : this
											}, '-', {
												text : '删除',
												id : 'bbar_deleteServDefine',
												iconCls : 'delete',
												handler : this.onDeleteClick,
												scope : this
											}, '-', {
												text : '下发',
												id : 'bbar_deleteServDefine',
												iconCls : 'submit',
												handler : this.onDownLoad,
												scope : this
											}

									]
								}),
						ds : this.store,
						listeners : {
							"rowcontextmenu" : {
								fn : this.onRightMenuClick,
								scope : this
							},
							"dblclick" : {
								fn : this.onDblclick,
								scope : this
							}
						}
					});
			Ext.getCmp('byNameORNTf').addListener('specialkey', this.enterKeyEnter,this);
		},
		enterKeyEnter : function(textfield, e) {
			 if (e.getKey() == Ext.EventObject.ENTER) {
				 this.filterByName();
			 }
		},
		filterByName: function(){
			var selNode = connServTree.getSelectionModel().getSelectedNode();
			if (selNode == null) {
				Ext.MessageBox.alert('系统提示', blankStr
						+ '请先在页面左侧选择所在服务域或根节点!' + blankStr);
				return;
			}
			var parNode = selNode.id.indexOf("node") != -1 ? ""
					: selNode.id;
			var servName = Ext.getCmp('byNameORNTf').getValue();
				var store = connServ.getStore();
	    		store.proxy = new Ext.data.HttpProxy({url:"Scp/connServRegSCAction_findConnServRegSC.action"});
	    		store.baseParams = {
	    				'connServSCDto.connServCode' : servName ,
	    				'connServSCDto.connRoutePlatCode' : parNode
	    		};
	    		store.load({
	    			params: {
	    				'page.start' : 0,
	    				'page.pageSize' : PAGESIZE
	    			}
	    		});
	    		connServ.render();
		},
		resumeClick : function() {
			Ext.getCmp('byNameORNTf').setValue("");
		},
		// 下发方法
		onDownLoad : function() {
				connServ.connDownLoadWindow.show();
				connServ.connDownLoadWindow.connSrpIntefacesGrid.store.load({
							params : {
								'pageConn.start' : 0,
								'pageConn.PageSize' : 10
							}
						});
		},
		onModifyClick : function() {
			record = connServ.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!" + blankStr);
				return;
			}
			this.updateWindow.show();
			this.updateWindow.connServForm.getForm().loadRecord(record);
		},
		onDeleteClick : function() {
			record = this.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!" + blankStr);
				return;
			}
			ConnServRegSCObj.areaCode = record.get('areaCode');
			ConnServRegSCObj.connRoutePlatCode = record
					.get('connRoutePlatCode');
			ConnServRegSCObj.connServCode = record.get('connServCode');
			ConnServRegSCObj.connServId = record.get('connServId');
			ConnServRegSCObj.connServInvokeMode = record
					.get('connServInvokeMode');
			ConnServRegSCObj.connServName = record.get('connServName');
			ConnServRegSCObj.connServProcStatus = record
					.get('connServProcStatus');
			ConnServRegSCObj.connServStatus = record.get('connServStatus');
			ConnServRegSCObj.connServType = record.get('connServType');
			ConnServRegSCObj.delFlag = record.get('delFlag');
			ConnServRegSCObj.wsdlId = record.get('wsdlId');
			ConnServRegSCObj.servDefineId = record.get('servDefineId');
			ConnServRegSCObj.provideCode = record.get('provideCode');
			ConnServRegSCObj.protocolId = record.get('protocolId');
			ConnServRegSCObj.description = record.get('description');
			Ext.MessageBox.confirm("系统提示", "确定要删除该互联服务吗?", function(btn) {
						if (btn == "yes") {
							ConnServRegSCDwr.remove(ConnServRegSCObj, function(
											data) {
										if (data.optFlag) {
											Ext.MessageBox.alert("系统提示",
													blankStr + data.msg
															+ blankStr);
											connServ.store.load({
														params : {
															'page.start' : 0,
															'page.pageSize' : 10
														}
													});
										} else {
											Ext.MessageBox.alert("系统提示",
													blankStr + data.msg
															+ blankStr);
										}
									});
						}
					});
		},
		onDownLoadClick : function() {
			record = connServ.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请选择一条服务!" + blankStr);
				return;
			}
			connservId = record.get('connServId');
			connRouteAddress = "";
			ConnServRegSCDwr.downLoad(connservId, connRouteAddress, function(
							data) {
						if (data.optFlag) {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
							connServ.store.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : 10
										}
									});
						} else {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
						}
					});
		},
		useLoadingMessage : function(message) {
			var loadingMessage;
			if (message)
				loadingMessage = message;
			else
				loadingMessage = "正在处理,请稍候...";

			dwr.engine.setPreHook(function() {
				var disabledZone = $('disabledZone');
				if (!disabledZone) {
					disabledZone = document.createElement('div');
					disabledZone.setAttribute('id', 'disabledZone');
					disabledZone.style.position = "absolute";
					disabledZone.style.zIndex = "1000";
					disabledZone.style.left = "0px";
					disabledZone.style.top = "0px";
					disabledZone.style.width = "50%";
					disabledZone.style.height = "50%";
					document.body.appendChild(disabledZone);
					var messageZone = document.createElement('div');
					messageZone.setAttribute('id', 'messageZone');
					messageZone.style.position = "absolute";
					messageZone.style.top = "50%";
					messageZone.style.right = "0px";
					messageZone.style.background = "purple";
					messageZone.style.position = "center";
					messageZone.style.color = "white";
					messageZone.style.fontFamily = "Arial,Helvetica,sans-serif";
					messageZone.style.padding = "10px";
					disabledZone.appendChild(messageZone);
					var text = document.createTextNode(loadingMessage);
					messageZone.appendChild(text);
				} else {
					$('messageZone').innerHTML = loadingMessage;
					disabledZone.style.visibility = 'visible';
				}
			});
			dwr.engine.setPostHook(function() {
						$('disabledZone').style.visibility = 'hidden';
					});
		},
		onDblclick : function(e) {
			record = this.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请选择一条记录!" + blankStr);
				return;
			}
			this.updateWindow.show();
			this.updateWindow.connServForm.getForm().loadRecord(record);
		},
		format : function(val) {
			value = ""
			if (val == 1) {
				value = '<font color=green>' + "已注册" + '</font>';
			} else if (val == 2) {
				value = '<font color=blue>' + "已发布" + '</font>';
			} else if (val == 3) {
				value = '<font color=red>' + "已注销" + '</font>';
			} else {
				value = '<font color=orange>' + value+ '</font>';
			}
			return value;
		},
		format1 : function(val) {
			value = ""
			if (val == 1) {
				value = '<font color=green>' + "初始状态" + '</font>';
			} else if (val == 2) {
				value = '<font color=darkslategray>' + "已下发" + '</font>';
			} else if (val == 3) {
				value = '<font color=red>' + "未审核" + '</font>';
			} else if (val == 4) {
				value = '<font color=blue>' + "已审核" + '</font>';
			} else if (val == 5) {
				value = '<font color=darkorchid>' + "已上报" + '</font>';
			} else {
				value = '<font color=orange>' + value + '</font>';
			}
			return value;
		},
		onConnLimit : function(val, params, record) {
			return '<a href = javascript:onConnLimit("' + val + '")>'
					+ '<center>' + '配置' + '</center>' + '</a>';
		},
		downLoad : function() {
			return '<a href = javascript:onDownLoadInfo()>' + '<center>' + '查看'
					+ '</center>' + '</a>';
		}
	});
	connServ = new ConnServGrid();
	connServ.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 10
				}
			});
});

function onConnLimit(val) {
	connServ.connLimitWindow.servLimitGrid.areaCombo.setValue("");
	connServCode = val;
	connServ.connLimitWindow.show();
	connServ.connLimitWindow.servLimitGrid.store.load({
		callback : function() {
			dwr.engine.setAsync(false);
			ConnServLimitDwr.findLimitSc('', connServCode, function(data) {
						var store = connServ.connLimitWindow.servLimitGrid
								.getStore();
						connServ.connLimitWindow.servLimitGrid
								.getSelectionModel().clearSelections();
						// connServ.connLimitWindow.servLimitGrid.sm.removeListener('rowselect',this.onCellClick,this)
						for (i = 0; i < data.length; i++) {
							index = store.indexOfId(data[i].connServManCode);
							if (index != -1) {
								record = store.getAt(index);
								record.set('connServLimitId',
										data[i].connServLimitId);
								record.set('businid', data[i].connServManCode);
								record
										.set('connServCode',
												data[i].connServCode);
							}
							connServ.connLimitWindow.servLimitGrid
									.getSelectionModel().selectRow(index, true);
						};
					});
			dwr.engine.setAsync(true);
		}
	});
}
function onDownLoadInfo() {
	record = connServ.getSelectionModel().getSelected();
	connServProcStatus = record.get('connServProcStatus');
	connServCode = record.get('connServCode');
	connRoutePlatCode = record.get('connRoutePlatCode');
	if (connServProcStatus != 4 && connServProcStatus != 2) {
		Ext.MessageBox
				.alert('系统提示', blankStr + '该互联服务未下发，无法查看下发信息!' + blankStr);
		return;
	} else {
		connServ.connServDownLoadWindow.show();
		connServ.connServDownLoadWindow.connSendInfoGrid.store.load({
					params : {
						'page.start' : 0,
						'page.PageSize' : 10,
						'connSendInfoDto.connFlag' : 2,
						'connSendInfoDto.connCode' : connServCode
					}
				});
	}
}