/**
 * 互联服务注册主页面
 * 
 * @class QueryForm
 * @extends Ext.ux.Form
 */
var areaUrl = "connSrpRegAction_queryArea.action";
var servUrl = "servAffordManRegAction_queryAllServInfo.action";
var ConnServRegTree_URL = "connServRegTreeAction_queryConnServTree.action";

var PAGESIZE = 10;
var connServ;
var currentConnRoutePlatCode;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var ConnServRegObj = {
	connServId : '',
	connServCode : '',
	connServName : '',
	connServType : '',
	areaCode : '',
	connRoutePlatCode : '',
	provideCode : '',
	connServInvokeMode : '',
	connServStatus : '',
	connServProcStatus : '',
	wsdlId : '',
	protocolId : '',
	delFlag : '',
	description : '',
	servDefineId : '',
	addServTime : '',
	updateServTime : '',
	firstUploadTime : '',
	lastUploadTime : '',
	downloadTime : ''
};
var url_Invoke_Mode = "servAffordManRegAction_queryInvokeMode.action";
var providerUrl = "connLimitScAction_queryConnMan.action";
var SERVTYPE_STORE_URL = 'register/servDefineAction_queryServType.action';
var SERVMANURL = 'register/getAllServMan_queryAllServManConn.action';
var SRP_CODE = "";

Ext
		.onReady(function() {
			Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});
			Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';
			Ext.QuickTips.init();

			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
			Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
			// 检查用户状态 是否session 超时
			function checkUserSessionStatus(conn, response, options) {
				var sessionStatus = response.getResponseHeader["sessionstatus"];

				if (typeof (sessionStatus) != "undefined") {
					Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
				}
			}
			;

			var loader = new Ext.tree.MyTreeLoader({
				dataUrl : ConnServRegTree_URL
			});
			loader.processResponse = function(response, node, callback) {
				var res = response.responseText;
				try {
					var json = eval("(" + res + ")");
					node.beginUpdate();
					var o = json["key"];
					for ( var i = 0, len = o.length; i < len; i++) {
						var n = this.createNode(o[i]);
						if (n) {
							node.appendChild(n);
						}
					}
					node.endUpdate();
					if (typeof callback == "function") {
						callback(this, node);
					}
				} catch (e) {
					this.handleFailure(response);
				}
			};
			/**
			 * 互联服务注册页面左边的树
			 */
			ConnServTree = Ext.extend(TreePanelFil, {
				constructor : function() {
					ConnServTree.superclass.constructor.call(this, {
						renderTo : 'connserv_tree',
						title : '互联服务',
						autoScroll : true,
						enableDD : false, // 是否支持拖拽效果
						containerScroll : true, // 是否支持滚动条
						width : Ext.getBody().getViewSize().width * 0.2,
						height : Ext.getBody().getViewSize().height - 5,
						frame : false,
						rootVisible : true, // 是否显示根节点
						baseCls : 'x-panel',
						margins : '0 0 0 0',
						loader : loader,
						root : new Ext.tree.AsyncTreeNode({
							// id : '1',
							text : '互联服务域',
							iconCls : 'fwroot',
							leaf : false,
							draggable : false
						})
					});
				}
			});
			var connServTree = new ConnServTree();
			connServTree.getRootNode().expand();

			connServTree.on('click', function(node, e) {
				var nodeId = node.id;
				currentConnRoutePlatCode = nodeId;
				var store = connServ.getStore();
				store.proxy = new Ext.data.HttpProxy({
					url : "Srp/connServRegAction_findConnServReg.action"
				});
				store.baseParams = {
					'connServRegDto.connRoutePlatCode' : nodeId
				};
				store.load({
					params : {
						'page.start' : 0,
						'page.pageSize' : PAGESIZE
					}
				});
				connServ.render();
			});

			ServForm = Ext.extend(Ext.ux.Form, {
				areaCombo : null,
				servManCombo : null,
				servCombo : null,
				servTypeCombo : null,
				servTye : null,
				constructor : function() {
					this.areaCombo = this.createCombo2("服务名称", "servName",
							"servId", "servName", "90%", servUrl,
							"servDtoList", "recordCount", true);
					this.areaCombo.initComponent = this
							.addBlankSelectForCombox(this.areaCombo);
					this.areaCombo.store.load();
					this.servTypeCombo = this.createCombo1("服务类型", 'servType',
							'businid', 'businname', '90%', SERVTYPE_STORE_URL,
							'items_SERVTYPE', 'results_SERVTYPE');
					this.servTypeCombo.initComponent = this
							.addBlankSelectForCombox(this.servTypeCombo);
					this.servTypeCombo.store.load();
					this.servManCombo = this.createCombo2(show_name,
							"servManName", "servManId", "servManName", "90%",
							SERVMANURL, "servManDtoList", "recordCount", true);
					this.servManCombo.initComponent = this
							.addBlankSelectForCombox(this.servManCombo);
					this.servManCombo.store.load();

					ServForm.superclass.constructor.call(this, {
						title : "服务查询",
						width : 700,
						height : 99,
						labelWidth : 80,
						region : "center",
						// applyTo:"queryform",
						bodyStyle : "padding: 5px 5px 0",
						items : [ {
							layout : "column",
							items : [ {
								layout : "form",
								items : this.servManCombo,
								columnWidth : .3333
							}, {
								layout : "form",
								items : this.areaCombo,
								columnWidth : .3333
							}, {
								layout : "form",
								items : this.servTypeCombo,
								columnWidth : .3333
							} ]
						} ],
						buttons : [ {
							text : '查询',
							id : 'query_connserv_btn',
							iconCls : 'find',
							width : 20,
							hidden : false,
							handler : this.queryFormClick,
							scope : this
						}, {
							text : '重置',
							id : 'resume_connserv_btn',
							width : 20,
							iconCls : 'resume',
							hidden : false,
							handler : this.onResumeClick,
							scope : this
						} ]

					});
				},
				queryFormClick : function() {
					servId = this.areaCombo.getValue();
					servType = this.servTypeCombo.getValue();
					servManId = this.servManCombo.getValue();
					if (servId != null && servId != "") {
						servId = parseInt(servId);
					}else{
						servId = 0;
					}
					if (servType != null && servType != "") {
						servType = parseInt(servType);
					}else{
						servType = 0;
					}
					if (servManId != null && servManId != "") {
						servManId = parseInt(servManId);
					}else{
						servManId = 0;
					}
					connServ.insertWindow.servGrid.store.baseParams = {
						'servId' : servId,
						'servManId' : servManId,
						'servType' : servType
					};
					connServ.insertWindow.servGrid.store.load({
						params : {
							'start' : 0,
							'limit' : 10
						}
					});
				},
				onResumeClick : function() {
					connServ.insertWindow.servForm.getForm().reset();
				},
				addBlankSelectForCombox : function(combo) {
					combo.on("select", function() {
						if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
							combo.setValue("");
						}
					});
					combo.store.on("datachanged", function(a) {
						var r = new Ext.data.Record({});
						r.set(combo.valueField, ''); // 添加一格值为-1的选项
						r.set(combo.displayField, combo.emptyText);
						a.insert(0, r);
					});
				}
			});
			/** ********************************域内服务列表***************************************************** */
			ServGrid = Ext
					.extend(
							Ext.grid.EditorGridPanel,
							{
								sm : null,
								servField : null,
								store : null,
								constructor : function() {

											this.store = new Ext.data.Store(
													{ // Grid Store
														proxy : new Ext.data.HttpProxy(
																{
																	url : "register/servDefineAction_queryServDefine.action",
																	method : 'POST'
																}),
														reader : new Ext.data.JsonReader(
																{
																	totalProperty : 'totalProperty',
																	root : 'servDefineDtoList'
																},
																[
																		{
																			name : 'servId'
																		},
																		{
																			name : 'servName'
																		},
																		{
																			name : 'servDefineId'
																		},
																		{
																			name : 'servType'
																		},
																		{
																			name : 'servTypeName'
																		},
																		{
																			name : 'servDesc'
																		},
																		{
																			name : 'servInvokeMode'
																		},
																		{
																			name : 'servManId'
																		},
																		{
																			name : 'versionNo'
																		},
																		{
																			name : 'versionState'
																		},
																		{
																			name : 'verStateName'
																		},
																		{
																			name : 'protocolName'
																		},
																		{
																			name : 'protocolId'
																		},
																		{
																			name : 'servCode'
																		},
																		{
																			name : 'servManCode'
																		},
																		{
																			name : 'wsdlId'
																		} ])
													}),
											this.sm = new Ext.grid.CheckboxSelectionModel(
													{
														singleSelect : true,
														header : '',
														handleMouseDown : Ext.emptyFn
													});
									this.sm.on("rowselect", this.rowselect,
											this);
									this.servField = new Ext.form.TextField({
										name : 'servCode',
										allowBlank : false
									});
									ServGrid.superclass.constructor
											.call(
													this,
													{
														// title:'服务定义',
														frame : false,
														width : 700,
														height : 295,
														title : '域内服务列表',
														clicksToEdit : 1,
														viewConfig : {
															forceFit : true
														},
														loadMask : {
															msg : '正在载入数据,请稍候...'
														},
														sm : this.sm,
														// cm: new
														// Ext.grid.ColumnModel([new
														// Ext.grid.RowNumberer(),
														cm : new Ext.grid.ColumnModel(
																[
																		new Ext.grid.RowNumberer(),
																		this.sm,
																		{
																			header : '服务id',
																			dataIndex : 'servId',
																			hidden : true
																		},
																		{
																			header : '服务名称',
																			dataIndex : 'servName',
																			sortable : true,
																			width : 50
																		},
																		{
																			header : '服务编码',
																			dataIndex : 'servCode',
																			sortable : true,
																			width : 100,
																			editor : this.servField
																		},
																		{
																			header : '服务版本',
																			dataIndex : 'versionNo',
																			sortable : true,
																			width : 40
																		},
																		{
																			header : '服务类型',
																			dataIndex : 'servTypeName',
																			sortable : true,
																			width : 50
																		},
																		{
																			header : '服务状态',
																			dataIndex : 'verStateName',
																			sortable : true,
																			hidden : false,
																			width : 40,
																			renderer : this.format2
																		} ]),
														bbar : new Ext.PagingToolbar(
																{
																	firstText : '第一页',
																	nextText : '下一页',
																	prevText : '上一页',
																	refreshText : '刷新',
																	lastText : '最后一页',
																	beforePageText : '当前',
																	afterPageText : '页/共{0}页',
																	pageSize : 10,
																	store : this.store,
																	displayInfo : true,
																	displayMsg : '本页显示 {0} - {1},共{2}条记录',
																	emptyMsg : "没有可显示的记录"
																}),
														ds : this.store,
														listeners : {}
													});
								},
								format2 : function(value) {
									if (value == "正常") {
										value = '<font color=blue>' + "正常"
												+ '</font>';
									} else if (value == "注销") {
										value = '<font color=red>' + "已注销"
												+ '</font>';
									}
									return value;
								},
								rowselect : function(grid, rowIndex, record1, e) {
									var record = record1;
									ConnServRegObj.connServId = '';
									ConnServRegObj.servDefineId = record
											.get('servDefineId');
									ConnServRegObj.areaCode = '';
									ConnServRegObj.connRoutePlatCode = '';
									ConnServRegObj.connServCode = '';
									var servCode = record.get('servCode');
									var that = this;
									/**
									 * 互联服务编码进行处理
									 */
									if (servCode == null || servCode == '') {
										Ext.MessageBox.alert("系统提示",
												"互联服务编码不可为空");
										return;
									}
									var end = servCode.lastIndexOf('.');
									var start = servCode.indexOf('.');
									if (start == -1) {
									} else if (start == end) {
									} else {
										servCode = servCode
												.substring(start + 1);
									}
									ConnServRegObj.connServInvokeMode = record
											.get('servInvokeMode');
									ConnServRegObj.connServName = record
											.get('servName');
									ConnServRegObj.connServProcStatus = 1;
									ConnServRegObj.connServStatus = record
											.get('versionState');
									ConnServRegObj.connServType = record
											.get('servType');
									ConnServRegObj.delFlag = 0;
									ConnServRegObj.description = record
											.get('servDesc');
									ConnServRegObj.protocolId = record
											.get('protocolId');
									ConnServRegObj.provideCode = '';
									ConnServRegObj.wsdlId = record
											.get('wsdlId');
									servManCode = record.get('servManCode');
									/**
									 * 区域编码从库中读取
									 */
									areaCode = "";
									connRoutePlatCode = "";
									// 互联服务商编码从库中读取
									connServManCode = "";
									Ext.MessageBox
											.confirm(
													"系统提示",
													"确认要添加该服务为互联服务吗?",
													function(btn) {
														if (btn == "yes") {
															ConnServRegDwr
																	.queryLocalAreaCode(function(
																			data) {
																		connRoutePlatCode = data;
																		if (connRoutePlatCode != "") {
																			index = connRoutePlatCode
																					.lastIndexOf('.');
																			areaCode = connRoutePlatCode
																					.substring(
																							0,
																							index);
																		}
																		ConnServRegDwr
																				.queryConnServManCode(
																						servManCode,
																						function(
																								data1) {
																							connServManCode = data1;
																							ConnServRegObj.areaCode = areaCode;
																							ConnServRegObj.connRoutePlatCode = connRoutePlatCode;
																							/**
																							 * 服务商编码转换信息如果找不到，则保留原服务商编码信息
																							 */
																							/**
																							 * 此处由于修改了服务商编码方式为标准形式，故互联服务编码规则进行更改为区域加服务商编码加服务编码
																							 */
																							if (connServManCode == "") {
																								ConnServRegObj.connServCode = areaCode
																										+ '.'
																										+ record
																												.get("servCode");

																							} else {
																								ConnServRegObj.connServCode = areaCode
																										+ '.'
																										+ connServManCode
																										+ '.'
																										+ servCode;
																							}
																							if (connServManCode == "") {
																								ConnServRegObj.provideCode = servManCode;
																							} else {
																								ConnServRegObj.provideCode = connServManCode;
																							}
																							ConnServRegDwr
																									.check(
																											null,
																											ConnServRegObj.connServCode,
																											function(
																													datax) {
																												if (datax == 'ok') {
																													ConnServRegDwr
																															.save(
																																	ConnServRegObj,
																																	function(
																																			data2) {
																																		if (data2 != null) {
																																			Ext.MessageBox
																																					.alert(
																																							"系统提示",
																																							blankStr
																																									+ "互联服务信息保存成功!"
																																									+ blankStr);
																																			connServ.insertWindow
																																					.hide();
																																			that.store
																																					.load({
																																						params : {
																																							'start' : 0,
																																							'limit' : 10
																																						}
																																					});
																																			connServ.store
																																					.load({
																																						params : {
																																							'page.start' : 0,
																																							'page.pageSize' : 10
																																						}
																																					});
																																		} else {
																																			Ext.MessageBox
																																					.alert(
																																							"系统提示",
																																							blankStr
																																									+ "互联服务信息保存失败!"
																																									+ blankStr);
																																		}
																																	});
																												} else {
																													ConnServRegObj.connServCode = ConnServRegObj.connServCode
																															+ "."
																															+ record
																																	.get("versionNo");
																													ConnServRegDwr
																															.save(
																																	ConnServRegObj,
																																	function(
																																			data3) {
																																		if (data3 != null) {
																																			Ext.MessageBox
																																					.alert(
																																							"系统提示",
																																							blankStr
																																									+ "互联服务信息保存成功!"
																																									+ blankStr);
																																			connServ.insertWindow
																																					.hide();
																																			that.store
																																					.load({
																																						params : {
																																							'start' : 0,
																																							'limit' : 10
																																						}
																																					});
																																			connServ.store
																																					.load({
																																						params : {
																																							'page.start' : 0,
																																							'page.pageSize' : 10
																																						}
																																					});
																																		} else {
																																			Ext.MessageBox
																																					.alert(
																																							"系统提示",
																																							blankStr
																																									+ "互联服务信息保存失败!"
																																									+ blankStr);
																																		}
																																	});
																												}
																											});
																						});
																	});
														} else {
															connServ.insertWindow.servGrid
																	.getSelectionModel()
																	.deselectRow(
																			rowIndex);
														}
													});
									// }
									// }
								}
							});
			/** ****************************互联服务添加窗口****************************************** */
			InsertDefineWindow = Ext.extend(Ext.Window, {

				servGrid : null,
				servForm : null,
				constructor : function() {
					this.servForm = new ServForm();
					this.servGrid = new ServGrid();
					InsertDefineWindow.superclass.constructor.call(this, {
						title : "互联服务添加窗口",
						width : 720,
						height : 430,
						resizable : false,
						plain : true,
						modal : true,
						autoScroll : true,
						closeAction : 'hide',
						items : [ this.servForm, this.servGrid ]
					});
				}
			});

			/** ********************************互联服务修改form表单************************************************* */
			ConnServForm = Ext
					.extend(
							Ext.ux.Form,
							{
								provideCode : null,
								srpCode : null,
								servCode : null,
								servName : null,
								areaCode : null,
								servId : null,
								servStatus : null,
								servInvokeMode : null,
								connServType : null,
								connServProcStatus : null,
								wsdlId : null,
								protocolId : null,
								delFlag : null,
								description : null,
								servDefineId : null,
								constructor : function() {
									this.provideCode = this
											.createTextField("系统编码",
													"provideCode", "90%",
													"text", 100, false, "",
													"超出最大长度100");
									this.provideCode.disabled = true;
									this.srpCode = this.createTextField(
											"服务平台编码", "connRoutePlatCode",
											"90%", "text", 100, false, "",
											"超出最大长度100");
									this.servCode = this
											.createTextField("服务编码",
													"connServCode", "90%",
													"text", 100, false, "",
													"超出最大长度100");
									// this.servCode.disabled = true;
									this.servName = this
											.createTextField("服务名称",
													"connServName", "90%",
													"text", 100, false, "",
													"超出最大长度100");
									this.areaCode = this.createTextField(
											"区域编码", "areaCode", "90%", "text",
											100, false, "", "超出最大长度100");
									this.servId = this.createHidden("互联服务Id",
											"connServId");
									that = this;
									josnData = [ {
										connServStatus : 1,
										servStatName : '已注册'
									}, {
										connServStatus : 2,
										servStatName : '已发布'
									}, {
										connServStatus : 3,
										servStatName : '已注销'
									} ];
									this.servStatus = this.createMemoryCombo(
											"服务状态", 'connServStatus',
											'servStatName', '90%', josnData);
									this.servStatus.store.load();
									this.servInvokeMode = this.createCombo2(
											"调用模式", "connServInvokeMode",
											"businid", "businname", "90%",
											url_Invoke_Mode, "invokeMode",
											"InvokeModeCount", true);
									;
									this.servInvokeMode.store.load();
									this.servInvokeMode.disabled = true;
									this.connServType = this.createHidden(
											"服务类型", "connServType");
									this.connServProcStatus = this
											.createHidden("服务流程状态",
													"connServProcStatus");
									this.wsdlId = this.createHidden("wsdlId",
											"wsdlId");
									this.protocolId = this.createHidden(
											"protocolId", "protocolId");
									this.delFlag = this.createHidden("delFlag",
											"delFlag");
									this.description = this.createTextField(
											"服务描述", "description", "90%",
											"text", 100, true, "", "超出最大长度100");
									this.servDefineId = this.createHidden(
											"servDefineId", "servDefineId");
									ConnServForm.superclass.constructor
											.call(
													this,
													{
														width : 330,
														height : 280,
														region : "center",
														labelWidth : 80,
														bodyStyle : "padding: 5px 5px 0",
														items : [
																this.provideCode,
																this.srpCode,
																this.servCode,
																this.servName,
																this.areaCode,
																this.servId,
																this.description,
																this.servStatus,
																this.servInvokeMode,
																this.connServType,
																this.connServProcStatus,
																this.wsdlId,
																this.protocolId,
																this.delFlag,
																this.servDefineId ],
														buttons : [
																{
																	text : '修改',
																	id : 'modify_srp_btn',
																	width : 20,
																	iconCls : 'update',
																	hidden : false,
																	handler : this.onModifyClick,
																	scope : this
																},
																{
																	text : '重置',
																	id : 'resume_srp_btn',
																	width : 20,
																	iconCls : 'resume',
																	hidden : false,
																	handler : this.onResumeClick,
																	scope : this
																} ]

													});
								},
								onModifyClick : function() {
									if (!this.getForm().isValid()) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请填写必填信息" + blankStr);
										return;
									} else {
										ConnServRegObj.areaCode = this.areaCode
												.getValue();
										ConnServRegObj.connRoutePlatCode = this.srpCode
												.getValue();
										ConnServRegObj.connServCode = this.servCode
												.getValue();
										ConnServRegObj.connServId = this.servId
												.getValue();
										ConnServRegObj.connServInvokeMode = this.servInvokeMode
												.getValue();
										ConnServRegObj.connServName = this.servName
												.getValue();
										ConnServRegObj.connServProcStatus = 1;
										ConnServRegObj.connServStatus = this.servStatus
												.getValue();
										ConnServRegObj.connServType = this.connServType
												.getValue();
										ConnServRegObj.delFlag = this.delFlag
												.getValue();
										ConnServRegObj.description = this.description
												.getValue();
										ConnServRegObj.protocolId = this.protocolId
												.getValue();
										ConnServRegObj.provideCode = this.provideCode
												.getValue();
										ConnServRegObj.servDefineId = this.servDefineId
												.getValue();
										ConnServRegObj.wsdlId = this.wsdlId
												.getValue();
										ConnServRegDwr
												.check(
														ConnServRegObj.connServId,
														ConnServRegObj.connServCode,
														function(datax) {
															if (datax == 'ok') {
																ConnServRegDwr
																		.update(
																				ConnServRegObj,
																				function(
																						data) {
																					if (data) {
																						Ext.MessageBox
																								.alert(
																										"系统提示",
																										blankStr
																												+ "信息修改成功!"
																												+ blankStr);
																						connServ.updateWindow
																								.hide();
																						connServ.store
																								.load({
																									params : {
																										'page.start' : 0,
																										'page.pageSize' : 10
																									}
																								});
																					} else {
																						Ext.MessageBox
																								.alert(
																										"系统提示",
																										blankStr
																												+ "信息修改失败!"
																												+ blankStr);
																					}
																				});
															} else {
																Ext.MessageBox
																		.alert(
																				"系统提示",
																				blankStr
																						+ datax
																						+ blankStr);
															}
														});
									}
								},
								onResumeClick : function() {
									record = connServ.getSelectionModel()
											.getSelected();
									if (record == null) {
										this.getForm().reset();
									} else {
										this.getForm().loadRecord(record);
									}
								},
								createTextField : function(fieldLabel, name,
										anchor, inputType, maxLength,
										allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
									var tf = new Ext.form.TextField({
										fieldLabel : fieldLabel,
										name : name,
										xtype : 'textfield',
										readOnly : false,
										allowBlank : allowBlank,
										anchor : anchor,
										blankText : '该选项为必填项,请输入内容...',
										vtype : vtype,
										inputType : inputType,
										maxLength : maxLength,
										maxLengthText : maxLengthText
									});
									return tf;
								}
							});
			/** *****************************互联服务修改窗口**************************************** */
			UpdateConnServWindow = Ext.extend(Ext.Window, {
				connServForm : null,
				constructor : function() {

					this.connServForm = new ConnServForm();
					UpdateConnServWindow.superclass.constructor.call(this, {
						title : "互联服务修改窗口",
						width : 350,
						height : 320,
						resizable : false,
						plain : true,
						modal : true,
						autoScroll : true,
						closeAction : 'hide',
						items : [ this.connServForm ]
					});
				}
			});
			/**
			 * 互联权限展现列表
			 */
			ConnLimitGrid = Ext
					.extend(
							UxGrid,
							{
								store : null,
								sm : null,
								constructor : function() {

											this.store = new Ext.data.Store(
													{ // Grid Store
														proxy : new Ext.data.HttpProxy(
																{
																	url : "Scp/connLimitAction_QueryConnServLimit.action",
																	method : 'POST'
																}),
														reader : new Ext.data.JsonReader(
																{
																	totalProperty : '1',
																	id : "connServLimitId",
																	root : 'limit'
																},
																[
																		{
																			name : 'connServLimitId'
																		},
																		{
																			name : 'connServCode'
																		},
																		{
																			name : 'connServManCode'
																		},
																		{
																			name : 'businid'
																		},
																		{
																			name : 'delFlag'
																		},
																		{
																			name : 'businname'
																		},
																		{
																			name : 'connServName'
																		},
																		{
																			name : 'areaCode'
																		} ])
													}),
											this.sm = new Ext.grid.CheckboxSelectionModel(
													{
														singleSelect : false,
														handleMouseDown : Ext.emptyFn
													});
									ConnLimitGrid.superclass.constructor
											.call(
													this,
													{
														// title:'互联服务权限列表',
														frame : false,
														width : 660,
														region : "center",
														height : 390,
														viewConfig : {
															forceFit : true
														},
														loadMask : {
															msg : '正在载入数据,请稍候...'
														},
														cm : new Ext.grid.ColumnModel(
																[
																		new Ext.grid.RowNumberer(),
																		{
																			header : '服务权限id',
																			dataIndex : 'connServLimitId',
																			hidden : true
																		},
																		{
																			header : '互联服务名称',
																			dataIndex : 'connServName',
																			sortable : true,
																			width : 100,
																			hidden : true
																		},
																		{
																			header : '互联服务编码',
																			dataIndex : 'connServCode',
																			sortable : true,
																			hidden : false,
																			width : 100
																		},
																		{
																			header : '服务商编码',
																			dataIndex : 'connServManCode',
																			sortable : true,
																			hidden : false
																		} ]),
														ds : this.store,
														listeners : {}
													});
								}
							});
			/**
			 * 互联权限展示窗口
			 */
			ConnServLimitWindow = Ext.extend(Ext.Window, {
				connServGrid : null,
				constructor : function() {

					this.connServGrid = new ConnLimitGrid();
					UpdateConnServWindow.superclass.constructor.call(this, {
						title : "互联服务权限",
						width : 680,
						height : 430,
						resizable : false,
						plain : true,
						modal : true,
						autoScroll : true,
						closeAction : 'hide',
						items : [ this.connServGrid ]
					});
				}
			});
			ServDefineGrid = Ext
					.extend(
							UxGrid,
							{
								store : null,
								constructor : function() {

											this.store = new Ext.data.Store(
													{ // Grid Store
														proxy : new Ext.data.HttpProxy(
																{
																	url : "register/servDefineAction_queryServDefineByConnServId.action",
																	method : 'POST'
																}),
														reader : new Ext.data.JsonReader(
																{
																	root : 'servList'
																},
																[
																		{
																			name : 'servId'
																		},
																		{
																			name : 'servName'
																		},
																		{
																			name : 'servDefineId'
																		},
																		{
																			name : 'servType'
																		},
																		{
																			name : 'servTypeName'
																		},
																		{
																			name : 'servDesc'
																		},
																		{
																			name : 'servInvokeMode'
																		},
																		{
																			name : 'servManId'
																		},
																		{
																			name : 'versionNo'
																		},
																		{
																			name : 'versionState'
																		},
																		{
																			name : 'verStateName'
																		},
																		{
																			name : 'protocolName'
																		},
																		{
																			name : 'protocolId'
																		},
																		{
																			name : 'servCode'
																		},
																		{
																			name : 'servManCode'
																		},
																		{
																			name : 'wsdlId'
																		} ])
													}),
											ServDefineGrid.superclass.constructor
													.call(
															this,
															{
																frame : false,
																width : 720,
																height : 160,
																title : '相关标准服务信息',
																viewConfig : {
																	forceFit : true
																},
																loadMask : {
																	msg : '正在载入数据,请稍候...'
																},
																cm : new Ext.grid.ColumnModel(
																		[
																				{
																					header : '服务id',
																					dataIndex : 'servId',
																					hidden : true
																				},
																				{
																					header : '服务名称',
																					dataIndex : 'servName',
																					sortable : true,
																					width : 50
																				},
																				{
																					header : '服务编码',
																					dataIndex : 'servCode',
																					sortable : true,
																					width : 100,
																					editor : this.servField
																				},
																				{
																					header : '服务版本',
																					dataIndex : 'versionNo',
																					sortable : true,
																					width : 40
																				},
																				{
																					header : '服务类型',
																					dataIndex : 'servTypeName',
																					sortable : true,
																					width : 50
																				},
																				{
																					header : '服务状态',
																					dataIndex : 'verStateName',
																					sortable : true,
																					hidden : false,
																					width : 40,
																					renderer : this.format2
																				} ])
															});
								}
							});
			ServDefineWindow = Ext.extend(Ext.Window, {
				connServGrid : null,
				constructor : function() {

					this.servDefineGrid = new ServDefineGrid();
					ServDefineWindow.superclass.constructor.call(this, {
						title : "相关标准服务信息",
						width : 750,
						height : 200,
						resizable : false,
						plain : true,
						modal : true,
						autoScroll : true,
						closeAction : 'hide',
						items : [ this.servDefineGrid ]
					});
				}
			});

			ConnServGrid = Ext
					.extend(
							UxGrid,
							{
								insertWindow : null,
								updateWindow : null,
								limitWindow : null,
								servDefineWindow : null,
								store : null,
								constructor : function() {

											this.store = new Ext.data.Store(
													{ // Grid Store
														proxy : new Ext.data.HttpProxy(
																{
																	method : 'POST'
																}),
														reader : new Ext.data.JsonReader(
																{
																	totalProperty : 'page.totalCount',
																	root : 'page.result'
																},
																[
																		{
																			name : 'connServId'
																		},
																		{
																			name : 'connServCode'
																		},
																		{
																			name : 'connServName'
																		},
																		{
																			name : 'connServType'
																		},
																		{
																			name : 'areaCode'
																		},
																		{
																			name : 'areaName'
																		},
																		{
																			name : 'connRoutePlatCode'
																		},
																		{
																			name : 'provideCode'
																		},
																		{
																			name : 'connServInvokeMode'
																		},
																		{
																			name : 'connServStatus'
																		},
																		{
																			name : 'connServProcStatus'
																		},
																		{
																			name : 'wsdlId'
																		},
																		{
																			name : 'protocolId'
																		},
																		{
																			name : 'delFlag'
																		},
																		{
																			name : 'description'
																		},
																		{
																			name : 'servDefineId'
																		},
																		{
																			name : 'addServTime'
																		},
																		{
																			name : 'updateServTime'
																		},
																		{
																			name : 'firstUploadTime'
																		},
																		{
																			name : 'lastUploadTime'
																		},
																		{
																			name : 'downloadTime'
																		} ])
													}),
											this.insertWindow = new InsertDefineWindow();
									this.updateWindow = new UpdateConnServWindow();
									this.limitWindow = new ConnServLimitWindow();
									this.servDefineWindow = new ServDefineWindow();

									ConnServGrid.superclass.constructor
											.call(
													this,
													{
														title : '互联服务列表',
														frame : true,
														width : Ext.getBody()
																.getViewSize().width * 0.8,
														height : Ext.getBody()
																.getViewSize().height - 10,
														renderTo : "grid-div",
														region : "center",
														viewConfig : {
															forceFit : true
														},
														loadMask : {
															msg : '正在载入数据,请稍候...'
														},
														sm : new Ext.grid.RowSelectionModel(
																{
																	singleSelect : true
																}),
														cm : new Ext.grid.ColumnModel(
																[
																		new Ext.grid.RowNumberer(),
																		{
																			header : '服务id',
																			dataIndex : 'connServId',
																			hidden : true
																		},
																		{
																			header : '互联服务名称',
																			dataIndex : 'connServName',
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '互联服务编码',
																			dataIndex : 'connServCode',
																			sortable : true,
																			hidden : false,
																			width : 140
																		},
																		{
																			header : show_name
																					+ '编码',
																			dataIndex : 'provideCode',
																			sortable : true,
																			hidden : true
																		},
																		{
																			header : '区域名称',
																			dataIndex : 'areaName',
																			sortable : true,
																			width : 130
																		},
																		{
																			header : '所属服务平台编码',
																			dataIndex : 'connRoutePlatCode',
																			hidden : true,
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '互联服务描述',
																			dataIndex : 'description',
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '互联服务状态',
																			dataIndex : 'connServStatus',
																			hidden : false,
																			renderer : this.format,
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '互联流程状态',
																			dataIndex : 'connServProcStatus',
																			hidden : false,
																			sortable : true,
																			width : 100,
																			renderer : this.format1
																		},
																		{
																			header : '是否本平台服务',
																			dataIndex : 'connRoutePlatCode',
																			sortable : true,
																			width : 100,
																			renderer : this.juge
																		},
																		{
																			header : '注册时间',
																			dataIndex : 'addServTime',
																			hidden : true,
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '更新时间',
																			dataIndex : 'updateServTime',
																			hidden : true,
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '第一次上报时间',
																			dataIndex : 'firstUploadTime',
																			hidden : true,
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '最后一次上报时间',
																			dataIndex : 'lastUploadTime',
																			hidden : true,
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '下发时间',
																			dataIndex : 'downloadTime',
																			hidden : true,
																			sortable : true,
																			width : 100
																		},
																		{
																			header : '互联权限查看',
																			dataIndex : 'connServCode',
																			sortable : true,
																			width : 100,
																			renderer : this.limitDisplay
																		},
																		{
																			header : '相关标准服务查看',
																			dataIndex : 'connServId',
																			sortable : true,
																			width : 100,
																			renderer : this.servDefine
																		} ]),
														tbar : [
																'服务名称或编码:',
																{
																	xtype : 'textfield',
																	width : 300,
																	id : 'byNameORNTf'
																},
																'-',
																{
																	text : '查询',
																	iconCls : 'find',
																	handler : this.filterByName,
																	scope : this
																},
																'-',
																{
																	text : '重置',
																	iconCls : 'resume',
																	handler : this.resumeClick,
																	scope : this
																} ],
														bbar : new Ext.PagingToolbar(
																{
																	firstText : '第一页',
																	nextText : '下一页',
																	prevText : '上一页',
																	refreshText : '刷新',
																	lastText : '最后一页',
																	beforePageText : '当前',
																	afterPageText : '页/共{0}页',
																	pageSize : 10,
																	paramNames : {
																		start : 'page.start',
																		limit : 'page.pageSize'
																	},
																	store : this.store,
																	displayInfo : true,
																	displayMsg : '本页显示 {0} - {1},共{2}条记录',
																	emptyMsg : "没有可显示的记录",
																	items : [
																			'-',
																			{
																				text : '添加',
																				id : 'bbar_newServDefine',
																				iconCls : 'new',
																				handler : this.onAddClick,
																				scope : this
																			},
																			'-',
																			{
																				text : '修改',
																				id : 'bbar_updateServDefine',
																				iconCls : 'update',
																				handler : this.onModifyClick,
																				scope : this
																			},
																			'-',
																			{
																				text : '删除',
																				id : 'bbar_deleteServDefine',
																				iconCls : 'delete',
																				handler : this.onDeleteClick,
																				scope : this
																			},
																			'-',
																			{
																				text : '上报',
																				id : 'bbar_deleteServDefine',
																				iconCls : 'submit',
																				handler : this.onUpLoadClick,
																				scope : this
																			},
																			'-',
																			{
																				text : '审核',
																				id : 'bbar_deleteServDefine',
																				iconCls : 'excelx',
																				handler : this.onCheckClick,
																				scope : this
																			} ]
																}),
														ds : this.store,
														listeners : {
															"rowcontextmenu" : {
																fn : this.onRightMenuClick,
																scope : this
															},
															"dblclick" : {
																fn : this.onDblClick,
																scope : this
															}
														}

													});
									Ext.getCmp('byNameORNTf').addListener(
											'specialkey', this.enterKeyEnter,
											this);
								},
								enterKeyEnter : function(textfield, e) {
									if (e.getKey() == Ext.EventObject.ENTER) {
										this.filterByName();
									}
								},
								filterByName : function() {
									var selNode = connServTree
											.getSelectionModel()
											.getSelectedNode();
									if (selNode == null) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '请先在页面左侧选择所在服务域或根节点!'
												+ blankStr);
										return;
									}
									var parNode = selNode.id.indexOf("node") != -1 ? ""
											: selNode.id;
									var servName = Ext.getCmp('byNameORNTf')
											.getValue();
									var store = connServ.getStore();
									store.proxy = new Ext.data.HttpProxy(
											{
												url : "Srp/connServRegAction_findConnServReg.action"
											});
									store.baseParams = {
										'connServRegDto.connServCode' : servName,
										'connServRegDto.connRoutePlatCode' : parNode
									};
									store.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : PAGESIZE
										}
									});
									connServ.render();
								},
								resumeClick : function() {
									Ext.getCmp('byNameORNTf').setValue("");
								},
								onAddClick : function() {
									if (!currentConnRoutePlatCode) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '请先在页面左侧选择所在服务域!' + blankStr);
										return;
									}
									if (currentConnRoutePlatCode != SRP_CODE) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '只能添加本平台服务域信息!' + blankStr);
										return;
									}

									this.insertWindow.show();
									this.insertWindow.servForm.getForm()
											.reset();
									this.insertWindow.servGrid.store.baseParams = {
										'servId' : 0,
										'servManId' : 0,
										'servType' : 0
									};
									this.insertWindow.servGrid.store.load({
										params : {
											'start' : 0,
											'limit' : 10
										}
									});
								},
								onModifyClick : function() {
									if (!currentConnRoutePlatCode) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '请先在页面左侧选择所在服务域!' + blankStr);
										return;
									}
									if (currentConnRoutePlatCode != SRP_CODE) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '只能修改本平台服务域信息!' + blankStr);
										return;
									}

									record = connServ.getSelectionModel()
											.getSelected();
									if (record == null) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请选择一条记录!" + blankStr);
										return;
									}
									connServProcStatus = record
											.get('connServProcStatus');
									this.updateWindow.show();
									if (connServProcStatus != 1)
										this.updateWindow.connServForm.servCode
												.setDisabled(true);
									else
										this.updateWindow.connServForm.servCode
												.setDisabled(false);
									this.updateWindow.connServForm.getForm()
											.loadRecord(record);
								},
								onDeleteClick : function() {
									if (!currentConnRoutePlatCode) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '请先在页面左侧选择所在服务域!' + blankStr);
										return;
									}
									if (currentConnRoutePlatCode != SRP_CODE) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '只能删除本平台服务域信息!' + blankStr);
										return;
									}

									record = this.getSelectionModel()
											.getSelected();
									if (record == null) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请选择一条记录!" + blankStr);
										return;
									}
									ConnServRegObj.areaCode = record
											.get('areaCode');
									ConnServRegObj.connRoutePlatCode = record
											.get('connRoutePlatCode');
									ConnServRegObj.connServCode = record
											.get('connServCode');
									ConnServRegObj.connServId = record
											.get('connServId');
									ConnServRegObj.connServInvokeMode = record
											.get('connServInvokeMode');
									ConnServRegObj.connServName = record
											.get('connServName');
									ConnServRegObj.connServProcStatus = record
											.get('connServProcStatus');
									ConnServRegObj.connServStatus = record
											.get('connServStatus');
									ConnServRegObj.connServType = record
											.get('connServType');
									ConnServRegObj.delFlag = record
											.get('delFlag');
									ConnServRegObj.wsdlId = record
											.get('wsdlId');
									ConnServRegObj.servDefineId = record
											.get('servDefineId');
									ConnServRegObj.provideCode = record
											.get('provideCode');
									ConnServRegObj.protocolId = record
											.get('protocolId');
									ConnServRegObj.description = record
											.get('description');
									Ext.MessageBox
											.confirm(
													"系统提示",
													"确定要删除该互联服务吗?",
													function(btn) {
														if (btn == "yes") {
															ConnServRegDwr
																	.remove(
																			ConnServRegObj,
																			function(
																					data) {
																				if (data.optFlag) {
																					Ext.MessageBox
																							.alert(
																									"系统提示",
																									blankStr
																											+ data.msg
																											+ blankStr);
																					connServ.store
																							.load({
																								params : {
																									'page.start' : 0,
																									'page.pageSize' : 10
																								}
																							});
																				} else {
																					Ext.MessageBox
																							.alert(
																									"系统提示",
																									blankStr
																											+ data.msg
																											+ blankStr);
																				}
																			});
														}
													});
								},
								onUpLoadClick : function() {
									if (!currentConnRoutePlatCode) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '请先在页面左侧选择所在服务域!' + blankStr);
										return;
									}
									if (currentConnRoutePlatCode != SRP_CODE) {
										Ext.MessageBox.alert('系统提示', blankStr
												+ '只能审核本平台服务域信息!' + blankStr);
										return;
									}

									record = this.getSelectionModel()
											.getSelected();
									if (record == null) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请选择一条记录!" + blankStr);
										return;
									}
									ConnServRegObj.areaCode = record
											.get('areaCode');
									ConnServRegObj.connRoutePlatCode = record
											.get('connRoutePlatCode');
									ConnServRegObj.connServCode = record
											.get('connServCode');
									ConnServRegObj.connServId = record
											.get('connServId');
									ConnServRegObj.connServInvokeMode = record
											.get('connServInvokeMode');
									ConnServRegObj.connServName = record
											.get('connServName');
									ConnServRegObj.connServProcStatus = record
											.get('connServProcStatus');
									ConnServRegObj.connServStatus = record
											.get('connServStatus');
									ConnServRegObj.connServType = record
											.get('connServType');
									ConnServRegObj.delFlag = record
											.get('delFlag');
									ConnServRegObj.wsdlId = record
											.get('wsdlId');
									ConnServRegObj.servDefineId = record
											.get('servDefineId');
									ConnServRegObj.provideCode = record
											.get('provideCode');
									ConnServRegObj.protocolId = record
											.get('protocolId');
									ConnServRegObj.description = record
											.get('description');
									ConnServRegDwr
											.queryLocalAreaCode(function(data) {
												if (ConnServRegObj.connRoutePlatCode != data) {
													Ext.MessageBox
															.alert(
																	"系统提示",
																	blankStr
																			+ "只能上传本系统互联服务信息!"
																			+ blankStr);
													return;
												}
												if (ConnServRegObj.connServProcStatus == 5) {
													Ext.MessageBox
															.alert(
																	"系统提示",
																	blankStr
																			+ "该互联服务信息已上报!"
																			+ blankStr);
													return;
												}
												ConnServRegDwr
														.upLoad(
																ConnServRegObj,
																function(data) {
																	if (data.optFlag) {
																		Ext.MessageBox
																				.alert(
																						data.title,
																						blankStr
																								+ data.msg
																								+ blankStr);
																	} else {
																		Ext.MessageBox
																				.alert(
																						data.title,
																						blankStr
																								+ data.msg
																								+ blankStr);
																	}
																});
											});
								},
								onCheckClick : function() {
									that = this;
									record = this.getSelectionModel()
											.getSelected();
									if (record == null) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请选择一条记录!" + blankStr);
										return;
									}
									connServId = record.get('connServId');
									ConnServRegObj.areaCode = record
											.get('areaCode');
									ConnServRegObj.connRoutePlatCode = record
											.get('connRoutePlatCode');
									ConnServRegObj.connServCode = record
											.get('connServCode');
									ConnServRegObj.connServId = record
											.get('connServId');
									ConnServRegObj.connServInvokeMode = record
											.get('connServInvokeMode');
									ConnServRegObj.connServName = record
											.get('connServName');
									ConnServRegObj.connServProcStatus = record
											.get('connServProcStatus');
									if (ConnServRegObj.connServProcStatus != 3) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "仅在未审核状态下才能审核!" + blankStr);
										return;
									}
									ConnServRegObj.connServStatus = record
											.get('connServStatus');
									ConnServRegObj.connServType = record
											.get('connServType');
									ConnServRegObj.delFlag = record
											.get('delFlag');
									ConnServRegObj.description = record
											.get('description');
									ConnServRegObj.protocolId = record
											.get('protocolId');
									ConnServRegObj.provideCode = record
											.get('provideCode');
									ConnServRegObj.servDefineId = record
											.get('servDefineId');
									ConnServRegObj.wsdlId = record
											.get('wsdlId');
									ConnServRegDwr
											.synMemory(
													ConnServRegObj,
													function(data) {
														if (data.optFlag) {
															Ext.MessageBox
																	.alert(
																			data.title,
																			blankStr
																					+ data.msg
																					+ blankStr,
																			function(
																					btn) {
																				if (btn == "ok") {
																					that.store
																							.load({
																								params : {
																									'page.start' : 0,
																									'page.pageSize' : 10
																								}
																							});
																				}
																			});
														} else {
															Ext.MessageBox
																	.alert(
																			data.title,
																			blankStr
																					+ data.msg
																					+ blankStr);
														}
													});
								},
								onDblClick : function(e) {

									record = this.getSelectionModel()
											.getSelected();
									if (record == null) {
										Ext.MessageBox.alert("系统提示", blankStr
												+ "请选择一条记录!" + blankStr);
										return;
									}
									this.updateWindow.show();
									connServProcStatus = record
											.get('connServProcStatus');
									if (connServProcStatus != 1)
										this.updateWindow.connServForm.servCode
												.setDisabled(true);
									else
										this.updateWindow.connServForm.servCode
												.setDisabled(false);
									this.updateWindow.connServForm.getForm()
											.loadRecord(record);
								},
								format : function(val) {
									value = "";
									if (val == 1) {
										value = '<font color=green>' + "已注册"
												+ '</font>';
									} else if (val == 2) {
										value = '<font color=blue>' + "已发布"
												+ '</font>';
									} else if (val == 3) {
										value = '<font color=red>' + "已注销"
												+ '</font>';
									} else {
										value = '<font color=orange>' + "其他"
												+ '</font>';
									}
									return value;
								},
								format1 : function(val) {
									value = "";
									if (val == 1) {
										value = '<font color=green>' + "初始状态"
												+ '</font>';
									} else if (val == 2) {
										value = '<font color=purle>' + "已下发"
												+ '</font>';
									} else if (val == 3) {
										value = '<font color=red>' + "未审核"
												+ '</font>';
									} else if (val == 4) {
										value = '<font color=blue>' + "已审核"
												+ '</font>';
									} else if (val == 5) {
										value = '<font color=darkviolet>'
												+ "已上报" + '</font>';
									}
									return value;
								},
								juge : function(val) {
									if (val == SRP_CODE) {
										return '是';
									} else {
										return '否';
									}
								},
								limitDisplay : function(val) {
									return '<a href=javascript:connLimitDisplay()>'
											+ '查看' + '</a>';
								},
								servDefine : function(val) {
									return '<a href=javascript:servDefineDisplay()>'
											+ '查看' + '</a>';
								}
							});
			connServ = new ConnServGrid();
			connServ.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 10
				}
			});
			ConnServRegDwr.queryLocalAreaCode(function(data) {
				SRP_CODE = data;
			});
		});
function connLimitDisplay() {
	record = connServ.getSelectionModel().getSelected();
	connServCode = record.get('connServCode');
	connServ.limitWindow.show();
	connServ.limitWindow.connServGrid.store.load({
		params : {
			'connServCode' : connServCode
		}
	});
}
function servDefineDisplay() {
	record = connServ.getSelectionModel().getSelected();
	connServId = record.get('connServId');
	connRoutePlatCode = record.get('connRoutePlatCode');
	ConnServRegDwr.queryLocalAreaCode(function(data) {
		if (connRoutePlatCode != data) {
			Ext.MessageBox.alert("系统提示", blankStr + "只能查看与本平台互联服务相关的标准服务!"
					+ blankStr);
			return;
		}
		connServ.servDefineWindow.show();
		connServ.servDefineWindow.servDefineGrid.store.load({
			params : {
				'connServId' : connServId
			}

		});
	});

}
