/**
 * 互联服务域注册主页面
 * 
 * @class EditForm
 * @extends Ext.ux.Form
 */
var connSrpSC;
var editForm;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var ConnSrpRegScObj = {
	connRoutePlatId : "",
	connRoutePlatCode : "",
	connRoutePlatName : "",
	connRoutePlatArea : "",
	connRoutePlatUrl : "",
	srpDynamicStatus : "",
	srpStaticStatus : "",
	delFlag : ""
};
var areaUrl = "connSrpRegAction_queryArea.action";
var srpStaticUrl = "connSrpRegAction_queryStaticStatus.action";
var srpDynUrl = "connSrpRegAction_queryDynStatus.action";
Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}

	EditForm = Ext.extend(Ext.ux.Form, {
		areaCombo : null,
		aipName : null,
		aipCode : null,
		aipAddress : null,
		aipId : null,
		aipDynamicStatus : null,
		aipStaticStatus : null,
		aipDelFlag : null,
		constructor : function() {
			this.areaCombo = this.createCombo2("区域名称", "connRoutePlatArea",
					"businid", "businname", "90%", areaUrl, "areaList",
					"areaCount", false);
			this.areaCombo.initComponent = this
					.addBlankSelectForCombox(this.areaCombo);
			this.areaCombo.store.load();
			this.aipAddress = this.createTextField("平台地址", "connRoutePlatUrl",
					"90%", "text", 100, false, "", "超出最大长度100");
			this.aipName = this.createTextField("平台名称", "connRoutePlatName",
					"90%", "text", 100, false, "", "超出最大长度100");
			this.aipCode = this.createTextField("平台编码", "connRoutePlatCode",
					"90%", "text", 100, false, "", "超出最大长度100");
			this.aipId = this.createHidden("平台Id", "connRoutePlatId");
			that = this;
			this.aipDynamicStatus = this.createCombo2("平台运行状态",
					"srpDynamicStatus", "businid", "businname", "90%",
					srpDynUrl, "srpDynStatus", "srpDynCount", true);
			this.aipDynamicStatus.initComponent = this
					.addBlankSelectForCombox(this.aipDynamicStatus);
			this.aipDynamicStatus.disabled = true, this.aipDynamicStatus.store
					.load({
								callback : function() {
									that.aipDynamicStatus.setValue(1)
								}
							});
			this.aipStaticStatus = this.createCombo2("平台静态状态",
					"srpStaticStatus", "businid", "businname", "90%",
					srpStaticUrl, "srpStaticStatus", "srpStaticCount", true);
			this.aipStaticStatus.initComponent = this
					.addBlankSelectForCombox(this.aipStaticStatus);
			this.aipStaticStatus.disabled = true;
			this.aipStaticStatus.store.load({
						callback : function() {
							that.aipStaticStatus.setValue(1);
						}
					});
			this.aipDelFlag = this.createHidden("平台删除标志", "delFlag");
			EditForm.superclass.constructor.call(this, {
						title : "互联服务域编辑",
						width : Ext.getBody().getViewSize().width - 5,
						height : Ext.getBody().getViewSize().height * 0.33,
						region : "center",
						applyTo : "queryform",
						bodyStyle : "padding: 5px 5px 0",
						labelAlign : "right",
						items : [{
									layout : "column",
									items : [{
												layout : "form",
												items : this.aipName,
												columnWidth : .3333
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.aipCode
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.areaCombo
											}, {
												layout : "form",
												items : this.aipAddress,
												columnWidth : .3333
											}, {
												layout : "form",
												items : this.aipDynamicStatus,
												columnWidth : .3333
											}, {
												layout : "form",
												items : this.aipStaticStatus,
												columnWidth : .3333
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.aipDelFlag
											}, {
												layout : "form",
												items : this.aipId,
												columnWidth : .3333
											}]
								}],
						buttons : [{
									text : '修改',
									id : 'modify_srp_btn',
									width : 20,
									iconCls : 'update',
									hidden : false,
									handler : this.onModifyClick,
									scope : this
								}, {
									text : '重置',
									id : 'resume_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : false,
									handler : this.onResumeClick,
									scope : this
								},{
									text : '下发',
									id : 'newUpLoad_srp_btn',
									width : 20,
									iconCls : 'submit',
									hidden : false,
									handler : this.onNewDownLoad,
									scope : this
								},{
									text : '同步SRC数据',
									id : 'syn_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : true,
									handler : this.onSynClick,
									scope : this
								}]

					})
		},
		onModifyClick : function() {
			if (!this.getForm().isValid()) {
				Ext.MessageBox.alert("系统提示", blankStr + "请填写必填信息" + blankStr);
				return;
			} else {
				ConnSrpRegScObj.connRoutePlatId = this.aipId.getValue();
				ConnSrpRegScObj.connRoutePlatArea = this.areaCombo.getValue();
				ConnSrpRegScObj.connRoutePlatCode = this.aipCode.getValue();
				ConnSrpRegScObj.connRoutePlatName = this.aipName.getValue();
				ConnSrpRegScObj.connRoutePlatUrl = this.aipAddress.getValue();
				ConnSrpRegScObj.delFlag = this.aipDelFlag.getValue();
				ConnSrpRegScObj.srpDynamicStatus = this.aipDynamicStatus
						.getValue();
				ConnSrpRegScObj.srpStaticStatus = this.aipStaticStatus
						.getValue();
				ConnSrpRegSCDwr.update(ConnSrpRegScObj, function(data) {
					if (data) {
						Ext.MessageBox.alert("系统提示", blankStr + "信息修改成功!"
										+ blankStr);
						editForm.getForm().reset();
						document.getElementById("modify_srp_btn").disabled = true;
						connSrpSC.store.load({
									params : {
										'page.start' : 0,
										'page.pageSize' : 10
									}
								});
					} else {
						Ext.MessageBox.alert("系统提示", blankStr + "信息修改失败!"
										+ blankStr);
					}
				});
			}
		},
		onResumeClick : function() {
			record = connSrpSC.getSelectionModel().getSelected();
			if (record == null) {
				editForm.getForm().reset();
				this.aipDynamicStatus.setValue(1);
				this.aipStaticStatus.setValue(1);
			} else {
				editForm.getForm().loadRecord(record);
			}
		},
		onDownLoad : function() {
			record = connSrpSC.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert("系统提示", blankStr + "请从服务域信息列表中选择一个平台进行下发!"
								+ blankStr);
				return;
			}
			connRoutePlatId = record.get('connRoutePlatId');
			connRoutePlatUrl = record.get('connRoutePlatUrl');
			// this.useLoadingMessage(false);
			ConnSrpRegSCDwr.downLoad(connRoutePlatId, connRoutePlatUrl,
					function(data) {
						if (data.optFlag) {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
							connSrpSC.store.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : 10
										}
									});
						} else {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
							// connSrpSC.store.load({params:{'page.start':0,'page.pageSize':10}});
						}
					});
					
		},
		// 下发方法
		onNewDownLoad : function() {
				connSrpSC.connDownLoadWindow.show();
				connSrpSC.connDownLoadWindow.connSrpIntefacesGrid.store.load({
							params : {
								'page.start' : 0,
								'page.PageSize' : 10
							}
						});
		},
		useLoadingMessage : function(message) {
			var loadingMessage;
			if (message)
				loadingMessage = message;
			else
				loadingMessage = "正在处理,请稍候...";

			dwr.engine.setPreHook(function() {
				var disabledZone = $('disabledZone');
				if (!disabledZone) {
					disabledZone = document.createElement('div');
					disabledZone.setAttribute('id', 'disabledZone');
					disabledZone.style.position = "absolute";
					disabledZone.style.zIndex = "1000";
					disabledZone.style.left = "0px";
					disabledZone.style.top = "0px";
					disabledZone.style.width = "50%";
					disabledZone.style.height = "50%";
					document.body.appendChild(disabledZone);
					var messageZone = document.createElement('div');
					messageZone.setAttribute('id', 'messageZone');
					messageZone.style.position = "absolute";
					messageZone.style.top = "50%";
					messageZone.style.right = "0px";
					messageZone.style.background = "purple";
					messageZone.style.position = "center";
					messageZone.style.color = "white";
					messageZone.style.fontFamily = "Arial,Helvetica,sans-serif";
					messageZone.style.padding = "10px";
					disabledZone.appendChild(messageZone);
					var text = document.createTextNode(loadingMessage);
					messageZone.appendChild(text);
				} else {
					$('messageZone').innerHTML = loadingMessage;
					disabledZone.style.visibility = 'visible';
				}
			});
			dwr.engine.setPostHook(function() {
						$('disabledZone').style.visibility = 'hidden';
					});
		},
		onCheckClick : function() {

		},
		onSynClick : function() {

		},
		createTextField : function(fieldLabel, name, anchor, inputType,
				maxLength, allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
			var tf = new Ext.form.TextField({
						fieldLabel : fieldLabel,
						name : name,
						xtype : 'textfield',
						readOnly : false,
						allowBlank : allowBlank,
						anchor : anchor,
						blankText : '该选项为必填项,请输入内容...',
						vtype : vtype,
						inputType : inputType,
						maxLength : maxLength,
						maxLengthText : maxLengthText
					});
			return tf;
		},
		addBlankSelectForCombox : function(combo) {
			combo.on("select", function() {
						if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
							combo.setValue("");
						}
					});
			combo.store.on("datachanged", function(a) {
						var r = new Ext.data.Record({});
						r.set(combo.valueField, ''); // 添加一格值为-1的选项
						r.set(combo.displayField, combo.emptyText);
						a.insert(0, r);
					});
		}
	});
	editForm = new EditForm();
	document.getElementById("modify_srp_btn").disabled = true;
	/**
	 * 服务域下发信息列表
	 */
	ConnSendInfoGrid = Ext.extend(UxGrid, {
		store : null,
		sm : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
							url : "Scp/connSendInfoAction_QuerySendInfo.action",
							method : 'POST'
						}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							id : "connSendId",
							root : 'page.result'
						}, [{
									name : 'connSendId'
								}, {
									name : 'connCode'
								}, {
									name : 'connRoutePlatCode'
								}, {
									name : 'connStateFlag'
								}, {
									name : 'delFlag'
								}, {
									name : 'connRoutePlatName'
								}, {
									name : 'connInterAddr'
								}, {
									name : 'connFlag'
								}])
			}), this.sm = new Ext.grid.RowSelectionModel({
						singleSelect : true
					});
			ConnSendInfoGrid.superclass.constructor.call(this, {
						// title:'互联服务权限列表',
						frame : false,
						width : 660,
						region : "center",
						height : 390,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : this.sm,
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(),
								// this.sm,
								{
									header : '互联服务域下发id',
									dataIndex : 'connServLimitId',
									hidden : true
								},
								// {header : '互联服务名称',dataIndex :
								// 'connServName',sortable : true,width :
								// 100,hidden:true},
								{
									header : '互联服务域编码',
									dataIndex : 'connCode',
									sortable : true,
									hidden : false,
									width : 100
								}, {
									header : '互联平台编码',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									hidden : false
								}, {
									header : '互联平台名称',
									dataIndex : 'connRoutePlatName',
									sortable : true,
									hidden : false
								}, {
									header : '接口地址',
									dataIndex : 'connInterAddr',
									sortable : true,
									hidden : false
								}, {
									header : '下发信息',
									dataIndex : 'connStateFlag',
									sortable : true,
									hidden : false,
									renderer : this.format
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 10,
									paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
									},
									store : this.store,
									displayInfo : true,
									displayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录",
									items : ['-', {
												text : '下发',
												id : 'bbar_deleteServDefine',
												iconCls : 'submit',
												handler : this.onDownLoadClick,
												scope : this
											}, '-'

									]
								}),
						ds : this.store,
						listeners : {}
					});
		},
		format : function(val) {
			if (val == 1) {
				return '成功';
			} else {
				return '失败';
			}
		},
		onDownLoadClick : function() {
			record = connSrpSC.connSrpDownLoadWindow.connSendInfoGrid
					.getSelectionModel().getSelected();
			recordSrp = connSrpSC.getSelectionModel().getSelected();
			connRoutePlatId = recordSrp.get('connRoutePlatId');
			if (record == null) {
				Ext.MessageBox.alert('系统提示', '请选择一条记录下发!');
				return;
			}
			connStateFlag = record.get('connStateFlag');
			if (connStateFlag == 1) {
				Ext.MessageBox.alert('系统提示', blankStr + '该服务域已经下发!' + blankStr);
				return;
			}
			connSrpCode = record.get('connCode');
			connRoutePlatAddr = record.get('connInterAddr');
			connRoutePlatCode = record.get('connRoutePlatCode');
			ConnSrpRegSCDwr.downLoadSingle(connRoutePlatId, connRoutePlatAddr,
					connRoutePlatCode, function(data) {
						if (data.optFlag) {
							Ext.MessageBox.alert('系统提示', blankStr
											+ '互联服务域下发成功!' + blankStr);
							connSrpSC.connSrpDownLoadWindow.connSendInfoGrid.store
									.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : 10,
											'connSendInfoDto.connFlag' : 1,
											'connSendInfoDto.connCode' : connSrpCode
										}
									});
						} else {
							Ext.MessageBox.alert('系统提示', blankStr
											+ '互联服务域下发失败!' + blankStr);
						}
					});
		}
	});
	/**
	 * 服务域下发信息窗口
	 */
	ConnSrpDownLoadWindow = Ext.extend(Ext.Window, {
				connSendInfoGrid : null,
				constructor : function() {

					this.connSendInfoGrid = new ConnSendInfoGrid();
					ConnSrpDownLoadWindow.superclass.constructor.call(this, {
								title : "互联服务下发信息窗口SC",
								width : 680,
								height : 430,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connSendInfoGrid]
							});
				}
			});
	// 互联接口列表

	ConnSrpIntefacesGrid = Ext.extend(UxGrid, {
		store : null,
		sm : null,
		constructor : function() {

			this.store = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
					url : "Scp/connSrpIntefacesAction_findConnSrpIntfaces.action",
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							root : 'page.result'
						}, [{
									name : 'connSrpInterId'
								}, {
									name : 'connRoutePlatCode'
								}, {
									name : 'connInterAddr'
								}, {
									name : 'connInterType'
								}, {
									name : 'connInterTypeName'
								}, {
									name : 'delFlag'
								}])
			}), this.sm = new Ext.grid.CheckboxSelectionModel({
				//header : ''
					// singleSelect : false
				}), this.sm.on("rowselect", this.rowSelect1, this);
			ConnSrpIntefacesGrid.superclass.constructor.call(this, {
						frame : false,
						width : 660,
						region : "center",
						height : 390,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : this.sm,
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(),this.sm, {
									header : '接口id',
									dataIndex : 'connSrpInterId',
									hidden : true
								}, {
									header : '服务域平台编码',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									width : 100
								}, {
									header : '平台接口地址',
									dataIndex : 'connInterAddr',
									sortable : true,
									width : 100
								}, {
									header : '接口类型',
									dataIndex : 'connInterTypeName',
									sortable : true,
									width : 130
								}, {
									header : '删除标志',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									hidden : true,
									renderer : this.format,
									width : 100
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 10,
									paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
									},
									store : this.store,
									displayInfo : true,
									dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录",
									items : ['-', {
												text : '下发',
												id : 'bbar_deleteServDefine',
												iconCls : 'submit',
												handler : this.onDownLoad,
												scope : this
											}, '-'

									]
								}),
						ds : this.store,
						listeners : {}
					});
		},
		format : function(val) {
			if (val == 1) {
				return '成功';
			} else {
				return '失败';
			}
		},
		rowSelect1:function(){
		record = this.getSelectionModel().getSelected();
	},
		onDownLoadClick : function() {
			record = connSrpSC.connServDownLoadWindow.connSendInfoGrid
					.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox.alert('系统提示', '请选择一条记录下发!');
				return;
			}
			connStateFlag = record.get('connStateFlag');
			if (connStateFlag == 1) {
				Ext.MessageBox
						.alert('系统提示', blankStr + '该互联服务已经下发!' + blankStr);
				return;
			}
			connRouteCode = record.get('connRoutePlatCode');
			connServCode = record.get('connCode');
			connRoutePlatAddr = record.get('connInterAddr');
			connServId = connSrpSC.getSelectionModel().getSelected()
					.get('connServId');
			ConnServRegSCDwr.downLoadSingleRoute(connServId, connRoutePlatAddr,
					connRouteCode, function(data) {
						if (data.optFlag) {
							Ext.MessageBox.alert('系统提示', blankStr + '互联服务下发成功!'
											+ blankStr);
							connSrpSC.connServDownLoadWindow.connSendInfoGrid.store
									.load({
										params : {
											'page.start' : 0,
											'page.PageSize' : 10,
											'connSendInfoDto.connFlag' : 2,
											'connSendInfoDto.connCode' : connServCode
										}
									});
						} else {
							Ext.MessageBox.alert('系统提示', blankStr + '互联服务下发失败!'
											+ blankStr);
						}
					});
		},
		onDownLoad : function() {
			var servCtrlIdStr = '';
			var servCtrlNameStr = '';
			var count = 0;
			record = connSrpSC.connDownLoadWindow.connSrpIntefacesGrid.getSelectionModel().getSelected();
			record1 = connSrpSC.getSelectionModel().getSelected();
			if (record1 == null||record == null) {
				Ext.MessageBox.alert('系统提示', '请选择一条记录下发!');
				return;
			}
		
			var cell = connSrpSC.connDownLoadWindow.connSrpIntefacesGrid.getSelectionModel().each(function(rec) {
							if (rec.get('connSrpInterId') > 0) {
								servCtrlIdStr += rec.get('connSrpInterId') + ',';
								count++;
							}
						});
			connRouteAddress="";
			connRoutePlatId = record1.get('connRoutePlatId');
			connSrpInterId = record.get('connSrpInterId');
			ConnSrpRegSCDwr.newDownLoad(connRoutePlatId, servCtrlIdStr,connRouteAddress, function(
							data) {
						if (data.optFlag) {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
							connSrpSC.store.load({
										params : {
											'page.start' : 0,
											'page.pageSize' : 10
										}
									});
						} else {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
						}
					});
		}
	});
    ConnDownLoadWindow = Ext.extend(Ext.Window, {
				connSendInfoGrid : null,
				constructor : function() {

					this.connSendInfoGrid = new ConnSendInfoGrid();
					ConnSrpDownLoadWindow.superclass.constructor.call(this, {
								title : "互联服务下发信息窗口SC",
								width : 680,
								height : 430,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connSendInfoGrid]
							});
				}
			});
	// 互联下发打开窗口
	ConnDownLoadWindow = Ext.extend(Ext.Window, {
				connSrpIntefacesGrid : null,
				constructor : function() {

					this.connSrpIntefacesGrid = new ConnSrpIntefacesGrid();
					ConnDownLoadWindow.superclass.constructor.call(this, {
								title : "互联服务下发信息窗口SC",
								width : 680,
								height : 430,
								resizable : false,
								plain : true,
								modal : true,
								autoScroll : true,
								closeAction : 'hide',
								items : [this.connSrpIntefacesGrid]
							});
				}
			});
	ConnSrpSCGrid = Ext.extend(UxGrid, {
		sm : null,
		connSrpDownLoadWindow : null,
		connDownLoadWindow : null,
		constructor : function() {

			this.servDefineStore = new Ext.data.Store({ // Grid Store
				proxy : new Ext.data.HttpProxy({
							url : "Scp/connSrpRegSCAction_findConnSrpRegSC.action",
							method : 'POST'
						}),
				reader : new Ext.data.JsonReader({
							totalProperty : 'page.totalCount',
							root : 'page.result'
						}, [{
									name : 'connRoutePlatId'
								}, {
									name : 'connRoutePlatAreaName'
								}, {
									name : 'delFlag'
								}, {
									name : 'connRoutePlatCode'
								}, {
									name : 'connRoutePlatName'
								}, {
									name : 'connRoutePlatArea'
								}, {
									name : 'connRoutePlatUrl'
								}, {
									name : 'srpDynamicStatus'
								}, {
									name : 'srpStaticStatus'
								}, {
									name : 'srpDynamicStatusName'
								}, {
									name : 'srpStaticStatusName'
								}, {
									name : 'firstUploadTime'
								}, {
									name : 'lastUploadTime'
								}, {
									name : 'downloadTime'
								}])
			}), this.sm = new Ext.grid.CheckboxSelectionModel({
						singleSelect : true
					}), this.sm.on("rowselect", this.rowSelect, this);
			this.sm.on("rowdeselect", this.rowDeselect, this);
			this.connSrpDownLoadWindow = new ConnSrpDownLoadWindow();
			this.connDownLoadWindow = new ConnDownLoadWindow();
			ConnSrpSCGrid.superclass.constructor.call(this, {
						title : '互联服务域列表',
						frame : true,
						width : Ext.getBody().getViewSize().width - 5,
						renderTo : "grid-div",
						region : "center",
						height : Ext.getBody().getViewSize().height * 0.64,
						viewConfig : {
							forceFit : true
						},
						loadMask : {
							msg : '正在载入数据,请稍候...'
						},
						sm : this.sm,
						cm : new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(), this.sm, {
									header : '服务id',
									dataIndex : 'connRoutePlatId',
									hidden : true
								}, {
									header : '平台名称',
									dataIndex : 'connRoutePlatName',
									sortable : true,
									width : 100
								}, {
									header : '平台编码',
									dataIndex : 'connRoutePlatCode',
									sortable : true,
									hidden : false,
									width : 100
								}, {
									header : '服务区域名称',
									dataIndex : 'connRoutePlatAreaName',
									sortable : true,
									hidden : false
								}, {
									header : '代理地址',
									dataIndex : 'connRoutePlatUrl',
									sortable : true,
									width : 130
								}, {
									header : '平台静态状态',
									dataIndex : 'srpStaticStatusName',
									sortable : true,
									width : 100,
									renderer : this.format
								}, {
									header : '平台运行状态',
									dataIndex : 'srpDynamicStatusName',
									sortable : true,
									width : 100,
									renderer : this.format1
								}, {
									header : '第一次上报时间',
									dataIndex : 'firstUploadTime',
									sortable : true,
									width : 100
								}, {
									header : '最后一次上报时间',
									dataIndex : 'lastUploadTime',
									sortable : true,
									width : 100
								}, {
									header : '下发时间',
									dataIndex : 'downloadTime',
									sortable : true,
									width : 100
								}, {
									header : '下发情况',
									dataIndex : '',
									sortable : true,
									width : 100,
									renderer : this.downloadSrp
								}]),
						bbar : new Ext.PagingToolbar({
									firstText : '第一页',
									nextText : '下一页',
									prevText : '上一页',
									refreshText : '刷新',
									lastText : '最后一页',
									beforePageText : '当前',
									afterPageText : '页/共{0}页',
									pageSize : 10,
									paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
									},
									store : this.servDefineStore,
									displayInfo : true,
									displayMsg : '本页显示 {0} - {1},共{2}条记录',
									emptyMsg : "没有可显示的记录"
								}),
						ds : this.servDefineStore,
						listeners : {
			// "rowcontextmenu" : {fn : this.onRightMenuClick,scope : this}
						}
					});
		},
		format : function(val) {
			value = "";
			if (val == '初始状态') {
				value = '<font color=green>' + "初始状态" + '</font>';
			} else if (val == '已下发') {
				value = '<font color=purle>' + "已下发" + '</font>';
			} else if (val == '未审核') {
				value = '<font color=red>' + "未审核" + '</font>';
			} else if (val == '已审核') {
				value = '<font color=blue>' + "已审核" + '</font>';
			} else if (val == '已上报') {
				value = '<font color=darkviolet>' + "已上报" + '</font>';
			} else {
				value = '<font color=darkviolet>' + "其他" + '</font>';
			}
			return value;
		},
		format1 : function(val) {
			value = "";
			if (val == '正常') {
				value = '<font color=blue>' + "正常" + '</font>';
			} else {
				value = '<font color=red>' + "异常" + '</font>';
			}
			return value;
		},
		rowSelect : function() {
			record = this.getSelectionModel().getSelected();
			editForm.getForm().loadRecord(record);
			document.getElementById("modify_srp_btn").disabled = false;
		},
		rowDeselect : function() {
			editForm.getForm().reset();
			editForm.aipDynamicStatus.setValue(1);
			editForm.aipStaticStatus.setValue(1);
			document.getElementById("modify_srp_btn").disabled = true;

		},
		downloadSrp : function() {
			return '<a href = javascript:downLoadSrpSingle()>' + '<center>查看'
					+ '</center>' + '</a>';
		}
	});
	connSrpSC = new ConnSrpSCGrid();
	connSrpSC.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 10
				}
			});
});

function downLoadSrpSingle() {
	record = connSrpSC.getSelectionModel().getSelected();
	connRoutePlatCode = record.get('connRoutePlatCode');
	connSrpSC.connSrpDownLoadWindow.show();
	connSrpSC.connSrpDownLoadWindow.connSendInfoGrid.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 10,
					'connSendInfoDto.connFlag' : 1,
					'connSendInfoDto.connCode' : connRoutePlatCode
				}
			});
}