/**
 * 互联服务域注册主页面
 * 
 * @class EditForm
 * @extends Ext.ux.Form
 */
var connSrp;
var editForm;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var ConnSrpRegObj = {
	connRoutePlatId : "",
	connRoutePlatCode : "",
	connRoutePlatName : "",
	connRoutePlatArea : "",
	connRoutePlatUrl : "",
	srpDynamicStatus : "",
	srpStaticStatus : "",
	delFlag : "",
	addServTime :'',
	updateServTime :'',
	firstUploadTime :'',
	lastUploadTime :'',
	downloadTime :''
};
var areaUrl = "connSrpRegAction_queryArea.action";
var srpStaticUrl = "connSrpRegAction_queryStaticStatus.action";
var srpDynUrl = "connSrpRegAction_queryDynStatus.action";
var SRP_CODE;
Ext.onReady(function() {
	Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}

	EditForm = Ext.extend(Ext.ux.Form, {
		areaCombo : null,
		aipName : null,
		aipCode : null,
		aipAddress : null,
		aipId : null,
		aipDynamicStatus : null,
		aipStaticStatus : null,
		aipDelFlag : null,
		constructor : function() {
			this.areaCombo = this.createCombo2("区域名称", "connRoutePlatArea",
					"businid", "businname", "90%", areaUrl, "areaList",
					"areaCount", false);
			this.areaCombo.initComponent = this
					.addBlankSelectForCombox(this.areaCombo);
			this.areaCombo.store.load();
			this.areaCombo.addListener('select', this.setAipCode);
			this.aipAddress = this.createTextField("平台地址", "connRoutePlatUrl",
					"90%", "text", 100, false, "", "超出最大长度100");
			this.aipName = this.createTextField("平台名称", "connRoutePlatName",
					"90%", "text", 100, false, "", "超出最大长度100");
			this.aipCode = this.createTextField("平台编码", "connRoutePlatCode",
					"90%", "text", 100, false, "", "超出最大长度100");
			this.aipCode.setDisabled(true);
			this.aipId = this.createHidden("平台Id", "connRoutePlatId");
			that = this;
			this.aipDynamicStatus = this.createCombo2("平台运行状态",
					"srpDynamicStatus", "businid", "businname", "90%",
					srpDynUrl, "srpDynStatus", "srpDynCount", true);
			this.aipDynamicStatus.initComponent = this
					.addBlankSelectForCombox(this.aipDynamicStatus);
			this.aipDynamicStatus.disabled = true;
			this.aipDynamicStatus.store.load({
						callback : function() {
							that.aipDynamicStatus.setValue(1)
						}
					});
			this.aipStaticStatus = this.createCombo2("平台静态状态",
					"srpStaticStatus", "businid", "businname", "90%",
					srpStaticUrl, "srpStaticStatus", "srpStaticCount", true);
			this.aipStaticStatus.initComponent = this
					.addBlankSelectForCombox(this.aipStaticStatus);
			this.aipStaticStatus.disabled = true;
			this.aipStaticStatus.store.load({
						callback : function() {
							that.aipStaticStatus.setValue(1);
						}
					});
			this.aipDelFlag = this.createHidden("平台删除标志", "delFlag");
			EditForm.superclass.constructor.call(this, {
						title : "互联服务域编辑",
						width : Ext.getBody().getViewSize().width * 0.997,
						height : Ext.getBody().getViewSize().height * 0.32,
						region : "center",
						applyTo : "queryform",
						labelAlign : "right",
						bodyStyle : "padding: 5px 5px 0",
						// bodyStyle: "background-color:white;padding:10px 10px
						// 0 0;",
						items : [{
									layout : "column",
									items : [{
												layout : "form",
												items : this.aipName,
												columnWidth : .3333
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.aipCode
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.areaCombo
											}, {
												layout : "form",
												items : this.aipAddress,
												columnWidth : .3333
											}, {
												layout : "form",
												items : this.aipDynamicStatus,
												columnWidth : .3333
											}, {
												layout : "form",
												items : this.aipStaticStatus,
												columnWidth : .3333
											}, {
												layout : "form",
												columnWidth : .3333,
												items : this.aipDelFlag
											}, {
												layout : "form",
												items : this.aipId,
												columnWidth : .3333
											}]
								}],
						buttons : [{
									text : '添加',
									id : 'add_srp_btn',
									iconCls : 'new',
									width : 20,
									hidden : false,
									handler : this.addFormClick,
									scope : this
								}, {
									text : '修改',
									id : 'modify_srp_btn',
									width : 20,
									iconCls : 'update',
									hidden : false,
									handler : this.onModifyClick,
									scope : this
								}, {
									text : '重置',
									id : 'resume_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : false,
									handler : this.onResumeClick,
									scope : this
								}, {
									text : '上报',
									id : 'upLoad_srp_btn',
									width : 20,
									iconCls : 'submit',
									hidden : false,
									handler : this.onUpLoad,
									scope : this
								}, {
									text : '审核',
									id : 'check_srp_btn',
									width : 20,
									iconCls : 'excelx',
									hidden : false,
									handler : this.onCheckClick,
									scope : this
								}, {
									text : '同步SRC数据',
									id : 'syn_srp_btn',
									width : 20,
									iconCls : 'resume',
									hidden : true,
									handler : this.onSynClick,
									scope : this
								}]

					})
		},
		addFormClick : function() {
			if (!this.getForm().isValid()) {
				Ext.MessageBox.alert("系统提示", blankStr + "请输入必填信息!" + blankStr);
				return;
			} else {
				ConnSrpRegObj.connRoutePlatId = this.aipId.getValue();
				ConnSrpRegObj.connRoutePlatArea = this.areaCombo.getValue();
				ConnSrpRegObj.connRoutePlatCode = this.aipCode.getValue();
				ConnSrpRegObj.connRoutePlatName = this.aipName.getValue();
				ConnSrpRegObj.connRoutePlatUrl = this.aipAddress.getValue();
				ConnSrpRegObj.delFlag = 0;
				ConnSrpRegObj.srpDynamicStatus = this.aipDynamicStatus
						.getValue();
				ConnSrpRegObj.srpStaticStatus = this.aipStaticStatus.getValue();
				if (this.aipCode.getValue() != SRP_CODE) {
					Ext.MessageBox.alert('系统提示', blankStr + '只能添加本平台服务域信息!'
									+ blankStr);
					return;
				}
				ConnSrpRegDwr.isSrpExist(SRP_CODE, function(data1) {
							if (data1) {
								Ext.MessageBox.alert('系统提示', blankStr
												+ '本平台信息已经注册过，不允许再次注册!'
												+ blankStr);
								return;
							} else {
								ConnSrpRegDwr.save(ConnSrpRegObj,
										function(data) {
											if (data != null) {
												Ext.MessageBox.alert("系统提示",
														blankStr + "添加服务域信息成功!"
																+ blankStr);
												editForm.getForm().reset();
												connSrp.store.load({
															params : {
																'page.start' : 0,
																'page.pageSize' : 10
															}
														});
											} else {
												Ext.MessageBox.alert("系统提示",
														blankStr + "添加服务域信息失败!"
																+ blankStr);
											}
										});
							}
						});

			}
		},
		onModifyClick : function() {
			if (!this.getForm().isValid()) {
				Ext.MessageBox.alert("系统提示", blankStr + "请填写必填信息" + blankStr);
				return;
			} else {
				ConnSrpRegObj.connRoutePlatId = this.aipId.getValue();
				ConnSrpRegObj.connRoutePlatArea = this.areaCombo.getValue();
				ConnSrpRegObj.connRoutePlatCode = this.aipCode.getValue();
				ConnSrpRegObj.connRoutePlatName = this.aipName.getValue();
				ConnSrpRegObj.connRoutePlatUrl = this.aipAddress.getValue();
				ConnSrpRegObj.delFlag = this.aipDelFlag.getValue();
				this.aipDynamicStatus.setValue(1);
				// ConnSrpRegObj.srpDynamicStatus =
				// this.aipDynamicStatus.getValue();
				// ConnSrpRegObj.srpStaticStatus =
				// this.aipStaticStatus.getValue();
				ConnSrpRegObj.srpDynamicStatus = 1;
				ConnSrpRegObj.srpStaticStatus = 1;
				if (this.aipCode.getValue() != SRP_CODE) {
					Ext.MessageBox.alert('系统提示', blankStr + '只能修改本平台信息!'
									+ blankStr);
					return;
				}
				ConnSrpRegDwr.update(ConnSrpRegObj, function(data) {
					if (data) {
						Ext.MessageBox.alert("系统提示", blankStr + "信息修改成功!"
										+ blankStr);
						editForm.getForm().reset();
						editForm.aipDynamicStatus.setValue(1);
						editForm.aipStaticStatus.setValue(1);
						document.getElementById("add_srp_btn").disabled = false;
						document.getElementById("modify_srp_btn").disabled = true;
						connSrp.store.load({
									params : {
										'page.start' : 0,
										'page.pageSize' : 10
									}
								});
					} else {
						Ext.MessageBox.alert("系统提示", blankStr + "信息修改失败!"
										+ blankStr);
					}
				});
			}
		},
		onResumeClick : function() {
			record = connSrp.getSelectionModel().getSelected();
			if (record == null) {
				editForm.getForm().reset();
				this.aipDynamicStatus.setValue(1);
				this.aipStaticStatus.setValue(1);
			} else {
				editForm.getForm().loadRecord(record);
			}
		},
		onUpLoad : function() {
			record = connSrp.getSelectionModel().getSelected();
			if (record == null) {
				Ext.MessageBox
						.alert("系统提示", blankStr + "请选择一条记录上传!" + blankStr);
				return;
			}
			ConnSrpRegObj.connRoutePlatArea = record.get('connRoutePlatArea');
			ConnSrpRegObj.connRoutePlatCode = record.get('connRoutePlatCode');
			ConnSrpRegObj.connRoutePlatId = record.get('connRoutePlatId');
			ConnSrpRegObj.connRoutePlatName = record.get('connRoutePlatName');
			ConnSrpRegObj.connRoutePlatUrl = record.get('connRoutePlatUrl');
			ConnSrpRegObj.delFlag = record.get('delFlag');
			ConnSrpRegObj.srpStaticStatus = record.get('srpStaticStatus');
			ConnSrpRegObj.srpDynamicStatus = record.get('srpDynamicStatus');
			ConnServRegDwr.queryLocalAreaCode(function(data) {
						if (ConnSrpRegObj.connRoutePlatCode != data) {
							Ext.MessageBox.alert("系统提示", blankStr
											+ "只能上传本系统服务域信息!" + blankStr);
							return;
						}
						if (ConnSrpRegObj.srpStaticStatus == 5) {
							Ext.MessageBox.alert("系统提示", blankStr
											+ "该服务域信息已经上报!" + blankStr);
							return;
						}
						ConnSrpRegDwr.upLoad(ConnSrpRegObj, {callback:function(data) {
									if (data.optFlag) {
										Ext.MessageBox.alert(data.title,
												blankStr + data.msg + blankStr);
										connSrp.store.load({
													params : {
														'page.start' : 0,
														'page.pageSize' : 10
													}
												});
									} else {
										Ext.MessageBox.alert(data.title,
												blankStr + data.msg + blankStr);
									}
								},	errorHandler:function(message) { alert(message); }});
					});
		},
		onCheckClick : function() {
			record = connSrp.getSelectionModel().getSelected();
			that = this;
			if (record == null) {
				Ext.MessageBox.alert("系统提示", "请选择一条记录进行审核!");
				return;
			}
			ConnSrpRegObj.connRoutePlatArea = record.get('connRoutePlatArea');
			ConnSrpRegObj.connRoutePlatCode = record.get('connRoutePlatCode');
			ConnSrpRegObj.connRoutePlatId = record.get('connRoutePlatId');
			ConnSrpRegObj.connRoutePlatName = record.get('connRoutePlatName');
			ConnSrpRegObj.connRoutePlatUrl = record.get('connRoutePlatUrl');
			ConnSrpRegObj.delFlag = record.get('delFlag');
			ConnSrpRegObj.srpStaticStatus = record.get('srpStaticStatus');
			if (ConnSrpRegObj.srpStaticStatus != 3) {
				Ext.MessageBox.alert("系统提示", blankStr + "只有在未审核状态下才能审核!"
								+ blankStr);
				return;
			}
			ConnSrpRegObj.srpDynamicStatus = record.get('srpDynamicStatus');
			ConnSrpRegDwr.synMemory(ConnSrpRegObj, function(data) {
						if (data.optFlag) {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr,
									function(btn) {
										connSrp.store.load({
													params : {
														'page.start' : 0,
														'page.pageSize' : 10
													}
												});
									});
						} else {
							Ext.MessageBox.alert(data.title, blankStr
											+ data.msg + blankStr);
						}
					});
		},
		onSynClick : function() {

		},
		createTextField : function(fieldLabel, name, anchor, inputType,
				maxLength, allowBlank, vtype, maxLengthText) { // 生成一个通用的TextField
			var tf = new Ext.form.TextField({
						fieldLabel : fieldLabel,
						name : name,
						xtype : 'textfield',
						readOnly : false,
						allowBlank : allowBlank,
						anchor : anchor,
						blankText : '该选项为必填项,请输入内容...',
						vtype : vtype,
						inputType : inputType,
						maxLength : maxLength,
						maxLengthText : maxLengthText
					});
			return tf;
		},
		addBlankSelectForCombox : function(combo) {
			combo.on("select", function() {
						if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
							combo.setValue("");
						}
					});
			combo.store.on("datachanged", function(a) {
						var r = new Ext.data.Record({});
						r.set(combo.valueField, ''); // 添加一格值为-1的选项
						r.set(combo.displayField, combo.emptyText);
						a.insert(0, r);
					});
		},
		setAipCode : function() {
			areaCode = that.areaCombo.getValue();
			areaCode = areaCode + '.' + '1111';
			that.aipCode.setValue(areaCode);
		}
	});
	editForm = new EditForm();
	document.getElementById("modify_srp_btn").disabled = true;
	ConnSrpGrid = Ext.extend(UxGrid, {
				sm : null,
				constructor : function() {

					this.store = new Ext.data.Store({ // Grid Store
						proxy : new Ext.data.HttpProxy({
									url : "Srp/connSrpRegAction_findConnSrpReg.action",
									method : 'POST'
								}),
						reader : new Ext.data.JsonReader({
									totalProperty : 'page.totalCount',
									root : 'page.result'
								}, [{
											name : 'connRoutePlatId'
										}, {
											name : 'connRoutePlatAreaName'
										}, {
											name : 'delFlag'
										}, {
											name : 'connRoutePlatCode'
										}, {
											name : 'connRoutePlatName'
										}, {
											name : 'connRoutePlatArea'
										}, {
											name : 'connRoutePlatUrl'
										}, {
											name : 'srpDynamicStatus'
										}, {
											name : 'srpStaticStatusName'
										}, {
											name : 'srpDynamicStatusName'
										}, {
											name : 'srpStaticStatus'
										}, {
											name : 'addServTime'
										}, {
											name : 'updateServTime'
										}, {
											name : 'firstUploadTime'
										}, {
											name : 'lastUploadTime'
										}, {
											name : 'downloadTime'
										}])
					}), this.sm = new Ext.grid.CheckboxSelectionModel({
								singleSelect : true
							}), this.sm.on("rowselect", this.rowSelect, this);
					this.sm.on("rowdeselect", this.rowDeselect, this);
					ConnSrpGrid.superclass.constructor.call(this, {
								title : '互联服务域列表',
								frame : true,
								width : Ext.getBody().getViewSize().width
										* 0.997,
								renderTo : "grid-div",
								region : "center",
								height : Ext.getBody().getViewSize().height
										* 0.65,
								viewConfig : {
									forceFit : true
								},
								loadMask : {
									msg : '正在载入数据,请稍候...'
								},
								sm : this.sm,
								cm : new Ext.grid.ColumnModel([
										new Ext.grid.RowNumberer(), this.sm, {
											header : '服务id',
											dataIndex : 'connRoutePlatId',
											hidden : true
										}, {
											header : '平台名称',
											dataIndex : 'connRoutePlatName',
											sortable : true,
											width : 100
										}, {
											header : '平台编码',
											dataIndex : 'connRoutePlatCode',
											sortable : true,
											hidden : false,
											width : 100
										}, {
											header : '服务区域名称',
											dataIndex : 'connRoutePlatAreaName',
											sortable : true,
											hidden : false
										}, {
											header : '代理地址',
											dataIndex : 'connRoutePlatUrl',
											sortable : true,
											width : 130
										}, {
											header : '平台静态状态',
											dataIndex : 'srpStaticStatusName',
											sortable : true,
											renderer : this.format,
											width : 100
										}, {
											header : '平台运行状态',
											dataIndex : 'srpDynamicStatusName',
											sortable : true,
											renderer : this.format1,
											width : 100
										}, {
											header : '注册时间',
											dataIndex : 'addServTime',
											sortable : true,
											width : 100
										}, {
											header : '更新时间',
											dataIndex : 'updateServTime',
											sortable : true,
											width : 100
										},  {
											header : '第一次上报时间',
											dataIndex : 'firstUploadTime',
											sortable : true,
											width : 100
										}, {
											header : '最后一次上报时间',
											dataIndex : 'lastUploadTime',
											sortable : true,
											width : 100
										}, {
											header : '下发时间',
											dataIndex : 'downloadTime',
											sortable : true,
											width : 100
										}, {
											header : '是否本平台服务域',
											dataIndex : 'connRoutePlatCode',
											sortable : true,
											width : 100,
											renderer : this.juge
										}]),
								bbar : new Ext.PagingToolbar({
											firstText : '第一页',
											nextText : '下一页',
											prevText : '上一页',
											refreshText : '刷新',
											lastText : '最后一页',
											beforePageText : '当前',
											afterPageText : '页/共{0}页',
											pageSize : 10,
											paramNames : {
												start : 'page.start',
												limit : 'page.pageSize'
											},
											store : this.store,
											displayInfo : true,
											displayMsg : '本页显示 {0} - {1},共{2}条记录',
											emptyMsg : "没有可显示的记录"
										}),
								ds : this.store,
								listeners : {
					// "rowcontextmenu" : {fn : this.onRightMenuClick,scope :
					// this}
								}
							});
				},
				format : function(val) {
					value = "";
					if (val == '初始状态') {
						value = '<font color=green>' + "初始状态" + '</font>';
					} else if (val == '已下发') {
						value = '<font color=purle>' + "已下发" + '</font>';
					} else if (val == '未审核') {
						value = '<font color=red>' + "未审核" + '</font>';
					} else if (val == '已审核') {
						value = '<font color=blue>' + "已审核" + '</font>';
					} else if (val == '已上报') {
						value = '<font color=darkviolet>' + "已上报" + '</font>';
					} else {
						value = '<font color=darkviolet>' + val + '</font>';
					}
					return value;
				},
				format1 : function(val) {
					value = "";
					if (val == '正常') {
						value = '<font color=blue>' + "正常" + '</font>';
					} else {
						value = '<font color=red>' + "异常" + '</font>';
					}
					return value;
				},
				rowSelect : function() {
					record = this.getSelectionModel().getSelected();
					editForm.getForm().loadRecord(record);
					document.getElementById("modify_srp_btn").disabled = false;
					document.getElementById("add_srp_btn").disabled = true;
				},
				rowDeselect : function() {
					editForm.getForm().reset();
					editForm.aipDynamicStatus.setValue(1);
					editForm.aipStaticStatus.setValue(1);
					document.getElementById("add_srp_btn").disabled = false;
					document.getElementById("modify_srp_btn").disabled = true;

				},
				juge : function(val) {
					if (val == SRP_CODE) {
						return '是';
					} else {
						return '否';
					}
				}
			});
	connSrp = new ConnSrpGrid();

	connSrp.store.load({
				params : {
					'page.start' : 0,
					'page.pageSize' : 10
				}
			});
	ConnServRegDwr.queryLocalAreaCode(function(data) {
				SRP_CODE = data;
			});
});