Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';
var pageTotal = 10;
var queryDicUrl = "getDicAction_queryDictionary.action";
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格
function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}
Ext.onReady(function() {
	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
		}
	}
	// 公用 代码区
	// combox自动加上"请选择"

	var addBlankSelectForCombox = function(combo) { // 自动添加一个空选择项
		combo.on("select", function() {
					if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
						combo.setValue("");
					}
				});
		combo.store.on("datachanged", function(a) {
					var r = new Ext.data.Record({});
					r.set(combo.valueField, ''); // 添加一格值为-1的选项
					r.set(combo.displayField, combo.emptyText);
					a.insert(0, r);
				});
	}

	// 先建注册服务商下拉列表
	var servManfields = Ext.data.Record.create([{
				name : 'connRoutePlatCode'
			}, {
				name : 'connRoutePlatName'
			}]);
	var servManDataStore = new Ext.data.Store({
		proxy : new Ext.data.HttpProxy({
			url : 'connSrpRegAction_queryConnPlat.action'
		}),
		reader : new Ext.data.JsonReader({
					root : 'sonnSrpRegList'
				}, servManfields),
		remoteSort : true
	});
	
	
	var servManCombox = new Ext.form.ComboBox({
				fieldLabel : "服务提供方",
				emptyText : "请选择…",
				store : servManDataStore,
				editable : false,
				hiddenName : 'connRoutePlatCode',
				valueField : 'connRoutePlatCode',
				id:'connRoutePlatName',
				displayField : 'connRoutePlatName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				forceSelection : true,
				width : 150,
				initComponent : function() {
					addBlankSelectForCombox(this);
				},
				mode : 'local'
			});

	// 服务下拉列表
	var servFields = Ext.data.Record.create([{
				name : 'connServCode'
			}, {
				name : 'connServName'
			}]);
	var servStore = new Ext.data.Store({
		proxy : new Ext.data.HttpProxy({
					url : 'connServRegAction_findConnServ.action'
				}),
		reader : new Ext.data.JsonReader({
					root : 'servList'
				}, servFields),
		remoteSort : true
	});

	var servCombox = new Ext.form.ComboBox({
				fieldLabel : "服务名称",
				emptyText : "请选择…",
				store : servStore,
				editable : false,
				value : '',
				hiddenName : 'connServCode',
				valueField : 'connServCode',
				displayField : 'connServName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				disabled : true,
				width : 150,
				mode : 'local',
				initComponent : function() {
					addBlankSelectForCombox(this);
				}
			});

	
	//定义查询操作
	var queryButton = new Ext.Button({
		align: 'center',
		text: '查询',
		iconCls: 'find',
		width:20,
		handler: queryCheck,
		scope: this
	})		
	//定义重置操作
	var resetButton =  new Ext.Button({
		align:'center',
		text : '重置',
		iconCls: 'resume',
		width:20,
		handler: resetQuery,
		scope :this
	})
	
	servManDataStore.load();

	// 二级联动,联动后，原先数据需要清除
	servManCombox.on("select", function(comb) {
		servStore.load({
					params : {
						connRoutePlatCode : comb.value
					}
				});
		servCombox.setValue('');
		// 当服务框未选择时，二级框置不可用
		if (servManCombox.getValue() == '') {
			servCombox.setDisabled(true)
		} else {
			servCombox.setDisabled(false);
		}
	});
		
	
	// 计算form 宽度
	var gridWidth = Ext.getBody().getViewSize().width - 5;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 5;
	}
	// 将上面的查询选项放进form 面板 中
	var queryform = new Ext.FormPanel({
		title : "查询条件",
		width : gridWidth,
		height : Ext.getBody().getViewSize().height*0.15,
		buttonAlign : 'center',
		applyTo : 'queryform',
		labelWidth : 80,
		labelAlign : "right",
		frame : true,
		items : [{
					layout : "column",
					items : [{
								columnWidth : 0.3,
								layout : "form",
								items : servManCombox
							}, {
								columnWidth : 0.3,
								layout : "form",
								items : servCombox
							},{
								columnWidth :0.10,
								layout : "form",
								items : queryButton
							},{
								columnWidth : 0.10,
								layout : "form",
								items : resetButton
							}]
				}]
	});
	function queryCheck() {
		var servManIdValue = servManCombox.getValue();
		if(servManIdValue == ''){
			servManIdValue = 0;
		}
		var servIdValue = servCombox.getValue();
		if(servIdValue == ''){
			servIdValue = 0;
		}
		store.baseParams = {
		                'servVersionDto.connPlatCode' : servManIdValue,
						'servVersionDto.connServCode' : servIdValue
		}
		store.load({params : {'page.start' : 0,'page.pageSize' : pageTotal}});
	}

	function resetQuery() {
		servManCombox.setValue('');
		servCombox.setValue('');
		servCombox.setDisabled(true);
		
	}
	/** ********************************************结果列表区*********************************** */
	var hp = new Ext.data.HttpProxy({
				url : 'register/servVersionAction_versionConnList.action'
			});
	var store = new Ext.data.Store({// 配置分组数据集
		proxy : hp,
		reader : new Ext.data.JsonReader({
					totalProperty : "page.totalCount",
					root : 'page.result',
					id : 'id',// default id
					fields : ['id','connPlatCode', 'servName','connServCode','sendTime','resendTimes', 'resendInterval','resendRule','resendRuleName']
				})
	});
	// 定义复选框选择模式变量：加上选择列
	var sm = new Ext.grid.CheckboxSelectionModel();
	sm.singleSelect = true;
	sm.on('rowselect', selectRow);
	sm.on('rowdeselect',deselectRow);
	// 创建Grid表格组件
	
	var columnWidth = gridWidth - 8;
	
	calResendInterval=function(val){
				if(val==null || ''==val)
					return 0;
				else//5 * 60 * parseInt(val) ;
					return val ;
			}
	var grid = new Ext.grid.GridPanel({
				title : '重投规则列表',
				applyTo : 'grid-div',
				width : gridWidth,
				height : Ext.getBody().getViewSize().height*0.58,
				frame : true,
				id    :'gridCfg',
				viewConfig: {
                forceFit: true
            	},
				bbar : new Ext.PagingToolbar({// 分页工具栏
					store : store,
					// 改变传给服务端的分页参数名。extjs3.1推荐是在Store 里面定义这个参数，可是我试验却失败了。
					// 在这里却可以成功，不知道是不是extjs 版本问题
					paramNames : {
						start : 'page.start',
						limit : 'page.pageSize'
					},
					pageSize : pageTotal,
					
					displayInfo : true,
					displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
					emptyMsg : "没有记录",
					items : [{
								text : '删除',
								tooltip : '删除被选择的内容',
								iconCls : 'delete', // modified by jch
								id : 'Btn_Del',
								handler : remove
							}]

				}),
				sm : sm,// 设置复选框选择模式
				store : store,
				loadMask : true,
				columns : [// 配置表格列
						sm,// 复选框选择模式中的checkbox组件将会显示在该列
						{
							header : "互联平台编码",
							width:columnWidth/7,
							sortable :true,
							dataIndex :'connPlatCode',
							name : 'connPlatCode',
							hidden :false
						},{
							header : "互联服务编码",
							width:columnWidth/7,
							sortable :true,
							dataIndex :'connServCode',
							name : 'connServCode',
							hidden :false
						}, {
							header : "服务名称",
							width : columnWidth / 7,// Ext.getBody().getViewSize().width
							sortable : true,
							dataIndex : 'servName',
							name : 'servName',
							hidden : false
						},{
							header : "重投次数",
							width : columnWidth / 9,// Ext.getBody().getViewSize().width
							sortable : true,
							dataIndex : 'resendTimes',
							name : 'resendTimes'
						}, {
							header : "重投间隔(s)",
							width : columnWidth / 9,// Ext.getBody().getViewSize().width
							sortable : true,
							dataIndex : 'resendInterval',
							name : 'resendInterval',
							renderer : calResendInterval
						}, {
							header : "固定时间",
							width : columnWidth / 9,// Ext.getBody().getViewSize().width
							sortable : true,
							dataIndex : 'sendTime',
							name : 'sendTime'
						}, {
							header : "重投规则",
							width : columnWidth / 9,// Ext.getBody().getViewSize().width
							sortable : true,
							dataIndex : 'resendRuleName',
							name : 'resendRuleName'
						}, {
							header : "重投规则",
							width : columnWidth / 9,// Ext.getBody().getViewSize().width
							dataIndex : 'resendRuleName',
							name : 'resendRuleName',
							hidden : true
						}]
			})
			
			store.load();
			function remove() {
				var id = '';
				var count = 0;
				var cell = grid.getSelectionModel().each(function(rec) {
					if (rec.get('id') > 0) {
						id += rec.get('id') + ',';
						count++;
					}
				});
				if (count > 0) {
					Ext.Msg.confirm("提醒信息", "确定要删除这 " + count + " 条信息吗",
						function(btn) {
							if (btn == 'yes') {
								ServVersionDwr.remove(id,
									function(data) {
										Ext.Msg.alert(data.title,
												data.msg);
										if (data.optFlag) {
											store.load({
												params : {
													'page.start' : 0,
													'page.pageSize' : pageTotal
												}
											});
											reset();
										}
									});
							}
						})
				} else {
					Ext.Msg.alert("提醒信息", "请选中指定记录进行删除操作");
				}
			}
	/** ************************************************编辑区******************** */
	msgResendIdHiddenField = new Ext.form.Hidden({
				name : "id",
				id : "id"
			});
	
			
	var resendRuleCombox = new Ext.form.ComboBox({
            fieldLabel: "重投策略",
            emptyText: '请选择...',
            isFormField: true,
            anchor: "90%",
            mode: 'local',
            hiddenName: "resendRule",
            allowBlank: false,
            blankText:'请选择...',
            lastQuery: '',
            triggerAction: 'all',
            displayField:"businname",
            valueField:"businid",
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: queryDicUrl+"?busintypeid=MSG_RESEND_RULE&"+new Date(), method: 'POST'}),
                reader: new Ext.data.JsonReader({totalProperty:"dicCount",root:"dicList"},new Ext.data.Record.create([{name:"businid"},{name:"businname"}]))
            }),
             readOnly: true
        });
	resendRuleCombox.store.load() ;
	
	var servManEditCombox = new Ext.form.ComboBox({
				fieldLabel : redStar + "服务提供方",
				emptyText : "请选择…",
				store : servManDataStore,
				editable : false,
				hiddenName : 'connRoutePlatCode',
				valueField : 'connRoutePlatCode',
				displayField : 'connRoutePlatName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				forceSelection : true,
				anchor: "90%",
				disabled : false,
				allowBlank: false,
				mode : 'local'
			});

	var servEditCombox = new Ext.form.ComboBox({
				fieldLabel :redStar +  "服务名称",
				emptyText : "请选择…",
				store : servStore,
				editable : false,
				hiddenName : 'connServCode',
				valueField : 'connServCode',
				displayField : 'connServName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				disabled : true,
				anchor: "90%",
				allowBlank:false,
				mode : 'local'
			});
	// 二级联动,联动后，原先数据需要清除
	servManEditCombox.on("select", function(comb) {
		servStore.load({
					params : {
						connPlatCode : comb.value
					}
				});
		servEditCombox.setValue('');
		// 当服务框未选择时，二级框置不可用
		if (servManEditCombox.getValue() == '') {
			servEditCombox.setDisabled(true)
		} else {
			servEditCombox.setDisabled(false);
		}
	});
	//重投次数
	var resendTimesField = new Ext.form.NumberField({
				fieldLabel : redStar + "重投次数",
				name : "resendTimes",
				id : "resendTimes",
				msgTarget : 'qtip',
				blankText : '请填重投次数！',
				maxLength : 4,
				allowBlank : false,
				//emptyText:3,
				anchor: "90%"
			});
	//重投间隔
	var resendIntervalField = new Ext.form.NumberField({
				fieldLabel : redStar +"重投间隔",
				name : "resendInterval",
				id : "resendInterval",
				blankText : '请填重投间隔！',
				maxLength : 4,
				allowBlank : false,
				anchor: "100%"
			});
	
	var resendTimeField = new Ext.form.TimeField({  
				fieldLabel : redStar + "固定时间",
                name : "sendTime",
				id : "sendTime",
                width : 150,  
                format: 'H:i',
                //increment : 60,//时间间隔为60分钟  
                invalidText :'时间格式无效',
                anchor: "90%"
            })  
	var editForm = new Ext.form.FormPanel({
		title : "编辑选项",
		width : gridWidth,// Ext.getBody().getViewSize().width - 5,
		//height : 150,
		height:Ext.getBody().getViewSize().height*0.25,
		applyTo : 'editDiv',
		labelWidth : 120,
		labelAlign : "right",
		frame : true,
		items : [{
			layout : "column",
			items : [{
				columnWidth : 0.3333,
				layout : "form",
				items : servManEditCombox
			}, {
				columnWidth : 0.3333,
				layout : "form",
				items : servEditCombox
			}, {
				columnWidth : 0.3333,
				layout : "form",
				items : resendTimesField
			}, {
				columnWidth : 0.3333,
				layout : "form",
				items : [{
					layout : "column",
					items:[{
						columnWidth : 0.9,
						layout : "form",
						items : resendIntervalField
					},{
						columnWidth : 0.1,
						xtype : 'label',
        				id : 'mylabel1',
       					html : '<font size="2">(秒)</font>'
					}]
				}]
			}, {
				columnWidth : 0.3333,
				layout : "form",
				items : resendTimeField
			}, {
				columnWidth : 0.3333,
				layout : "form",
				items : resendRuleCombox
			}]
		}],
		buttons : [{text : '添 加',id : 'addInfo',iconCls : 'new',width : 20,hidden : false,handler :add,scope : this},
				   {text : '修 改',id : 'modify',width : 20,iconCls : 'update',hidden : false,handler : modify,scope : this},
				   {text : '重 置',id : 'resumeInfo',width : 20,iconCls : 'resume',hidden : false,handler : reset,scope : this}
				  ]

	});
	document.getElementById("modify").disabled = true;
	function selectRow (){
		msgResendIdHiddenField.setValue(sm.getSelected().get('id'));
		servManEditCombox.setValue(sm.getSelected().get('connPlatCode'));
		servStore.load({
				params : {
					servAffordManId : sm.getSelected().get('connPlatCode')
				},callback:function(){
					servEditCombox.setValue(sm.getSelected().get('connServCode'));
				}
			});
		servManEditCombox.setDisabled(true);
		servEditCombox.setDisabled(true);
		
		resendTimesField.setValue(sm.getSelected().get('resendTimes'));
		resendIntervalField.setValue(sm.getSelected().get('resendInterval'));
		resendTimeField.setValue(sm.getSelected().get('sendTime')) ;
		resendRuleCombox.setValue(sm.getSelected().get('resendRule')) ;
		resendRuleCombox.setDisabled(false) ;
		
		document.getElementById("addInfo").disabled=true;
		document.getElementById("modify").disabled=false;
		
	}
	function deselectRow(){
		editForm.getForm().reset();
		servManDataStore.load();
		servManEditCombox.setDisabled(false);
		servEditCombox.setDisabled(true);
		document.getElementById("addInfo").disabled=false;
		document.getElementById("modify").disabled=true;
	}
	function add(){
		var date = new Date();
		var msgResendRuleObj = {
			recordsn : 0,
			servCode : servEditCombox.getValue()+"" ,
			sendTime : resendTimeField.getValue()+"",
			resendTimes : resendTimesField.getValue(),
			resendInterval : resendIntervalField.getValue(),
			resendRule : resendRuleCombox.getValue()
		}

		if (!editForm.form.isValid()) {
			Ext.Msg.alert('系统提示：', '请检查填写的信息，注意格式和必填项!');
			return false;
		}
//		//对一些输入数据合法性进行判断
       var pattern = new RegExp("^\\d+$");
//       if(!pattern.test(resendTimeField.getValue())){
//       		Ext.Msg.alert('信息提示','接收消息超时时长必须为非负整数！');
//       		return false;
//       }
       if(!pattern.test(resendTimesField.getValue())){
       		Ext.Msg.alert('信息提示','重投次数必须为非负整数！');
       		return false;
       }
       if(!pattern.test(resendIntervalField.getValue())){
       		Ext.Msg.alert('信息提示','重投间隔必须为非负整数！');
       		return false;
       }
		Ext.Msg.confirm('提示', '确认添加该条记录么？', function(btn) {// modified
			if (btn == 'yes') {
				ServVersionDwr.save(msgResendRuleObj,
					function(data) {
						Ext.Msg.alert(data.title, blankStr+data.msg+blankStr);
						if (data.optFlag) {
							store.load({
								params : {
									'page.start' : 0,
									'page.pageSize' : pageTotal
								}
							});
						}
						reset();
					});
			}
		});
	}
	function modify(){
		var date = new Date();
		var msgResendRuleObj = {
			recordsn : msgResendIdHiddenField.getValue(),
			servCode : servEditCombox.getValue()+"" ,
			sendTime : resendTimeField.getValue()+"",
			resendTimes : resendTimesField.getValue(),
			resendInterval : resendIntervalField.getValue(),
			resendRule : resendRuleCombox.getValue()
		}

		if (!editForm.form.isValid()) {
			Ext.Msg.alert('系统提示：', '请输入必填信息');
			return false;
		}
		//对一些输入数据合法性进行判断
       var pattern = new RegExp("^\\d+$");
//       if(!pattern.test(resendTimeField.getValue())){
//       		Ext.Msg.alert('信息提示','接收消息超时时长必须为非负整数！');
//       		return false;
//       }
       if(!pattern.test(resendTimesField.getValue())){
       		Ext.Msg.alert('信息提示','重投次数必须为非负整数！');
       		return false;
       }
       if(!pattern.test(resendIntervalField.getValue())){
       		Ext.Msg.alert('信息提示','重投间隔必须为非负整数！');
       		return false;
       }
		ServVersionDwr.modify(msgResendRuleObj,function(data) {
			Ext.Msg.alert(data.title, blankStr+data.msg+blankStr);
			if (data.optFlag) {
				store.load({
					params : {
						'page.start' : 0,
						'page.pageSize' : pageTotal
					}
				});
				reset();
			}
		});
	}
	function reset(){
		deselectRow();
		sm.clearSelections();
	}
	
});
