/**
 * @class Ext.ux.Media Version: 2.0 Author: Doug Hendricks.
 *        doug[always-At]theactivegroup.com Copyright 2007-2008, Active Group,
 *        Inc. All rights reserved.
 * 
 * ***********************************************************************************
 * This file is distributed on an AS IS BASIS WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ***********************************************************************************
 * 
 * License: Ext.ux.Media is licensed under the terms of : GNU Open Source GPL
 * 3.0 license:
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see < http://www.gnu.org/licenses/gpl.html>.
 * 
 * Donations are welcomed: http://donate.theactivegroup.com Commercial use is
 * prohibited without a Commercial License. See
 * http://licensing.theactivegroup.com.
 */
(function() {
	Ext.ux.Media = function(F) {
		Ext.apply(this, F || {});
		this.toString = this.mediaMarkup;
		this.initMedia();
	};
	var B = Ext.ux.Media;
	B.mediaTypes = {
		"PDF" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-pdf",
					type : "application/pdf",
					data : "@url",
					autoSize : true,
					params : {
						src : "@url"
					}
				}, Ext.isIE ? {
					classid : "CLSID:CA8A9780-280D-11CF-A24D-444553540000"
				} : false),
		"PDFFRAME" : {
			tag : "iframe",
			cls : "x-media x-media-pdf-frame",
			frameBorder : 0,
			style : {
				overflow : "none",
				width : "100%",
				height : "100%"
			},
			src : "@url",
			autoSize : true
		},
		"WMV" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-wmv",
					type : "application/x-mplayer2",
					data : "@url",
					autoSize : false,
					params : {
						filename : "@url",
						displaysize : 0,
						autostart : "@start",
						showControls : "@controls",
						showStatusBar : "@status",
						showaudiocontrols : true,
						stretchToFit : true,
						Volume : "@volume",
						PlayCount : 1
					}
				}, Ext.isIE ? {
					classid : "CLSID:22d6f312-b0f6-11d0-94ab-0080c74c7e95",
					codebase : "http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701",
					type : "application/x-oleobject"
				}
						: {
							src : "@url"
						}),
		"SWF" : Ext.apply({
			tag : "object",
			cls : "x-media x-media-swf",
			type : "application/x-shockwave-flash",
			scripting : "sameDomain",
			standby : "Loading..",
			loop : true,
			start : false,
			unsupportedText : {
				cn : ["The Adobe Flash Player is required.", {
							tag : "br"
						}, {
							tag : "a",
							cn : [{
								tag : "img",
								src : "http://www.adobe.com/images/shared/download_buttons/get_flash_player.gif"
							}],
							href : "http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash",
							target : "_flash"
						}]
			},
			params : {
				movie : "@url",
				menu : "@controls",
				play : "@start",
				quality : "high",
				allowscriptaccess : "@scripting",
				allownetworking : "all",
				allowfullScreen : false,
				bgcolor : "#FFFFFF",
				wmode : "opaque",
				loop : "@loop",
				width : "30%",
				height : "30%"
			}
		}, Ext.isIE ? {
			classid : "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
			codebase : "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0"
		}
				: {
					data : "@url"
				}),
		"JWP" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-swf x-media-flv",
					type : "application/x-shockwave-flash",
					data : "@url",
					loop : false,
					start : false,
					params : {
						movie : "@url",
						flashVars : {
							autostart : "@start",
							repeat : "@loop",
							height : "@height",
							width : "@width",
							id : "@id"
						}
					}
				}, Ext.isIE ? {
					classid : "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
					codebase : "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0"
				}
						: false),
		"QT" : Ext.apply({
			tag : "object",
			cls : "x-media x-media-quicktime",
			type : "video/quicktime",
			style : {
				position : "relative",
				"z-index" : 1,
				behavior : "url(#qt_event_source)"
			},
			scale : "aspect",
			unsupportedText : '<a href="http://www.apple.com/quicktime/download/">Get QuickTime</a>',
			scripting : true,
			volume : "50%",
			data : "@url",
			params : {
				src : Ext.isIE ? "@url" : null,
				href : "http://quicktime.com",
				target : "_blank",
				autoplay : "@start",
				targetcache : true,
				cache : true,
				wmode : "transparent",
				controller : "@controls",
				enablejavascript : "@scripting",
				loop : "@loop",
				scale : "@scale",
				volume : "@volume",
				QTSRC : "@url"
			}
		}, Ext.isIE ? {
			classid : "clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B",
			codebase : "http://www.apple.com/qtactivex/qtplugin.cab#version=7,2,1,0"
		}
				: {
					PLUGINSPAGE : "http://www.apple.com/quicktime/download/"
				}),
		"QTEVENTS" : {
			tag : "object",
			id : "qt_event_source",
			cls : "x-media x-media-qtevents",
			type : "video/quicktime",
			params : {},
			classid : "clsid:CB927D12-4FF7-4a9e-A169-56E4B8A75598",
			codebase : "http://www.apple.com/qtactivex/qtplugin.cab#version=7,2,1,0"
		},
		"WPMP3" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-audio x-media-wordpress",
					type : "application/x-shockwave-flash",
					data : "@url",
					start : true,
					loop : false,
					params : {
						movie : "@url",
						width : "@width",
						flashVars : {
							autostart : "@start",
							controller : "@controls",
							enablejavascript : "@scripting",
							loop : "@loop",
							scale : "@scale",
							initialvolume : "@volume",
							width : "@width",
							encode : "no",
							soundFile : ""
						}
					}
				}, Ext.isIE ? {
					classid : "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
				} : false),
		"REAL" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-real",
					type : "audio/x-pn-realaudio",
					data : "@url",
					controls : "imagewindow,all",
					start : false,
					standby : "Loading Real Media Player components...",
					params : {
						src : "@url",
						autostart : "@start",
						center : false,
						maintainaspect : true,
						controller : "@controls",
						controls : "@controls",
						volume : "@volume",
						loop : "@loop",
						console : "_master",
						backgroundcolor : "#000000"
					}
				}, Ext.isIE ? {
					classid : "clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA"
				} : false),
		"SVG" : {
			tag : "object",
			cls : "x-media x-media-img x-media-svg",
			type : "image/svg+xml",
			data : "@url",
			params : {
				src : "@url"
			}
		},
		"GIF" : {
			tag : "img",
			cls : "x-media x-media-img x-media-gif",
			src : "@url"
		},
		"JPEG" : {
			tag : "img",
			cls : "x-media x-media-img x-media-jpeg",
			src : "@url"
		},
		"JP2" : {
			tag : "object",
			cls : "x-media x-media-img x-media-jp2",
			type : "image/jpeg2000-image",
			data : "@url"
		},
		"PNG" : {
			tag : "img",
			cls : "x-media x-media-img x-media-png",
			src : "@url"
		},
		"HTM" : {
			tag : "iframe",
			cls : "x-media x-media-html",
			frameBorder : 0,
			style : {
				overflow : "auto",
				width : "100%",
				height : "100%"
			},
			src : "@url"
		},
		"TXT" : {
			tag : "object",
			cls : "x-media x-media-text",
			type : "text/plain",
			style : {
				overflow : "auto",
				width : "100%",
				height : "100%"
			},
			data : "@url"
		},
		"RTF" : {
			tag : "object",
			cls : "x-media x-media-rtf",
			type : "application/rtf",
			style : {
				overflow : "auto",
				width : "100%",
				height : "100%"
			},
			data : "@url"
		},
		"JS" : {
			tag : "object",
			cls : "x-media x-media-js",
			type : "text/javascript",
			style : {
				overflow : "auto",
				width : "100%",
				height : "100%"
			},
			data : "@url"
		},
		"CSS" : {
			tag : "object",
			cls : "x-media x-media-css",
			type : "text/css",
			style : {
				overflow : "auto",
				width : "100%",
				height : "100%"
			},
			data : "@url"
		},
		"SILVERLIGHT" : {
			tag : "object",
			cls : "x-media x-media-silverlight",
			type : "application/ag-plugin",
			data : "@url",
			params : {
				MinRuntimeVersion : "1.0",
				source : "@url"
			}
		},
		"SILVERLIGHT2" : {
			tag : "object",
			cls : "x-media x-media-silverlight",
			type : "application/x-silverlight-2-b2",
			data : "data:application/x-silverlight-2-b2,",
			params : {
				MinRuntimeVersion : "2.0"
			},
			unsupportedText : '<a href="http://go2.microsoft.com/fwlink/?LinkID=114576&v=2.0"><img style="border-width: 0pt;" alt="Get Microsoft Silverlight" src="http://go2.microsoft.com/fwlink/?LinkID=108181"/></a>'
		},
		"DATAVIEW" : {
			tag : "object",
			cls : "x-media x-media-dataview",
			classid : "CLSID:0ECD9B64-23AA-11D0-B351-00A0C9055D8E",
			type : "application/x-oleobject",
			unsupportedText : "MS Dataview Control is not installed"
		},
		"OWC:XLS" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-xls",
					type : "application/vnd.ms-excel",
					controltype : "excel",
					params : {
						DataType : "CSVURL",
						CSVURL : "@url",
						DisplayTitleBar : true,
						AutoFit : true
					}
				}, Ext.isIE ? {
					codebase : "file:msowc.cab",
					classid : "CLSID:0002E510-0000-0000-C000-000000000046"
				} : false),
		"OWC:CHART" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-xls",
					type : "application/vnd.ms-excel",
					data : "@url",
					params : {
						DataType : "CSVURL"
					}
				}, Ext.isIE ? {
					classid : "CLSID:0002E500-0000-0000-C000-000000000046"
				} : false),
		"OFFICE" : {
			tag : "object",
			cls : "x-media x-media-office",
			type : "application/x-msoffice",
			data : "@url"
		},
		"POWERPOINT" : Ext.apply({
					tag : "object",
					cls : "x-media x-media-ppt",
					type : "application/vnd.ms-powerpoint",
					file : "@url"
				}, Ext.isIE ? {
					classid : "CLSID:EFBD14F0-6BFB-11CF-9177-00805F8813FF"
				} : false),
		"XML" : {
			tag : "iframe",
			cls : "x-media x-media-xml",
			style : {
				overflow : "auto"
			},
			src : "@url"
		},
		"VLC" : {
			tag : "object",
			cls : "x-media x-media-vlc",
			type : "application/x-vlc-plugin",
			version : "VideoLAN.VLCPlugin.2",
			pluginspage : "http://www.videolan.org",
			data : "@url"
		},
		"RDP" : Ext.apply({
			tag : "object",
			cls : "x-media x-media-rdp",
			type : "application/rds",
			unsupportedText : 'Remote Desktop Web Connection ActiveX control is required. <a target="_msd" href="http://go.microsoft.com/fwlink/?linkid=44333">Download it here</a>.',
			params : {
				Server : "@url",
				Fullscreen : false,
				StartConnected : false,
				DesktopWidth : "@width",
				DesktopHeight : "@height"
			}
		}, Ext.isIE ? {
			classid : "CLSID:9059f30f-4eb1-4bd2-9fdc-36f43a218f4a",
			CODEBASE : "msrdp.cab#version=5,2,3790,0"
		} : false)
	};
	var C = /4$/i;
	var D = function(H, F, G) {
		if (H && typeof H.readyState != "undefined") {
			(G || C).test(H.readyState) ? F({
						type : "load"
					}) : D.defer(10, null, [H, F]);
		}
	};
	if (parseFloat(Ext.version) < 2.1) {
		throw "Ext.ux.Media and sub-classes are not License-Compatible with your Ext release.";
	}
	Ext.extend(B, Object, {
		mediaObject : null,
		mediaCfg : null,
		mediaVersion : null,
		requiredVersion : null,
		unsupportedText : null,
		init : function(F) {
			if (F && this.getEl === undefined) {
				Ext.applyIf(F, this);
			}
		},
		initMedia : function() {
			if (!Ext.isIE && this.initialConfig) {
				new B.VisibilityFix({
							mode : this.visibilityCls,
							hideMode : this.hideMode,
							elements : this.visModeTargets || null
						}).init(this);
			}
			if (this.events) {
				this.addEvents("mediarender", "mediaload");
			}
		},
		getMediaType : function(F) {
			return B.mediaTypes[F];
		},
		assert : function(F, G) {
			F = typeof F === "function" ? F.call(F.scope || null) : F;
			return Ext.value(F, G);
		},
		mediaMarkup : function(F, H, R, M) {
			F = F || this.mediaCfg;
			if (!F) {
				return "";
			}
			var J = Ext.apply({
						url : false,
						autoSize : false
					}, F);
			J.url = this.assert(J.url, false);
			if (J.mediaType) {
				var P, G, K = Ext.Element;
				var I = Ext.apply({}, this.getMediaType(this.assert(
								J.mediaType, false)) || false);
				var L = Ext.apply(I.params || {}, J.params || {});
				for (var Q in L) {
					if (L.hasOwnProperty(Q)) {
						J.children || (J.children = []);
						G = this.assert(L[Q], null);
						if (G !== null) {
							J.children.push({
										tag : "param",
										name : Q,
										value : typeof G === "object" ? Ext
												.urlEncode(G) : encodeURI(G)
									});
						}
					}
				}
				delete I.params;
				var N = this.assert(J.unsupportedText || this.unsupportedText
								|| I.unsupportedText, null);
				if (N) {
					J.children || (J.children = []);
					J.children.push(N);
				}
				if (J.style && typeof J.style != "object") {
					throw "Style must be JSON formatted";
				}
				J.style = this.assert(Ext.apply(I.style || {}, J.style || {}),
						{});
				delete I.style;
				J.height = this.assert(R || J.height || I.height
								|| J.style.height, null);
				J.width = this.assert(H || J.width || I.width || J.style.width,
						null);
				J = Ext.apply({
							tag : "object"
						}, J, I);
				if (J.height || J.autoSize) {
					Ext.apply(J.style, {
								height : K.addUnits(J.autoSize
												? "100%"
												: J.height,
										K.prototype.defaultUnit)
							});
				}
				if (J.width || J.autoSize) {
					Ext.apply(J.style, {
								width : K.addUnits(J.autoSize
												? "100%"
												: J.width,
										K.prototype.defaultUnit)
							});
				}
				J.id || (J.id = Ext.id());
				J.name = this.assert(J.name, J.id);
				var O = {
					url : J.url || "",
					height : (/%$/.test(J.height)) ? J.height : parseInt(
							J.height, 10)
							|| 100,
					width : (/%$/.test(J.width)) ? J.width : parseInt(J.width,
							10)
							|| 100,
					scripting : this.assert(J.scripting, false),
					controls : this.assert(J.controls, false),
					scale : this.assert(J.scale, 1),
					status : this.assert(J.status, false),
					start : this.assert(J.start, false),
					loop : this.assert(J.loop, false),
					volume : this.assert(J.volume, 20),
					id : J.id
				};
				delete J.url;
				delete J.mediaType;
				delete J.controls;
				delete J.status;
				delete J.start;
				delete J.loop;
				delete J.scale;
				delete J.scripting;
				delete J.volume;
				delete J.autoSize;
				delete J.params;
				delete J.unsupportedText;
				delete J.renderOnResize;
				delete J.listeners;
				delete J.height;
				delete J.width;
				return Ext.DomHelper.markup(J).replace(/(%40url|@url)/g, O.url)
						.replace(/(%40start|@start)/g, O.start + "").replace(
								/(%40controls|@controls)/g, O.controls + "")
						.replace(/(%40scale|@scale)/g, O.scale + "").replace(
								/(%40status|@status)/g, O.status + "").replace(
								/(%40id|@id)/g, O.id + "").replace(
								/(%40loop|@loop)/g, O.loop + "").replace(
								/(%40volume|@volume)/g, O.volume + "").replace(
								/(%40scripting|@scripting)/g, O.scripting + "")
						.replace(/(%40width|@width)/g, O.width + "").replace(
								/(%40height|@height)/g, O.height + "");
			} else {
				var N = this.assert(J.unsupportedText || this.unsupportedText
								|| I.unsupportedText, null);
				N = N ? Ext.DomHelper.markup(N) : null;
				return String.format(N || "Media Configuration/Plugin Error",
						" ", " ");
			}
		},
		setMask : function(F) {
			if (this.mediaMask && !this.mediaMask.enable) {
				F = Ext.get(F);
				if (this.mediaMask = new Ext.ux.IntelliMask(F
								|| this[this.mediaEl], Ext.apply({
									fixElementForMedia : true
								}, this.mediaMask))) {
					this.mediaMask.el.addClass("x-media-mask");
				}
			}
		},
		renderMedia : function(L, H, K, F, I) {
			if (!Ext.isReady) {
				Ext.onReady(this.renderMedia.createDelegate(this,
						Array.prototype.slice.call(arguments, 0)));
				return;
			}
			var J = (this.mediaCfg = L || this.mediaCfg);
			H = Ext.get(H
					|| this.lastCt
					|| (this.mediaObject
							? this.mediaObject.dom.parentNode
							: null));
			this.onBeforeMedia.call(this, J, H, K, F, I);
			if (H) {
				this.lastCt = H;
				var G;
				if (J && (G = this.mediaMarkup(J, F, I, H))) {
					this.setMask(H);
					this.clearMedia();
					H.update(G);
					if (this.mediaMask && this.autoMask) {
						this.mediaMask.show();
					}
				}
			}
			this.onAfterMedia(H);
		},
		clearMedia : function() {
			if (Ext.isReady && this.mediaObject) {
				try {
					this.mediaObject.removeAllListeners();
					this.mediaObject.remove();
				} catch (F) {
				}
			}
			this.mediaObject = null;
		},
		onBeforeMedia : function(J, H, I) {
			var F = J || this.mediaCfg, G;
			if (F && (G = this.getMediaType(F.mediaType))) {
				F.autoSize = F.autoSize || G.autoSize === true;
				if (F.autoSize
						&& (H = Ext.isReady ? Ext.get(H || this.lastCt) : null)) {
					F.height = H.getHeight(true)
							|| this.assert(F.height, "auto");
					F.width = H.getWidth(true) || this.assert(F.width, "auto");
				}
			}
		},
		onMediaLoad : function(F) {
			if (F && F.type == "load") {
				this.fireEvent("mediaload", this, this.mediaObject);
				if (this.mediaMask && this.autoMask) {
					this.mediaMask.hide();
				}
			}
		},
		onAfterMedia : function(G) {
			if (this.mediaCfg && G && (this.mediaObject = G.child(".x-media"))) {
				this.mediaObject.ownerCt = this;
				if (this.mediaCfg.tag !== "object") {
					this.mediaObject.on({
								load : this.onMediaLoad,
								scope : this,
								single : true
							});
				}
				D(this.mediaObject.dom, this.onMediaLoad.createDelegate(this));
				var F;
				if (F = this.mediaCfg.listeners || null) {
					this.mediaObject.on(F);
				}
				this.fireEvent("mediarender", this, this.mediaObject);
			}
		},
		getInterface : function() {
			return this.mediaObject ? this.mediaObject.dom || null : null;
		},
		detectVersion : Ext.emptyFn,
		autoMask : Ext.isIE
	});
	var E = function() {
	};
	Ext.extend(E, Object, {
				hideMode : !Ext.isIE ? "nosize" : "display",
				animCollapse : Ext.enableFx && Ext.isIE,
				animFloat : Ext.enableFx && Ext.isIE,
				visibilityCls : !Ext.isIE ? "x-hide-nosize" : null,
				autoScroll : true,
				shadow : false,
				bodyStyle : {
					position : "relative"
				},
				resizeMedia : function(G, F, H) {
					var I = this.mediaCfg;
					if (I && this.boxReady) {
						if (arguments.length > 3
								&& (!this.mediaObject || I.renderOnResize)) {
							this.refreshMedia(this[this.mediaEl]);
						}
					}
				},
				onAfterRender : function(F) {
					if (this.mediaCfg.renderOnResize) {
						this.on("resize", this.resizeMedia, this);
					} else {
						this.renderMedia(this.mediaCfg, this[this.mediaEl]
										|| this.getEl());
					}
				},
				doAutoLoad : Ext.emptyFn,
				refreshMedia : function(F) {
					if (this.mediaCfg) {
						this.renderMedia(null, F);
					}
				},
				mediaMask : false
			});
	Ext.ux.MediaComponent = Ext.extend(Ext.BoxComponent, {
		ctype : "Ext.ux.MediaComponent",
		autoEl : "div",
		cls : "x-media-comp",
		mediaEl : "el",
		getId : function() {
			return this.id
					|| (this.id = "media-comp" + (++Ext.Component.AUTO_ID));
		},
		initComponent : function() {
			this.visModeTargets = [this.actionMode];
			this.initMedia();
			Ext.ux.MediaComponent.superclass.initComponent.apply(this,
					arguments);
		},
		onRender : function() {
			Ext.ux.MediaComponent.superclass.onRender.apply(this, arguments);
			this.onAfterRender();
		},
		afterRender : function(F) {
			this.setAutoScroll();
			Ext.ux.MediaComponent.superclass.afterRender.apply(this, arguments);
		},
		beforeDestroy : function() {
			this.clearMedia();
			Ext.destroy(this.mediaMask, this.loadMask);
			Ext.ux.MediaComponent.superclass.beforeDestroy.call(this);
		},
		setAutoScroll : function() {
			if (this.rendered && this.autoScroll) {
				this.getEl().setOverflow("auto");
			}
		}
	});
	Ext.apply(Ext.ux.MediaComponent.prototype, Ext.ux.Media.prototype);
	Ext.apply(Ext.ux.MediaComponent.prototype, E.prototype);
	Ext.reg("media", Ext.ux.MediaComponent);
	B.Panel = Ext.extend(Ext.Panel, {
				ctype : "Ext.ux.Media.Panel",
				cls : "x-media-panel",
				mediaEl : "body",
				initComponent : function() {
					this.visModeTargets = [this.collapseEl,
							this.floating ? null : this.actionMode];
					this.initMedia();
					this.html = this.contentEl = this.items = null;
					B.Panel.superclass.initComponent.call(this);
				},
				onRender : function() {
					B.Panel.superclass.onRender.apply(this, arguments);
					this.onAfterRender();
				},
				beforeDestroy : function() {
					this.clearMedia();
					B.Panel.superclass.beforeDestroy.call(this);
				}
			});
	Ext.apply(B.Panel.prototype, B.prototype);
	Ext.apply(B.Panel.prototype, E.prototype);
	Ext.reg("mediapanel", Ext.ux.MediaPanel = B.Panel);
	B.Window = Ext.extend(Ext.Window, {
				cls : "x-media-window",
				ctype : "Ext.ux.Media.Window",
				mediaEl : "body",
				initComponent : function() {
					this.visModeTargets = [this.collapseEl,
							this.floating ? null : this.actionMode];
					this.initMedia();
					this.html = this.contentEl = this.items = null;
					B.Window.superclass.initComponent.call(this);
				},
				onRender : function() {
					B.Window.superclass.onRender.apply(this, arguments);
					this.onAfterRender();
				},
				beforeDestroy : function() {
					this.clearMedia();
					B.Window.superclass.beforeDestroy.call(this);
				}
			});
	Ext.apply(B.Window.prototype, B.prototype);
	Ext.apply(B.Window.prototype, E.prototype);
	Ext.reg("mediawindow", Ext.ux.MediaWindow = B.Window);
	Ext.onReady(function() {
		var F = Ext.util.CSS, G = [];
		F.getRule(".x-media")
				|| (G
						.push(".x-media{width:100%;height:100%;display:block;overflow:none;outline:none;}"));
		F.getRule(".x-media-mask")
				|| (G
						.push(".x-media-mask{width:100%;height:100%;position:relative;zoom:1;}"));
		F.getRule(".x-media-img")
				|| (G
						.push(".x-media-img{background-color:transparent;width:auto;height:auto;zoom:1;}"));
		F.getRule(".x-hide-nosize")
				|| (G
						.push(".x-hide-nosize,.x-hide-nosize *{height:0px!important;width:0px!important;border:none!important;}"));
		if (!!G.length) {
			F.createStyleSheet(G.join(""));
		}
	});
	Ext.apply(Ext.Element.prototype, {
		setVisible : function(I, F) {
			if (!F || !Ext.lib.Anim) {
				if (this.visibilityMode === Ext.Element.DISPLAY) {
					this.setDisplayed(I);
				} else {
					if (this.visibilityMode === Ext.Element.VISIBILITY) {
						this.fixDisplay();
						this.dom.style.visibility = I ? "visible" : "hidden";
					} else {
						this[I ? "removeClass" : "addClass"](String(this.visibilityMode));
					}
				}
			} else {
				var H = this.dom;
				var G = this.visibilityMode;
				if (I) {
					this.setOpacity(0.01);
					this.setVisible(true);
				}
				this.anim({
							opacity : {
								to : (I ? 1 : 0)
							}
						}, this.preanim(arguments, 1), null, 0.35, "easeIn",
						function() {
							if (!I) {
								if (G === Ext.Element.DISPLAY) {
									H.style.display = "none";
								} else {
									if (G === Ext.Element.VISIBILITY) {
										H.style.visibility = "hidden";
									} else {
										Ext.get(H).addClass(String(G));
									}
								}
								Ext.get(H).setOpacity(1);
							}
						});
			}
			return this;
		},
		isVisible : function(F) {
			var G = !(this.getStyle("visibility") === "hidden"
					|| this.getStyle("display") === "none" || this
					.hasClass(this.visibilityMode));
			if (F !== true || !G) {
				return G;
			}
			var H = this.dom.parentNode;
			while (H && H.tagName.toLowerCase() !== "body") {
				if (!Ext.fly(H, "_isVisible").isVisible()) {
					return false;
				}
				H = H.parentNode;
			}
			return true;
		}
	});
	var A = {
		mask : function(J, H, G) {
			if (this.getStyle("position") == "static") {
				this.setStyle("position", "relative");
			}
			if (this._maskMsg) {
				this._maskMsg.remove();
			}
			this._mask || (this._mask = Ext.DomHelper.append(this.dom, {
						cls : G || "ext-el-mask"
					}, true));
			!Ext.isIE || this.addClass("x-masked");
			this._mask.setVisible(true);
			if (typeof J == "string") {
				var I = this._maskMsg = Ext.DomHelper.append(this.dom, {
							cls : "ext-el-mask-msg " + H || "",
							style : {
								visibility : "hidden"
							},
							cn : {
								tag : "div",
								html : J
							}
						}, true);
				var F = this.dom;
				(function() {
					try {
						I.center(F).setVisible(true);
					} catch (K) {
					}
				}).defer(4);
			}
			if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict)
					&& this.getStyle("height") == "auto") {
				this._mask.setSize(this.dom.clientWidth, this.getHeight());
			}
			return this._mask;
		},
		unmask : function(F) {
			if (this._maskMsg) {
				if (F) {
					this._maskMsg.remove();
					delete this._maskMsg;
				} else {
					this._maskMsg.setVisible.defer(4, this._maskMsg, [false]);
				}
			}
			if (this._mask) {
				if (F) {
					this._mask.remove();
					delete this._mask;
				} else {
					this._mask.setVisible(false);
				}
			}
			this.removeClass("x-masked");
		}
	};
	B.VisibilityFix = function(F) {
		F || (F = {});
		this.init = function(G) {
			G.hideMode = F.hideMode || G.hideMode;
			G.on("render", function(K) {
						var H = [K.collapseEl,
								(K.floating ? null : K.actionMode)]
								.concat(F.elements || []);
						var I = Ext.Element;
						var J = F.mode || K.visibilityCls
								|| I[K.hideMode.toUpperCase()] || I.VISIBILITY;
						Ext.each(H, function(L) {
									var M = K[L] || L;
									if (M && M.setVisibilityMode) {
										M.setVisibilityMode(J);
									}
								});
					}, G, {
						single : true
					});
		};
	};
	Ext.ux.IntelliMask = function(G, F) {
		Ext.apply(this, F);
		this.el = Ext.get(G);
		this.removeMask = Ext.value(this.removeMask, true);
		if (G && this.fixElementForMedia) {
			Ext.apply(G, A);
		}
	};
	Ext.ux.IntelliMask.prototype = {
		msg : "Loading Media...",
		msgCls : "x-mask-loading",
		zIndex : null,
		disabled : false,
		active : false,
		autoHide : false,
		disable : function() {
			this.disabled = true;
		},
		enable : function() {
			this.disabled = false;
		},
		show : function(L, K, J, H) {
			if (this.disabled || !this.el) {
				return null;
			}
			var I = {}, F = this.autoHide;
			H = parseInt(H, 10) || 20;
			if (typeof L == "object") {
				I = L;
				L = I.msg;
				K = I.msgCls;
				J = I.fn;
				F = typeof I.autoHide != "undefined" ? I.autoHide : F;
				H = I.fnDelay || H;
			}
			var G = this.el.mask(L || this.msg, K || this.msgCls);
			this.active = !!this.el._mask;
			if (this.active) {
				if (this.zIndex) {
					this.el._mask.setStyle("z-index", this.zIndex);
					if (this.el._maskMsg) {
						this.el._maskMsg.setStyle("z-index", this.zIndex + 1);
					}
				}
			}
			if (typeof J === "function") {
				J.defer(H, I.scope || null);
			} else {
				H = 0;
			}
			if (F && (F = parseInt(F, 10) || 2000)) {
				this.hide.defer(F + (H || 0), this);
			}
			return this.active ? {
				mask : this.el._mask,
				maskMsg : this.el._maskMsg
			} : null;
		},
		hide : function(F) {
			if (this.el) {
				this.el.unmask(F || this.removeMask);
			}
			this.active = false;
			return this;
		},
		destroy : function() {
			this.hide(true);
			this.el = null;
		}
	};
})();