/**
 * @class Ext.ux.MediaFlash Version: 2.0 Author: Doug Hendricks.
 *        doug[always-At]theactivegroup.com Copyright 2007-2008, Active Group,
 *        Inc. All rights reserved.
 * 
 * ***********************************************************************************
 * This file is distributed on an AS IS BASIS WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ***********************************************************************************
 * 
 * License: Ext.ux.MediaFlash is licensed under the terms of : GNU Open Source
 * GPL 3.0 license:
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see < http://www.gnu.org/licenses/gpl.html>.
 * 
 * Donations are welcomed: http://donate.theactivegroup.com Commercial use is
 * prohibited without a Commercial License. See
 * http://licensing.theactivegroup.com.
 */
(function() {
	var A = Ext.ux.Media;
	A.Flash = Ext.extend(A, {
		constructor : function() {
			A.Flash.superclass.constructor.apply(this, arguments);
		},
		SWFObject : null,
		varsName : "flashVars",
		hideMode : "nosize",
		mediaType : Ext.apply({
			tag : "object",
			cls : "x-media x-media-swf",
			type : "application/x-shockwave-flash",
			loop : null,
			scripting : "sameDomain",
			start : true,
			unsupportedText : {
				cn : ["The Adobe Flash Player{0}is required.", {
							tag : "br"
						}, {
							tag : "a",
							cn : [{
								tag : "img",
								src : "http://www.adobe.com/images/shared/download_buttons/get_flash_player.gif"
							}],
							href : "http://www.adobe.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash",
							target : "_flash"
						}]
			},
			params : {
				movie : "@url",
				play : "@start",
				loop : "@loop",
				menu : "@controls",
				quality : "high",
				bgcolor : "#FFFFFF",
				wmode : "opaque",
				allowscriptaccess : "@scripting",
				allowfullscreen : false,
				allownetworking : "all"
			}
		}, Ext.isIE ? {
			classid : "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
			codebase : "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0"
		}
				: {
					data : "@url"
				}),
		getMediaType : function() {
			return this.mediaType;
		},
		initMedia : function() {
			var J = Ext.apply({}, this.mediaCfg || {});
			var H = (this.requiredVersion = J.requiredVersion
					|| this.requiredVersion || false);
			var C = !!(this.playerVersion = this.detectVersion());
			var F = C && (H ? this.assertVersion(H) : true);
			var E = this.assert(J.unsupportedText || this.unsupportedText
							|| (this.getMediaType() || {}).unsupportedText,
					null);
			if (E) {
				E = Ext.DomHelper.markup(E);
				E = J.unsupportedText = String
						.format(E, (H ? " " + H + " " : " "),
								(this.playerVersion ? " " + this.playerVersion
										+ " " : " Not installed."));
			}
			if (!F) {
				this.autoMask = false;
				var D = C && this.assertVersion("6.0.65");
				if (D && J.installUrl) {
					J = J.installDescriptor || {
						tag : "object",
						cls : "x-media x-media-swf x-media-swfinstaller",
						id : "SWFInstaller",
						type : "application/x-shockwave-flash",
						data : "@url",
						url : J.installUrl,
						width : (/%$/.test(J.width)) ? J.width : ((parseInt(
								J.width, 10) || 0) < 310 ? 310 : J.width),
						height : (/%$/.test(J.height)) ? J.height : ((parseInt(
								J.height, 10) || 0) < 138 ? 138 : J.height),
						loop : false,
						start : true,
						unsupportedText : E,
						params : {
							quality : "high",
							movie : "@url",
							allowscriptacess : "always",
							align : "middle",
							bgcolor : "#3A6EA5",
							pluginspage : J.pluginsPage || this.pluginsPage
									|| "http://www.adobe.com/go/getflashplayer"
						}
					};
					J.params[this.varsName] = "MMredirectURL="
							+ (J.installRedirect || window.location)
							+ "&MMplayerType="
							+ (Ext.isIE ? "ActiveX" : "Plugin")
							+ "&MMdoctitle="
							+ (document.title = document.title.slice(0, 47)
									+ " - Flash Player Installation");
				} else {
					J.mediaType = null;
				}
			}
			if (J.eventSynch) {
				J.params || (J.params = {});
				var I = J.params[this.varsName]
						|| (J.params[this.varsName] = {});
				if (typeof I === "string") {
					I = Ext.urlDecode(I, true);
				}
				var G = (J.eventSynch === true ? {
					allowedDomain : I.allowedDomain
							|| document.location.hostname,
					elementID : J.id || (J.id = Ext.id()),
					eventHandler : "Ext.ux.Media.Flash.eventSynch"
				} : J.eventSynch);
				Ext.apply(J.params, {
							allowscriptaccess : "always"
						})[this.varsName] = Ext.applyIf(I, G);
			}
			delete J.requiredVersion;
			delete J.installUrl;
			delete J.installRedirect;
			delete J.installDescriptor;
			delete J.eventSynch;
			J.mediaType = "SWF";
			this.mediaCfg = J;
			if (this.events) {
				this.addEvents("flashinit", "fscommand");
			}
			A.Flash.superclass.initMedia.call(this);
		},
		assertVersion : function(E) {
			var D;
			E || (E = []);
			if (Ext.isArray(E)) {
				D = E;
			} else {
				D = String(E).split(".");
			}
			D = (D.concat([0, 0, 0, 0])).slice(0, 3);
			var C;
			if (!(C = this.playerVersion
					|| (this.playerVersion = this.detectVersion()))) {
				return false;
			}
			if (C.major > parseFloat(D[0])) {
				return true;
			} else {
				if (C.major == parseFloat(D[0])) {
					if (C.minor > parseFloat(D[1])) {
						return true;
					} else {
						if (C.minor == parseFloat(D[1])) {
							if (C.rev >= parseFloat(D[2])) {
								return true;
							}
						}
					}
				}
			}
			return false;
		},
		detectVersion : function() {
			if (this.mediaVersion) {
				return this.mediaVersion;
			}
			var C = false;
			var D = function(I) {
				return I && !!I.length ? {
					major : I[0] !== null ? parseInt(I[0], 10) : 0,
					minor : I[1] !== null ? parseInt(I[1], 10) : 0,
					rev : I[2] !== null ? parseInt(I[2], 10) : 0,
					toString : function() {
						return this.major + "." + this.minor + "." + this.rev;
					}
				} : false;
			};
			var G = null;
			if (Ext.isIE) {
				try {
					G = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.7");
				} catch (H) {
					try {
						G = new ActiveXObject("ShockwaveFlash.ShockwaveFlash.6");
						C = [6, 0, 21];
						G.allowscriptaccess = "always";
					} catch (E) {
						if (C && C[0] === 6) {
							return D(C);
						}
					}
					try {
						G = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");
					} catch (F) {
					}
				}
				if (G) {
					C = G.GetVariable("$version").split(" ")[1].split(",");
				}
			} else {
				if (navigator.plugins && navigator.mimeTypes.length) {
					G = navigator.plugins["Shockwave Flash"];
					if (G && G.description) {
						C = G.description.replace(/([a-zA-Z]|\s)+/, "")
								.replace(/(\s+r|\s+b[0-9]+)/, ".").split(".");
					}
				}
			}
			return (this.mediaVersion = D(C));
		},
		_applyFixes : function() {
			var D;
			if (Ext.isIE && Ext.isWindows && (D = this.SWFObject)) {
				D.style.display = "none";
				if (D.readyState == 4) {
					for (var C in D) {
						if (typeof D[C] == "function") {
							D[C] = null;
						}
					}
				}
			}
		},
		onAfterMedia : function(C) {
			A.Flash.superclass.onAfterMedia.apply(this, arguments);
			this.SWFObject = this.getInterface();
			if (this.mediaObject) {
				var D = this.mediaObject.id;
				if (Ext.isIE) {
					if (!(Ext.query("script[for=" + D + "]").length)) {
						B(
								'var c;if(c=Ext.getCmp("'
										+ this.id
										+ '")){c.onfsCommand.apply(c,arguments);}',
								{
									event : "FSCommand",
									htmlFor : D
								});
					}
				} else {
					window[D + "_DoFSCommand"]
							|| (window[D + "_DoFSCommand"] = this.onfsCommand
									.createDelegate(this));
				}
			}
		},
		clearMedia : function() {
			if (this.mediaObject) {
				var C = this.mediaObject.id;
				if (Ext.isIE) {
					Ext.select("script[for=" + C + "]", true).remove();
				} else {
					window[C + "_DoFSCommand"] = null;
					delete window[C + "_DoFSCommand"];
				}
				this._applyFixes();
			}
			A.Flash.superclass.clearMedia.call(this);
			this.SWFObject = null;
		},
		getSWFObject : function() {
			return this.getInterface();
		},
		onfsCommand : function(D, C) {
			if (this.events) {
				this.fireEvent("fscommand", this, D, C);
			}
		},
		setVariable : function(D, E) {
			var C = this.getInterface();
			if (C && typeof C.SetVariable != "undefined") {
				C.SetVariable(D, E);
				return true;
			}
			return false;
		},
		getVariable : function(D) {
			var C = this.getInterface();
			if (C && typeof C.GetVariable != "undefined") {
				return C.GetVariable(D);
			}
			return undefined;
		},
		onFlashInit : function() {
			if (this.mediaMask && this.autoMask) {
				this.mediaMask.hide();
			}
			this.fireEvent.defer(10, this, ["flashinit", this,
							this.getInterface()]);
		},
		_handleSWFEvent : function(D) {
			var C = D.type || D || false;
			if (C) {
				if (this.events && !this.events[String(C)]) {
					this.addEvents(String(C));
				}
				return this.fireEvent.apply(this, [String(C), this]
								.concat(Array.prototype.slice
										.call(arguments, 0)));
			}
		}
	});
	A.Flash.eventSynch = function(C, E) {
		var D = Ext.get(C);
		if (D && D.ownerCt) {
			return D.ownerCt._handleSWFEvent.apply(D.ownerCt,
					Array.prototype.slice.call(arguments, 1));
		}
	};
	Ext.ux.FlashComponent = Ext.extend(Ext.ux.MediaComponent, {
				ctype : "Ext.ux.FlashComponent",
				getId : function() {
					return this.id
							|| (this.id = "flash-comp"
									+ (++Ext.Component.AUTO_ID));
				}
			});
	Ext.apply(Ext.ux.FlashComponent.prototype, A.Flash.prototype);
	Ext.reg("uxflash", Ext.ux.FlashComponent);
	A.Panel.Flash = Ext.extend(A.Panel, {
				ctype : "Ext.ux.Media.Panel.Flash"
			});
	Ext.apply(A.Panel.Flash.prototype, A.Flash.prototype);
	Ext.reg("flashpanel",
			Ext.ux.MediaPanel.Flash = Ext.ux.FlashPanel = A.Panel.Flash);
	Ext.reg("uxflashpanel", A.Panel.Flash);
	Ext.ux.FlashWindow = (A.Window.Flash = Ext.extend(A.Window, {
				ctype : "Ext.ux.FlashWindow",
				animCollapse : Ext.isIE
			}));
	Ext.apply(A.Window.Flash.prototype, A.Flash.prototype);
	var B = function(I, D) {
		D = Ext.apply({}, D || {}, {
					type : "text/javascript",
					text : I
				});
		try {
			var F, C, H = document;
			if (H && H.getElementsByTagName) {
				if (!(F = H.getElementsByTagName("head")[0])) {
					F = H.createElement("head");
					H.getElementsByTagName("html")[0].appendChild(F);
				}
				if (F && (C = H.createElement("script"))) {
					for (var G in D) {
						if (D.hasOwnProperty(G) && G in C) {
							C[G] = D[G];
						}
					}
					return !!F.appendChild(C);
				}
			}
		} catch (E) {
		}
		return false;
	};
})();