UxGrid = Ext.extend(Ext.grid.GridPanel, {
	frame : true,
	viewConfig : {
		forceFit : true
	},
	loadMask : {
		msg : '正在载入数据,请稍候...'
	},
	initComponent : function() {
		UxGrid.superclass.initComponent.call(this);
	},
	initEvents : function() {
		UxGrid.superclass.initEvents.call(this);
	},
	selectedRecord : function() {
		var record = this.getSelectionModel().getSelected();
		return record;
	},
	refresh : function() {
		this.getView().refresh();
	},
	remove : function(record) {
		this.getStore().remove(record);
	},
	createCombo : function(id, name, url, width) { // 生成一个通用的ComboBox
		var combo = new Ext.form.ComboBox({
			emptyText : '请选择...',
			isFormField : true,
			mode : 'local',
			triggerAction : 'all',
			width : width,
			readOnly : true,
			displayField : name,
			valueField : id,
			store : new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({
					url : url,
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({},
						new Ext.data.Record.create([ {
							name : id
						}, {
							name : name
						} ]))
			})
		});
		return combo;
	},

	createCombo1 : function(id, name, url, root, width) { // 生成一个通用的ComboBox
		var combo = new Ext.form.ComboBox({
			emptyText : '请选择...',
			isFormField : true,
			mode : 'local',
			triggerAction : 'all',
			width : width,
			readOnly : true,
			displayField : name,
			valueField : id,
			store : new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({
					url : url,
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
					root : root
				}, new Ext.data.Record.create([ {
					name : id
				}, {
					name : name
				} ]))
			})
		});
		return combo;
	},
	createCombo2 : function(fieldLabel, hiddenName, id, name, anchor, url,
			root, totalProperty, allowblank) { // 生成一个通用的ComboBox
		var combo = new Ext.form.ComboBox({
			fieldLabel : fieldLabel,
			emptyText : '请选择...',
			isFormField : true,
			anchor : anchor,
			mode : 'local',
			hiddenName : hiddenName,
			allowBlank : allowblank,
			blankText : '请选择...',
			// forceSelection: true,
			lastQuery : '',
			triggerAction : 'all',
			displayField : name,
			valueField : id,
			store : new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({
					url : url,
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({
					totalProperty : totalProperty,
					root : root
				}, new Ext.data.Record.create([ {
					name : id
				}, {
					name : name
				} ]))
			}),
			readOnly : true
		});
		return combo;
	},
	createMemoryCombo4AllowBlank : function(fieldLabel, id, name, anchor,
			jsonData, allowBlank, comboName) {
		var combo = new Ext.form.ComboBox({
			fieldLabel : fieldLabel,
			emptyText : '请选择...',
			isFormField : true,
			anchor : anchor,
			mode : 'local',
			hiddenName : comboName,
			allowBlank : allowBlank,
			blankText : '请选择...',
			forceSelection : true,
			triggerAction : 'all',
			displayField : name,
			valueField : id,
			store : new Ext.data.Store({
				proxy : new Ext.data.MemoryProxy(jsonData),
				reader : new Ext.data.JsonReader({},
						new Ext.data.Record.create([ {
							name : id
						}, {
							name : name
						} ]))
			}),
			readOnly : true
		});
		return combo;
	},
	createTextFiled : function(name, width) { // 生成一个通用的TextField
		var tf = new Ext.form.TextField({
			name : name,
			xtype : 'textfield',
			readOnly : false,
			width : width,
			blankText : '该选项为必填项,请输入内容...'
		});
		return tf;
	},
	createTextField : function(fieldLabel, name, anchor, inputType, maxLength,
			blankText, vtype, maxLengthText) { // 生成一个通用的TextField
		var tf = new Ext.form.TextField({
			fieldLabel : fieldLabel,
			name : name,
			xtype : 'textfield',
			readOnly : false,
			allowBlank : true,
			anchor : anchor,
			blankText : '该选项为必填项,请输入内容...',
			vtype : vtype,
			inputType : inputType,
			maxLength : maxLength,
			maxLengthText : maxLengthText
		});
		return tf;
	}
});
