Ext.namespace("Ext.ux");

Ext.apply(Ext.form.TextField.prototype, {
	validator : function(text) {
		if (this.allowBlank == false && Ext.util.Format.trim(text).length == 0)
			return false;
		else
			return true;
	}
});

Ext.override(Ext.form.TextField,
		{ // 区别汉字和英文的长度
			validateValue : function(value) {

				var strLen = this.countStrLen(value);

				if (value.length < 1 || value === this.emptyText) { // if it's
																	// blank
					if (this.allowBlank) {
						this.clearInvalid();
						return true;
					} else {
						this.markInvalid(this.blankText);
						return false;
					}
				}
				if (value.length < this.minLength) {
					this.markInvalid(String.format(this.minLengthText,
							this.minLength));
					return false;
				}
				if (strLen > this.maxLength) {
					this.markInvalid(String.format(this.maxLengthText,
							this.maxLength));
					return false;
				}
				if (this.vtype) {
					var vt = Ext.form.VTypes;
					if (!vt[this.vtype](value, this)) {
						this.markInvalid(this.vtypeText
								|| vt[this.vtype + 'Text']);
						return false;
					}
				}
				if (typeof this.validator == "function") {
					var msg = this.validator(value);
					if (msg !== true) {
						this.markInvalid(msg);
						return false;
					}
				}
				if (this.regex && !this.regex.test(value)) {
					this.markInvalid(this.regexText);
					return false;
				}
				return true;
			},
			countStrLen : function(strTemp) { // 计算字符串的长度,区分英文和汉字
				var i, sum;
				sum = 0;
				for (i = 0; i < strTemp.length; i++) {
					if ((strTemp.charCodeAt(i) >= 0)
							&& (strTemp.charCodeAt(i) <= 255))
						sum = sum + 1;
					else
						sum = sum + 2;
				}
				return sum;
			}
		});

Ext.ux.Form = Ext
		.extend(
				Ext.form.FormPanel,
				{
					frame : true,
					bodyStyle : "padding: 5px 5px 0",
					initComponent : function() {
						Ext.ux.Form.superclass.initComponent.call(this);
					},
					initEvents : function() {
						Ext.ux.Form.superclass.initEvents.call(this);
					},
					createButton : function(text, handler) {
						var btn = new Ext.Button({
							text : text,
							handler : handler
						});
						return btn;
					},
					createTextFiled : function(fieldLabel, name, anchor,
							blankText, vtype, maxLength, maxLengthText) { // 生成一个通用的TextField
						var tf = new Ext.form.TextField({
							fieldLabel : fieldLabel,
							name : name,
							xtype : 'textfield',
							readOnly : false,
							allowBlank : false,
							anchor : anchor,
							blankText : '该选项为必填项,请输入内容...',
							vtype : vtype,
							maxLength : maxLength,
							maxLengthText : maxLengthText
						});
						return tf;
					},
					createTextField : function(fieldLabel, name, anchor,
							inputType, maxLength, blankText, vtype,
							maxLengthText) { // 生成一个通用的TextField
						var tf = new Ext.form.TextField({
							fieldLabel : fieldLabel,
							name : name,
							xtype : 'textfield',
							readOnly : false,
							allowBlank : true,
							anchor : anchor,
							blankText : '该选项为必填项,请输入内容...',
							vtype : vtype,
							inputType : inputType,
							maxLength : maxLength,
							maxLengthText : maxLengthText
						});
						return tf;
					},
					createRadio : function(boxLabel, name, checked, inputValue,
							width) { // 生成一个通用的Radio
						var radio = new Ext.form.Radio({
							boxLabel : boxLabel,
							checked : checked,
							name : name,
							labelSeparator : "",
							inputValue : inputValue,
							anchor : "90%",
							width : width
						});
						return radio;
					},
					createCombo : function(fieldLabel, id, name, anchor, url,
							extra1, extra2) { // 生成一个通用的ComboBox
						var combo = new Ext.form.ComboBox({
							autoLoad : true,
							fieldLabel : fieldLabel,
							emptyText : '请选择...',
							isFormField : true,
							anchor : anchor,
							mode : 'local',
							name : id,
							// hiddenName: name,
							allowBlank : false,
							blankText : '请选择...',
							// forceSelection: true,
							lastQuery : '',
							triggerAction : 'all',
							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.HttpProxy({
									url : url,
									method : 'POST'
								}),
								reader : new Ext.data.JsonReader({},
										new Ext.data.Record.create([ {
											name : id
										}, {
											name : name
										}, {
											name : extra1
										}, {
											name : extra2
										} ]))
							}),
							readOnly : true
						});
						return combo;
					},
					createCombo1 : function(fieldLabel, hiddenName, id, name,
							anchor, url, root, totalProperty) { // 生成一个通用的ComboBox
						var combo = new Ext.form.ComboBox({
							fieldLabel : fieldLabel,
							emptyText : '请选择...',
							isFormField : true,
							anchor : anchor,
							mode : 'local',
							hiddenName : hiddenName,
							allowBlank : false,
							blankText : '请选择...',
							// forceSelection: true,
							lastQuery : '',
							triggerAction : 'all',
							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.HttpProxy({
									url : url,
									method : 'POST'
								}),
								reader : new Ext.data.JsonReader({
									totalProperty : totalProperty,
									root : root
								}, new Ext.data.Record.create([ {
									name : id
								}, {
									name : name
								} ]))
							}),
							readOnly : true
						});
						return combo;
					},
					createCombo2 : function(fieldLabel, hiddenName, id, name,
							anchor, url, root, totalProperty, allowblank) { // 生成一个通用的ComboBox
						var combo = new Ext.form.ComboBox({
							fieldLabel : fieldLabel,
							emptyText : '请选择...',
							isFormField : true,
							anchor : anchor,
							mode : 'local',
							hiddenName : hiddenName,
							allowBlank : allowblank,
							blankText : '请选择...',
							// forceSelection: true,
							lastQuery : '',
							triggerAction : 'all',
							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.HttpProxy({
									url : url,
									method : 'POST'
								}),
								reader : new Ext.data.JsonReader({
									totalProperty : totalProperty,
									root : root
								}, new Ext.data.Record.create([ {
									name : id
								}, {
									name : name
								} ]))
							}),
							readOnly : true
						});
						return combo;
					},
					createComboWr : function(fieldLabel, hiddenName, id, name,
							anchor, url, root, totalProperty) { // 生成一个通用的ComboBox
						var combo = new Ext.form.ComboBox({
							fieldLabel : fieldLabel,
							emptyText : '请选择...',
							isFormField : true,
							anchor : anchor,
							mode : 'local',
							hiddenName : hiddenName,
							allowBlank : false,
							blankText : '请选择...',
							// forceSelection: true,
							lastQuery : '',
							triggerAction : 'all',
							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.HttpProxy({
									url : url,
									method : 'POST'
								}),
								reader : new Ext.data.JsonReader({
									totalProperty : totalProperty,
									root : root
								}, new Ext.data.Record.create([ {
									name : id
								}, {
									name : name
								} ]))
							}),
							readOnly : false
						});
						return combo;
					},
					createMemoryCombo : function(fieldLabel, id, name, anchor,
							jsonData) {
						var combo = new Ext.form.ComboBox({
							fieldLabel : fieldLabel,
							emptyText : '请选择...',
							isFormField : true,
							anchor : anchor,
							mode : 'local',
							hiddenName : id,
							allowBlank : false,
							blankText : '请选择...',
							forceSelection : true,
							triggerAction : 'all',
							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.MemoryProxy(jsonData),
								reader : new Ext.data.JsonReader({},
										new Ext.data.Record.create([ {
											name : id
										}, {
											name : name
										} ]))
							}),
							readOnly : true
						});
						return combo;
					},
					createMemoryCombo4AllowBlank : function(fieldLabel, id,
							name, anchor, jsonData, allowBlank, comboName) {
						var combo = new Ext.form.ComboBox({
							fieldLabel : fieldLabel,
							emptyText : '请选择...',
							isFormField : true,
							anchor : anchor,
							mode : 'local',
							hiddenName : comboName,
							allowBlank : allowBlank,
							blankText : '请选择...',
							forceSelection : true,
							triggerAction : 'all',
							displayField : name,
							valueField : id,
							store : new Ext.data.Store({
								proxy : new Ext.data.MemoryProxy(jsonData),
								reader : new Ext.data.JsonReader({},
										new Ext.data.Record.create([ {
											name : id
										}, {
											name : name
										} ]))
							}),
							readOnly : true
						});
						return combo;
					},
					createTextArea : function(fieldLabel, name, height, anchor) {
						var ta = new Ext.form.TextArea({
							fieldLabel : fieldLabel,
							name : name,
							height : height,
							anchor : anchor,
							allowBlank : false,
							blankText : '该选项为必填项,请输入内容...'
						});
						return ta;
					},
					createTextArea4AllowBlank : function(fieldLabel, name,
							height, anchor, allowBlank) {
						var ta = new Ext.form.TextArea({
							fieldLabel : fieldLabel,
							name : name,
							height : height,
							anchor : anchor,
							allowBlank : allowBlank,
							blankText : '该选项为必填项,请输入内容...'
						});
						return ta;
					},

					createHidden : function(fieldLabel, name) {
						var hidden = new Ext.form.Hidden({
							fieldLabel : fieldLabel,
							name : name
						});
						return hidden;
					},
					createHtmlEditor : function(fieldLabel, anchor) { // 生成一个通用的HtmlEditor
						var he = new Ext.form.HtmlEditor({
							fieldLabel : fieldLabel,
							height : 270,
							anchor : anchor,
							enableLinks : false,
							enableSourceEdit : false,
							fontFamilies : [ '宋体', '隶书', '黑体' ]
						});
						return he;
					},
					createButton : function(text, fn, scope) {
						var btn = new Ext.Button({
							align : 'left',
							text : text,
							handler : fn,
							scope : scope
						});
						return btn;
					},
					createDateField : function(fieldLabel, name, format,
							anchor, minText, value) {
						var df = new Ext.form.DateField({
							fieldLabel : fieldLabel,
							name : name,
							value : value,
							anchor : anchor,
							minText : minText,
							format : format
						});
						return df;
					},
					createDateField4notAllowBlank : function(fieldLabel, name, format,
							anchor, minText, value) {
						var df = new Ext.form.DateField({
							fieldLabel : fieldLabel,
							name : name,
							value : value,
							anchor : anchor,
							minText : minText,
							format : format,
							allowBlank:false
						});
						return df;
					},
					createLabel : function(fieldLabel, text) {
						var label = new Ext.form.Label({
							width : 90,
							height : 40,
							fieldLabel : fieldLabel,
							text : text
						});
						return label;
					},
					createNumberField : function(fieldLabel, name, anchor,
							blankText, vtype, maxLength, maxLengthText) { // 生成一个通用的TextField
						var tf = new Ext.form.NumberField({
							fieldLabel : fieldLabel,
							name : name,
							xtype : 'numbersfield',
							readOnly : false,
							allowBlank : false,
							anchor : anchor,
							blankText : '该选项为必填项,请输入内容...',
							vtype : vtype,
							maxLength : maxLength,
							maxLengthText : maxLengthText
						});
						return tf;
					},
					createTimeField : function(fieldLabel, name, id, width,
							value) {
						var timeField = new Ext.form.DateField({
							fieldLabel : fieldLabel,
							xtype : 'xdatetime',
							name : name,
							id : id,
							width : width,
							allowBlank : true,
							altFormats : 'Y-m-d H:i:s',
							format : 'Y-m-d H:i:s',
							value : value,
							emptyText : '选择一个日期'
						});
						return timeField;
					}
				});

Ext.reg("uxForm", Ext.ux.Form);
