/*
 * Ext JS Library 2.2.1 Copyright(c) 2006-2009, Ext JS, LLC. licensing@extjs.com
 * 
 * http://extjs.com/license
 */

/*
 * Note that this control will most likely remain as an example, and not as a
 * core Ext form control. However, the API will be changing in a future release
 * and so should not yet be treated as a final, stable API at this time.
 */

/**
 * @class Ext.ux.ItemSelector
 * @extends Ext.form.Field A control that allows selection of between two
 *          Ext.ux.MultiSelect controls.
 * 
 * @history 2008-06-19 bpm Original code contributed by Toby Stuart (with
 *          contributions from Robert Williams)
 * 
 * @constructor Create a new ItemSelector
 * @param {Object}
 *            config Configuration options
 */
Ext.ux.ItemSelector = Ext.extend(Ext.form.Field, {
	externalTagId : null, // 对ItemSelector的扩展
	msWidth : 200,
	msHeight : 300,
	hideNavIcons : false,
	imagePath : "",
	iconAddAll : "../javascript/common/multiSelect/addAll.gif",
	iconDelAll : "../javascript/common/multiSelect/deleteAll.gif",
	iconDown : "../javascript/common/multiSelect/down2.gif",
	iconLeft : "../javascript/common/multiSelect/left2.gif",
	iconRight : "../javascript/common/multiSelect/right2.gif",
	iconTop : "../javascript/common/multiSelect/top2.gif",
	iconBottom : "../javascript/common/multiSelect/bottom2.gif",
	drawAddAllIcon : true,
	drawDelAllIcon : true,
	drawLeftIcon : true,
	drawRightIcon : true,
	drawTopIcon : false,
	drawBotIcon : false,
	fromStore : null,
	toStore : null,
	fromData : null,
	toData : null,
	displayField : 0,
	valueField : 1,
	switchToFrom : false,
	allowDup : false,
	focusClass : undefined,
	delimiter : ',',
	readOnly : false,
	toLegend : null,
	fromLegend : null,
	toSortField : null,
	fromSortField : null,
	toSortDir : 'ASC',
	fromSortDir : 'ASC',
	toTBar : null,
	fromTBar : null,
	bodyStyle : null,
	border : false,
	defaultAutoCreate : {
		tag : "div"
	},

	initComponent : function() {
		Ext.ux.ItemSelector.superclass.initComponent.call(this);
		this.addEvents({
					'rowdblclick' : true,
					'change' : true
				});
	},

	onRender : function(ct, position) {
		Ext.ux.ItemSelector.superclass.onRender.call(this, ct, position);

		this.fromMultiselect = new Ext.ux.Multiselect({
					externalTagId: this.externalTagId,
					legend : this.fromLegend,
					delimiter : this.delimiter,
					allowDup : this.allowDup,
					copy : this.allowDup,
					allowTrash : this.allowDup,
					dragGroup : this.readOnly ? null : "drop2-"
							+ this.el.dom.id,
					dropGroup : this.readOnly ? null : "drop2-"
							+ this.el.dom.id + ",drop1-" + this.el.dom.id,
					width : this.msWidth,
					height : this.msHeight,
					dataFields : this.dataFields,
					data : this.fromData,
					displayField : this.displayField,
					valueField : this.valueField,
					store : this.fromStore,
					isFormField : false,
					tbar : this.fromTBar,
					appendOnly : true,
					sortField : this.fromSortField,
					sortDir : this.fromSortDir
				});
		this.fromMultiselect.on('dblclick', this.onRowDblClick, this);

		if (!this.toStore) {
			this.toStore = new Ext.data.SimpleStore({
						fields : this.dataFields,
						data : this.toData
					});
		}
		this.toStore.on('add', this.valueChanged, this);
		this.toStore.on('remove', this.valueChanged, this);
		this.toStore.on('load', this.valueChanged, this);

		this.toMultiselect = new Ext.ux.Multiselect({
					externalTagId: this.externalTagId,
					legend : this.toLegend,
					delimiter : this.delimiter,
					allowDup : this.allowDup,
					dragGroup : this.readOnly ? null : "drop1-"
							+ this.el.dom.id,
					// dropGroup: this.readOnly ? null :
					// "drop2-"+this.el.dom.id+(this.toSortField ? "" :
					// ",drop1-"+this.el.dom.id),
					dropGroup : this.readOnly ? null : "drop2-"
							+ this.el.dom.id + ",drop1-" + this.el.dom.id,
					width : this.msWidth,
					height : this.msHeight,
					displayField : this.displayField,
					valueField : this.valueField,
					store : this.toStore,
					isFormField : false,
					tbar : this.toTBar,
					sortField : this.toSortField,
					sortDir : this.toSortDir
				});
		this.toMultiselect.on('dblclick', this.onRowDblClick, this);

		var p = new Ext.Panel({
					bodyStyle : this.bodyStyle,
					border : this.border,
					layout : "table",
					layoutConfig : {
						columns : 3
					}
				});
		p.add(this.switchToFrom ? this.toMultiselect : this.fromMultiselect);
		var icons = new Ext.Panel({
					header : false
				});
		p.add(icons);
		p.add(this.switchToFrom ? this.fromMultiselect : this.toMultiselect);
		p.render(this.el);
		icons.el.down('.' + icons.bwrapCls).remove();

		if (this.imagePath != ""
				&& this.imagePath.charAt(this.imagePath.length - 1) != "/")
			this.imagePath += "/";
		this.iconAddAll = this.imagePath + (this.iconAddAll || 'addAll.gif');
		this.iconDelAll = this.imagePath + (this.iconDelAll || 'deleteAll.gif');
		this.iconDown = this.imagePath + (this.iconDown || 'down2.gif');
		this.iconLeft = this.imagePath + (this.iconLeft || 'left2.gif');
		this.iconRight = this.imagePath + (this.iconRight || 'right2.gif');
		this.iconTop = this.imagePath + (this.iconTop || 'top2.gif');
		this.iconBottom = this.imagePath + (this.iconBottom || 'bottom2.gif');
		var el = icons.getEl();
		this.addIcon = el.createChild({
					tag : 'img',
					src : this.switchToFrom ? this.iconLeft : this.iconRight,
					style : {
						cursor : 'pointer',
						margin : '2px'
					}
				});
		el.createChild({
					tag : 'br'
				});
		this.AddAllIcon = el.createChild({
					tag : 'img',
					src : this.iconAddAll,
					style : {
						cursor : 'pointer',
						margin : '2px'
					}
				});
		el.createChild({
					tag : 'br'
				});
		this.removeIcon = el.createChild({
					tag : 'img',
					src : this.switchToFrom ? this.iconRight : this.iconLeft,
					style : {
						cursor : 'pointer',
						margin : '2px'
					}
				});
		el.createChild({
					tag : 'br'
				});
		this.DelAllIcon = el.createChild({
					tag : 'img',
					src : this.iconDelAll,
					style : {
						cursor : 'pointer',
						margin : '2px'
					}
				});
		el.createChild({
					tag : 'br'
				});
		if (!this.readOnly) {
			this.addIcon.on('click', this.fromTo, this);
			this.AddAllIcon.on('click', this.addAll, this);
			this.removeIcon.on('click', this.toFrom, this);
			this.DelAllIcon.on('click', this.resetStore, this);
		}

		if (!this.drawLeftIcon || this.hideNavIcons) {
			this.addIcon.dom.style.display = 'none';
		}
		if (!this.drawRightIcon || this.hideNavIcons) {
			this.removeIcon.dom.style.display = 'none';
		}

		var tb = p.body.first();
		this.el.setWidth(p.body.first().getWidth());
		p.body.removeClass();

		this.hiddenName = this.name;
		var hiddenTag = {
			tag : "input",
			type : "hidden",
			value : "",
			name : this.name
		};
		this.hiddenField = this.el.createChild(hiddenTag);
		
		if (this.toStore.getCount())
			this.valueChanged(this.toStore);
	},

	initValue : Ext.emptyFn,

	toTop : function() {
		var selectionsArray = this.toMultiselect.view.getSelectedIndexes();
		var records = [];
		if (selectionsArray.length > 0) {
			selectionsArray.sort();
			for (var i = 0; i < selectionsArray.length; i++) {
				record = this.toMultiselect.view.store
						.getAt(selectionsArray[i]);
				records.push(record);
			}
			selectionsArray = [];
			for (var i = records.length - 1; i > -1; i--) {
				record = records[i];
				this.toMultiselect.view.store.remove(record);
				this.toMultiselect.view.store.insert(0, record);
				selectionsArray.push(((records.length - 1) - i));
			}
		}
		this.toMultiselect.view.refresh();
		this.toMultiselect.view.select(selectionsArray);
	},

	toBottom : function() {
		var selectionsArray = this.toMultiselect.view.getSelectedIndexes();
		var records = [];
		if (selectionsArray.length > 0) {
			selectionsArray.sort();
			for (var i = 0; i < selectionsArray.length; i++) {
				record = this.toMultiselect.view.store
						.getAt(selectionsArray[i]);
				records.push(record);
			}
			selectionsArray = [];
			for (var i = 0; i < records.length; i++) {
				record = records[i];
				this.toMultiselect.view.store.remove(record);
				this.toMultiselect.view.store.add(record);
				selectionsArray.push((this.toMultiselect.view.store.getCount())
						- (records.length - i));
			}
		}
		this.toMultiselect.view.refresh();
		this.toMultiselect.view.select(selectionsArray);
	},

	up : function() {
		var record = null;
		var selectionsArray = this.toMultiselect.view.getSelectedIndexes();
		selectionsArray.sort();
		var newSelectionsArray = [];
		if (selectionsArray.length > 0) {
			for (var i = 0; i < selectionsArray.length; i++) {
				record = this.toMultiselect.view.store
						.getAt(selectionsArray[i]);
				if ((selectionsArray[i] - 1) >= 0) {
					this.toMultiselect.view.store.remove(record);
					this.toMultiselect.view.store.insert(
							selectionsArray[i] - 1, record);
					newSelectionsArray.push(selectionsArray[i] - 1);
				}
			}
			this.toMultiselect.view.refresh();
			this.toMultiselect.view.select(newSelectionsArray);
		}
	},

	down : function() {
		var record = null;
		var selectionsArray = this.toMultiselect.view.getSelectedIndexes();
		selectionsArray.sort();
		selectionsArray.reverse();
		var newSelectionsArray = [];
		if (selectionsArray.length > 0) {
			for (var i = 0; i < selectionsArray.length; i++) {
				record = this.toMultiselect.view.store
						.getAt(selectionsArray[i]);
				if ((selectionsArray[i] + 1) < this.toMultiselect.view.store
						.getCount()) {
					this.toMultiselect.view.store.remove(record);
					this.toMultiselect.view.store.insert(
							selectionsArray[i] + 1, record);
					newSelectionsArray.push(selectionsArray[i] + 1);
				}
			}
			this.toMultiselect.view.refresh();
			this.toMultiselect.view.select(newSelectionsArray);
		}
	},

	addAll : function() {
//		this.reset();
//		var fromElNum = this.fromMultiselect.view.store.getCount();
//		this.fromMultiselect.view.selectRange(0, fromElNum - 1);
//		this.fromTo();
		range = this.fromMultiselect.store.getRange();
		this.fromMultiselect.store.removeAll();
		this.toMultiselect.store.add(range);
	},
	
	fromTo : function() {
		var selectionsArray = this.fromMultiselect.view.getSelectedIndexes();
		var records = [];
		if (selectionsArray.length > 0) {
			for (var i = 0; i < selectionsArray.length; i++) {
				record = this.fromMultiselect.view.store
						.getAt(selectionsArray[i]);
				records.push(record);
			}
			if (!this.allowDup)
				selectionsArray = [];
			for (var i = 0; i < records.length; i++) {
				record = records[i];
				if (this.allowDup) {
					var x = new Ext.data.Record();
					record.id = x.id;
					delete x;
					this.toMultiselect.view.store.add(record);
				} else {
					this.fromMultiselect.view.store.remove(record);
					this.toMultiselect.view.store.add(record);
					selectionsArray.push((this.toMultiselect.view.store
							.getCount() - 1));
				}
			}
		}
		this.toMultiselect.view.refresh();
		this.fromMultiselect.view.refresh();
		if (this.toSortField)
			this.toMultiselect.store.sort(this.toSortField, this.toSortDir);
		if (this.allowDup)
			this.fromMultiselect.view.select(selectionsArray);
		else
			this.toMultiselect.view.select(selectionsArray);
	},

	toFrom : function() {
		var selectionsArray = this.toMultiselect.view.getSelectedIndexes();
		var records = [];
		if (selectionsArray.length > 0) {
			for (var i = 0; i < selectionsArray.length; i++) {
				record = this.toMultiselect.view.store
						.getAt(selectionsArray[i]);
				records.push(record);
			}
			selectionsArray = [];
			for (var i = 0; i < records.length; i++) {
				record = records[i];
				this.toMultiselect.view.store.remove(record);
				if (!this.allowDup) {
					if (this.externalTagId && regClassId == 2) { // 根据全局变量regClassId判断地区选择是否为地市
						var regId = Ext.getCmp(this.externalTagId).getValue();
						if (record.get('regId') != regId) continue;
					}
					this.fromMultiselect.view.store.add(record);
					selectionsArray.push((this.fromMultiselect.view.store
							.getCount() - 1));
				}
			}
		}
		this.fromMultiselect.view.refresh();
		this.toMultiselect.view.refresh();
		if (this.fromSortField)
			this.fromMultiselect.store.sort(this.fromSortField,
					this.fromSortDir);
		this.fromMultiselect.view.select(selectionsArray);
	},

	valueChanged : function(store) {
		var record = null;
		var values = [];
		for (var i = 0; i < store.getCount(); i++) {
			record = store.getAt(i);
			values.push(record.get(this.valueField));
		}
		var oldValue = this.hiddenField.dom.value;
		this.hiddenField.dom.value = values.join(this.delimiter);
		this.fireEvent('change', this, this.getValue(), oldValue);
	},

	getValue : function() {
		return this.hiddenField.dom.value;
	},

	onRowDblClick : function(vw, index, node, e) {
		return this.fireEvent('rowdblclick', vw, index, node, e);
	},
	
	reset: function() {
		this.fromMultiselect.store.removeAll();
		this.toMultiselect.store.removeAll();
		var oldValue = this.hiddenField.dom.value;
		this.hiddenField.dom.value = '';
		this.fireEvent('change', this, this.getValue(), oldValue);
	},

	resetStore : function() {
		if (this.externalTagId && regClassId == 2) {
			var regId = Ext.getCmp(this.externalTagId).getValue();
			var values = [];
			for (var i = 0; i < this.toMultiselect.store.getCount(); i++) {
				if (this.toMultiselect.store.getAt(i).get('regId') == regId)
					values.push(this.toMultiselect.store.getAt(i));
			}
			range = values;
		}
		else {
			range = this.toMultiselect.store.getRange();		
		}
		this.toMultiselect.store.removeAll();
		if (!this.allowDup) {
			this.fromMultiselect.store.add(range);
			this.fromMultiselect.store.sort(this.displayField, 'ASC');
		}
		this.valueChanged(this.toMultiselect.store);
	},
	
	clear : function() {
		this.reset();
	}
});

Ext.reg("itemselector", Ext.ux.ItemSelector);