/**  
 * author：yctang  
 * date ：2009-07-02
 * JavaScript实现Map数据结构，及JS中的单例
 * jsp里面只需要引入该js，使用var mp1 = new Ih.Map();即可
 * */ 
 var Ih={};
Ih.Map=Class.create();

//defines the prototype of the Map.
Ih.Map.prototype={
    initialize:function(){
        this.m=new Array();
    },
    put:function(k,v){
        var newEntry=new Ih.MapEntry(k,v);
        for(var i=0;i<this.m.length;i++){
            var entry=this.m[i];
            if(entry.keyEquals(k)){
                return;
            }
        }
        this.m.push(newEntry);        
    },
    get:function(k){
        for(var i=0;i<this.m.length;i++){
            var entry=this.m[i];
            if(entry.keyEquals(k)){
                return entry.value;
            }
        }
        return null;
    },
    remove:function(k){
        var entryPoped;
        for(var i=0;i<this.m.length;i++){
            entryPoped=this.m.pop();
            if(entryPoped.keyEquals(k)){
                break;
            }else{
                this.m.unshift(entryPoped);
            }
        }
    }
    ,
    getSize:function(){
        return this.m.length;
    },
    getKeys:function(){
        var keys=new Array();
        for(var i=0;i<this.m.length;i++){
            keys.push(this.m[i].key);
        }
        return keys;
    },
    getValues:function(){
        var values=new Array();
        for(var i=0;i<this.m.length;i++){
            values.push(this.m[i].value);
        }
        return values;
    },
    isEmpty:function(){
        return (this.m==null||this.m.length<=0);
    },
    containsKey:function(k){
        for(var i=0;i<this.m.length;i++){
            if(this.m[i].keyEquals(k))
                return true;
        }
        return false;
    },
    putAll:function(map){
        if(map==null||typeof map!="object"){
            throw new Error("the object to be put should be a valid object");
        }
        for(var i=0;i<map.getSize();i++){
            this.put(map.m[i].key,map.m[i].value);
        }
    }
};
    

//single entry structure in the Map
Ih.MapEntry=function(k,v){
    this.key=k;
    this.value=v;
    this.keyEquals=function(key2){
        if(this.key==key2){
            return true;
        }else{
            return false;
        }
    }
}