/**
* 扩展的vtypes
* @author Qinaldo
* created on 2008-10-27
*/

Ext.apply(Ext.form.VTypes, {
	
	//手机
	"mobile": function(_v) {
		return /^1[385][0-9]\d{8}$/.test(_v);
	},
	"mobileText": "该输入项必须是手机号码格式,格式如:13958788888,15088888888",
	"mobileMask": /[0-9]/i,
	
	//联系电话
	"phone": function(_v) {
        return /^[0-9]{1}[0-9-]{1,12}$/.test(_v);
    },
    "phoneText": "该输入项应为电话号码或手机号码,最大长度13位,格式如:0551-2231111,15088888888",
    "phoneMask": /[0-9-]/,
	
    //电子邮箱
    "email": function(v) {
        return /^([\w]+)(.[\w]+)*@([\w-]+\.){1,5}([A-Za-z]){2,4}$/.test(v);
    },
    "emailText": "该输入项应为电子邮箱格式,格式如:xiaofei_suman@163.com",
    "emailMask": /[a-zA-Z0-9_@.]/,
    
	//经度
	"longitude": function(v) {
		return /^((\d|[1-9]\d|1[0-7]\d)\s(\d|[1-5]\d)\s(\d|[1-5]\d)\.\d{3,4}E)|(180\s0\s0E)$/.test(v);
			
	},
	"longitudeText": "该输入项必须是经度格式,格式如：117 15 10.657E 或者 117 15 10.6570E",
	"longitudeMask": /[ 0-9.E]/,
	
	//纬度
	"latitude": function(v) {
		return /^((\d|[1-8]\d)\s(\d|[1-5]\d)\s(\d|[1-5]\d)\.\d{3,4}N)|(90\s0\s0N)$/.test(v);
	},
	"latitudeText": "该输入项必须是纬度格式,格式如：31 51 25.061N 或者 31 51 25.0610N",
	"latitudeMask": /[ 0-9.N]/,
	
	//工程简称alias
	"alias": function(v) {
	   return /^[a-z0-9]{1,20}$/i.test(v);
	},
	"aliasText": "该输入项应为英文字母、数字,最大长度20,格式如：abc, ABC",
	"aliasMask": /[a-z0-9]/i,
	
	//用户标识usercode
    "usercode": function(v) {
       return /^[a-z0-9]{1,16}$/i.test(v);
    },
    "usercodeText": "该输入项应为英文字母、数字,最大长度16,格式如：abc, ABC",
    "usercodeMask": /[a-z0-9]/i,
    //角色名字
    "roleName":function(v) {
       return /^.{1,15}$/i.test(v);
    },
    "roleNameText": "最大长度15个字符",
    
    //工程阈值(limin)
    "limin": function(v) {
       return /^[0-9]{1}[0-9]{0,4}\.{0,1}[0-9]{0,3}$/i.test(v);
    },
    "liminText": "该输入项应为数字格式,范围为(0-99999.999),格式如：11.222,222.024",
    "liminMask": /[0-9.]/,
    
    "alarmColor":function(v){
    	return /^#[0-9A-F]{6}$/i.test(v);
    },
    "alarmColorText":"该输入项以#开头,后跟6个字符,如#FF0000",
    "alarmColorMask":/#[0-9A-F]/i,
    
    //普通次数count
    "count": function(v){
    	return /^([0-9]|[1-9][0-9]|100)$/.test(v);
    },
    "countText": "该输入项应为纯数字,且必须是正整数,范围为(0-100)",
    "countMask": /[0-9]/,
    
    //时间间隔周期timeEscape
    "timeEscape": function(v){
    	return /^([0-9]|[1-5][0-9]|60)$/i.test(v);
    },
    "timeEscapeText": "该输入项应为数字格式,且必须是正整数,范围为(0-60)",
    "timeEscapeMask": /[0-9]/,
    
    //资源数据导入文件格式.csv
    'csvFile':function(v){
    	return /^.*.csv$/i.test(v);   	
    },
    "csvFileText": "该输入项必须是.csv文件,如E:\\1.csv",
    
    // 综合查询-参数管理-表达式A四则运算
    "arithmetic": function(v) {
    	return /^无$/.test(v);
    },
    "arithmeticText": "输入格式不正确,应如:A运算符B运算符C（运算符包括+、-、*、/,A、B、C为下拉框选项）",
    
    //菜单权限码标识
    "funcId" : function(v) {
    	return /^[0-9]{1,8}$/i.test(v);
    },
    "funcIdText": "该输入项必须是1-8位数字,如1234,13349093.",
    
    //业务定义ID
    "ewsServId" : function(v) {
        return /^[0-9]{1,10}$/i.test(v);
    },
    "ewsServIdText": "该输入项必须是1-10位数字,如1234,1334909313.",
    "ewsServIdMask": /[0-9]/,
    
    //Ip校验
    "ip" : function(v) {
        return /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/i.test(v);
    },
    "ipText": "该输入项必须是ip输入格式,如192.168.100.3",
    "ipMask": /[0-9.]/,
    
    //端口
    "port" : function(v) {
        return /^(0|([1-9]\d{0,3}|[1-5]\d{4}|[6][0-5][0-5]([0-2]\d|[3][0-5])))$/i.test(v);
    },
    "portText": "该输入项必须是1-65535位数字, 如8000",
    "portMask": /[0-9]/,
    
    //最大连接数
    "maxConn" : function(v) {
        return /^[0-9]{1,19}$/i.test(v);
    },
    "maxConnText": "该输入项必须是1-19位数字, 如1234,1334909313",
    "maxConnMask": /[0-9]/,
    
     //最大连接数
    "offinum" : function(v) {
        return /^[0-9a-zA-Z]{1,10}$/i.test(v);
    },
    "offinumText": "该输入项必须是1-10位数字、英文字母, 如5103a, a3434",
    "offinumMask": /[0-9a-zA-Z]/
});


