/**
 * 功能说明：设备树共通编码
 * @author Qinaldo
 * @created on 2009年4月16日9:40:05
 */

LeftPanel = Ext.extend(Ext.tree.TreePanel, {
	constructor: function() {
		LeftPanel.superclass.constructor.call(this, {
			title: '业务模型',
			region:'west',
            split:true,
			autoScroll:true, 
	        enableDD:false,//是否支持拖拽效果
	        containerScroll: true,//是否支持滚动条
	        split:true,
	        width: 160,
	        border: true,
	        frame: false,
	        animCollapse:false,
            animate: false,
            //collapseMode:'mini',
            collapseFirst:false,
	        height:Ext.getBody().getViewSize().height - 10,
	        rootVisible:true,//是否显示跟节点
	        collapsible: true,
	        margins:'0 0 0 0',
	        loader:new Ext.tree.TreeLoader({  
	            dataUrl: 'getDeviceNodesByUserId.action'
	        }),
	        root: new Ext.tree.AsyncTreeNode({
	        	id: 'resource_root_1',
	            text:'业务模型',
	            draggable:false,
	            expanded: true
	        }),
	        listeners: {
	        	'click': {fn: this.onTreeClick, scope: this},
	        	'dblclick': {fn: this.onTreeDblClick, scope: this}
	        }
		});
	},
	onTreeDblClick: function(node, e) {
		if(node.attributes.device) {
        	for(var i=0; i<window.frames.length; i++) {
                if(window.frames[i] && window.frames[i].invokeDbl) {
                    window.frames[i].invokeDbl(node);
                }
           }
    	}
	},
	onTreeClick: function(node, e) {
		//统一接口 invoke(node 节点)
    	var root = node.ownerTree.getRootNode();
    	if(node.attributes.device) {
    		if(window.invokeAlarm)
    		{
    			invokeAlarm(node,node.parentNode);
    		}
        	for(var i=0; i<window.frames.length; i++) {
                if(window.frames[i] && window.frames[i].invoke) {
                    window.frames[i].invoke(node);
                }
           }
    	}
    	for(var i=0; i<window.frames.length; i++) {
    		if(window.frames[i] && window.frames[i].invokeXp) {
                    window.frames[i].invokeXp(node,root);
            }
    	}
	}
});

/*
var tabs_data = null;

function createTreePanel(rootText,rootId) {
    var tree= new Ext.tree.TreePanel({
        autoScroll:true, 
        enableDD:false,//是否支持拖拽效果
        containerScroll: true,//是否支持滚动条
        split:true,
        width: 160,
        border: false,
        frame: false,
        height:Ext.getBody().getViewSize().height - 70,
        //minSize: 175,
        //maxSize: 300,
        rootVisible:true,//是否显示跟节点
        collapsible: true,
        margins:'0 0 0 0',
        loader:new Ext.tree.TreeLoader({  
            dataUrl: 'getChildNodesWithMain.action'
        }),
        root: new Ext.tree.AsyncTreeNode({
        	id: rootId,
            text:rootText,
            draggable:false
        })
    });
    return tree;
}


*//**
 * tab设备导航
 * @class TabTreePanel
 * @extends Ext.TabPanel
 *//*
TabsPanel = Ext.extend(Ext.TabPanel, {
    
    constructor: function() {
        
        TabsPanel.superclass.constructor.call(this, {
            margins:'0 0 0 0',
            resizeTabs: true,
            minTabWidth: 80,
            tabWidth: 80,
            enableTabScroll: true,
            border: false,
            width:188,
            height:Ext.getBody().getViewSize().height - 45,
            autoTabs: true,
            autoWidth: true,
            frame: false,
            activeTab: 0,
            defaults:{autoHeight: true}
        });
    }
});

*//**
 * 外层的Panel
 * @class TabsPanel
 * @extends Ext.Panel
 *//*
LeftPanel = Ext.extend(Ext.Panel, {
    tabsPanel: null,
    
     constructor: function(data) {
        tabs_data = eval(data);
        this.tabsPanel = new TabsPanel();        
        LeftPanel.superclass.constructor.call(this, {
        	//title: '设备树',
            id:'api-tree',
            region:'west',
            split:true,
            width: 190,
            minSize: 190,
            maxSize: 200,
            closable: true,
            height: Ext.getBody().getViewSize().height - 2,
            collapsible: true,
            margins:'0 0 5 5',
            rootVisible:false,
            frame: true,
            lines:true,
            autoScroll:true,
            animCollapse:false,
            animate: false,
            collapseMode:'mini',
            collapseFirst:false,
            items:[this.tabsPanel],
            listeners: {
                'render': {fn:this.renderToPanel, scope: this}
            }
        });
    },
    initTabs: function() {
    	for(var i=0,len=tabs_data.length; i<len; i++) {
    		var rootId = tabs_data[i].id;
    		var tabsId = 'tabTree_' + tabs_data[i].id;
    		var title = tabs_data[i].title;
    		var p = new Ext.Panel({id:tabsId,title:title,autoScroll:true,layout: 'fit',border:false,autoWidth:true});
    		var tree = createTreePanel(title,rootId);
    		p.add(tree);
    		tree.on('click', this.treeClick, this);
    		//tree.on('contextmenu', this.treeRightMenu, this);
    		this.tabsPanel.add(p);
    	    
    	}
    },
    renderToPanel: function() {
    	this.initTabs();
    },
    treeClick: function(node,e) {
    	//统一接口 invoke(node 节点)
    	var root = node.ownerTree.getRootNode();
    	if(node.attributes.device) {
        	for(var i=0; i<window.frames.length; i++) {
                if(window.frames[i] && window.frames[i].invoke) {
                    window.frames[i].invoke(node);
                }
           }
    	}
    	for(var i=0; i<window.frames.length; i++) {
    		if(window.frames[i] && window.frames[i].invokeXp) {
                    window.frames[i].invokeXp(node,root);
            }
    	}
    }
});*/

/**
 * 创建右键菜单
 * @param {} menuData
 * @return {}
 *//*
function createRightMenu(node,rightMenuData){
    
    var menu = new Ext.menu.Menu();
    
    for(var i=0; i<rightMenuData.length; i++){
        var menuItem = null;
        
        if(rightMenuData[i].isDisplay){
            menuItem = new Ext.menu.Item({
                id: rightMenuData[i].id,
                text: rightMenuData[i].menuBiz,
                treeNode: node,
                capaId: rightMenuData[i].capaId,
                handler: onRightMenuClick
            });
        }
        menu.addItem(menuItem);
    }
    return menu;
}*/

/**
 * 右键菜单处理函数
 * @param {} menuItem
 *//*
function onRightMenuClick(rightMenuItem) {
	var capaId = rightMenuItem.capaId;     //功能菜单id
	var treeNode = rightMenuItem.treeNode;
	
	//导航树统一接口invoke(node,parentNode)
	invoke(treeNode, rightMenuItem.treeNode);      
}
*/
