function createCheckBoxTree(containerId,url, width, height,title)
{
	var tree = new Ext.tree.TreePanel({
		title: title,
		el: containerId,
		width:width,
		height:height,
		checkModel: 'cascade',    //对树的级联多选
		onlyLeafCheckable: false,//对树所有结点都可选
		animate: false,
		rootVisible: true,
		autoScroll:true,
		loader: new Ext.tree.TreeLoader({
			dataUrl: url,
			baseAttrs: { uiProvider: Ext.tree.TreeCheckNodeUI } //添加 uiProvider 属性
		})
	});
	return tree;
}
function createCheckBoxTreex(url, width, height,title)
{
	var tree = new Ext.tree.TreePanel({
		title: title,
		width:width,
		height:height,
		frame: false,
		border: false,
		checkModel: 'cascade',    //对树的级联多选
		onlyLeafCheckable: false,//对树所有结点都可选
		animate: false,
		rootVisible: true,
		autoScroll:true,
		loader: new Ext.tree.TreeLoader({
			dataUrl: url,
			baseAttrs: { uiProvider: Ext.tree.TreeCheckNodeUI } //添加 uiProvider 属性
		})
	});
	return tree;
}

function createCheckBoxTreeRoot(text,id)
{
	var root = new Ext.tree.AsyncTreeNode({
		text: text,
		draggable:false,
		id:id
		//uiProvider: Ext.tree.CheckboxNodeUI
	});
	return root;
}
function createTree( containerId,url,width, height,title )
{
	var tree = new Ext.tree.TreePanel(
    {
    	title: title,
        el: containerId,
        width:width,
        height:height,
       animate:true, 
       loader: new Ext.tree.TreeLoader({dataUrl:url}),
       enableDD:false,
       containerScroll: true
    });
    return tree;
}
function createTreeRoot(text,id)
{
	var root = new Ext.tree.AsyncTreeNode({
		text: text,
		draggable:false,
		id:id
	});
	return root;
}

function node_click(node) {
    	node.getUI().check(!node.attributes.checked);
    }

function clearCheckboxTree(tree) {
	var checkedNodes = tree.getChecked();
	for(var i = 0; i < checkedNodes.length; i++) {
		var childNodes = checkedNodes[i].childNodes;
		checkedNodes[i].getUI().checkbox.checked = false;
		checkedNodes[i].attributes.checked = false;
		for(var j = 0; j < childNodes.length; j++) {
			childNodes[j].getUI().checkbox.checked = false;
			childNodes[j].attributes.checked = false;
		}
	}
}

function clearCheckTree(nodes){
	for(var i=0; i<nodes.length; i++){
		if(!nodes[i].isLeaf()){
            var childNodes = nodes[i].childNodes;
            clearCheckTree(childNodes);            
        } 
        nodes[i].getUI().checkbox.checked = false;
        nodes[i].attributes.checked = false;
	}
}