
function createGrid(params)
{	
	var grid = new Ext.grid.GridPanel({
		renderTo: params.renderTo,
		store: createGridDataStore(params.col, params.url),
		labelAlign: 'center',
		sm: createGridSelectModel(params.isSingleSelect),
		cm: createGridColumnModel(params.isNeedRowNum, params.col),
		frame: true,
		loadMask: {
			msg: '正在载入数据,请稍候...'
		},
		width: params.width,
		height: params.height,
		bbar: createGridToolbar(params.tbar)
	});
	
	return grid;
}

function createGridToolbar(tbars)
{
	var plants = new Array(tbars.length*2);
	for(var i = 0; i<tbars.length; i++)
	{
		plants[i*2] = new Ext.Toolbar.Separator({});
		plants[i*2+1] = tbars[i];
	}
	var tbar = new Ext.Toolbar({items: [plants]});
	return tbar;
}

function createGridDataStore(col, actionUrl)
{
	var plants = new Array(col.length);
	for(var i = 0; i<col.length; i++)
	{
		plants[i] = {name:col[i].field};
	}
	var plant = Ext.data.Record.create(plants);
	
	var store = new Ext.data.Store({
					proxy: new Ext.data.HttpProxy({url: actionUrl, method: 'POST'}),
					reader: new Ext.data.JsonReader({},plant)
				});
	return store;
}

function createGridColumnModel(isNeedRowNum, col)
{	
	var cols = new Array(col.length);
	var b = true;
	
	for(var i = 0; i<col.length;i++)
	{
		if(isNeedRowNum)
		{
			if(b)
			{
				cols[i] = new Ext.grid.RowNumberer();
				b=false;
				continue;
			}
		}
		
		cols[i] = {
					header: col[i].header,
					dataIndex: col[i].field,
					width: col[i].width,
					hidden: col[i].hidden
					};
	}
	var cm = new Ext.grid.ColumnModel(cols);
	cm.defaultSortable = true;
	return cm;	
}

function createGridSelectModel(isSingleSelect)
{
	return new Ext.grid.RowSelectionModel({singleSelect : isSingleSelect});
}


