/**
 *  form 共通编码
 *  @author Qinaldo
 *  @created 2008-09-27
 */

function createForm(el,width, height,labelWidth){
	var frm = new Ext.form.FormPanel({
		el: el,
		width : width,
		height : height,
		frame : true,
		labelWidth : labelWidth,
		bodyStyle : "padding: 5px 5px 0"
	});		
	return frm;
}

function createTextfield(fieldLabel,id,name,readOnly,allowBlank,anchor,vtype,inputType,blankText,maxLength,maxLengthText,minLength,minLengthText) {
	var textfield = new Ext.form.TextField({
		fieldLabel:fieldLabel,
		id:id,
		name:name,
		readOnly:readOnly,
		anchor:anchor,
		allowBlank:allowBlank,
		vtype:vtype,
		inputType:inputType,
		blankText:blankText,
		maxLength: maxLength,
		maxLengthText: maxLengthText,
		minLength: minLength,
		minLengthText :minLengthText
	});
	return textfield;
}

function createHidden(id,name) {
	var hidden = new Ext.form.Hidden({
		id:id,
		name:name,
		readOnly:true,
		allowBlank:false
	});
	return hidden;
}

function createComboStore(url,id,name) {
	var store = new Ext.data.Store({
		proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
		reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name}]))
	});
	return store;
}

function createComboBox(store,fieldLabel,id,name,width,displayField,valueField,anchor) {
	var combo = new Ext.form.ComboBox({
		store: store,
		fieldLabel:fieldLabel,
		id:id,
		name:name,
		width:width,
		displayField:displayField,
		valueField:valueField,
		anchor:anchor,
		allowBlank:false,
		blankText:'请选择...',
		readOnly:true,
		selectOnFocus:true,
		triggerAction: 'all',
		modal:'local',
		emptyText:'请选择...',
		forceSelection:true		
	});
	return combo;
}

function createNumberfield(fieldLabel,id,name,readOnly,allowBlank,anchor,blankText,allowDecimals,maxLength,maxLengthText) {
	var nf = new Ext.form.NumberField({
		fieldLabel: fieldLabel,
		id:id,
		name:name,
		readOnly:readOnly,
		allowBlank:allowBlank,
		anchor:anchor,
		blankText:blankText,
		allowDecimals: allowDecimals,
		maxLength: maxLength,
		maxLengthText: maxLengthText
	});
	return nf;
}

//为了业务字典表能够通用，创建通用列表框，方便以后直接使用
function createDictionaryCombo(fieldLabel, hiddenName,anchor, url, allowblank) { // 生成一个通用的ComboBox
	var combo = new Ext.form.ComboBox({
		fieldLabel : fieldLabel,
		emptyText : '请选择...',
		isFormField : true,
		anchor : anchor,
		mode : 'local',
		hiddenName : hiddenName,
		allowBlank : allowblank,
		blankText : '请选择...',
		lastQuery : '',
		triggerAction : 'all',
		displayField : "businname",
		valueField : "businid",
		store : new Ext.data.Store({
			autoLoad:true,
			proxy : new Ext.data.HttpProxy({
				url : "queryDicByBusitypeid.action?busintypeId="+url,
				method : 'POST'
			}),
			reader : new Ext.data.JsonReader({
				root : "bndictDictionarys"
			}, new Ext.data.Record.create([ {
				name : "businid"
			}, {
				name : "businname"
			} ]))
		}),
		readOnly : true
	});
	
	function addBlankSelectForCombox(combo){
		combo.on("select", function() {
						if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
							combo.setValue("");
						}
					});
			combo.store.on("datachanged", function(a) {
						var r = new Ext.data.Record({});
						r.set(combo.valueField, ''); // 添加一格值为-1的选项
						r.set(combo.displayField, combo.emptyText);
						a.insert(0, r);
					});
	}
	if(allowblank){
		combo.initComponent = addBlankSelectForCombox(combo);
	}
	return combo;
}

