/**  
 * author：yctang  
 * date ：2009-06-22
 * 实现GridPanel的每一个单元格tips显示  
 * jsp引用该js
 * 调用此方法的js里面必须先初始化	Ext.QuickTips.init();
 * 使用的例子 autoLoad : {params : {start : 0,limit : 10},callback:function(a,b,c){showPanelTips(grid)}},
 * */  
function showPanelTips(gridPanel)   
{      
    //控制grid页面展示的对象   
    var view=gridPanel.getView();   
    for(var rowIndex=0;rowIndex<gridPanel.getStore().getCount();rowIndex++)   
    {   
        var record=gridPanel.getStore().getAt(rowIndex);   
        for(var columnIndex=0;columnIndex<gridPanel.colModel.getColumnCount();columnIndex++)   
        {   
                var textDisplay=record.get(gridPanel.colModel.getDataIndex(columnIndex));   
                var cell=view.getCell(rowIndex,columnIndex);   
                //Ext动态生成的ID   
                var cid = Ext.id();   
                cell.firstChild.setAttribute('id',cid);   
                Ext.QuickTips.register({   
                        target: cid,   
                        text: textDisplay,   
                        maxWidth: 100,      //设置后显示内容可以自动换行   
                        dismissDelay:20000, //设置显示时间                               
                        trackMouse: true,   
                        autoHide: true,   
                        animate: true  
                    });    
        }   
           
    }   
}  