/***
* @see 下拉选择树
* @author dbwu
*/

Ext.namespace("Ext.ux");
Ext.ux.ComboBoxTree = Ext.extend(Ext.form.ComboBox, {   
  
    allowUnLeafClick : true,   
    hiddenName:'',								//用于传递node.id参数
    listWidth:200, 								//这是设置下拉框的宽度，默认和comBoxTree的宽度相等
    //width : 200,   							//设置宽度（调试发现无效）
    //tpl: '<div id="treeTpl"></div>', 			//html代码   
    treeHeight : 180,   
    store : new Ext.data.SimpleStore({   
      	fields : [],
        data : [[]]   
    }),   
       
    //Default   
    editable : false, // 禁止手写及联想功能   
    mode : 'local',   
    triggerAction : 'all',   
    maxHeight : 500,   
    selectedClass : '',   
    onSelect : Ext.emptyFn,   
    emptyText : '请选择...',   
  
    clearValue : function() { 
      		  this.setRawValue('');   
            },   
  	setHiddenValue : function(value){ 
        if(this.hiddenName){   
          this.hiddenName = value;   
        }   
        Ext.ux.ComboBoxTree.superclass.setValue.call(this,value);   
       // this.value = value;   
    },   
    getValue : function(){ 
        return typeof this.value != 'undefined' ? this.value : '';   
    },   
  
    /**  
     * ----------------------------------   
     * 树的单击事件处理  
     * @param node,event  
     * ----------------------------------  
     */  
    treeClk : function(node, e) {   
        this.setValue(node.id);// 设置option值   
        this.setHiddenValue(node.id);
        this.setRawValue(node.text); 
        this.collapse();// 隐藏option列表   
        this.fireEvent('treeselected', node);   
  
    },   
  
    /**  
     * 初始化  
     * Init  
     */  
    initComponent : function() {   
        Ext.ux.ComboBoxTree.superclass.initComponent.call(this);   
        this.tree.autoScroll = true;   
        this.tree.height = this.treeHeight;   
        this.tree.containerScroll = false;   
        this.tplId = Ext.id();   
  
        // overflow:auto"   
        this.tpl = '<div id="' + this.tplId + '" style="' + this.treeHeight    + '";overflow:hidden;"></div>';   
        this.addEvents('treeselected');   
        // this.on('treeselected',this.onTreeSelected,this);   
    },   
  
    /**  
     * ------------------  
     * 事件监听器   
     * Listener  
     * ------------------  
     */  
    listeners : {   
        'expand' : {   
            fn : function() {   
                if (!this.tree.rendered && this.tplId) {   
  
                    this.tree.render(this.tplId);   
  
                }   
                this.tree.show();   
            },   
            single : true  
        },   
  
        'render' : {   
            fn : function() {   
  				 
  				this.setWidth(200);										//设置高度，直接设置高度不起作用....faint
                this.tree.on('click', this.treeClk, this);   
            }   
        },   
        'beforedestroy' : {   
            fn : function(cmp) {   
                this.purgeListeners();   
                this.tree.purgeListeners();   
            }   
        }   
    }   
  
});   
  
/**  
 * ---------------------------------   
 * 将ComboBoxTree注册为Ext的组件,以便使用  
 * Ext的延迟渲染机制，xtype:'combotree'   
 * ---------------------------------  
 */  
Ext.reg('combotree', Ext.ux.ComboBoxTree);  




/*****
 * 
 * 	创建下拉选择树，标签和url自定义
 *  
 * */

function createComboxTree(label, width,url)
{
	var comTree = new Ext.ux.ComboBoxTree({  
						fieldLabel : label,  
						labelWidth: 65,
						//width : width,  
				       	// xtype : 'combotree',  
				        hiddenName:'set you need', 
				        allowUnLeafClick : true,  
				        tree : new Ext.tree.TreePanel({  
				            rootVisible : true,  
				            root : new Ext.tree.AsyncTreeNode({  
				                id : '0',  
				                text : "省中心",  
				                expanded : true,  
				                loader : new Ext.tree.TreeLoader({  
				                    dataUrl : url
				                })  
				            })  
				        }),  
				        allowBlank : false
					 })  
	return comTree;
}






