Ext.grid.CheckColumn = function(config){
    Ext.apply(this, config);
    if(!this.id){
        this.id = Ext.id();
    }
    this.renderer = this.renderer.createDelegate(this);
};

Ext.grid.CheckColumn.prototype ={
    init : function(grid){
        this.grid = grid;
        this.grid.on('render', function(){
            var view = this.grid.getView();
            view.mainBody.on('mousedown', this.onMouseDown, this);
        }, this);
    },

    onMouseDown : function(e, t){
        if(t.className && t.className.indexOf('x-grid3-cc-'+this.id) != -1){
            e.stopEvent();
            var index = this.grid.getView().findRowIndex(t);
            var record = this.grid.store.getAt(index);
            var fieldNo = record.data["fieldNo"];
            var objectTypeId = officeDataTree.getSelectedNode().id;
            var togDataIndex = this.dataIndex === 'isCheckFlag' ? "isCompFlag" : "isCheckFlag";
			var type = this.dataIndex === "isCheckFlag" ? 1 : 2;
			
			if(record.data[togDataIndex]) {
				Ext.MessageBox.alert("系统提示：", "该属性已被选择,请取消另一选择项后,重试！");
				return;
			}
			
            if(record.data[this.dataIndex]) {
            	OfficeDataManager.deleteOfficeDataId(objectTypeId, fieldNo, type, function(data) {
            		if(data) {
            			
            		} else {
            			Ext.MessageBox.alert("系统提示：","删除时操作可能出现了某些错误,请重试！");
            		}
            	});
            }
            
            if(!record.data[this.dataIndex]) {
            	OfficeDataManager.saveOfficeDataId(objectTypeId, fieldNo,type, function(data) {
            		if(data) {
            			
            		} else {
            			Ext.MessageBox.alert("系统提示：","增加时操作可能出现了某些错误,请重试！");
            		}
            	});
            }
            record.set(this.dataIndex, !record.data[this.dataIndex]);
        }
    },

    renderer : function(v, p, record){
        p.css += ' x-grid3-check-col-td'; 
        return '<div class="x-grid3-check-col'+(v?'-on':'')+' x-grid3-cc-'+this.id+'">&#160;</div>';
    }
};