/**
 * @description: 更该PagingToolbar中的pagesize属性
 * @author: chen.bo
 */

Ext.ns('Ext.ux.data');

Ext.ux.data.PageSizePlugin = function() {
	Ext.ux.data.PageSizePlugin.superclass.constructor.call(this, {
		store : new Ext.data.SimpleStore({
			fields : ['text', 'value'],
			data : [['10', 10], ['20', 20], ['30', 30], ['50', 50],
					['100', 100]]
		}),
		mode : 'local',
		displayField : 'text',
		valueField : 'value',
		editable : false,
		allowBlank : false,
		triggerAction : 'all',
		width : 80
	});
};  

Ext.extend(Ext.ux.data.PageSizePlugin, Ext.form.ComboBox, {
	init : function(paging) {
		paging.on('render', this.onInitView, this);
	},

	onInitView : function(paging) {
		paging.add('-', '每页显示', this, '条记录');
		this.setValue(paging.pageSize);
		this.on('select', this.onPageSizeChanged, paging);
	},

	onPageSizeChanged : function(combo) {
		this.pageSize = parseInt(combo.getValue());
		this.doLoad(0);
	}
});