 /**************************************菜单添加修改form**************************************/
var formatConverterWindow ;
var servDefineId ;
/** ************************CanReqGrid服务定义************************************* */
var canReqGridStore ;
CanReqGrid = Ext.extend(UxGrid, {
	constructor : function() {
		this.canReqGridStore = new Ext.data.Store({ // Grid Store
			proxy : new Ext.data.HttpProxy({
						url : "getCanReqServman.action",
						method : 'POST'
					}),
			reader : new Ext.data.JsonReader({
						root : 'canVisitServManList'
					}, [{name:'servManCode'},{name:'servManName'}])
		}),

		CanReqGrid.superclass.constructor.call(this, {
					frame : true,
					width : Ext.getBody().getViewSize().width*.45,
					height : Ext.getBody().getViewSize().height- 140,
					viewConfig : {
						forceFit : true
					},
					loadMask : {
						msg : '正在载入数据,请稍候...'
					},
					sm : new Ext.grid.RowSelectionModel({
								singleSelect : true
							}),
					cm : new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
							{
								header : '消费方',
								dataIndex : 'servManCode',
								hidden : true
							},
							// {header:'服务编码',dataIndex:'servCode',hidden:true},
							{
								header : '消费方名称',
								dataIndex : 'servManName',
								sortable : true,
								width : 100
							}
					]),
					ds : this.canReqGridStore,
					listeners : {
						"dblclick" : {
							fn : this.onModifyClick,
							scope : this
						}
					}
				});
	},
	onModifyClick : function() {
		var selServMan = this.selectedRecord();
		var servManCode = selServMan.get('servManCode') ;
		ServDefineDwr.getDataFormatConverter(servDefineId,servManCode, function(data){
		    if(data) {
		    	var obj = Ext.decode(data) ;
		    	var dataFormatId =obj[0].dataFormatId;
				var reqConvertScript=obj[0].reqConvertScript;
				var resConvertScript=obj[0].resConvertScript ;
				
		    	formatConverterWindow.formatConverterForm.dataFormatId.setValue(dataFormatId) ;
		    	formatConverterWindow.formatConverterForm.servManCode.setValue(servManCode) ;
	    		formatConverterWindow.formatConverterForm.reqConverter.setValue(reqConvertScript) ;
	    		formatConverterWindow.formatConverterForm.resConverter.setValue(resConvertScript) ;
		    }else{
		    	formatConverterWindow.formatConverterForm.servManCode.setValue(servManCode) ;
		    	formatConverterWindow.formatConverterForm.dataFormatId.setValue(0) ;
	    		formatConverterWindow.formatConverterForm.reqConverter.setValue('') ;
	    		formatConverterWindow.formatConverterForm.resConverter.setValue('') ;
		    }
		});
	}
});

FormatConverterForm = Ext.extend(Ext.ux.Form, {
    dataFormatId:null,
    servDefineId:null,
    servManCode:null,
    reqConverter:null,       //请求转换
    resConverter:null,       //相应转换
    canReqGrid :null,
    
    constructor: function() {
    	this.dataFormatId = this.createHidden("服务定义ID","dataFormatConverter.dataFormatId") ;
    	this.servManCode = this.createHidden("服务消费方","dataFormatConverter.servManCode") ;
        this.servDefineId = this.createHidden("服务定义ID","dataFormatConverter.servDefineId") ;
        this.reqConverter = new Ext.form.TextArea({  
						autoScroll : true,
						title :"请求格式模板",
						fieldLabel : "请求格式模板",
						name : "dataFormatConverter.reqConvertScript",
						id : "dataFormatConverter.reqConvertScript",
						width: Ext.getBody().getViewSize().width*.45,
						height : Ext.getBody().getViewSize().height- 140
//						autoWidth : true
					}) ;
        this.resConverter =  new Ext.form.TextArea({  
						autoScroll : true,
						title :"响应格式模板",
						fieldLabel : "响应格式模板",
						name : "dataFormatConverter.resConvertScript",
						id : "dataFormatConverter.resConvertScript",
						width: Ext.getBody().getViewSize().width*.45,
						height : Ext.getBody().getViewSize().height- 140
//						autoWidth : true
					}) ;
        this.canReqGrid = new CanReqGrid() ;
        
        FormatConverterForm.superclass.constructor.call(this, {
        	title: '*左边为请求消息模板 *右边为响应消息模板',
            width : Ext.getBody().getViewSize().width - 70,// Ext.getBody().getViewSize().width - 5,
			height : Ext.getBody().getViewSize().height - 60,
            labelWidth: 100,
            frame: true,
            //autoDestroy: false ,
            waitMsgTarget : true,
            labelAlign : "right",
            items:[{
					layout : "column",
					items :[this.dataFormatId,this.servDefineId,this.servManCode,
					{
						columnWidth : 0.15,
						layout : "fit",
						items:this.canReqGrid 
					},
					{
					    columnWidth : 0.42,
						layout : "fit",
						items : this.reqConverter
						},
					{
					    columnWidth : 0.42,
						layout : "fit",
						items : this.resConverter
						}]
				}],
            buttons: [
               {text: '保存', id: 'addBtn', iconCls: 'save',width: 20, hidden: false, handler: this.addFormatConverterClick, scope: this},
               {text: '重置', id: 'resetBtn',width: 20, iconCls:'resume',  handler: this.resetFormatConverterClick, scope: this}
            ]
        })
     },
     addFormatConverterClick: function() {     //添加
    	if(this.getForm().isValid()) {
        	this.getForm().submit( {
                url : 'addOrUpdateDataFormatConverter.action',
                success : function() {
                    Ext.Msg.alert('保存成功', '添加成功！');
                },
                failure : function() {
                    Ext.Msg.alert('保存失败', '添加失败！');
                },
                waitMsg : '正在保存数据，稍后...'
                });
    	}else{
    		Ext.Msg.alert('信息', '请填写完成再提交!');
    	}
     },
     resetFormatConverterClick: function() {
     	this.getForm().reset();
     }
});
 
 // form_win定义一个Window对象，用于新建和修改时的弹出窗口。
 FormatConverterWindow = Ext.extend(Ext.Window,{
    formatConverterForm : null,
    constructor: function() {
        this.formatConverterForm = new FormatConverterForm();
        FormatConverterWindow.superclass.constructor.call(this, {
            title: "模板编辑窗口",
            width : Ext.getBody().getViewSize().width  - 50,
        	height : Ext.getBody().getViewSize().height - 20,
            resizable : false,
            plain: true,
            modal: true,
            autoScroll: true,
//            closeAction: 'hide',
        	items : [{
					layout: "form",
					items : [{
								columnWidth : 1.0,
								layout : "form",
								items : this.formatConverterForm
							}]
				}]
        });
    }
});

function showFormatConverterWin(){
	var record = servDefineGrid.selectedRecord();
	formatConverterWindow = new FormatConverterWindow();
	servDefineId = record.get('servDefineId') ;
   	formatConverterWindow.formatConverterForm.servDefineId.setValue(servDefineId) ;
   	formatConverterWindow.formatConverterForm.canReqGrid.store.load({params:{"servDefineId":servDefineId}}) ;
	formatConverterWindow.show() ;
	
}