SubScirbeWindow = Ext.extend(Ext.Window, {

			servSubscribGrid : servSubscribGrid,
			constructor : function() {
//				this.servSubscribGrid = new ServSubscribeVisitLimitGrid();
				InsertDefineWindow.superclass.constructor.call(this, {
							title : "订阅服务权限窗口",
							width : 770,
							height : 460,
							resizable : false,
							plain : true,
							modal : true,
							autoScroll : true,
							closeAction : 'hide',
							items : [this.servSubscribGrid]
						});
			}
		});

/** *************************************InsertDefineWindow组件************************************************* */
InsertDefineWindow = Ext.extend(Ext.Window, {

			defineForm : null,
			constructor : function() {

				this.defineForm = new DefineForm();
				InsertDefineWindow.superclass.constructor.call(this, {
							title : "添加原子服务窗口",
							width : 370,
							height : 430,
							resizable : false,
							plain : true,
							modal : true,
							autoScroll : true,
							closeAction : 'hide',
							items : [this.defineForm]
						});
			}
		});

/** *************************************UpdateDefineWindow组件************************************************* */
UpdateDefineWindow = Ext.extend(Ext.Window, {

			defineForm : null,
			constructor : function() {

				this.defineForm = new DefineForm();

				Ext.getCmp('add_define_btn').hide(); // 隐藏添加按钮
				Ext.getCmp('update_define_btn').show(); // 显示修改按钮
				Ext.getCmp('reset_define_btn').hide(); // 隐藏清空按钮
			    Ext.getCmp('resume_define_btn').show(); // 显示重置按钮

				UpdateDefineWindow.superclass.constructor.call(this, {
							title : "修改原子服务窗口",
							width : 370,
							height : 430,
							resizable : false,
							plain : true,
							modal : true,
							autoScroll : true,
							closeAction : 'hide',
							items : [this.defineForm]
						});
			}
		});
/*************************************关联版本查看窗口**********************************************/
RelationDefineWindow = Ext.extend(Ext.Window, {

			defineGrid : null,
			constructor : function() {

				this.defineGrid = new DefineGrid(400,750);
				RelationDefineWindow.superclass.constructor.call(this, {
							title : "关联服务版本窗口",
							width : 770,
							height : 440,
							resizable : false,
							plain : true,
							modal : true,
							autoScroll : true,
							closeAction : 'hide',
							items : [this.defineGrid]
						});
			}
		});

/** ************************原子服务Grid************************************* */
ServDefineGrid = Ext.extend(UxGrid, {
	insertDefineWindow : null, // 增加服务定义窗口
	updateDefineWindow : null, // 修改服务定义窗口
	relationDefineWindow :null,//关联服务版本窗口
	rightMenu : null,
	servCombo : null, // 服务下拉选择框，查询
	servLabel : null,
	sm : null,
   servDefineStore : null,
	constructor : function(height, width) {

		this.servDefineStore = new Ext.data.Store({ // Grid Store
			proxy : new Ext.data.HttpProxy({
						url : "register/atomServDefineAction_queryAtomServ.action",
						method : 'POST'
					}),
			reader : new Ext.data.JsonReader({
						totalProperty : 'page.totalCount',
						root : 'page.result'
					}, [{name:'servAtomservId'},{name:'wsdlOperId'},{name:'atomservCode'},{name:'atomservName'},{name:'atomservDesc'},{name:'servBusitype'}, {name:'protocolId'},{name:'atomservInputDesc'},{name:'atomservOutputDesc'},
						{name:'status'},{name:'conndetectFlag'},{name:'delFlag'},{name:'servManId'},{name:'servManName'},{name:'wsdlId'},{name:'wsdlAddr'},{name:'servBusiTypeName'},{name:'servProbeFlag'},{name:'relaNumber'}])
		}),
       this.sm = new Ext.grid.RowSelectionModel({singleSelect : true}),
		this.rightMenu = new Ext.menu.Menu({
					items : [{
								text : '修改服务定义',
								handler : this.onModifyClick,
								scope : this
							}, {
								text : '删除服务定义',
								handler : this.onDeleteClick,
								scope : this
							}]
				});

		this.insertDefineWindow = new InsertDefineWindow();
		this.updateDefineWindow = new UpdateDefineWindow();
        this.relationDefineWindow = new RelationDefineWindow();
		// this.userNameTf = this.createTextFiled("userName",90);
		// this.userIDTf = this.createTextFiled("userID",90);
		this.servLabel = new Ext.form.Label({
					text : '服务：'
				}), this.servCombo = this.createCombo1("servAtomservId", "atomservName",
				"register/atomServDefineAction_queryAtomServNoPage.action",
				"atomList", 130);
		this.servCombo.store.load();
		this.servCombo.on('select', this.onServComboSelect, this);

		ServDefineGrid.superclass.constructor.call(this, {
					// title:'服务定义',
					frame : true,
					width : width,
					height : height,
					viewConfig : {
						forceFit : true
					},
					loadMask : {
						msg : '正在载入数据,请稍候...'
					},
					sm : this.sm,
					// cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
					cm : new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
							{
								header : '原子服务id',
								dataIndex : 'servAtomservId',
								hidden : true
							},
							{
								header : '原子服务名称',
								dataIndex : 'atomservName',
								sortable : true,
								width : 100
							}, {
								header : '原子服务编码',
								dataIndex : 'atomservCode',
								sortable : true,
								hidden : false,
								width : 100
							}, {
								header : '提供者',
								dataIndex : 'servManName',
								sortable : true,
								hidden : false
							}, {
								header : '业务类型',
								dataIndex : 'servBusiTypeName',
								sortable : true,
								width : 130
//								renderer :this.busiTypeName
							},{
								header : '是否可用',
								dataIndex : 'status',
								sortable : true,
								width : 80,
								renderer : this.isCanUse
							}, {
								header : '是否探测',
								dataIndex : 'conndetectFlag',
								sortable : true,
								hidden : false,
								width : 100,
								renderer:this.isDetect
							}, {
								header : '关联服务个数',
								dataIndex : 'relaNumber',
								sortable : true,
								width : 100,
								renderer : this.relaServVersion
							}
					]),
					bbar : new Ext.PagingToolbar({
								firstText : '第一页',
								nextText : '下一页',
								prevText : '上一页',
								refreshText : '刷新',
								lastText : '最后一页',
								beforePageText : '当前',
								afterPageText : '页/共{0}页',
								pageSize : 10,
								store : this.servDefineStore,
								displayInfo : false,
								paramNames : {
										start : 'page.start',
										limit : 'page.pageSize'
												},
								dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
								emptyMsg : "没有可显示的记录",
								items : ['-', {
											text : '添加',
											id : 'bbar_newServDefine',
											iconCls : 'new',
											handler : this.onAddClick,
											scope : this
										}, '-', {
											text : '修改',
											id : 'bbar_updateServDefine',
											iconCls : 'update',
											handler : this.onModifyClick,
											scope : this
										}, '-', {
											text : '删除',
											id : 'bbar_deleteServDefine',
											iconCls : 'delete',
											handler : this.onDeleteClick,
											scope : this
										}, '-'

								]
							}),
					tbar : new Ext.Toolbar({
						items : [this.servLabel, this.servCombo]
							/*
							 * '-','用户姓名：', this.userNameTf, '-','用户标识：',
							 * this.userIDTf, '-',{iconCls: 'find', id:
							 * 'findUserIcon', handler: this.queryHandler,
							 * scope: this}]
							 */
						}),
					ds : this.servDefineStore,
					listeners : {
						"dblclick" : {
							fn : this.onModifyClick,
							scope : this
						},
						"rowcontextmenu" : {
							fn : this.onRightMenuClick,
							scope : this
						}
					}
				});
	},
	queryHandler : function() { // 查询
		var organId = this.organCombo.getValue();
		var userName = this.userNameTf.getValue();
		var userID = this.userIDTf.getValue();
		this.store.load({
					params : {
						start : 0,
						limit : PAGESIZE,
						recordCount : -1,
						organId : organId,
						userName : userName,
						userID : userID
					}
				});
	},
	// 选择服务，查询该服务对应的服务定义
	onServComboSelect : function(combo, record, index) {
		var servId = combo.getValue();
		// var userName = this.userNameTf.getValue();
		// var userID = this.userIDTf.getValue();

		this.store.load({
					params : {
						'page.start':0,
			            'page.pageSize':PAGESIZE,
			            'servAtomServDefineDto.servAtomservId' : servId
					}
				});
	},
	onRightMenuClick : function(grid, rowIndex, e) {
		this.getSelectionModel().selectRow(rowIndex);
		this.fireEvent("cellclick", grid, rowIndex);
		e.preventDefault();
		this.rightMenu.showAt(e.getXY());
	},

	onAddClick : function() {
		selNode = servTree.getSeletedNode();
			
		if(selNode!==null){
			parNode = selNode.parentNode;
		}
		
		/**
		 * 循环查找服务的上层服务商节点
		 */

		if (!selNode || selNode.id.indexOf('sys') == -1|| selNode.id == 'atom_serv_root') {
			Ext.MessageBox.alert('系统提示:', '请选择左边服务提供者...');
			return;
		}
		if (parNode != null) {
			nodeId = parNode.id.substring(9);
		}
		servManNodeId = selNode.id.substring(9);
		manCode = parNode.attributes.code;
		var win = this.insertDefineWindow;
		win.defineForm.getForm().reset();
		win.defineForm.servManIdHidden.setValue(servManNodeId);
		win.defineForm.servManName.setValue(selNode.text);
		win.defineForm.wsdlCombo.store.load({
					params : {
						'wsdlConfDto.servManId' : servManNodeId
					}
				});
		win.defineForm.protoNameCombo.store.load({
					params : {'protocolInfoDto.servManId' : servManNodeId}
				});
		win.defineForm.servBusiTypeCombo.store.load();
		/*win.defineForm.versionStateCombo.store.load({callback:function(){
		 win.defineForm.versionStateCombo.setValue(1);
		}});*/
		var form = win.defineForm;
		/*
		 * win.defineForm.operationNameTextField.setValue('InterfaceService');
		 * win.defineForm.paramNameTextField.setValue('RequestMsg');
		 * win.defineForm.resOperationNameTextField.setValue('InterfaceServiceResponse');
		 * win.defineForm.resParamNameTextField.setValue('ResponseMsg');
		 * win.defineForm.nsTextField.setValue('http://www.yunnantelecom.com/services/mboss/');
		 */
		win.show();
		/*if (form.servTypeCombo.getValue() == '4') {
			form.wsdlNameCombo.setValue('');
			form.wsdlNameCombo.setDisabled(true);
			form.wsdlNameCombo.hide()
			form.operNameCombo.setValue('');
			form.operNameCombo.setDisabled(true);
			form.operNameCombo.hide();
			form.protoNameCombo.setValue('');
			form.protoNameCombo.setDisabled(true);
			form.protoNameCombo.hide();
			form.privateUrlTextField.setValue('');
			form.privateUrlTextField.setDisabled(true);
			form.privateUrlTextField.hide();
			form.queueNameCombo.setDisabled(true);
			form.queueNameCombo.show();
			form.protocolConvertCombox.hide();
			form.servProbeCombo.hide();
		} else {
			form.queueNameCombo.setValue('');
			form.queueNameCombo.setDisabled(false);
			form.queueNameCombo.hide();
			form.wsdlNameCombo.setDisabled(false);
			form.wsdlNameCombo.show();
			form.operNameCombo.setDisabled(false);
			form.operNameCombo.show();
			form.protoNameCombo.setDisabled(false);
			form.protoNameCombo.show();
			form.privateUrlTextField.show();
			form.servProbeCombo.show();
			form.protocolConvertCombox.hide();
			if (form.servTypeCombo.getValue() == '3') {
				form.protocolConvertCombox.show();
			}
			form.complexServPanel.hide();
		}
			form.complexServPanel.hide();*/
	},
	onModifyClick : function() {
		var record = this.selectedRecord();
		if(record==null){
			Ext.Msg.alert('系统提示', blankStr + '请选择一条原子服务记录' + blankStr);
			return;
		}
		wsdlId = record.get('wsdlId');
		wsdlOperId = record.get('wsdlOperId');
		protocolId = record.get('protocolId');
		servManId = record.get('servManId');
		var win = this.updateDefineWindow;
		var form = win.defineForm;
		servBusitype = record.get('servBusitype');
/*		form.wsdlCombo.store.addListener('load', this.setWsdlValue, this);
		form.wsdlOperCombo.store.addListener('load', this.setOperValue, this);
		form.protoNameCombo.store.addListener('load', this.setProtoValue, this);
//		form.versionStateCombo.store.addListener('load', this.setVersionValue,this);
		win.addListener("show", this.loadData, this);*/
		//加载wsdl信息
		form.wsdlCombo.store.load({params:{
		 'wsdlConfDto.servManId' : this.selectedRecord().get('servManId')
		},callback:function(){
		  form.wsdlCombo.setValue(record.get('wsdlId'));
		  //加载操作信息
		  form.wsdlOperCombo.store.load({params:{'wsdlOperDto.wsdlId':wsdlId},callback:function(){
		    form.wsdlOperCombo.setValue(wsdlOperId);
		  }});
		  //加载业务私有地址
		  form.wsdlPrivateAddText.store.load({params:{'wsdlOperDto.wsdlId':wsdlId},callback:function(){
		  	form.wsdlPrivateAddText.setValue(wsdlId);
		  }});
		  }});
		  //加载协议文档
		  form.protoNameCombo.store.load({params:{'protocolInfoDto.servManId':servManId},callback:function(){
		  	if(protocolId ==0||protocolId == null){
		  		form.protoNameCombo.setValue('');
		  	}else{
		     form.protoNameCombo.setValue(protocolId);
		  	}
		  }});
		win.defineForm.servBusiTypeCombo.store.load({callback:function(){
		win.defineForm.servBusiTypeCombo.setValue(servBusitype);
		}});
		/*selNode = servTree.getSeletedNode();
		if(selNode!=null){
		  parNode = selNode.parentNode;
		}
		if (parNode != null) {
			nodeId = parNode.id.substring(9);
		}*/
		/*
		 * for(var i =6;i<9;i++){ //隐藏上传组件 form.getComponent(i).hideLabel =
		 * true; form.getComponent(i).hide(); }
		 */
		if (record) {
			win.show();
			form.getForm().loadRecord(record);
		} else {
			Ext.Msg.alert('系统提示', blankStr + '请选择一条原子服务记录' + blankStr);
		}
	},
	privateAddress : function() {
		this.insertDefineWindow.defineForm.operNameCombo.store.load({
			params : {
				'wsdlOperDto.wsdlId' : parseInt(this.insertDefineWindow.defineForm.wsdlNameCombo.getValue())
			}
		});
		this.insertDefineWindow.defineForm.wsdlPrivateAddText.store.load({
			params : {
				'wsdlConfDto.wsdlId' : parseInt(this.insertDefineWindow.defineForm.wsdlNameCombo.getValue())
			}
		});
	},
	setWsdlValue : function() {
		if (this.selectedRecord().get('wsdlId') == 0) {
			this.updateDefineWindow.defineForm.wsdlCombo.setValue()
		} else {
			this.updateDefineWindow.defineForm.wsdlCombo.setValue(this
					.selectedRecord().get('wsdlId'));
		}
		if (this.updateDefineWindow.defineForm.wsdlCombo.getValue() != '') {
			this.updateDefineWindow.defineForm.wsdlOperCombo.store.load({
				params : {
					'wsdlOperDto.wsdlId' : parseInt(this.updateDefineWindow.defineForm.wsdlCombo
							.getValue())
				}
			});
		}
		this.updateDefineWindow.defineForm.wsdlPrivateAddText.store.load({
					params : {
						'wsdlConfDto.wsdlId' : this.selectedRecord()
								.get('wsdlId')
					}
				});
	},
	setOperValue : function() {
		if (this.selectedRecord().get('wsdlOperId') == 0) {
			this.updateDefineWindow.defineForm.wsdlOperCombo.setValue();
		} else {
			this.updateDefineWindow.defineForm.wsdlOperCombo.setValue(this.selectedRecord().get('wsdlOperId'));
/*			var store = this.updateDefineWindow.defineForm.wsdlOperCombo.store;
			length = store.data.length;
			if(length>0){
				wsdlOperId = this.selectedRecord().get('wsdlOperId');
			  for(i =0;i<length;i++){
			    wsdlOperId1 = store.getAt(i).get('wsdlOperId');
			    if(wsdlOperId == wsdlOperId1){
			     this.updateDefineWindow.defineForm.wsdlOperCombo.setValue(this.selectedRecord().get('wsdlOperId'));
			      break;
			    }
			    
			  }
			}*/
		}
	},
	setProtoValue : function() {
		if (this.selectedRecord().get('protocolId') == 0) {
			this.updateDefineWindow.defineForm.protoNameCombo.setValue();
		} else {
			this.updateDefineWindow.defineForm.protoNameCombo.setValue(this.selectedRecord().get('protocolId'));
		}
	},
	setVersionValue : function() {
		if (this.selectedRecord().get('versionState') == 0) {
			this.updateDefineWindow.defineForm.versionStateCombo.setValue();
		} else {
			this.updateDefineWindow.defineForm.versionStateCombo.setValue(this
					.selectedRecord().get('versionState'));
		}
	},
	onDeleteClick : function() {
		var record = this.selectedRecord();
		if(record==null){
			Ext.Msg.alert('系统提示', blankStr + '请选择一条原子服务记录' + blankStr);
			return;
		}
		relaNumber = record.get('relaNumber');
		atomServDefineObj.atomservCode = record.get('atomservCode');
		atomServDefineObj.servAtomservId = record.get('servAtomservId');
		atomServDefineObj.atomservName = record.get('atomservName');
		servManId = record.get('servManId');
		servAtomservId = record.get('servAtomservId');
		if (record) {
			servDefineId = record.get('servDefineId');
			Ext.MessageBox.confirm('系统提示:', '您确定要删除所选原子服务吗？', function(btn) {
				if (btn == 'yes') {
					dwrLoadMask.show();
					AtomServDefineDwr.remove(atomServDefineObj,'atom_sys_'+servManId,'atom_'+servAtomservId,relaNumber,
							function(data) {
								if (data.optFlag) {
									dwrLoadMask.hide();
									Ext.MessageBox.alert("系统提示:", blankStr+ data.msg + blankStr);
									servDefineGrid.remove(record);
									servTree.refreshNode(servTree.getNodeById('atom_sys_'+servManId));
									if (servDefineGrid.getStore().getCount() == 0) // 服务定义列表中无记录添加按钮可用
										document.getElementById("bbar_newServDefine").disabled = false;
								} else {
									dwrLoadMask.hide();
									Ext.MessageBox.alert("系统提示:", blankStr+ data.msg+ blankStr);
								}
							});
				}
			});
		} else {
			Ext.Msg.alert('系统提示', blankStr + '请选择一条服务定义记录' + blankStr);
		}

	},
	loadData : function() {
		this.updateDefineWindow.defineForm.wsdlCombo.store.load({
					params : {
						'wsdlConfDto.servManId' : this.selectedRecord()
								.get('servManId')
					}
				});
		// this.updateDefineWindow.defineForm.operNameCombo.store.load({params:{'wsdlOperDto.wsdlId'
		// :
		// parseInt(this.updateDefineWindow.defineForm.wsdlNameCombo.getValue())}});
		this.updateDefineWindow.defineForm.protoNameCombo.store.load({
					params : {
						'protocolInfoDto.servManId' : this.selectedRecord()
								.get('servManId')
					}
				});
//		this.updateDefineWindow.defineForm.versionStateCombo.store.load();

	},
	selectedRecord : function() {
		var record = this.getSelectionModel().getSelected();
		return record;
	},
	refresh : function() {
		this.getView().refresh();
	},
	remove : function(record) {
		this.getStore().remove(record);
	},
	// 替换json字符串中的特殊符号'<'
	dealStrToJson : function(value) {
		if (value != null && value.indexOf('<') != -1)
			value = value.replace(/</g, '&lt');
		return value;
	},
	// 转换消息类型number为名称显示
	dealNumToName : function(value) {
		if (value == 0)
			return '同步';
		else if (value == 1)
			return '异步';
	},
	busiTypeName:function(val){
		
	},isCanUse:function(val){
		str = "";
		if(val == 0){
			str = "否";
		}else if(val == 1){
			str = "是";
		}else{
			str = "否"
		}
		return str;
	},isDetect:function(val){
		str = "";
		if(val == 0){
			str = "否";
		}else if (val == 1){
			str = "是";
		}else{
			str = "否";
		}
		return str;
	},relaServVersion:function(val){
		return '<a href = javascript:relaServVersion()>'+val+'</a>';
	}
});
function relaServVersion(){
	record = servDefineGrid.getSelectionModel().getSelected();
//	servDefineId = record.get('servDefineId');
	servAtomservId = record.get('servAtomservId');
//	servManId = record.get('servManId');
	servDefineGrid.relationDefineWindow.show();
	servDefineGrid.relationDefineWindow.defineGrid.store.load({params:{start:0,limit:10,atomServId:servAtomservId}});
}
