/**
 * 流量监控模块JS
 * 
 * @author ZhangJian
 */
Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';
var pageSize = 10;
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

Ext.onReady(function() {
			Ext.override(Ext.menu.DateMenu, {
				render : function() {
					Ext.menu.DateMenu.superclass.render.call(this);
					if (Ext.isGecko) {
						this.picker.el.dom.childNodes[0].style.width = '178px';
						this.picker.el.dom.style.width = '178px';
					}
				}
			});

			Ext.QuickTips.init();

			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
			Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
			var redStar = '<font color=red>' + '*' + '</font>';// 红色星号

			Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
			// 检查用户状态 是否session 超时
			function checkUserSessionStatus(conn, response, options) {
				var sessionStatus = response.getResponseHeader["sessionstatus"];

				if (typeof (sessionStatus) != "undefined") {
					Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
						if (btn == 'ok') {
							var redirect = URL_START + document.location.host
									+ LOG_IN_URL + '?flag=true';
							window.location = redirect;
						}
					});
				}
			}
			// 公用 代码区
			// combox自动加上"请选择"
			var addBlankSelectForCombox = function(combo) { // 自动添加一个空选择项
				combo.on("select", function() {
					if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
						combo.setValue("");
					}
				});
				combo.store.on("datachanged", function(a) {
					var r = new Ext.data.Record({});
					r.set(combo.valueField, ''); // 添加一格值为-1的选项
					r.set(combo.displayField, combo.emptyText);
					a.insert(0, r);
				});
			}

			// 先建注册服务商下拉列表
			var servManStore = new Ext.data.JsonStore(
					{
						url : 'register/servAffordManRegAction_queryAllRegiteredServMans.action',
						root : 'servManList',
						fields : [ 'servManId', 'servManName' ],
						autoLoad : true
					})
			// 服务提供方下拉列表
			var servAffordManCombox = new Ext.form.ComboBox({
				fieldLabel : "服务提供方",
				emptyText : "请选择…",
				store : servManStore,
				editable : false,
				// value:'',
				hiddenName : 'servManId',
				valueField : 'servManId',
				displayField : 'servManName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				forceSelection : true,
				width : 150,
				mode : 'local'
			});
			var servConsumeManCombox = new Ext.form.ComboBox({
				fieldLabel : "服务消费方",
				emptyText : "请选择…",
				store : servManStore,
				editable : false,
				// value:'',
				hiddenName : 'servManId',
				valueField : 'servManId',
				displayField : 'servManName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				forceSelection : true,
				width : 150,
				initComponent : function() {
					addBlankSelectForCombox(this);
				},
				mode : 'local'
			});

			var servStore = new Ext.data.JsonStore(
					{
						url : 'register/servAffordManRegAction_queryServByServMan.action',
						root : 'servDtoList',
						fields : [ 'servId', 'servName' ]
					})
			// 服务名称下拉列表
			var servCombox = new Ext.form.ComboBox({
				fieldLabel : "服务名称",
				emptyText : "请选择…",
				store : servStore,
				editable : false,
				value : '',
				hiddenName : 'servId',
				valueField : 'servId',
				displayField : 'servName',
				typeAhead : true,
				triggerAction : 'all',
				selectOnFocus : true,
				disabled : true,
				width : 150,
				mode : 'local',
				initComponent : function() {
					addBlankSelectForCombox(this);
				}
			});
			/*
			 * 起始更新时间和截止更新时间
			 * 
			 */
			var beginTimeField = new Ext.form.DateField({
				fieldLabel : '开始时间',
				name : 'updateTimeBegin',
				id : 'updateTimeBegin',
				width : 150,
				allowBlank : false,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				emptyText : '选择一个日期'
			});
			var endTimeField = new Ext.form.DateField({
				fieldLabel : '结束时间',
				name : 'updateTimeEnd',
				id : 'updateTimeEnd',
				width : 150,
				allowBlank : false,
				altFormats : 'Y-m-d H:i:s',
				format : 'Y-m-d H:i:s',
				emptyText : '选择一个日期'
			});
			// 二级联动,联动后，原先数据需要清除
			servAffordManCombox.on("select", function(comb) {
				servStore.load({
					params : {
						servAffordManId : comb.value
					}
				});
				servCombox.setValue('');
				// 当服务框未选择时，二级框置不可用
				if (servAffordManCombox.getValue() == '') {
					servCombox.setDisabled(true)
				} else {
					servCombox.setDisabled(false);
				}
			});
			// 计算form 宽度
			var gridWidth = Ext.getBody().getViewSize().width - 5;
			if (screen.width == 1024 && screen.height == 768) {
				gridWidth = Ext.getBody().getViewSize().width - 4;
			}
			// 将上面的查询选项放进form 面板 中
			var queryform = new Ext.FormPanel({
				title : "查询条件",
				width : gridWidth,// Ext.getBody().getViewSize().width - 5,
				height : Ext.getBody().getViewSize().height * 0.29,// 150,
				buttonAlign : 'center',
				applyTo : 'queryform',
				labelWidth : 80,
				labelAlign : "right",
				frame : true,
				items : [ {
					layout : "column",
					items : [ {
						columnWidth : 0.3333,
						layout : "form",
						items : servConsumeManCombox
					}, {
						columnWidth : 0.3333,
						layout : "form",
						items : servAffordManCombox
					}, {
						columnWidth : 0.3333,
						layout : "form",
						items : servCombox
					}, {
						columnWidth : 0.3333,
						layout : "form",
						items : beginTimeField
					}, {
						columnWidth : 0.3333,
						layout : "form",
						items : endTimeField

					} ]
				} ],
				buttons : [ {
					text : "查询",
					iconCls : 'find',
					width : 20,
					hidden : false,
					handler : queryCheck
				}, {
					text : "重置",
					iconCls : 'resume',
					width : 20,
					hidden : false,
					handler : resetQuery
				} ]
			});

			/** ********************************************结果列表区*********************************** */
			var hp = new Ext.data.HttpProxy({
				url : 'monitor/aipMessageQueryAtomAction_findFluxInfo.action'
			});
			var store = new Ext.data.Store({// 配置分组数据集
				proxy : hp,
				reader : new Ext.data.JsonReader({
					totalProperty : "servMonPage.totalCount",
					root : 'servMonPage.result',
					fields : [ 'servMonitorId', 'servId', 'servName',
							'busiMoSum', 'busiMoAvg', 'servManSendName',
							'requestTimes', 'responseTimes', 'successRate', 'failureRate', 'responseAvgTime',
							'responseMinTime', 'responseMaxTime', 'updateTime','servManSendName',
							'ctrlAnalyseTime',,'updateTime','busiServMaxTime','busiServMinTime','busiServAvgTime','servManReceiveName']
				})
			});
			var bbar = new Ext.PagingToolbar({// 分页工具栏
				store : store,
				// 改变传给服务端的分页参数名。extjs3.1推荐是在Store 里面定义这个参数，可是我试验却失败了。
				// 在这里却可以成功，不知道是不是extjs 版本问题
				paramNames : {
					start : 'servMonPage.start',
					limit : 'servMonPage.pageSize'
				},
				pageSize : pageSize,
				displayInfo : true,
				displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
				emptyMsg : "没有记录"
			});
			function queryCheck() {
				var msgText = '时间格式应为：yyyy-mm-dd hh:mm:ss！';
				var msgTextStart = blankStr + "请选择开始时间!" + blankStr;
				var msgTextEnd = blankStr + "请选择结束时间!" + blankStr;
				if (!Ext.getCmp('updateTimeBegin').isValid()) {
					if (Ext.getCmp("updateTimeBegin").getRawValue() == null
							|| Ext.getCmp("updateTimeBegin").getRawValue() == "") {
						Ext.MessageBox.alert("系统提示", msgTextStart, function() {
							Ext.getCmp("updateTimeBegin").focus();
						});
					} else {
						Ext.MessageBox.alert("系统提示", msgText, function(btn) {
							Ext.getCmp("updateTimeBegin").setValue();
							Ext.getCmp('updateTimeBegin').focus();
						});
					}
					return;
				}
				if (!Ext.getCmp('updateTimeEnd').isValid()) {
					if (Ext.getCmp("updateTimeEnd").getRawValue() == null
							|| Ext.getCmp("updateTimeEnd").getRawValue() == "") {
						Ext.MessageBox.alert("系统提示", msgTextEnd, function(btn) {
							Ext.getCmp("updateTimeEnd").focus();
						})
					} else {
						Ext.MessageBox.alert("系统提示", msgText, function(btn) {
							Ext.getCmp("updateTimeEnd").setRawValue("");
							Ext.getCmp('updateTimeEnd').focus();
						});
					}
					return;
				}
				updateBegin = Ext.get("updateTimeBegin").getValue();
				updateEnd = Ext.get("updateTimeEnd").getValue();
				updateBeginTemp = new Date(Date.parse(updateBegin.replace(/-/g,
						"/")));
				updateEndTemp = new Date(Date.parse(updateEnd
						.replace(/-/g, "/")));

				daydiff = (updateEndTemp.getTime() - updateBeginTemp.getTime())
						/ (1000 * 60 * 60 * 24);
				if (daydiff < 0) {
					Ext.Msg.alert("信息提示", "结束时间不能小于开始时间！");
					return;
				}
				// 处理服务id为空时由string类型转long型控制台报错的问题
				var servComboxValue = servCombox.getValue();
				var servConsumeManComboxValue = servConsumeManCombox.getValue();
				var servAffordManComboxValue = servAffordManCombox.getValue();
				var radioValue = 1;
				pageTotal = 10;
				bbar.pageSize = pageTotal;
				if (servComboxValue == '') {
					servComboxValue = 0;
				}
				if (servAffordManComboxValue == '') {
					servAffordManComboxValue = 0;
				}
				store.baseParams = {
					'servMonDto.servId' : parseInt(servComboxValue),
					'servMonDto.servManReceiveId' : parseInt(servAffordManComboxValue),
					'servMonDto.servManSendCode' : servConsumeManComboxValue,
					'servMonDto.updateTimeBegin' : Ext.get("updateTimeBegin").getValue(),
					'servMonDto.updateTimeEnd' : Ext.get("updateTimeEnd").getValue(),
					'servMonDto.showMode' : radioValue
				}
				store.load({
					params : {
						'servMonPage.start' : 0,
						'servMonPage.pageSize' : pageTotal
					}
				}); // 传参供查询调用
			}

			function resetQuery() {
				Ext.getCmp("modeSelect").suspendEvents();
				queryform.getForm().reset();
				Ext.getDom("updateTimeBegin").value = '';
				Ext.getDom("updateTimeEnd").value = '';
				servCombox.setDisabled(true);
			}

			// store.load({params:{start:0, limit:pageSize}});
			// 创建表格数据

			// 定义复选框选择模式变量：加上选择列
			var sm = new Ext.grid.CheckboxSelectionModel();
			// 创建Grid表格组件
			var gridHeight = 360;
			/*
			 * if (Ext.getBody().getViewSize().height - 360 > gridHeight) {
			 * gridHeight = Ext.getBody().getViewSize().height - 360; }
			 */

			var columnWidth = gridWidth - 8;
			var grid = new Ext.grid.GridPanel({
				title : '服务流量监控列表',
				applyTo : 'grid-div',
				width : gridWidth,// Ext.getBody().getViewSize().width - 5,
				// height : 300,
				height : Ext.getBody().getViewSize().height * 0.69,// gridHeight,//
				frame : true,
				stripeRows : true,
				bbar : bbar,
				sm : sm,// 设置复选框选择模式
				store : store,
				loadMask : true,
				viewConfig : {
					forceFit : true
				},
				columns : [// 配置表格列
				sm,// 复选框选择模式中的checkbox组件将会显示在该列
				new Ext.grid.RowNumberer(),
				{
					header : "服务ID",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'servId',
					name : 'servId',
					hidden : true

				}, {
					header : "业务服务名称",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'servManReceiveName',
					name : 'servManReceiveName'
				}, {
					header : "服务名称",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'servName',
					name : 'servName'
				}, {
					header : "服务消费方",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'servManSendName',
					name : 'servManSendName'
				}, {
					header : "总业务流量(KB)",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'busiMoSum',
					name : 'busiMoSum'
				}, {
					header : "平均业务流量(KB)",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'busiMoAvg',
					name : 'busiMoAvg'
				}, {
					header : "服务请求次数",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'requestTimes',
					name : 'requestTimes'
				}, {
					header : "服务响应次数",
					width : columnWidth / 12,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'responseTimes',
					name : 'responseTimes'
				}, {
					header : "服务调用成功率(%)",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'successRate',
					name : 'successRate',
					hidden : true

				}, {
					header : "服务调用失败率(%)",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'failureRate',
					name : 'failureRate'
				}, {
					header : "业务服务历时平均值(ms)",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'busiServAvgTime',
					name : 'busiServAvgTime'
				}, {
					header : "业务服务历时最小值(ms)",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'busiServMinTime',
					name : 'busiServMinTime'
				}, {
					header : "业务服务历时最大值(ms)",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'busiServMaxTime',
					name : 'busiServMaxTime'
				}, {
					header : "分析时间",
					width : columnWidth / 8,// Ext.getBody().getViewSize().width
					sortable : true,
					dataIndex : 'updateTime',
					name : 'updateTime'
				}]
			})
			store.load({
				params : {
					'servMonPage.start' : 0,
					'servMonPage.pageSize' : pageSize
				}
			});
		});
