var TEST_STORE_URL='test.action';

TestGrid=Ext.extend(Ext.grid.GridPanel, {
	testStore : new Ext.data.Store({
		proxy : new Ext.data.HttpProxy({
			url : TEST_STORE_URL,
			method : 'POST'
		}),
		reader : new Ext.data.JsonReader({
		}, [{name : 'cm1'},
			{name : 'cm2'}, 
			{name : 'cm3'}])
	}),
	constructor: function() {
		TestGrid.superclass.constructor.call(this, {
			renderTo : 'testGrid',
			title : 'test',
			frame : true,
			stripeRows : true,
			width : Ext.getBody().getViewSize().width - 5,
			height : Ext.getBody().getViewSize().height - 280,
//			viewConfig : {
//				forceFit : true
//			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			sm : new Ext.grid.RowSelectionModel({
				singleSelect : true
			}),
			cm : new Ext.grid.ColumnModel([{
					header : "列1",
					dataIndex : 'cm1',
					align : 'center',
					width : 100
				}, {
					header : "列2",
					dataIndex : 'cm2',
					align : 'center',
					width : 100
				}, {
					header : "列3",
					dataIndex : 'cm3',
					align : 'center',
					width : 100
				}]),
			ds : this.testStore,
			bbar : new Ext.Toolbar({
				items : ['-', {
					text : '增加',
					iconCls : 'new',
					handler : this.addClick,
					scope : this
				}]
			})
		})
	},
	addClick:function(){
		AlarmManager.test(function(data){
			alert("dwr调用:"+data);
		})
	}
});

/*********************onReady 组件渲染及处理*************************************************/
Ext.onReady(function() {
    
    Ext.QuickTips.init();
    Ext.form.Field.prototype.msgTarget = 'side';
    
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    
    testGrid=new TestGrid();
    testGrid.store.load();
    
});