/**
 * 资源树
 * @author pbqi
 * @date 2009-11-3 16:17:07
 */
ResourceTree = Ext.extend(Ext.tree.TreePanel, {
    
    rightMenu: null,
    
	constructor: function() {
        
        this.rightMenu = new Ext.menu.Menu({
            items: [
                { text: '子全选', handler: this.doSelectSub, scope: this},
                { text: '子反选', handler: this.doUnSelectSub, scope: this}
            ]
        });
        
		ResourceTree.superclass.constructor.call(this, {
			//title: '资源树',
			width:Ext.getBody().getViewSize().width*0.24,
			height:Ext.getBody().getViewSize().height - 80,
			margins: '50px 50px 50px 50px',
			frame: true,
			border: true,
			checkModel: 'cascade',    //对树的级联多选
			onlyLeafCheckable: false,//对树所有结点都可选
			animate: false,
			rootVisible: true,
			autoScroll:true,
			baseCls:'x-panel',
			loader: new Ext.tree.TreeLoader({
				dataUrl: 'getNodesWithChinaByUserId.action',
				baseAttrs: { uiProvider: Ext.tree.TreeCheckNodeUI } //添加 uiProvider 属性
			}),
	        root: new Ext.tree.AsyncTreeNode({
	        	id: 'resource_root_1',
	            text:'资源树',
	            draggable:false,
	            expanded: true
	        }),
            listeners: {
                'contextmenu': {fn: this.onContextMenuClick, scope: this}
            }
		});
	},
    /**
     * 右键选择带子节点的设备节点
     */
    onContextMenuClick: function(node, e) {
        if(node.attributes.device && !node.attributes.leaf) {
            this.getSelectionModel().select(node);
            e.preventDefault();
            this.rightMenu.showAt(e.getXY());
        }
    },
    /**
     * 子全选
     */
    doSelectSub: function() {
        var that = this;
        var selNode = that.getSelectionModel().getSelectedNode();
        selNode.getUI().checkbox.checked = true;  
        selNode.attributes.checked = true; 
        var childs;
        if(!selNode.isExpanded()) {
            selNode.expand(true, true, function(node) {
                childs = node.childNodes;
                if(childs && childs.length) {
                    for(var i = 0, len = childs.length; i < len; i++) {
                        childs[i].getUI().checkbox.checked = true;  
                        childs[i].attributes.checked = true; 
                        that.fireEvent('check', childs[i], true); 
                    }
                }
            });
       } else {
            childs = selNode.childNodes;
	        if(childs && childs.length) {
	            for(var i = 0, len = childs.length; i < len; i++) {
	                childs[i].getUI().checkbox.checked = true;  
	                childs[i].attributes.checked = true;  
	                that.fireEvent('check', childs[i], true); 
	            }
	        }
       }
    },
    /**
     * 子反选
     */
    doUnSelectSub: function() {
        var that = this;
        var selNode = that.getSelectionModel().getSelectedNode();
        var childs;
        if(!selNode.isExpanded()) {
            selNode.expand(true, true, function(node) {
                childs = node.childNodes;
                if(childs && childs.length) {
                    for(var i = 0, len = childs.length; i < len; i++) {
                        childs[i].getUI().checkbox.checked = !childs[i].getUI().checkbox.checked; 
                        childs[i].attributes.checked = !childs[i].attributes.checked; 
                        that.fireEvent('check', childs[i], childs[i].attributes.checked); 
                    }
                }
            });
        }else {
	        childs = selNode.childNodes;
	        if(childs && childs.length) {
	            for(var i = 0, len = childs.length; i < len; i++) {
	                childs[i].getUI().checkbox.checked = !childs[i].getUI().checkbox.checked;  
	                childs[i].attributes.checked = !childs[i].attributes.checked;
	                that.fireEvent('check', childs[i], childs[i].attributes.checked);
	            }
	        }
        }
    },
	/**
	 * 获得被选中的节点的instanceId(Array)
	 */
	getSelNodeInstanceIds: function(){
		var selNodes = this.getChecked();
		var instanceIds = [];
		if(selNodes && selNodes.length) {
			for(var i = 0, len = selNodes.length; i < len; i++) {
				if(selNodes[i].attributes.device) {
					var nodeId = selNodes[i].id;
					var arr = nodeId.split("_");
					instanceIds.push(arr[2]);
				}
			}
		}
		return instanceIds;
	},
	
	/**
	 * 获得被选中的节点id 为字符串("D_11_11")(Array)
	 */
	getSelNodeIds: function(){
		var selNodes = this.getChecked();
		var deviceIds = [];
		if(selNodes && selNodes.length) {
			for(var i = 0, len = selNodes.length; i < len; i++) {
				if(selNodes[i].attributes.device) {
					deviceIds.push(selNodes[i].id);
				}
			}
		}
		return deviceIds;
	},
	/**
	 * 获得被选择的节点记录(Nodes)
	 */
	getSelectedNodes: function() {
		var selNodes = this.getChecked();
		var deviceNodes = [];
		if(selNodes && selNodes.length) {
			for(var i = 0, len = selNodes.length; i < len; i++) {
				if(selNodes[i].attributes.device) {
					deviceNodes.push(selNodes[i]);
				}
			}
		}
		return deviceNodes;
	},
    
	clearCheckTree: function(nodes){
		for(var i=0; i<nodes.length; i++){
			if(!nodes[i].isLeaf()){
	            var childNodes = nodes[i].childNodes;
	            this.clearCheckTree(childNodes);            
	        } 
	        nodes[i].getUI().checkbox.checked = false;
	        nodes[i].attributes.checked = false;
		}
	}
});