/***************************************UserRoleGrid组件***************************************************/
AlarmTypeGrid = Ext.extend(Ext.grid.GridPanel, {
	
    alarmTypeSm: null,
    
    constructor: function() {
    	
    	this.alarmTypeSm = new Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn});
    	this.alarmTypeSm.on('rowselect', this.onCheckSelected, this);
    	
        AlarmTypeGrid.superclass.constructor.call(this, {
            width: Ext.getBody().getViewSize().width * 0.18,
            height: 300,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: this.alarmTypeSm,
            cm: new Ext.grid.ColumnModel([
                this.alarmTypeSm,
                {header:'id',dataIndex:'almType',hidden:true},
                {header:'告警类型',dataIndex:'almTypeName'}
            ]),
	        ds:new Ext.data.Store({
		        proxy: new Ext.data.HttpProxy({url: 'getAllAlarmType.action', method: 'POST'}),
		        reader: new Ext.data.JsonReader({},[{name:'almType'},{name:'almTypeName'}])
		    })
        });
    },
    onCheckSelected: function(selModel, rowIndex, r) {
    	
    	var selRecord = selModel.getSelections();
    	if(r && r.data.almType == -1)  {
    		if(selRecord && selRecord.length > 1) {
    			for(var i = 0; i < selRecord.length; i++) {
    				if(selRecord[i].data.almType != -1)
    				    selModel.deselectRow(this.store.find("almType", selRecord[i].data.almType));
    			}
    		}
    	}
    	if(r && r.data.almType != -1 && selRecord.length > 1)  {
             selModel.deselectRow(this.store.find("almType", -1));
        }
    }
});

/***************************************AlarmCatGrid组件***************************************************/
AlarmCatGrid = Ext.extend(Ext.grid.GridPanel, {
	
    alarmCatSm: null,
    
    constructor: function() {
    	
    	 this.alarmCatSm = new Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn});
    	 this.alarmCatSm.on('rowselect', this.onCheckSelected, this); 
    	
        AlarmCatGrid.superclass.constructor.call(this, {
            width: Ext.getBody().getViewSize().width * 0.18,
            height: 300,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: this.alarmCatSm,
            cm: new Ext.grid.ColumnModel([
                this.alarmCatSm,
                {header:'almCat',dataIndex:'almCat',hidden:true},
                {header:'告警类别',dataIndex:'almCatName'}
            ]),
	        ds:new Ext.data.Store({
		        proxy: new Ext.data.HttpProxy({url: 'getAllAlarmCat.action', method: 'POST'}),
		        reader: new Ext.data.JsonReader({},[{name:'almCat'},{name:'almCatName'}])
		    })
        });
    },
    onCheckSelected: function(selModel, rowIndex, r) {
    	
    	var selRecord = selModel.getSelections();
    	if(r && r.data.almCat == -1)  {
    		if(selRecord && selRecord.length > 1) {
    			for(var i = 0; i < selRecord.length; i++) {
    				if(selRecord[i].data.almCat != -1)
    				    selModel.deselectRow(this.store.find("almCat", selRecord[i].data.almCat));
    			}
    		}
    	}
    	if(r && r.data.almCat != -1 && selRecord.length > 1)  {
             selModel.deselectRow(this.store.find("almCat", -1));
        }
    }
}); 

/***************************************AlarmLevelGrid组件***************************************************/
AlarmLevelGrid = Ext.extend(Ext.grid.GridPanel, {
	
    alarmLevelSm: null,
   
    
    constructor: function() {
    	 
    	 this.alarmLevelSm = new Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn});
    	 this.alarmLevelSm.on('rowselect', this.onCheckSelected, this); 
    	 
        AlarmLevelGrid.superclass.constructor.call(this, {
            width: Ext.getBody().getViewSize().width * 0.18,
            height: 300,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: this.alarmLevelSm,
            cm: new Ext.grid.ColumnModel([
                this.alarmLevelSm,
                {header:'id',dataIndex:'almLevel',hidden:true},
                {header:'告警级别',dataIndex:'almLevelName'}
            ]),
	        ds:new Ext.data.Store({
		        proxy: new Ext.data.HttpProxy({url: 'getAllAlarmLev.action', method: 'POST'}),
		        reader: new Ext.data.JsonReader({},[{name:'almLevel'},{name:'almLevelName'}])
		    })
        });
    },
    onCheckSelected: function(selModel, rowIndex, r) {
    	
    	var selRecord = selModel.getSelections();
    	if(r && r.data.almLevel == -1)  {
    		if(selRecord && selRecord.length > 1) {
    			for(var i = 0; i < selRecord.length; i++) {
    				if(selRecord[i].data.almLevel != -1)
    				    selModel.deselectRow(this.store.find("almLevel", selRecord[i].data.almLevel));
    			}
    		}
    	}
    	if(r && r.data.almLevel != -1 && selRecord.length > 1)  {
             selModel.deselectRow(this.store.find("almLevel", -1));
        }
    }
});
