/**
 * 告警过滤器树
 * @author pbqi
 * @date 2009-11-3 16:17:07
 */
AlarmWebFilterTree = Ext.extend(Ext.tree.TreePanel, {
	
	rightMenu : null,
	saveFlag: true,
	
	constructor: function() {
		
		 //对根节点右键菜单，主要针对目录的操作
		this.rootRightMenu = new Ext.menu.Menu({
            items: [
                { text: '增加目录', handler: this.addCatalog, scope:this},'-',
                { text: '刷新', handler: this.refreshCatalog, scope: this}
            ]
        });
        
		//对目录右键菜单，主要针对目录的操作
        this.catalogRrightMenu = new Ext.menu.Menu({
            items: [
            	{ text: '修改目录', handler: this.updateCatalog, scope:this},
                { text: '删除目录', handler: this.deleteCatalog, scope:this},'-',
                { text: '增加过滤器', handler: this.addFilter, scope:this},'-',
                { text: '刷新', handler: this.refreshFilter, scope: this}
            ]
        });
        
        //对叶子节点右键菜单， 主要针对过滤器的操作
        this.filterRightMenu = new Ext.menu.Menu({
            items: [
                { text: '修改过滤器', handler: this.updateFilter, scope:this},
                { text: '删除过滤器', handler: this.deleteFilter, scope:this}
            ]
        });
        
		AlarmWebFilterTree.superclass.constructor.call(this, {
			title: '告警过滤器',
			region:'west',
            split:true,
			autoScroll:true, 
	        enableDD:false,//是否支持拖拽效果
	        containerScroll: true,//是否支持滚动条
	        split:true,
	        width: 160,
	        border: true,
	        frame: false,
	        animCollapse:false,
            animate: false,
            collapseFirst:false,
	        height:Ext.getBody().getViewSize().height - 10,
	        rootVisible:true,//是否显示跟节点
	        collapsible: true,
	        margins:'0 0 0 0',
	        loader:new Ext.tree.TreeLoader({  
	            dataUrl: 'getChildNodes.action'
	        }),
	        /*tbar: [
             '名称:',{xtype:'textfield',width:100, id:'byNameTf'},
             '-',{iconCls:'find', handler: this.filterByName,scope:this},
             '-',{iconCls:'refreshxp', handler: this.doRefresh,scope:this}
            ],*/
	        root: new Ext.tree.AsyncTreeNode({
	        	id: 'web_filter_root',
	            text:'告警过滤器',
	            draggable:false,
	            expanded: true
	        }),
	        listeners: {
	        	'contextmenu': {fn: this.onRightMenuClick, scope: this},
	        	'click': {fn: this.onTreeClick, scope: this}
	        }/*,
	        bbar: new Ext.Toolbar({
            	items:[
            		{ id: 'tips',xtype: 'label',text: '选择节点为:',style: 'color: black;'}
            	]
            })*/
		});
	},
	onTreeClick: function(node, e) {
		e.preventDefault();
		this.getSelectionModel().select(node);
		if(node != this.getRootNode() && !node.attributes.catalog) {
			this.updateFilter();
		} else {
			if(node.attributes.catalog) {
				this.saveFlag = true;
			}
			this.outPanel.clearCondition();
		}
		
	},
	refreshCatalog: function() {
		this.doRefresh();
	},
	refreshFilter: function() {
		this.doRefresh();
	},
	doRefresh: function() {	//刷新节点
       this.refreshNode(this.getRootNode());
	},
	onRightMenuClick: function(node, e) {	//右键菜单
		//this.fireEvent("click", node, e);
        this.getSelectionModel().select(node);	//选中被右键选择的节点
        //Ext.get('tips').dom.innerHTML = '<font color=black>选择节点为：</font>' +'<font color=blue>' + node.text+ '</font>';
    								
		e.preventDefault();
		if(node == this.getRootNode()) {
			 this.rootRightMenu.showAt(e.getXY());//取得鼠标点击坐标，展示菜单
		} else if(node.attributes.catalog === "true"){
			 this.catalogRrightMenu.showAt(e.getXY());//取得鼠标点击坐标，展示菜单
		} else {
			this.filterRightMenu.showAt(e.getXY());
		}
	},
	addCatalog: function() {
		var that = this;	//获得过滤器树的引用
		Ext.Msg.prompt('增加过滤器目录', '请输入新增加的过滤器目录名称', function(btn, text){
		    if (btn == 'ok'){
		    	AlarmWebFilterManager.saveCatalog(text, function(data) {
		    		if(data) {
		    			 Ext.MessageBox.alert("系统提示:", blankStr + "添加过滤器目录成功" + blankStr);
		    			 that.refreshNode(that.getRootNode());
		    		} else {
		    			 Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		    		}
		    	});
		    }
		});
	},
	updateCatalog: function() {
		var that = this;	//获得过滤器树的引用
		var selectedNode = this.getSelectedNode();
		if(!selectedNode)
			return;
			
		Ext.Msg.prompt('修改过滤器目录', '请输入要修改的过滤器目录名称', function(btn, text){
		    if (btn == 'ok'){
		    	AlarmWebFilterManager.updateCatalog(selectedNode.id.substring(11), text, function(data) {
		    		if(data) {
		    			Ext.MessageBox.alert("系统提示:", blankStr + "修改过滤器目录成功" + blankStr);
		    			that.refreshNode(that.getRootNode());
		    			//Ext.get('tips').dom.innerHTML = '<font color=black>选择节点为：</font>' + '</font>';
		    		} else {
		    			Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		    		}
		    	});
		    }
		}, null, false, selectedNode.text);
	},
	deleteCatalog: function() {
		var node = this.getSelectedNode();
		if(node.childNodes && node.childNodes.length) {
			Ext.MessageBox.alert("系统提示:", blankStr + "此过滤器目录下存在过滤器,不允许删除" + blankStr);
			return;
		}
		var that = this;
        Ext.MessageBox.confirm('系统提示:','你确定要删除所选过滤器目录吗？',function(btn){
            if(btn == 'yes') {
                AlarmWebFilterManager.deleteCatalog(node.id.substring(11), function(data){
                    if(data) {
                        Ext.MessageBox.alert("系统提示:", blankStr + "删除过滤器目录成功" + blankStr);
                        that.refreshNode(that.getRootNode());
                        //Ext.get('tips').dom.innerHTML = '<font color=black>选择节点为：</font>' + '</font>';
                    } else {
                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                    }
                });
            }
        });
	},
	addFilter: function() {	   //增加过滤器
		this.saveFlag = true;
		this.outPanel.clearCondition();
	},
	/**
	 * 获得过滤器的详细信息
	 */
	updateFilter: function() { 
		this.saveFlag = false;
		var that = this, 
			outPanel = that.outPanel,
			marjorFieldSet = outPanel.majorFieldSet,
			minorFieldSet = outPanel.minorFieldSet,
			resourceTree = outPanel.resourceTree;
			selNode = that.getSelectionModel().getSelectedNode();
		
		//清空
		outPanel.clearCondition();
		
		outPanel.nameTf.setValue(selNode.text);
		
		var mk = new Ext.LoadMask(outPanel.el, {
			msg: '正在过滤器的详细信息...',
			removeMask : true
		});
		mk.show();
		
		AlarmWebFilterManager.getFilterInfo(selNode.id.substring(8), function(data) {
			if(data) {
				var jsonData = Ext.decode(data);
				var filterList = jsonData.filterList;
				var catList = jsonData.catList;
				var typeList = jsonData.typeList;
				var levelList = jsonData.levelList;
				var devList = jsonData.devList;
				that.resumeGrid(catList, marjorFieldSet.alarmCatGrid, "almCat", "almCatId");
				that.resumeGrid(typeList, marjorFieldSet.alarmTypeGrid, "almType", "almTypeId");
				that.resumeGrid(levelList, marjorFieldSet.alarmLevelGrid, "almLevel", "almLevelId");
				that.resumeResTree(devList, resourceTree);
				that.resumeTime(filterList, minorFieldSet);
				mk.hide();
		   } else {
		   		mk.hide();
		   }
		});
	},
	/**
	 * 恢复时间
	 */
	resumeTime: function(filterList, minorFieldSet) {
		if(filterList && filterList.length) {
			var r = filterList[0];
			minorFieldSet.startDateDf.setRawValue(r.startDate);
			minorFieldSet.endDateDf.setRawValue(r.endDate);
		}
	},
	/**
	 * list: 后台返回的结果
	 * grid: 为对应的grid
	 * storeId: store中对应的id
	 * id: 后台返回数据对应的id
	 */
	resumeGrid: function(list, grid, storeId, id) {
		if(list && list.length) {
			for(var i = 0; i < list.length; i++) {
				var idIndex = grid.store.find(storeId,(list[i].id)[id]);
				grid.getSelectionModel().selectRow(idIndex, true); 
			}
		}
	},
	/**
	 * 恢复资源树
	 */
	resumeResTree: function(devList, resourceTree) {
		if(devList && devList.length) {
			for(var i = 0, len = devList.length; i < len; i++) {
				(function(i){
					var path = devList[i].path;
					var index = path.lastIndexOf("/");
					if(index > 0)
						path = path.substring(0, index);
					var childs = devList[i].childs;
					resourceTree.expandPath(path, null, function(bSuccess, oLastNode){
    					if(bSuccess) {
	    					if(childs && childs.length) {
								for(var j = 0, leng = childs.length; j < leng; j++) {
									var node = resourceTree.getNodeById(childs[j].nodeId);
				                    if(node != null) {
				                    	node.getUI().checkxpx(!node.attributes.checked);
				                    	node.attributes.checked = true;
				                    	node.attributes.device = "true";
				                    }
								}
							}
    					}
					});
				})(i);
			}
		}
	},
	deleteFilter: function() {
		
		var node = this.getSelectedNode();
		var pNode = node.parentNode;
		var that = this;
		
		 Ext.MessageBox.confirm('系统提示:','你确定要删除所选过滤器吗？',function(btn){
            if(btn == 'yes') {
                AlarmWebFilterManager.deleteFilter(node.id.substring(8), function(data){
                    if(data) {
                        Ext.MessageBox.alert("系统提示:", blankStr + "删除过滤器成功！" + blankStr);
                        that.refreshNode(that.getRootNode());
                        that.outPanel.clearCondition();
                        //Ext.get('tips').dom.innerHTML = '<font color=black>选择节点为：</font>' + '</font>';
                    } else {
                        Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
                    }
                });
            }
        });
	},
    refreshNode: function(node) {	//刷新节点
        this.getLoader().load(node, function() {
            node.expand();
        });
    },
	isLeaf: function(node) {		//判断某个节点是否为叶子节点
		if(node.attributes.leaf === "true")
			return true;
		return false;
	},
	getSelectedNode: function() {	//获得被选择的节点
        return this.getSelectionModel().getSelectedNode();
    }
});