/**
* @description 对告警中字段过滤的设置
* @author pbqi
* @date 2009-11-3 19:27:15
*/

/**
 * 关键字段
 */
MajorFieldSet = Ext.extend(Ext.form.FieldSet, {
	
	alarmTypeGrid: null,	//告警类型
	alarmCatGrid: null,	//告警类别
	alarmLevelGrid:null,	//告警级别
	
	constructor: function() {
		
    	this.alarmTypeGrid = new AlarmTypeGrid();
    	this.alarmTypeGrid.store.load();
    	this.alarmCatGrid = new AlarmCatGrid();
    	this.alarmCatGrid.store.load();
    	this.alarmLevelGrid = new AlarmLevelGrid();
    	this.alarmLevelGrid.store.load();
		
		MajorFieldSet.superclass.constructor.call(this, {
			 title: '关键字段',
             height: 330,
             layout:'form',
             items: [{
             	layout: 'column',
             	xtype: 'panel',
             	items: [{
	             	columnWidth: .33,
	             	items:[this.alarmTypeGrid]
	             }, {
	             	columnWidth: .33,
	             	items:[this.alarmCatGrid]
	             }, {
	             	columnWidth: .34,
	             	layout:'form',
	             	items:[this.alarmLevelGrid]
	             }]
	         }]
		});
	},
	clearGrid: function() {
		this.alarmTypeGrid.getSelectionModel().clearSelections();
		this.alarmCatGrid.getSelectionModel().clearSelections();
		this.alarmLevelGrid.getSelectionModel().clearSelections();
	},
	getSelectedTypes: function() {
		return this.getArrayId(this.alarmTypeGrid, 'almType');
	},
	getSelectedCats: function() {
		return this.getArrayId(this.alarmCatGrid, 'almCat');
	},
	getSelectedLevels: function() {
		return this.getArrayId(this.alarmLevelGrid, 'almLevel');
	},
	/**
	 * private 获得通过属性和grid获得被选中记录的id数组
	 */
	getArrayId: function(grid, id) {
		var almIds = [];
		var selRecord = grid.getSelectionModel().getSelections();
		if(selRecord && selRecord.length) {
			for(var i = 0; i < selRecord.length; i++) {
				almIds.push(selRecord[i].get(id));
			}
		}
		return almIds;
	}
});


/**
 * 其他字段
 */
MinorFieldSet = Ext.extend(Ext.form.FieldSet, {
	
	startDateDf:null,
	endDateDf:null,
	
	constructor: function() {
		
		this.startDateDf = Ext.pbqi.ux.createDateField("开始时间", "startDate", 'Y-m-d H:i:s', '80%', new Date(new Date().getTime() - 24*60*60*1000));
		this.endDateDf = Ext.pbqi.ux.createDateField("结束时间", "endDate", 'Y-m-d H:i:s', '80%', new Date());
		
		MinorFieldSet.superclass.constructor.call(this, {
			 title: '其他字段',
             height: Ext.getBody().getViewSize().height - 450,
             layout:'form',
             items: [{
             	layout: 'column',
             	xtype: 'panel',
             	items: [{
	             	columnWidth: .48,
	             	layout: 'form',
	             	items:[this.startDateDf]
	             }, {
	             	columnWidth: .48,
	             	layout: 'form',
	             	items:[this.endDateDf]
	             }]
	         }]
		});
	}
});
