/**
 * @description 条件设置面板
 * @author pbqi
 * @date 2009-11-3 19:05:36
 */
OutPanel = Ext.extend(Ext.Panel, {
	
	nameTf : 		null,	//过滤器名称
	resourceTree :	null,	//资源查询网元树
	majorFieldSet:	null,	//关键字段组成的fieldSet
	
	constructor: function(cfg) {
		
		var cfg = cfg || {};
		Ext.apply(this, cfg);	//拷贝构造中传递的参数到当前对象中
		
		this.nameTf = Ext.pbqi.ux.createTextField("过滤器名称", "name", '90%');
		this.tipHidden = Ext.pbqi.ux.createHidden("tip");
		
		this.saveBtn = Ext.pbqi.ux.createButton("保存",this.doSave, this,"save");
		
		this.resourceTree = new ResourceTree();
		
		this.majorFieldSet = new MajorFieldSet();
		this.minorFieldSet = new MinorFieldSet();
		
		OutPanel.superclass.constructor.call(this, {
			title:　'条件设置',
			region: 'center',
			items: '33444',
			isFormField:true,
			height: Ext.getBody().getViewSize().height - 10,
			frame: true,
			layout: 'form',
			items:[{
					layout: 'column',
					items: [{
						columnWidth: .4,
						layout: 'form',
						items: [this.nameTf]
					}, {
						columnWidth: .2,
						layout: 'form',
						items: [this.saveBtn]
					}, {
						columnWidth: .1,
						layout: 'form',
						items: [this.tipHidden]
					}]
				},{
					xtype:'panel',
					height:10,
					width: 1000,
					border:1
					//frame: true
				},{
					layout: 'column',
					items: [{
						columnWidth: .3,
						items: [this.resourceTree]
					}, {
						columnWidth: .7,
						layout: 'form',
						items: [this.majorFieldSet, this.minorFieldSet]
					}]
			}]
		});
	},
	getConditionObj: function() {
		//获得过滤器名称
		var filterName = this.nameTf.getValue();
		
		//获得3个关键字段grid被选择的记录
		var almTypeIds = this.majorFieldSet.getSelectedTypes();
		var almCatIds = this.majorFieldSet.getSelectedCats();
		var almLevelIds = this.majorFieldSet.getSelectedLevels();
		
		//获得时间段数组
		var times = [];
		var startTime = this.minorFieldSet.startDateDf.getRawValue();
		var endTime = this.minorFieldSet.endDateDf.getRawValue();
		if(startTime && endTime) {
			times.push(startTime);
			times.push(endTime);
		}
		
		//获得被选择的网元
		var devStrs = this.resourceTree.getSelNodeIds();
		var devIds = this.resourceTree.getSelNodeInstanceIds();
		
		//设置把对应的属性加入到条件对象中
		var conditionObj = {
			filterName: filterName,
			almTypeIds: almTypeIds,
			almCatIds: almCatIds,
			almLevelIds: almLevelIds,
			times: times,
			devIds: devIds,
			devStrs: devStrs
		};
		return conditionObj;
	},
	doSave: function() {	//保存
		var that = this;	//获得当前对象的引用
			filterTree = this.filterTree;
			selFilterNode = filterTree.getSelectedNode();
		
		if(!selFilterNode) {
			Ext.MessageBox.alert("系统提示:", blankStr + "请首先选择过滤器树上节点" + blankStr);
			return;
		}
		if(selFilterNode == filterTree.getRootNode()) {
			Ext.MessageBox.alert("系统提示:", blankStr + "只能在过滤器目录下添加过滤器" + blankStr);
			return;
		}
		
		var conditionObj = this.getConditionObj();
		if(!conditionObj.filterName) {
			Ext.MessageBox.alert("系统提示:", blankStr + "请输入过滤器名称" + blankStr);
			return;
		}
		if(conditionObj.times && conditionObj.times.length == 2) {
			var t = conditionObj.times;
			if(Date.parseDate(t[0], 'Y-m-d H:i:s').getTime() > Date.parseDate(t[1], 'Y-m-d H:i:s').getTime()) {
				Ext.MessageBox.alert("系统提示:", blankStr + "开始时间大于结束时间，请重新选择" + blankStr);
				return;
			}
		}
		
		var pNode = selFilterNode.parentNode;
		
		var mk = new Ext.LoadMask(this.el, {
			msg: '正在保存过滤器...',
			removeMask : true
		});
		mk.show();
		if(filterTree.saveFlag) {
			conditionObj.nodeId = selFilterNode.id;
			
			AlarmWebFilterManager.saveFilter(conditionObj, function(data) {
	    		if(data) {
	    			 Ext.MessageBox.alert("系统提示:", blankStr + "添加过滤器成功" + blankStr);
	    			 mk.hide();
	    			 that.clearCondition();
	    			 filterTree.refreshNode(selFilterNode);
	    		} else {
	    			 Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
	    			 mk.hide();
	    		}
	    	});
	    } else {
	    	
			conditionObj.nodeId = pNode.id;
			
	    	AlarmWebFilterManager.updateFilter(selFilterNode.id.substring(8), conditionObj, function(data) {
	    		if(data) {
	    			 Ext.MessageBox.alert("系统提示:", blankStr + "修改过滤器成功" + blankStr);
	    			 mk.hide();
	    			 that.clearCondition();
	    			 filterTree.refreshNode(pNode);
	    			 //Ext.get('tips').dom.innerHTML = '<font color=black>选择节点为：</font>' + '</font>';
	    		} else {
	    			 Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
	    			 mk.hide();
	    		}
	    	});
	    }
	    
	},
	clearCondition:function() {
		this.nameTf.reset();
		
		//清空3个关键字段grid被选择的记录
		this.majorFieldSet.clearGrid();
		
		//清空时间段数组
		var startTime = this.minorFieldSet.startDateDf.reset();
		var endTime = this.minorFieldSet.endDateDf.reset();
		
		//获得被选择的网元
		this.resourceTree.clearCheckTree(this.resourceTree.getRootNode().childNodes);
	},
	/**
	 * 取得图标并显示
	 * @params:icon(图标名称)
	 * @params:cls(图标对应的class)
	 * @params:offsetX(图标距离在上面到左的位置)
	 * @params:msg(提示信息)
	 */
	getIcon: function(icon, cls, offsetX, msg) {
		if(!this[icon]) {	//保证图标唯一
			var elp = this.getIconCt();
            this[icon] = elp.createChild({cls:cls});
		}
		this.showIcon(icon,offsetX, msg);
	},
	showIcon: function(icon, offsetX, msg) {     //显示图标
		this[icon].alignTo(this.tipHidden.el, 'tl-tr', [offsetX, 0]);
        this[icon].dom.qtip = msg;
        this[icon].show();
	},		
	hideIcon: function(icon) { //隐藏图标
		if(this[icon])
			this[icon].hide();
	},
	//这里可以设置Field组件id或者其他-->获得组件的Ext.Element
	getIconCt : function(id){	
		//Ext.get(id).findParent('.x-form-element', 5, true) || this.el.findParent('.x-form-field-wrap', 5, true);   
        return this.tipHidden.el.findParent('.x-form-element', 5, true) || this.el.findParent('.x-form-field-wrap', 5, true);   
    },
    
	/**
	 * 开始时间和结束时间比较， 取得最小的开始时间和最大的结束时间
	 */
	getTimePanel: function() {
		var timeBegins = [], timeEnds = [], times = [];	//times为应该获得的时间段
		if(timeStore && timeStore.getCount()) {
			for(var i = 0; i < timeStore.getCount(); i++) {
				var r = timeStore.getAt(i);
				timeBegins.push(r.get('timeBegin'));
				timeEnds.push(r.get('timeEnd'));
			}
			times.push(this.getMinBeginDate(timeBegins));
			times.push(this.getMaxEndDate(timeEnds));
		}
		return times;
	},
	/**
	 * private 取得最小的开始时间
	 */
	getMinBeginDate: function(timeBegins) {
		var min;
		if(timeBegins && timeBegins.length) {
			min = timeBegins[0];
			for(var i = 1; i < timeBegins.length; i++) {
				if(Date.parseDate(min, 'Y-m-d H:i').getTime() - Date.parseDate(timeBegins[i], 'Y-m-d H:i').getTime() >= 0) {
					min = timeBegins[i];
				}
			}
		}
		return min;
	},
	/**
	 * private 取得最大的结束时间
	 */
	getMaxEndDate: function(timeEnds) {
		var max;
		if(timeEnds && timeEnds.length) {
			max = timeEnds[0];
			for(var i = 1; i < timeEnds.length; i++) {
				if(Date.parseDate(max, 'Y-m-d H:i').getTime() - Date.parseDate(timeEnds[i], 'Y-m-d H:i').getTime() <= 0) {
					max = timeEnds[i];
				}
			}
		}
		return max;
	}
});
