/*============ 时间选择面板 ============*/

Array.prototype.sortDates = function() {
	return this.sort(function(a,b){
		return a - b;		
	});
};

Ext.ux.DatePickerPlus = Ext.extend(Ext.DatePicker, { 
	
    selectedDates: [], // 已选择的日期
	
	lastSelectedDate : false, // 最后选择的日期,初始化为false
	
	preSelectedDates : [], // 已选择的日期, 毫秒数格式
	
	maxSelectionDays : false, // 允许选择的最大天数, false表示不限制
		
	// private
    handleDateClick : function(e, t){	
		e.stopEvent();
		
        if(t.dateValue && !Ext.fly(t.parentNode).hasClass("x-date-disabled")){
			var currentGetCell = t.parentNode; // 当前点击的单元格
			var eO = Ext.EventObject; // 键盘事件
			var targetdate = t.dateValue; // 当前选择的日期
					
			// 单选的情况
			if (!eO.ctrlKey && !eO.shiftKey) {
				this.removeAllPreselectedClasses();
				this.preSelectedDates.push(targetdate);			
				Ext.get(currentGetCell).addClass("x-date-selected");
			}
			// ctrl键按下的情况
			if (eO.ctrlKey) {
				if (this.preSelectedDates.indexOf(targetdate) == -1) {
					if (this.maxSelectionDays === this.preSelectedDates.length) {
						Ext.Msg.alert('系统提示', '最多只允许选择' + this.maxSelectionDays + '天');
						return;
					}
					this.preSelectedDates.push(targetdate);	
					Ext.get(currentGetCell).addClass("x-date-selected");
				}
				else {
					this.preSelectedDates.remove(targetdate);			
					Ext.get(currentGetCell).removeClass("x-date-selected");
				}
			}
			// shift键按下的情况
			if (eO.shiftKey) {
				var startdate = (targetdate > this.lastSelectedDate) ? 
					this.lastSelectedDate : targetdate;
				var enddate = (targetdate > this.lastSelectedDate) ?
					targetdate : this.lastSelectedDate;
				var days = (enddate - startdate)/86400000 + 1; // 选择的天数
				
				if (days > this.maxSelectionDays) {
					Ext.Msg.alert('系统提示', '最多只允许选择' + this.maxSelectionDays + '天');
						return;
				}
				this.removeAllPreselectedClasses();
				
				for (var i=0; i<days; i++) {
					this.cells.each(function(c){
					   if(c.dom.firstChild.dateValue == startdate){
						   c.addClass("x-date-selected");
						   return false;
					   }
					});
					this.preSelectedDates.push(startdate);
					startdate += 86400000;
				}					
			}
			this.lastSelectedDate = targetdate;			
        }
    },
	
	removeAllPreselectedClasses: function() {
		this.cells.removeClass("x-date-selected"); // 清除当前页面已选择日期的样式
		this.preSelectedDates = []; // 清空已选择的日期
	},
	
	//private
    update : function(date){
        var vd = this.activeDate;
		// 初始化选择今天
		if (!this.activeDate) {
			var t = date.getTime();
			this.preSelectedDates.push(t);
			this.lastSelectedDate = t;
		}
        this.activeDate = date;		
		
        var days = date.getDaysInMonth();
        var firstOfMonth = date.getFirstDateOfMonth();
        var startingPos = firstOfMonth.getDay()-this.startDay;

        if(startingPos <= this.startDay){
            startingPos += 7;
        }

        var pm = date.add("mo", -1);
        var prevStart = pm.getDaysInMonth()-startingPos;

        var cells = this.cells.elements;
        var textEls = this.textNodes;
        days += startingPos;

        var day = 86400000;
        var d = (new Date(pm.getFullYear(), pm.getMonth(), prevStart)).clearTime();
        var today = new Date().clearTime().getTime();
        var sel = date.clearTime().getTime();
        var min = this.minDate ? this.minDate.clearTime() : Number.NEGATIVE_INFINITY;
        var max = this.maxDate ? this.maxDate.clearTime() : Number.POSITIVE_INFINITY;
        var ddMatch = this.disabledDatesRE;
        var ddText = this.disabledDatesText;
        var ddays = this.disabledDays ? this.disabledDays.join("") : false;
        var ddaysText = this.disabledDaysText;
        var format = this.format;

        var setCellClass = function(cal, cell){
			var eCell = Ext.get(cell);
            cell.title = "";
            var t = d.getTime();
            cell.firstChild.dateValue = t;
			
            if(t == today){
                cell.className += " x-date-today";
                cell.title = cal.todayText;
            }
			
			if (cal.preSelectedDates.indexOf(t)!=-1) {
				eCell.addClass("x-date-selected");
			}
            
            if(t < min) {
                cell.className = " x-date-disabled";
                cell.title = cal.minText;
                return;
            }
            if(t > max) {
                cell.className = " x-date-disabled";
                cell.title = cal.maxText;
                return;
            }
            if(ddays){
                if(ddays.indexOf(d.getDay()) != -1){
                    cell.title = ddaysText;
                    cell.className = " x-date-disabled";
                }
            }
            if(ddMatch && format){
                var fvalue = d.dateFormat(format);
                if(ddMatch.test(fvalue)){
                    cell.title = ddText.replace("%0", fvalue);
                    cell.className = " x-date-disabled";
                }
            }
        };

        var i = 0;
        for(; i < startingPos; i++) {
            textEls[i].innerHTML = (++prevStart);
            d.setDate(d.getDate()+1);
            cells[i].className = "x-date-prevday";
            setCellClass(this, cells[i]);
        }

        for(; i < days; i++){
            intDay = i - startingPos + 1;
            textEls[i].innerHTML = (intDay);
            d.setDate(d.getDate()+1);
            cells[i].className = "x-date-active";
            setCellClass(this, cells[i]);
        }
        var extraDays = 0;
        for(; i < 42; i++) {
             textEls[i].innerHTML = (++extraDays);
             d.setDate(d.getDate()+1);
             cells[i].className = "x-date-nextday";
             setCellClass(this, cells[i]);
        }

        this.mbtn.setText(this.monthNames[date.getMonth()] + " " + date.getFullYear());

        if(!this.internalRender){
            var main = this.el.dom.firstChild;
            var w = main.offsetWidth;
            this.el.setWidth(w + this.el.getBorderWidth("lr"));
            Ext.fly(main).setWidth(w);
            this.internalRender = true;
            
            if(Ext.isOpera && !this.secondPass){
                main.rows[0].cells[1].style.width = (w - (main.rows[0].cells[0].offsetWidth+main.rows[0].cells[2].offsetWidth)) + "px";
                this.secondPass = true;
                this.update.defer(10, this, [date]);
            }
        }
    },
	
	getValues: function() {
		this.selectedDates = [];
		
		for (var i=0,il=this.preSelectedDates.length;i<il;++i) {
			this.selectedDates.push(new Date(this.preSelectedDates[i]));
		}
		return this.selectedDates = this.selectedDates.sortDates();
	},
	
	selectToday: function() {
		var today = this.value;
		this.removeAllPreselectedClasses();
		this.preSelectedDates.push(today.getTime());
		this.lastSelectedDate = today.getTime();	
		this.update(today);
	}
}); 

Ext.reg('datepickerplus', Ext.ux.DatePickerPlus);

function getDateEndIndex(dateBeginIndex, selectedDates, days) {
	var dateEndIndex = dateBeginIndex + 1;
			
	if (dateEndIndex < days ) {
		var beginDate = selectedDates[dateBeginIndex].add(Date.DAY, 1).getTime();
		var targetDate = selectedDates[dateEndIndex].getTime();
		
		if (beginDate == targetDate) {
			return getDateEndIndex(dateEndIndex, selectedDates, days);
		}
	}
	
	return dateBeginIndex;
}

var timeStore = new Ext.data.SimpleStore({
	data: [],
	fields: ['timeBegin', 'timeEnd']
});

var TimePanel = {
	height: 300,
	title: '时间选择',
	id: 'timePanel',
	layout: 'table',
	layoutConfig: {columns: 3},
	frame: true,
	items: [{
			xtype: 'panel',
			frame : true,
			width: 190,
			height: 260,
			labelWidth: 20,
			//style: 'margin: 2 8 8 8; padding: 0 8 0 15',
			items: [{
					items: [{
							xtype: 'datepickerplus',
							id: 'datepicker',
							maxSelectionDays: 100
					}]							
				},{
					height:5
				},{
					layout: 'form',
					labelWidth: 60,
					items: [{
							xtype: 'timefield',
							width: 100,
							id: 'timeBegin',
							fieldLabel: '开始时间',
							allowBlank: false,
							blankText: '请选择开始时间',
							format: 'H:i',
							value: '00:00'					
					}]	
				}, {
					layout: 'form',
					labelWidth: 60,
					items: [{
							xtype: 'timefield',
							width: 100,
							id: 'timeEnd',
							fieldLabel: '结束时间',
							allowBlank: false,
							blankText: '请选择结束时间',
							format: 'H:i',
							value: '23:59'	
					}]			
			}]
		}, {
			width: 45,
			items: [{
					xtype: 'button',
					text: '&nbsp;>&nbsp;',
					handler: function() {
						var timeBeginCmp = Ext.getCmp('timeBegin');
						var timeEndCmp = Ext.getCmp('timeEnd');
						
						if (timeBeginCmp.isValid() && timeEndCmp.isValid()) {
							var timeBegin = timeBeginCmp.getValue();
							var timeEnd = timeEndCmp.getValue();
							var tb = Date.parse('Jan 1, 2000 ' + timeBegin);
							var te = Date.parse('Jan 1, 2000 ' + timeEnd);
							
							if(te < tb) {
								Ext.Msg.alert('系统提示', '结束时间不能小于开始时间');								
							} else {
								var selectedDates = Ext.getCmp('datepicker').getValues();
								var days = selectedDates.length;
	
								if (timeBegin == '00:00' && timeEnd == '23:59') {
									
									for (var i=0; i<days; ) {
										var dateBegin = selectedDates[i].format('Y-m-d');
										var dateEndIndex = getDateEndIndex(i, selectedDates, days);
										var dateEnd = selectedDates[dateEndIndex].format('Y-m-d');
										i = dateEndIndex + 1;
										
										var db = dateBegin + ' ' + timeBegin;
										var de = dateEnd + ' ' + timeEnd;
										var number = 0;
										var count = timeStore.getCount();
										
										timeStore.each(function(record) {
											if (record.get('timeBegin') == db && record.get('timeEnd') == de) {
												return false;
											}
											number++;
										});
										
										if (number == count) {
											timeStore.add(new Ext.data.Record({'timeBegin':db, 'timeEnd':de}));									
										}
									}
								} 
								else {
									for (var i=0; i<days; i++) {
										var dateBegin = selectedDates[i].format('Y-m-d');
										var db = dateBegin + ' ' + timeBegin;
										var de = dateBegin + ' ' + timeEnd;
										var number = 0;
										var count = timeStore.getCount();
										
										timeStore.each(function(record) {
											if (record.get('timeBegin') == db && record.get('timeEnd') == de) {
												return false;
											}
											number++;
										});
										
										if (number == count) {
											timeStore.add(new Ext.data.Record({'timeBegin':db, 'timeEnd':de}));									
										}	
									}
								}
							}
						}
					}
				}, {
					height: 15
				}, {
					xtype: 'button',
					text: '&nbsp;<&nbsp;',
					handler: function() {
						var selMod = Ext.getCmp('timeGrid').getSelectionModel();
						
						if(!selMod.getCount())
						{
							Ext.MessageBox.alert('系统提示', '请选择一条待删除的记录');
						}
						else
						{
							timeStore.remove(selMod.getSelected());
							Ext.getCmp('timeGrid').getView().refresh();
						}	
					}
				}, {
					height: 15					
				}, {
					xtype: 'button',
					text: '<<',
					handler: function() {
						timeStore.removeAll();
					}
			}]
		}, {
			width: 300,
			items: [{
					layout: 'fit',
					height: 260,
					items: [{
							xtype: 'grid',
							width: 300,
							id: 'timeGrid',
							bodyStyle: 'border: 1px solid #6593cf;',
							stripeRows: true,
							enableColumnMove: false,
							enableHdMenu: false,
							viewConfig: {forceFit: true},
							cm: new Ext.grid.ColumnModel([
								new Ext.grid.RowNumberer(),
								{header: '开始时间', align: 'center', sortable: true, dataIndex: 'timeBegin'},
								{header: '结束时间', align: 'center', sortable: true, dataIndex: 'timeEnd'}
							]),
							sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
							store: timeStore
					}]	
			}]
			
    }]
};
