/**
 * 告警呈现信息
 * 
 * @author pbqi
 * @created on 2009年11月17日15:30:31
 */

/**
 * 告警中各字段配置
 */
FieldGrid = Ext.extend(Ext.grid.GridPanel, {

	constructor : function() {

		FieldGrid.superclass.constructor.call(this, {
					title : '告警被选字段',
					frame : true,
					border : true,
					width : Ext.getBody().getViewSize().width * 0.465,
					height : Ext.getBody().getViewSize().height - 5,
					sm : new Ext.grid.RowSelectionModel({
								singleSelect : false
							}),
					viewConfig : {
						forceFit : true
					},
					loadMask : {
						msg : '正在载入数据,请稍候...'
					},
					cm : new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
							{
								header : '字段序号',
								dataIndex : 'id.fieldno',
								width : 50,
								sortable : true
							}, {
								header : '字段英文名',
								dataIndex : 'fieldname',
								width : 60,
								hidden : false,
								sortable : true
							}, {
								header : 'tablefieldname',
								dataIndex : 'tablefieldname',
								width : 0,
								hidden : true
							}, {
								header : 'fieldtype',
								dataIndex : 'fieldtype',
								width : 0,
								hidden : true
							}, {
								header : '字段中文名',
								dataIndex : 'displayname',
								width : 100,
								hidden : false,
								sortable : true
							}, {
								header : 'fieldlen',
								dataIndex : 'fieldlen',
								width : 0,
								hidden : true
							}, {
								header : 'fieldint',
								dataIndex : 'fieldint',
								width : 0,
								hidden : true
							}, {
								header : 'fielddec',
								dataIndex : 'fielddec',
								width : 0,
								hidden : true
							}, {
								header : 'fieldnull',
								dataIndex : 'fieldnull',
								width : 0,
								hidden : true
							}, {
								header : 'inputtype',
								dataIndex : 'inputtype',
								width : 0,
								hidden : true
							}, {
								header : 'inputexpression',
								dataIndex : 'inputexpression',
								width : 0,
								hidden : true
							}, {
								header : 'iskey',
								dataIndex : 'iskey',
								width : 0,
								hidden : true
							}]),
					ds : new Ext.data.Store({
								proxy : new Ext.data.HttpProxy({
											url : "getAlarmFieldByObjectTypeId.action",
											method : 'POST'
										}),
								reader : new Ext.data.JsonReader({}, [{
													name : 'id.fieldno'
												}, {
													name : 'fieldname'
												}, {
													name : 'tablefieldname'
												}, {
													name : 'fieldtype'
												}, {
													name : 'displayname'
												}, {
													name : 'fieldlen'
												}, {
													name : 'fieldint'
												}, {
													name : 'fielddec'
												}, {
													name : 'fieldnull'
												}, {
													name : 'inputtype'
												}, {
													name : 'inputexpression'
												}, {
													name : 'iskey'
												}])
							}),
					listeners : {
						'dblclick' : {
							fn : this.onDblClick,
							scope : this
						}
					}
				});
	},
	onDblClick : function() {
		iconForm.rightMove();
	}
});

/** ********************中间所有按钮的处理部分***************************** */
IconForm = Ext.extend(Ext.ux.Form, {

			rightBtn : null, // 右移按钮
			leftBtn : null, // 左移按钮
			allRightBtn : null, // 全部右移按钮
			allLeftBtn : null, // 全部左移按钮

			upBtn : null, // 上移按钮
			downBtn : null, // 下移按钮
			topBtn : null, // 上移至顶部按钮
			bottomBtn : null, // 下移至底部按钮

			constructor : function() {

				this.rightBtn = this.createButton('增加', this.rightMove, this,
						"right");
				this.leftBtn = this.createButton('删除', this.leftMove, this,
						"left");

				this.allRightBtn = this.createButton('全加', this.allRightMove,
						this, "rightAll");
				this.allLeftBtn = this.createButton('全删', this.allLeftMove,
						this, "leftAll");

				this.upBtn = this.createButton('上移', this.upMove, this, "up");
				this.downBtn = this.createButton('下移', this.downMove, this,
						"down");

				this.topBtn = this
						.createButton('顶部', this.topMove, this, "top");
				this.bottomBtn = this.createButton('底部', this.bottomMove, this,
						"bottom");

				IconForm.superclass.constructor.call(this, {
							width : Ext.getBody().getViewSize().width * 0.07,
							height : Ext.getBody().getViewSize().height - 8,
							frame : false,
							border : false,
							items : [
									{ // 空的panel 用来给2个组件之间间隔一定的距离
										xtype : 'panel',
										border : false,
										height : 60
									}, {
										xtype : 'panel',
										border : false,
										height : 80
									}, this.rightBtn, this.leftBtn,
									this.allRightBtn,
									this.allLeftBtn, {
										xtype : 'panel',
										border : false,
										height : 20
									}, this.upBtn, this.downBtn, this.topBtn,
									this.bottomBtn]
						});
			},
			/**
			 * 移动至顶部
			 */
			topMove : function() {
				var rs = queryGrid.getSelectionModel().getSelections();
				if (rs && rs.length) {
					var copyR = rs[0].copy();
					queryGrid.store.insert(0, copyR);
					queryGrid.store.remove(rs[0]);
					queryGrid.getView().refresh();
					queryGrid.getSelectionModel().selectRow(0, true);
				}
			},
			/**
			 * 移动至底部
			 */
			bottomMove : function() {
				var rs = queryGrid.getSelectionModel().getSelections();
				var count = queryGrid.store.getCount();
				if (rs && rs.length) {
					var copyR = rs[0].copy();
					queryGrid.store.remove(rs[0]);
					queryGrid.store.add(copyR);
					queryGrid.getView().refresh();
					queryGrid.getSelectionModel().selectRow(count - 1, true);
				}
			},
			/**
			 * 向上移动
			 */
			upMove : function() {
				var rs = queryGrid.getSelectionModel().getSelections();
				if (rs && rs.length) {
					var len = rs.length, index = queryGrid.store.indexOf(rs[0]);

					if (index == 0)
						return;
					var copyRs = [];
					for (var i = 0; i < len; i++) {
						copyRs.push(rs[i].copy());
					}
					queryGrid.store.insert(index - 1, copyRs);
					for (var j = 0; j < len; j++) {
						queryGrid.store.remove(rs[j]);
					}
					queryGrid.getView().refresh();
					queryGrid.getSelectionModel().selectRow(index - 1, true);
				}
			},
			/**
			 * 向下移动
			 */
			downMove : function() {
				var rs = queryGrid.getSelectionModel().getSelections();
				if (rs && rs.length) {
					var len = rs.length, index = queryGrid.store.indexOf(rs[0]);
					count = queryGrid.store.getCount();

					if (index == count - 1)
						return;

					var copyR = rs[0].copy();

					if (index == count - 2) {
						queryGrid.store.remove(rs[0]);
						queryGrid.store.add(copyR);
					} else {
						queryGrid.store.insert(index + 2, copyR);
						queryGrid.store.remove(rs[0]);
					}
					queryGrid.getView().refresh();
					queryGrid.getSelectionModel().selectRow(index + 1, true);
				}
			},
			rightMove : function() { // 右移处理函数
				this.move(fieldGrid, queryGrid);
			},
			leftMove : function() { // 左移处理函数
				this.move(queryGrid, fieldGrid);
			},
			allRightMove : function() { // 全部右移处理函数
				this.allMove(fieldGrid, queryGrid);
			},
			allLeftMove : function() { // 全部去除处理函数
				this.allMove(queryGrid, fieldGrid);
			},
			/**
			 * private全部移动通用函数
			 */
			allMove : function(srcGrid, targetGrid) {
				srcGrid.store.each(function(record) { // 遍历整个fieldGrid下的store
							var qRecord = record.copy();
							targetGrid.store.add(qRecord);
						});
				srcGrid.store.removeAll();
			},
			/**
			 * private移动通用函数
			 */
			move : function(srcGrid, targetGrid) {
				var rs = srcGrid.getSelectionModel().getSelections();
				if (rs && rs.length) {
					for (var i = 0, len = rs.length; i < len; i++) {
						var gRecord = rs[i].copy();
						targetGrid.store.add(gRecord);
						srcGrid.store.remove(rs[i]);
					}
				}
				srcGrid.getView().refresh();
				targetGrid.getView().refresh();
			}
		});

/** ******************已选字段Grid********************************* */
QueryGrid = Ext.extend(Ext.grid.GridPanel, {
			constructor : function() {
				QueryGrid.superclass.constructor.call(this, {
							title : '告警已选字段',
							frame : true,
							border : true,
							width : Ext.getBody().getViewSize().width * 0.464,
							height : Ext.getBody().getViewSize().height - 5,
							sm : new Ext.grid.RowSelectionModel({
										singleSelect : false
									}),
							cm : new Ext.grid.ColumnModel([
									new Ext.grid.RowNumberer(), {
										header : '字段序号',
										dataIndex : 'id.fieldno',
										width : 50,
										sortable : true
									}, {
										header : '字段英文名',
										dataIndex : 'fieldname',
										width : 60,
										hidden : false,
										sortable : true
									}, {
										header : '字段中文名',
										dataIndex : 'displayname',
										width : 80,
										sortable : true
									}]),
							viewConfig : {
								forceFit : true
							},
							ds : new Ext.data.Store({
										proxy : new Ext.data.MemoryProxy(),
										reader : new Ext.data.JsonReader({}, [{
															name : 'id.fieldno'
														}, {
															name : 'fieldname'
														}, {
															name : 'displayname'
														}])
									}),
							listeners : {
								'dblclick' : {
									fn : this.onDblClick,
									scope : this
								}
							},
							bbar : new Ext.Toolbar({
										items : [{
													text : '保存',
													iconCls : 'save',
													handler : this.doSave,
													scope : this
												}]
									})
						});
			},
			doSave : function() {
				var store = this.store, count = store.getCount(), indexs = [], // store中记录的顺序
				fieldNos = [], // 字段序号
				fieldNames = [], // 字段英文名
				displayNames = []; // 字段中文名

				for (var i = 0; i < count; i++) {
					var r = store.getAt(i);
					indexs.push(i);
					fieldNos.push(r.get('id.fieldno'))
					fieldNames.push(r.get('fieldname'));
					displayNames.push(r.get('displayname'));
				}
				var mk = new Ext.LoadMask(this.el, {
							msg : '告警呈现配置正在保存中...请稍候',
							removeMask : true
						});
				if (indexs && indexs.length && fieldNos && fieldNos.length
						&& fieldNames && fieldNames.length && displayNames
						&& displayNames.length) {
					mk.show();
					AlarmViewConfigManager.save(indexs, fieldNos, fieldNames,
							displayNames, function(data) {
								if (data) {
									Ext.MessageBox.alert('系统提示:', blankStr
													+ '保存告警呈现信息配置成功！'
													+ blankStr);
									mk.hide();
								} else {
									Ext.MessageBox.alert('系统提示:', blankStr
													+ '操作可能出现了某些错误,请重试！'
													+ blankStr);
									mk.hide();
								}
							});
				} else {
					Ext.MessageBox.alert('系统提示:', blankStr
									+ '你没有配置,请选择你想看到的字段信息配置' + blankStr);
				}
			},
			onDblClick : function() { // 保存
				iconForm.leftMove();
			}
		});
