/**
 * @description 告警阀值配置
 * @author jzwu
 * @created on 2010年6月18日
 * 
 */

 
Ext.BLANK_IMAGE_URL = '../resources/images/default/s.gif';      //本地图形化
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';     //需要补充的空格 

var thresholdQueryForm;
var alarmThresholdGrid;
var alarmThresholdConf;
var PAGESIZE = 10;
var ALARMTYPE_STORE_URL='alarmThresholdAction_queryAlarmType.action'; 
var ALARMCONTENT_STORE_URL='alarmThresholdAction_queryAlarmContent.action'; 
var redStar = '<font color=red>' + '*' + '</font>';
var alarmThresholdObj={
	servAffordManConfig : {servManId:''},
	servAffordManReg :{servId:''},
	alarmType:'',
	alarmContent :'',
	alarmThreshold :'',
	alarmTriggerThreshold : ''
}
/******************************告警阀值查询************************/
ThresholdQueryForm = Ext.extend(Ext.ux.Form, {
    
    AlarmType: null,           	//告警类型
    ServMan: null,         		//接入系统
    Server: null,     			//服务
    
    
     constructor: function() {
        
        this.AlarmType = this.createCombo1(redStar+"告警类型",'alarmType','businid','businname', '60%',ALARMTYPE_STORE_URL,'items_ALARMTYPE','results_ALARMTYPE');
        this.ServMan = this.createCombo1("接入系统",'servManId','servManId','servManName', "60%","register/servAffordManRegAction_queryAllRegiteredServMans.action",'servManList');
        this.Server = this.createCombo1("服务",'servId','servId','servName',"60%",'register/servAffordManRegAction_queryServByServMan.action','servDtoList');
        this.AlarmType.store.load();
        this.ServMan.store.load();
        this.ServMan.on("select", function(comb) {
			this.Server.store.load({
					params : {
						servAffordManId : comb.value
					}
			});
			this.Server.setValue('');
		},this);
		this.AlarmType.allowBlank=true;
		this.ServMan.allowBlank=true;
		this.Server.allowBlank=true;
        ThresholdQueryForm.superclass.constructor.call(this, {
        	renderTo: 'alarmThresholdQuery',
            width: Ext.getBody().getViewSize().width-5,
            height: Ext.getBody().getViewSize().height*0.22,
            title:"告警阀值查询",
            labelWidth: 90,
            labelAlign: 'right',
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            layout: 'column',
            items:[
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.AlarmType},
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.ServMan}, 
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.Server}],
            buttons: [
               {text: '查询', iconCls: 'find',width: 20, handler: this.queryThreshold, scope: this},
               {text: '重置', width: 20,iconCls:'resume', handler: this.doReset, scope: this}
            ]
        })
     },
    queryThreshold: function() {   //告警阀值查询
    	var alarmType = this.AlarmType.getValue();
    	var servManId = this.ServMan.getValue();
    	var servId =  this.Server.getValue(); 
    	alarmThresholdGrid.store.baseParams = {recordCount: -1,alarmType:alarmType,servManId:servManId,servId:servId}; 		
    	alarmThresholdGrid.store.load({params: {start: 0, limit: PAGESIZE}});	
    },
    doReset: function() {                //重置表单
    	this.AlarmType.setValue('');
    	this.ServMan.setValue('');
    	this.Server.setValue('');
    	this.Server.store.removeAll();
    }
});
/***************************告警展示********************/
AlarmThresholdGrid = Ext.extend(UxGrid, {
  
    constructor: function() {
        this.sm = new Ext.grid.CheckboxSelectionModel({header:'',handleMouseDown:Ext.emptyFn});
        this.sm.on('rowselect',this.select );
		this.sm.on('rowdeselect',this.reset );
    	this.alarmThresholdStore = new Ext.data.Store({          //Grid Store
            proxy: new Ext.data.HttpProxy({url: "alarmThresholdAction_queryAlarmThreshold.action", method: 'POST'}),
            reader: new Ext.data.JsonReader({totalProperty: 'totalProperty', root:'alarmThresholdDtoList'},[
            {name:'alarmThresConfId'},{name:'alarmTypeId'},{name:'alarmType'}, {name:'servManId'},{name:'servManName'},{name:'servId'},{name:'servName'},
            	 {name:'alarmContentId'},{name:'alarmContent'},{name:'alarmThreshold'},{name:'alarmTriggerThreshold'}          
            ])
        }),
        AlarmThresholdGrid.superclass.constructor.call(this, {
        	renderTo: 'alarmThresholdGrid',
        	title:'告警阀值列表',
            frame: true,
            width: Ext.getBody().getViewSize().width-5,
            height: Ext.getBody().getViewSize().height*0.5,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: this.sm,
            cm: new Ext.grid.ColumnModel([this.sm,new Ext.grid.RowNumberer(),
            	{header:'告警阀值配置id',dataIndex:'alarmThresConfId',hidden:true},
            	{header:'告警类型id',dataIndex:'alarmTypeId',hidden:true},
            	{header:'告警类型',dataIndex:'alarmType'},
            	{header:'接入系统id',dataIndex:'servManId',hidden:true},
                {header:'接入系统',dataIndex:'servManName',width:100},
                {header:'服务id',dataIndex:'servId',hidden:true},
                {header:'服务',dataIndex:'servName',width:100},
                {header:'告警内容id',dataIndex:'alarmContentId',hidden:true,width:100},
                {header:'告警内容',dataIndex:'alarmContent'},
                {header:'告警阀值',dataIndex:'alarmThreshold'},
                {header:'触发次数阀值',dataIndex:'alarmTriggerThreshold'}
            ]),
            bbar: new Ext.PagingToolbar({
                firstText:'第一页',
                nextText:'下一页',
                prevText:'上一页',
                refreshText:'刷新',
                lastText:'最后一页',
                beforePageText: '当前',
                afterPageText:'页/共{0}页',
                pageSize:PAGESIZE,
                store:this.alarmThresholdStore,
                displayInfo:true, 
                dsiplayMsg:'本页显示 {0} - {1},共{2}条记录',
                emptyMsg:"没有可显示的记录",
                items:['-',
                    {text:'删除',id: 'bbar_deleteAlarmThreshold',iconCls: 'delete',handler:this.onDeleteClick,scope:this}                  
                ]
            }),
            ds: this.alarmThresholdStore
            
        })
    },
    onDeleteClick: function(){
    	var confIdStr='';
    	var count=0;
    	var records = this.getSelectionModel().getSelections();
        if(records) {
        	this.getSelectionModel().each(function(rec) {
				if (rec.get('alarmThresConfId') > 0) {
					confIdStr += rec.get('alarmThresConfId') + ',';
					count++;
				}
			});
			if (count > 0) {
				Ext.Msg.confirm("提醒信息", "确定要删除这 " + count + " 条信息吗",
				function(btn) {
					if (btn == 'yes') {
					   AlarmThresholdDwr.deleteAlarmThreshold(confIdStr,function(data) {					   	
		               if(data) {		               	   
		                   Ext.MessageBox.alert("系统提示:", blankStr + "删除成功" + blankStr);
		                   /*for(var i=0;i<records.length;i++){
		                   	alarmThresholdGrid.getStore().remove(records[i]); 
		                   }*/
		                   alarmThresholdGrid.store.load({params: {start: 0, limit: PAGESIZE}}); 
		                   alarmThresholdConf.doReset();
		               } else {		               	  
		                   Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
		               }
            		});
						
					}
				}
				)
			}
    	
        }else {
             Ext.Msg.alert('系统提示', blankStr + '请选择一条记录' + blankStr);
        }
    },
    select: function(){
    	var record = alarmThresholdGrid.getSelectionModel().getSelected();  
    	alarmThresholdConf.Server.store.load({
			params : {
				servAffordManId : record.get('servManId')
			},callback:function(){
				alarmThresholdConf.getForm().loadRecord(record); 
			}
		});
		
		document.getElementById("addInfo").disabled=true;
		document.getElementById("updateInfo").disabled=false;	
    },
    reset: function(){
    	alarmThresholdConf.getForm().reset();
		document.getElementById("addInfo").disabled=false;
		document.getElementById("updateInfo").disabled=true;		
    }
  });
  
  /******************************告警阀值配置************************/
  AlarmThresholdConf = Ext.extend(Ext.ux.Form, {
    
  	ConfId: null,
    AlarmType: null,           	//告警类型
    ServMan: null,         		//接入系统
    Server: null,     			//服务
    AlarmContent: null,         //告警内容
    AlarmThreshold: null,       //告警阀值
    TriggerThreshold: null,     //触发次数阀值
    
    
     constructor: function() {
        this.ConfId = this.createHidden("告警阀值配置ID",'alarmThresConfId');
        this.AlarmType = this.createCombo1(redStar+"告警类型",'alarmTypeId','businid','businname', '60%',ALARMTYPE_STORE_URL,'items_ALARMTYPE','results_ALARMTYPE');
        this.ServMan = this.createCombo1(redStar+"接入系统",'servManId','servManId','servManName', "60%","register/servAffordManRegAction_queryAllRegiteredServMans.action",'servManList');
        this.Server = this.createCombo1("服务",'servId','servId','servName',"60%",'register/servAffordManRegAction_queryServByServMan.action','servDtoList');
        this.AlarmType.store.load();
        this.ServMan.store.load();
        this.ServMan.on("select", function(comb) {
			this.Server.store.load({
					params : {
						servAffordManId : comb.value
					}
			});
			this.Server.setValue('');
		},this);
		this.AlarmContent = this.createCombo1("告警内容",'alarmContentId','businid','businname', '60%',ALARMCONTENT_STORE_URL,'items_ALARMCONTENT','results_ALARMCONTENT');
		this.AlarmContent.store.load();
		this.AlarmThreshold = this.createTextFiled("告警阀值",'alarmThreshold','60%');
		this.TriggerThreshold = this.createTextFiled(redStar+"触发次数阀值",'alarmTriggerThreshold','60%');
		//服务告警类型，不需要填写，禁用编辑框
		this.AlarmType.on("select", function(comb) {
			if(comb.value == 3)
				this.AlarmThreshold.setDisabled(true);
			else
				this.AlarmThreshold.setDisabled(false);
		},this);
		this.ServMan.allowBlank=true;
		this.Server.allowBlank=true;
		this.AlarmContent.allowBlank=true;
		this.AlarmThreshold.allowBlank=true;
	
        AlarmThresholdConf.superclass.constructor.call(this, {
        	renderTo: 'alarmThresholdConfig',
            width: Ext.getBody().getViewSize().width-5,
            height: Ext.getBody().getViewSize().height*0.26,
            title:"告警阀值配置",
            labelWidth: 90,
            labelAlign: 'right',
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            layout: 'column',
            items:[
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.AlarmType},
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.ServMan}, 
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.Server},
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.AlarmContent},
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.AlarmThreshold},
            	{
            	columnWidth: 0.3333,
            	layout: 'form',
            	items: this.TriggerThreshold},
            	{
            	layout: 'form',
            	items: this.ConfId}
            	],
            buttons: [
               {text: '添 加', id:'addInfo',iconCls: 'new',width: 20, handler: this.addThreshold, scope: this},
               {text: '修 改', id:'updateInfo',iconCls: 'update',width: 20, handler: this.modifyThreshold, scope: this},
               {text: '重 置', width: 20,iconCls:'resume', handler: this.doReset, scope: this}
            ]
        })
     },
     addThreshold: function(){
     	var servIds ='';
     	if(this.ServMan.getValue()!=''&& this.Server.getValue()==''){
	     	this.Server.store.each(function(rec) { 
				if (rec.get('servId') > 0) {
					servIds += rec.get('servId') + ',';					
				}
			});
     	}
     	alarmThresholdObj.alarmType = this.AlarmType.getValue();
     	alarmThresholdObj.servAffordManConfig.servManId = this.ServMan.getValue();
     	alarmThresholdObj.servAffordManReg.servId = this.Server.getValue();
     	alarmThresholdObj.alarmContent = this.AlarmContent.getValue();
     	alarmThresholdObj.alarmThreshold = this.AlarmThreshold.getValue();
     	alarmThresholdObj.alarmTriggerThreshold  = this.TriggerThreshold.getValue();
     	if(this.getForm().isValid()) {
            AlarmThresholdDwr.saveAlarmThreshold(alarmThresholdObj,servIds,function(data) {
               if(data) {
               	 
                   Ext.MessageBox.alert("系统提示:", blankStr + "添加成功" + blankStr);
                   alarmThresholdGrid.store.load({params: {start: 0, limit: PAGESIZE}}); 
               } else {
               	 
                   Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
               }
            });
        } 
     },
     modifyThreshold: function(){
     	var alarmThresConfId = this.ConfId.getValue();
     	alarmThresholdObj.alarmType = this.AlarmType.getValue();
     	alarmThresholdObj.servAffordManConfig.servManId = this.ServMan.getValue();
     	alarmThresholdObj.servAffordManReg.servId = this.Server.getValue();
     	alarmThresholdObj.alarmContent = this.AlarmContent.getValue();
     	alarmThresholdObj.alarmThreshold = this.AlarmThreshold.getValue();
     	alarmThresholdObj.alarmTriggerThreshold  = this.TriggerThreshold.getValue();
     	if(this.getForm().isValid()) {
            AlarmThresholdDwr.updateAlarmThreshold(alarmThresholdObj,alarmThresConfId,function(data) {
               if(data) {               	   
                   Ext.MessageBox.alert("系统提示:", blankStr + "修改成功" + blankStr);
                   alarmThresholdGrid.store.load({params: {start: 0, limit: PAGESIZE}}); 
               } else {              	 
                   Ext.MessageBox.alert("系统提示:", blankStr + "操作可能出现了某些错误,请重试！" + blankStr);
               }
            });
        } 
     	
     },
     doReset: function(){
     	this.AlarmType.setValue('');
    	this.ServMan.setValue('');
    	this.Server.setValue('');
    	this.AlarmContent.setValue('');
    	this.AlarmThreshold.setValue('');
    	this.TriggerThreshold.setValue('');
    	this.Server.store.removeAll();
     	document.getElementById("addInfo").disabled=false;
		document.getElementById("updateInfo").disabled=true;	
     }
});
Ext.onReady(function() {
	
    Ext.QuickTips.init();                               //开启快速提示
    Ext.form.Field.prototype.msgTarget = 'qtip';        //提示方式"side"
    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
    alarmThresholdConf = new AlarmThresholdConf();
    thresholdQueryForm = new ThresholdQueryForm();
    alarmThresholdGrid = new AlarmThresholdGrid();
    alarmThresholdGrid.store.load({params: {start: 0, limit: PAGESIZE}});
    document.getElementById("updateInfo").disabled=true;
});