/**
 * @function:告警颜色,声音设置页面
 * @author:shtang
 * @type {}
 */

var winAddRecord=null;
var formAddRecord=null;
var winUpdateRecord=null;
var formUpdateRecord=null;
var tempColor = "F099cc";
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';  
var g_alarmLevel=null;
var g_selectRecode=null;


//主布局
Ext.onReady(function()
{
	
	    Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + window.parent.styleCssValue);
		var alarmExhibitTitle = {
			col:[
					{header:'告警级别',field:'soundname',width: 155  },
					{header:'告警颜色',field:'color', width: 150   },
					{header:'告警声音',field:'fileinfo', width: 250 }
				],
				containerId: 'alarmExhibit',
				recordName:'AlarmExhibitDto',
				url: 'getAlarmSoundColor.action',
				totalRecords:'totalCount'
		  };
		initAlarmExhibit(alarmExhibitTitle);
	 	g_alarmBoard.on('cellclick',function(){
      	g_selectRecode = g_alarmBoard.getSelectionModel().getSelected();
      	if(g_selectRecode!=null)
      	{
     		g_alarmLevel= g_selectRecode.data.alarmLevel;
      	}
     }) ;
     
     var rightClick=createRClickMenu(g_alarmBoard);
    	g_alarmBoard.on('rowcontextmenu',function(grid, index, event){
    	g_alarmBoard.getSelectionModel().selectRow(index); 
    	event.preventDefault();
    	rightClick.showAt(event.getXY());//取得鼠标点击坐标，展示菜单
   		 });
     
});

function initAlarmExhibit(col){
	g_alarmBoard=createAlarmBoard( col );	
	g_alarmBoard.on('rowdblclick', editExhibit, this, {});
		
 }
 

//右键菜单
function createRClickMenu(g_alarmBoard)
{
	 var rightClick = new Ext.menu.Menu({
        items : [{
        	iconCls:'update',
            text : '修改设置',
            //增加菜单点击事件
            handler:function ()
            {
                editExhibit();
             }
        },'-']
     }); 
     return rightClick;
}

//修改记录
function updateExhibit()
{
	var objs = [];
	objs = g_alarmBoard.getSelectionModel().getSelections();
	if(objs.length===0){
		Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"请选择一条记录"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
	}else{
		editExhibit();
	}
}

 //编辑记录
function editExhibit(){
	var alarmLevelPeior=null;
	var soundIDPeior=null;
	var  soundExhibitName=null;
	var objs = [];
	
	objs = g_alarmBoard.getSelectionModel().getSelections();
	var record = objs[0];
	alarmLevelPeior=record.get('soundkey');
	
	  if(!formUpdateRecord)
	    {
	    formUpdateRecord = new Ext.form.FormPanel({
      		width: 280,
            height: 360,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            defaults:{ width: 100 },
        items: [
        levelCreateCombo("告警级别","请选择......","90%",'getSoundAlarmLevel.action','comboUpdate1',true),
        createTextFiled("告警颜色","alarmCorlor","不能为空","colorchoice"),
        soundCreateCombo("告警声音","请选择......","90%",'getAllAlarmSound.action','comboUpdate2')
        ]
    });
    
  }
	if(!winUpdateRecord){
		
		winUpdateRecord = new Ext.Window({
			    title:"修改记录",
                applyTo     : 'update-win',
                layout      : 'fit',
                width       : 270,
                height      : 170,
                closeAction :'hide',
                plain       : true,
                items       : formUpdateRecord,
                modal		:true,

                buttons: [{
                    text     : '确定',
                    id:'btnUpdateRecord',
                    handler:function(){
                  if(!formUpdateRecord.getForm().isValid())
                	{
                		return;
               		}
                    var levelCom=Ext.getCmp('comboUpdate1').getValue();
                    var levelName=Ext.getCmp('comboUpdate1').getRawValue();
                    var colorTemp=Ext.getCmp('colorchoice').getValue();
                    var soundCom=Ext.getCmp('comboUpdate2').getRawValue();
                    
                 var record=g_alarmBoard.getSelectionModel().getSelected();
				 var alarmLevId=record.get('soundkey');
				 var alarmLevName=record.get('soundname');
				 var alarmCorlor=record.get('color');
				 var alarmSound=record.get('fileinfo');
				
				 if(alarmCorlor===colorTemp&&alarmSound===soundCom)
				 {
				 	 Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"您未做任何修改!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
				 	 return;	 
				 }
				
                AlarmExhibitManager.update(levelCom,colorTemp,soundCom,function(data){
        	   if(data) {
                   Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"更新成功!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
                   winUpdateRecord.hide();
                   g_selectRecode.set("color",colorTemp);
                   g_selectRecode.set("fileinfo",soundCom);
                   g_selectRecode.set("soundkey",levelCom);
                   g_selectRecode.set("soundname",levelName);
                   g_alarmBoard.getView().refresh();
                   
               } else {
                    Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"操作出现某些错误,请重试！"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
               }
        	});
                    	
                    }
                },{
                    text     : '取消',
                    handler  : function(){
                    winUpdateRecord.hide();
                    }
                }]
            });
	}
        winUpdateRecord.show(Ext.get('updateRecordBtn'));  
        
        winUpdateRecord.on('show',function(){
        	Ext.getCmp('colorchoice').setValue(record.get('color'));
        	 
        		Ext.getCmp('comboUpdate1').setValue(record.get('soundkey'));
        		Ext.getCmp('comboUpdate1').setRawValue(record.get('soundname'));
        	 
         
        		Ext.getCmp('comboUpdate2').setRawValue(record.get('fileinfo'));
        	   Ext.getCmp('comboUpdate2').setValue(record.get('fileinfo'));
        	
         
        
        	/*soundIDPeior=record.get('fileinfo');
          	soundExhibitName=record.get('fileinfo');*/
        });
        
        winUpdateRecord.on('hide',function(){
        g_alarmBoard.getSelectionModel().clearSelections();
        });
        
       /* Ext.getCmp('comboUpdate2').on("select",function(){
            soundIDPeior=Ext.getCmp('comboUpdate2').getValue();
            soundExhibitName=Ext.getCmp('comboUpdate2').getRawValue();
        });*/

}
     
 function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}




//增加记录
/*function addExhibit()
{
	    if(!formAddRecord)
	    {
	    formAddRecord = new Ext.form.FormPanel({
       		width: 280,
            height: 360,
            labelWidth: 55,
            frame: true,
            bodyStyle:"padding: 5px 5px 0",
            defaults:{ width: 100 },
        items:[
        levelCreateCombo("告警级别","请选择......","90%",'getSoundAlarmLevel.action','comboAdd1',false),
        createTextFiled("告警颜色","alarmCorlor","不能为空","colorChoose"),
        soundCreateCombo("告警声音","请选择......","90%",'getAllAlarmSound.action','comboAdd2')
        ] 
        });
  }
	if(!winAddRecord){
		winAddRecord = new Ext.Window({
			    title:"新增记录",
                applyTo     : 'hello-win',
                layout      : 'fit',
                width       : 270,
                height      : 170,
                closeAction :'hide',
                plain       : true,
                items       : formAddRecord,
                modal		:true,

                buttons: [{
                    text     : '添加',
                    id:'btnAddRecord',
                    handler:function(){
                    	var levelCom=Ext.getCmp('comboAdd1').getValue();
                    	var levelName=Ext.getCmp('comboAdd1').getRawValue();
                    	var colorTemp=Ext.getCmp('colorChoose').getValue();
                    	var soundCom=Ext.getCmp('comboAdd2').getValue();
                    	var exhibitName=Ext.getCmp('comboAdd2').getRawValue();
               var store=g_alarmBoard.store;     	
                var num=store.find('alarmLevel',levelCom);
                
                if(num!=null&&num>-1)
                {
                	Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"此告警级别已经添加,不可重复!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
                	return;
                }
                if(!formAddRecord.getForm().isValid())
                {
                	return;
                }
               AlarmExhibitManager.save(levelCom,colorTemp,soundCom,function(data){
        	   if(data) {
        	  var exhibitRecord= new Ext.data.Record.create([{name:'alarmLevelId'},{name:'alarmLevelName'},{name:'alarmColor'},{name:'soundID'},{name:'exhibitName'}]);
                  var newRecord=new exhibitRecord({
                  	alarmLevelId:levelCom,
                  	alarmLevelName:levelName,
                  	alarmColor:colorTemp,
                  	soundID:soundCom,
                  	exhibitName:exhibitName
                  });
                  g_alarmBoard.store.insert(0,newRecord);
					Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"添加成功!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
                   winAddRecord.hide();
               } else {
                   Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"操作可能出现了某些错误,请重试！"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
               }
        	});
                    }
                    
                },{
                    text     : '取消',
                    handler  : function(){
                        winAddRecord.hide();
                    }
                }]
            });
	}
        winAddRecord.show(Ext.get('addRecordBtn'));  
       winAddRecord.on('show',function(){
       		formAddRecord.getForm().reset();
        
        });
        
}*/


//删除记录
/*function deleteExhibit()
{
	
	var r = g_alarmBoard.getSelectionModel().getSelected();
        if(typeof(r) === 'undefined') {
             Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"请选择一条记录!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
            return;
        }
    
        Ext.MessageBox.show({
          title:"系统提示:",
          msg:blankStr+"您确定要删除吗?"+blankStr,
          buttons:{
          	        ok: '确定',
    				cancel: '取消'
          			},
          icon: Ext.MessageBox.QUESTION,
          fn:function(btn)
          {
          	if(btn=="ok")
          	{
          		 AlarmExhibitManager.deleteAlarmExhibit(r.data.alarmLevel, function(data){
                   if(data) {
                       Ext.MessageBox.show({title:"系统提示:",msg:blankStr+"删除成功!"+ blankStr,icon:Ext.MessageBox.INFO,buttons:{ok:'确定'}});
                       g_alarmBoard.store.remove(r);

                   }
            	
                });
          	}
          }
		 
        });
}
*/