var pageTotal = 10;

Ext.onReady(function(){
	
	Ext.override(Ext.menu.DateMenu, {
		render : function() {
			Ext.menu.DateMenu.superclass.render.call(this);
			if (Ext.isGecko) {
				this.picker.el.dom.childNodes[0].style.width = '178px';
				this.picker.el.dom.style.width = '178px';
			}
		}
	});
	Ext.QuickTips.init();

	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.styleCssValue);
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
					+ window.parent.parent.styleCssValue);
	var redStar = '<font color=red>' + '*' + '</font>';// 红色星号
	
	Ext.Ajax.on('requestcomplete', checkUserSessionStatus, this);
	// 检查用户状态 是否session 超时
	function checkUserSessionStatus(conn, response, options) {
		var sessionStatus = response.getResponseHeader["sessionstatus"];

		if (typeof(sessionStatus) != "undefined") {
			Ext.Msg.alert('提示', '会话超时，请重新登录!', function(btn, text) {
				if (btn == 'ok') {
					var redirect = URL_START + document.location.host
							+ LOG_IN_URL + '?flag=true';
					window.location = redirect;
				}
			});
		}
	};
	// 公用 代码区
	// combox自动加上"请选择"

	var addBlankSelectForCombox = function(combo) { // 自动添加一个空选择项
		combo.on("select", function() {
			if (combo.getValue() == -1) { // 当选择-1时，把值设置为空
				combo.setValue("");
			}
		});
		combo.store.on("datachanged", function(a) {
			var r = new Ext.data.Record({});
			r.set(combo.valueField, ''); // 添加一格值为-1的选项
			r.set(combo.displayField, combo.emptyText);
			a.insert(0, r);
		});
	}
	var servManStore = new Ext.data.JsonStore({
		url : 'register/getAllServMan.action',
		root : 'page.result',
		fields : ['servManId', 'servManName' ,'servManCode'],
		autoLoad : {
			params : {
				'page.start' : 0,
				'page.pageSize' : 1000
			}
		}
	});
	//故障单号
	var alarmIdTextField = new Ext.form.TextField({
		fieldLabel : "故障单号",
		name : "alarmId",
		id : "alarmId",
		blankText : '请填写故障单号！',
		maxLength : 32,
		width : 150

	});
	//流水号
	var serialIdTextField = new Ext.form.TextField({
		fieldLabel:'流水号',
		name:'serialId',
		id:'serialId',
		blankText:'请填写流水号！',
		maxLength:32,
		width:150	
	});
	//故障类型
	var alarmTypeComboBox = new Ext.form.ComboBox({
		fieldLabel:'故障类型',
		emptyText:'请选择...',
		store:servManStore,
		editable:false,
		valueField:'servManCode',
		displayField:'servManName',
		typeAhead:true,
		triggerAction:'all',
		selectOnFocus:true,
		forceSelection:true,
		width:150,
		mode:'local'
	});
//	alarmTypeComboBox.store.load({params:{'page.start':0,'page.pageSize':1000}});
	// 发生故障系统
	var servManComboBox =new Ext.form.ComboBox({
		fieldLabel:"发生故障系统",
		emptyText:"请选择...",
		store:servManStore,
		editable:false,
		valueField:'servManCode',
		displayField:'servManName',
		typeAhead:true,
		triggerAction:'all',
		selectOnFocus:true,
		forceSelection:true,
		width:150,
		mode:'local'
	});
	
	// 故障发生开始时间
	var beginTimeField = new Ext.form.DateField({
		fieldLabel : '故障发生开始时间',
		xtype :'xdatetime',
		name : 'beginTime',
		id : 'beginTime',
		width : 150,
		allowBlank : false,
		altFormats : 'Y-m-d H:i:s',
		format : 'Y-m-d H:i:s',
		emptyText : '选择一个日期'
	});
	//故障发生结束时间
	var endTimeField = new Ext.form.DateField({
		fieldLabel:'故障发生结束时间',
		xtype:'xdatetime',
		name:'endTime',
		id:'endTime',
		width:150,
		allowBlank:false,
		altFormats:'Y-m-d H:i:s',
		format:'Y-m-d H:i:s',
		emptyText:'选择一个日期'
	});
	// 计算form 宽度
	var gridWidth = Ext.getBody().getViewSize().width - 5;
	if (screen.width == 1024 && screen.height == 768) {
		gridWidth = Ext.getBody().getViewSize().width - 22;
	}	
	// 将上面的查询选项放进form面板中
	/******************************故障派单查询************************/
	var alarmQueryForm = new Ext.FormPanel({
		title : "查询条件",
		width : gridWidth,// Ext.getBody().getViewSize().width
		height : 130,
		buttonAlign : 'center',
		applyTo : 'alarmQueryForm',
		labelWidth : 120,
		labelAlign : "right",
		frame : true,
		items : [{
					layout : "column",
					items : [{
								columnWidth : 0.3333,
								layout : "form",
								items : alarmIdTextField
							}, {
								columnWidth : 0.3333,
								layout : "form",
								items : serialIdTextField
							}, {
								columnWidth : 0.3333,
								layout : "form",
								items : alarmTypeComboBox
							}, {
								columnWidth : 0.3333,
								layout : "form",
								items : servManComboBox
							}, {
								columnWidth : 0.3333,
								layout : "form",
								items : beginTimeField
							}, {
								columnWidth : 0.3333,
								layout : "form",
								items : endTimeField
							}
						]
				}],
		buttons : [{
				text:'发起故障单',
				handler:startAlarm
			},{
				text : "查询",
				handler : queryAlarm
			}, {
				text : "重置",
				handler : resetQuery
			}]
	});
	
	function startAlarm(){
		showAlarmStartWin();
	};
	function queryAlarm(){
		var msgText =  '时间为必选项，格式应为：yyyy-mm-dd hh:mm:ss！';
	   	if (!Ext.getCmp('beginTime').isValid()) {
			Ext.MessageBox.alert("信息提示", "开始"+msgText, function(btn) {
						Ext.getCmp('beginTime').focus();
					});
			return;
		}
	  	if (!Ext.getCmp('endTime').isValid()) {
			Ext.MessageBox.alert("信息提示", "结束"+msgText, function(btn) {
						Ext.getCmp('endTime').focus();
					});
			return;
		}
		beginTimeFieldValue = Ext.get("beginTime").getValue();
        endTimeFieldValue  = Ext.get("endTime").getValue();
        var beginTimeValueTemp = new Date(Date.parse(beginTimeFieldValue.replace(/-/g,"/")));
        var endTimeValueTemp = new Date(Date.parse(endTimeFieldValue.replace(/-/g,"/")));
        
        var daydiff = (endTimeValueTemp.getTime() - beginTimeValueTemp.getTime()); 
        if(daydiff < 0){
          Ext.Msg.alert("信息提示","结束时间不能小于开始时间！");
          return ;
         }
         var serialIdTextFieldTemp;
         var _reg = new RegExp("^[1-9]\d*|0$");

         if(serialIdTextField.getValue() == ""){
         	serialIdTextFieldTemp = 0;
         }else{
         	serialIdTextFieldTemp = serialIdTextField.getValue();
         }
         if(!_reg.test(serialIdTextFieldTemp)){
         	Ext.Msg.alert("信息提示","请输入整数类型的流水号！")
         }
         resultStore.baseParams = {
         	'alarmTransmitDto.alarmId':alarmIdTextField.getValue(),
         	'alarmTransmitDto.serialId':serialIdTextFieldTemp,
         	'alarmTransmitDto.alarmStaffMan':alarmTypeComboBox.getValue(),
         	'alarmTransmitDto.alarmSystem':servManComboBox.getValue(),
         	'alarmTransmitDto.alarmBeginTime':beginTimeFieldValue,
         	'alarmTransmitDto.alarmEndTime':endTimeFieldValue
         };
        resultStore.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : pageTotal
		}
	});

	};
	function resetQuery(){
		alarmIdTextField.setValue('');
		serialIdTextField.setValue('');
		alarmTypeComboBox.setValue('');
		servManComboBox.setValue('');
		beginTimeField.setValue('');
		endTimeField.setValue('');
	};
	/** ********************************************查询结果列表区*********************************** */
	var hp = new Ext.data.HttpProxy({
		url : 'audit/alarmQueryAction_alarmQuery.action'
	});
	// 配置分组数据集
	var resultStore = new Ext.data.Store({
		proxy : hp,
		reader : new Ext.data.JsonReader({
			totalProperty : "page.totalCount",
			root : 'page.result',
			idProperty : 'id',
			fields : ['alarmId', 'serialId', 'alarmStaffMan', 'alarmSystem', 'alarmOccurTime', 'alarmFinishTime', 'alarmFinishFlag']
		})
	});
	// 定义alarmgrid表格组件高度
	var gridHeight = 340;
	if (Ext.getBody().getViewSize().height - 360 > gridHeight) {
		gridHeight = Ext.getBody().getViewSize().height - 360;
	}
	//定义每列宽度
	var columnWidth = gridWidth - 8;
	//定义页尾工具栏
	var  bbar = new Ext.PagingToolbar({// 分页工具栏
		store : resultStore,
		// 改变传给服务端的分页参数名。extjs3.1推荐是在Store
		// 里面定义这个参数，可是我试验却失败了。
		// 在这里却可以成功，不知道是不是extjs 版本问题
		paramNames : {
			start : 'page.start',
			limit : 'page.pageSize'
		},
		pageSize : pageTotal,
		displayInfo : true,
		displayMsg : '第 {0} 条到 {1} 条，一共 {2} 条',
		emptyMsg : "没有记录"
	});
	// 定义复选框选择模式变量：加上选择列
	var sm = new Ext.grid.CheckboxSelectionModel();
	
	
	
	var alarmgrid = new Ext.grid.GridPanel({
		title : '查询结果列表',
		applyTo : 'alarmgrid',
		width : gridWidth,
		height : gridHeight,
		frame : true,
		bbar : bbar,
		sm : sm,// 设置复选框选择模式
		store : resultStore,
//		ds: this.resultStore,
		loadMask : true,
		stripeRows :true,
		columns : [// 配置表格列
			sm,	// 复选框选择模式中的checkbox组件将会显示在该列
			new Ext.grid.RowNumberer(), 
			{
				header : "故障单号",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'alarmId',
				name : 'alarmId'
			}, {
				header : "流水号",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'serialId',
				name : 'serialId'
			}, {
				header : "故障类型",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'alarmStaffMan',
				name : 'alarmStaffMan'
			},{
				header : "发生故障系统",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'alarmSystem',
				name : 'alarmSystem'
			}, {
				header : "故障发生时间",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'alarmOccurTime',
				name : 'alarmOccurTime'
			},{
				header : "故障结束时间",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'alarmFinishTime',
				name : 'alarmFinishTime'
			},{
				header : "处理结果",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'alarmFinishFlag',
				name : 'alarmFinishFlag',
				renderer:checkFinishFlag
		}, {
				header : "操作",
				width : columnWidth / 8,
				sortable : true,
				dataIndex : 'serialId',
				name : 'serialId',
				renderer:getAlarmDetail
		}]
	})
	resultStore.load({
		params : {
			'page.start' : 0,
			'page.pageSize' : pageTotal
		}
	});
	function checkFinishFlag(value){
		if(value == 0) return '处理中';
		if(value == 1) return '已完成';
		if(value == 2) return '已撤销';
	};
	function getAlarmDetail(value){
		return '<a style="text-decoration:none;" href=javascript:doPress()>' + '催单' + '</a>'+' | '+
			'<a style="text-decoration:none;" href=javascript:doCancel()>' + '取消' + '</a>'+' | '+
			'<a style="text-decoration:none;" href=javascript:doWatch()>' + '查看' + '</a>';
	};

})
function doPress(){
	alert("ceshi");
};
function doCancel(){
	
};
function doWatch(){
	
};