Ext.ns("Starit.Alarm", "Starit.Alarm.AlarmPresent");
var padBlank = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
Starit.Alarm.AlarmPresent.viewport = Ext.extend(Starit.CommonViewport, {

	constructor : function() {
		Starit.Alarm.AlarmPresent.viewport.superclass.constructor
				.call(this, {});
	},

	initCfgParams : function() {

		this.catalogTree = new Starit.Alarm.AlarmPresent.catalogTree({
					viewport : this
				});

		this.grid = new Starit.Alarm.AlarmPresent.FilterGrid({
					viewport : this
				});

		this.resourcesConfigForm = new Starit.Alarm.AlarmPresent.resourcesConfigForm(
				{
					viewport : this
				});
		this.propertyConfigForm = new Starit.Alarm.AlarmPresent.PropertyConfigForm(
				{
					viewport : this
				});
		this.saveForm = new Starit.Alarm.AlarmPresent.saveForm({
					viewport : this
				});

		this.initConfig({
					leftCmp : this.catalogTree,
					rightCmp : [{
						title : '告警过滤器',
						upper : this.grid,
						under : {
							cfgCmps : [this.saveForm, 
									this.propertyConfigForm,
									this.resourcesConfigForm]
						}
					}]
				});

	},
	/**
	 * 总体布局
	 * 总体为 leftCmp ，rightCmp(upper ,underPanel)
	 */
	initConfig : function(o) {
		this.items = [];

		if (o && o.leftCmp) {
			this.leftCmp = o.leftCmp;
			this.leftCmp.region = 'west';
			this.items.push(this.leftCmp);
		}

		if (o && o.rightCmp.length) {
			this.rightCmp = o.rightCmp[0];

			var rItems = [], c = this.rightCmp, title = this.rightCmp.title, underPanel;
			if (c.upper) {
				c.upper.region = 'center';
				rItems.push(c.upper);
			}

			if (c.under) {
				var cfgTab;
				if (c.under.cfgCmps && c.under.cfgCmps.length) {
					for (var m = 0, l = c.under.cfgCmps.length; m < l; m++) {
						//c.under.cfgCmps[m].iconCls = 'config';
					}
					cfgTab = this.createTabs(c.under.cfgCmps, 'south');
				}

				this.rightCmp.underPanel = new Ext.Panel({
							title : '相关信息',
							border : false,
							frame : false,
							layout : 'fit',
							region : 'south',
							height : (Ext.getBody().getViewSize().height) * 0.6,
							split : true,
							buttonAlign : 'center',
							items : [cfgTab],
							buttons : [{
										text : '保存',
										iconCls : 'save',
										handler : this.doSave,
										scope : this
									}]
						});
				rItems.push(this.rightCmp.underPanel);
			}
			var p = new Ext.Panel({
						border : false,
						bodyBorder : false,
						frame : true,
						region : 'center',
						layout : 'border',
						title : title,
						split : true,
						items : rItems
					});
		}
		this.items.push(p);
	},
	/**
	 * 过滤器的保存
	 */
	doSave : function() {
		var configObj = this.getFilterConfig();
		if(!configObj.filterName || configObj.filterName.trim()==''){
		   Ext.Msg.alert("系统提示",padBlank+"模板名称不能为空！"+padBlank+padBlank);
		   return ;
		}
		
		if(!configObj.templateType ||!configObj.filterCatId  ){
		   Ext.Msg.alert("系统提示",padBlank+"模板分类不能为空！"+padBlank+padBlank);
		   return ;
		}
		var that = this;
		
		var mk = new Ext.LoadMask(this.el, {
			msg: '正在保存过滤器...',
			removeMask : true
		});
		mk.show();
		
		if(this.grid.saveflag){
			AlarmWebFilterManager.saveFilter(configObj,function(data){
				if(data) {
	    			 Ext.MessageBox.alert("系统提示", padBlank + "添加过滤器成功!" + padBlank+padBlank);
	    			 that.grid.doAdd();
	    			 that.grid.getStore().reload();
	    			  mk.hide();
	    		} else {
	    			 Ext.MessageBox.alert("系统提示", padBlank + "添加过滤器失败！" + padBlank+padBlank);
	    			 mk.hide();
	    		}
			});
		}else{
			configObj.filterId = this.grid.getSelectionModel().getSelected().data.templateId;
			
			
			AlarmWebFilterManager.updateFilter(configObj.filterId, configObj, function(data) {
	    		if(data) {
	    			   that.grid.doAdd();
	    			   that.grid.getStore().reload();
	    			   mk.hide();
	    			   Ext.MessageBox.alert("系统提示", padBlank + "修改过滤器成功!" + padBlank);
	    			 
	    		} else {
	    			 Ext.MessageBox.alert("系统提示:", padBlank + "修改过滤器失败！" + padBlank);
	    			 mk.hide();
	    		}
	    	});
	    	
		}
	},
	getFilterConfig : function() {
		var saveform = this.saveForm;

		// 获得过滤器名称,备注，使用范围,目录的Id
		var filterName = saveform.mouldName.getValue();
		
		//var remark = saveform.notes.getValue();//这个目前数据库中没有了，该怎么办？
		
		var filterCatId = this.grid.catalogId;

		// 获得3个属性字段grid被选择的记录
		this.propertyConfigForm.doGetSelMsg();
		var almTypeIds = this.propertyConfigForm.typeGrid.selTypeArr;
		var almCatIds = this.propertyConfigForm.categoryGrid.selCategoryArr;
		var almLevelIds = this.propertyConfigForm.levelGrid.selLevelArr;

		// 获得相应的设备
		this.resourcesConfigForm.grid.doGetMsg();
		var selectDevice = this.resourcesConfigForm.grid.selectDevice;
		var devIds = [];
		var restypes = [];
		for(var i = 0; i < selectDevice.length; i++) {
			var sd = selectDevice[i].split(",");
			devIds.push(sd[0]);
			restypes.push(sd[1]);
		}
		
		//1.全国  2.个人
		var templateType=null ;
		if(this.catalogTree.isPersonal!=null){
			if(this.catalogTree.isPersonal ){
				templateType = 2; 
			}else{
				templateType = 1; 
			}
		}

		// 设置把对应的属性加入到条件对象中
		var configObj = {
			filterName : filterName,
			filterCatId: filterCatId,
			almTypeIds : almTypeIds,
			almCatIds : almCatIds,
			almLevelIds : almLevelIds,
			devIds : devIds,
			templateType:templateType,
			createTime:new Date(),
			//add by pbqi 2010-5-28 17:19:20(服务商类型)
			restypes:restypes
		};
		return configObj;
	}
});
Ext.BLANK_IMAGE_URL = "../resources/images/default/s.gif";

Ext.onReady(function() {
	Ext.QuickTips.init();// 这句 必须有，用于初始化提示。
	var testView = new Starit.Alarm.AlarmPresent.viewport();
});


